/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;

public final class ItemSelectorDialog
extends JPanel
implements ActionListener {
    public int selected_item = -1;
    public int[] selected_indices = null;
    public boolean cancelled = false;
    private JList list = null;
    private int nitems = 0;
    private JButton selectAllButton = null;
    private JButton clearButton = null;
    private JButton invertButton = null;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$utils$IpeUtils;

    public void showWindow(String title, int in_nitems, String[] item, boolean cancelable, boolean multiple_selections) {
        this.nitems = in_nitems;
        this.setSize(600, 300);
        this.setLayout(new BorderLayout());
        this.list = new JList<String>(item);
        JScrollPane scroll_pane = new JScrollPane(this.list);
        this.add((Component)scroll_pane, "Center");
        this.list.setSelectionMode(multiple_selections ? 2 : 0);
        JPanel selControls = new JPanel();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)selControls, "South");
        JLabel jl = new JLabel(title);
        jl.setBorder(new EmptyBorder(5, 5, 5, 5));
        topPanel.add((Component)jl, "North");
        this.add((Component)topPanel, "North");
        this.selectAllButton = new JButton();
        Actions.setMenuText((AbstractButton)this.selectAllButton, (String)ItemSelectorDialog.getText("SelectAll"), (boolean)true);
        this.selectAllButton.addActionListener(this);
        selControls.add(this.selectAllButton);
        this.clearButton = new JButton();
        Actions.setMenuText((AbstractButton)this.clearButton, (String)ItemSelectorDialog.getText("Clear"), (boolean)true);
        this.clearButton.addActionListener(this);
        selControls.add(this.clearButton);
        this.invertButton = new JButton();
        Actions.setMenuText((AbstractButton)this.invertButton, (String)ItemSelectorDialog.getText("Invert"), (boolean)true);
        this.invertButton.addActionListener(this);
        selControls.add(this.invertButton);
        DialogDescriptor dlg = new DialogDescriptor((Object)this, "", true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dialog.show();
        String answer = dlg.getValue().toString();
        if (dlg.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.selected_item = this.list.getSelectedIndex();
            this.selected_indices = this.list.getSelectedIndices();
            if (!cancelable && this.selected_item == -1) {
                this.showWindow(title, this.nitems, item, cancelable, multiple_selections);
                return;
            }
            this.cancelled = false;
        } else {
            this.cancelled = true;
            if (!cancelable && this.selected_item == -1) {
                this.showWindow(title, this.nitems, item, cancelable, multiple_selections);
                return;
            }
            this.selected_item = -1;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectAllButton) {
            int[] indices = new int[this.nitems];
            for (int i = 0; i < this.nitems; ++i) {
                indices[i] = i;
            }
            this.list.setSelectedIndices(indices);
        } else if (actionEvent.getSource() == this.clearButton) {
            this.list.setSelectedIndices(new int[0]);
        } else if (actionEvent.getSource() == this.invertButton) {
            int[] selected = this.list.getSelectedIndices();
            int numSelected = selected.length;
            int[] indices = new int[this.nitems - numSelected];
            int next = 0;
            for (int i = 0; i < this.nitems; ++i) {
                boolean isSelected = false;
                for (int j = 0; j < numSelected; ++j) {
                    if (selected[j] != i) continue;
                    isSelected = true;
                    break;
                }
                if (isSelected) continue;
                indices[next++] = i;
            }
            this.list.setSelectedIndices(indices);
        }
    }

    private static String getText(String key) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$utils$IpeUtils == null ? (class$com$sun$tools$debugger$dbxgui$utils$IpeUtils = ItemSelectorDialog.class$("com.sun.tools.debugger.dbxgui.utils.IpeUtils")) : class$com$sun$tools$debugger$dbxgui$utils$IpeUtils), (String)key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

