/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class DbxVariablesRootNode
extends AbstractNode {
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/Locals";
    private static String ICON_PENDING_VARIABLES = "org/netbeans/modules/debugger/resources/allInOneView/Locals";
    private static String ICON_LOCAL_VARIABLE = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static ResourceBundle bundle;
    private static HashMap locals;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$DebuggerNode;

    static String getLocalizedString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$DebuggerNode == null ? (class$org$netbeans$modules$debugger$support$nodes$DebuggerNode = DbxVariablesRootNode.class$("org.netbeans.modules.debugger.support.nodes.DebuggerNode")) : class$org$netbeans$modules$debugger$support$nodes$DebuggerNode));
        }
        return bundle.getString(s);
    }

    public DbxVariablesRootNode() {
        this(false);
    }

    public DbxVariablesRootNode(boolean isInTree) {
        super((Children)new DbxVariablesRootChildren());
        String name = null;
        name = "VARIABLES ROOT (Change Me)";
        this.setDisplayName(name);
        this.setName("VariablesRootNode");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariablesRootNode");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        locals = new HashMap();
    }

    static class VRListener
    implements PropertyChangeListener {
        private CoreDebugger debugger;
        private AbstractThread currentThread;
        private WeakReference node;
        protected static String stdIcon = DbxVariablesRootNode.access$300();
        protected static String pendingIcon = DbxVariablesRootNode.access$400();

        VRListener(Node node, CoreDebugger debugger) {
            this.debugger = debugger;
            this.node = new WeakReference<Node>(node);
            Validator validator = ((ValidatorHolder)debugger).getValidator();
            validator.addPropertyChangeListener((PropertyChangeListener)this);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            AbstractThread t = debugger.getCurrentThread();
            if (t instanceof CallStackProducer) {
                this.currentThread = t;
                this.currentThread.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        DbxVariablesRootNode getNode() {
            DbxVariablesRootNode wrn = (DbxVariablesRootNode)((Object)this.node.get());
            if (wrn != null) {
                return wrn;
            }
            this.destroy();
            return null;
        }

        void destroy() {
            Validator validator = ((ValidatorHolder)this.debugger).getValidator();
            validator.removePropertyChangeListener((PropertyChangeListener)this);
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.currentThread != null) {
                this.currentThread.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.currentThread = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            DbxVariablesRootNode node = this.getNode();
            if (node == null) {
                return;
            }
            if (e.getSource() instanceof Validator) {
                node.setIconBase(((Validator)e.getSource()).isValidated() ? ICON_BASE : ICON_PENDING_VARIABLES);
                return;
            }
            if (e.getSource() instanceof CoreDebugger && e.getPropertyName() == "currentThread") {
                AbstractThread t;
                if (this.currentThread != null) {
                    this.currentThread.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if ((t = this.debugger.getCurrentThread()) instanceof CallStackProducer) {
                    this.currentThread = t;
                    this.currentThread.addPropertyChangeListener((PropertyChangeListener)this);
                }
                ((DbxVariablesRootChildren)node.getChildren()).validate();
            } else if (e.getSource() instanceof CallStackProducer && (e.getPropertyName() == "callstack" || e.getPropertyName() == "currentCallstackFrameIndex")) {
                ((DbxVariablesRootChildren)node.getChildren()).validate();
            }
        }
    }

    private static final class DbxVariablesRootChildren
    extends Children.Keys
    implements LeafRefresher,
    Validator.Object {
        private VRListener l;
        private AbstractDebugger debugger;

        private DbxVariablesRootChildren() {
        }

        protected Node[] createNodes(Object key) {
            Node node = DebuggerNode.createNode((Object)key);
            if (node == null) {
                return new Node[0];
            }
            if (locals.containsKey(key) && node instanceof AbstractNode) {
                ((AbstractNode)node).setIconBase(ICON_LOCAL_VARIABLE);
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            this.debugger = Register.getCoreDebugger();
            this.l = new VRListener(this.getNode(), (CoreDebugger)this.debugger);
            Validator validator = ((ValidatorHolder)this.debugger).getValidator();
            validator.add((Validator.Object)this);
            this.validate();
        }

        protected void removeNotify() {
            this.l.destroy();
            Validator validator = ((ValidatorHolder)this.debugger).getValidator();
            validator.remove((Validator.Object)this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void validate() {
            HashMap newLocals = new HashMap();
            Object[] variables = new AbstractVariable[]{};
            AbstractThread o = ((ThreadsRoot)this.debugger).getCurrentThread();
            if (o != null) {
                if (o instanceof CallStackProducer) {
                    int i = ((CallStackProducer)o).getCurrentCallStackFrameIndex();
                    Location oo = ((CallStackProducer)o).getCallStack()[i];
                    if (oo instanceof VariablesProducer) {
                        o = oo;
                    }
                }
                if (o instanceof VariablesProducer) {
                    variables = ((VariablesProducer)o).getVariablesFilter().getVariables((VariablesProducer)o);
                    Arrays.sort(variables, Utils.localsComparator);
                }
            }
            this.setKeys(variables);
        }

        public boolean canRemove() {
            return false;
        }

        public void refreshMyKey(Object key) {
            this.refreshKey(key);
        }
    }
}

