/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.nodes;

import com.sun.tools.debugger.dbxgui.debugger.DbxStackFrame;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import com.sun.tools.debugger.dbxgui.utils.Log;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class DbxLocationNode
extends AbstractNode
implements GoToSourceCookie,
SwitchOnCookie,
PropertyChangeListener {
    protected static String ICON_PATH = "org/netbeans/modules/debugger/resources/";
    protected static final String ICON_BASE = ICON_PATH + "callStackView/NonCurrentFrame";
    private static final String ICON_BASE_CURRENT = ICON_PATH + "callStackView/CurrentFrame";
    private SystemAction[] staticActions;
    private DbxStackFrame frame;
    protected CallStackProducer producer;
    protected int index;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$nodes$DbxLocationNode;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$nodes$DbxLocationNode == null ? (class$com$sun$tools$debugger$dbxgui$nodes$DbxLocationNode = DbxLocationNode.class$("com.sun.tools.debugger.dbxgui.nodes.DbxLocationNode")) : class$com$sun$tools$debugger$dbxgui$nodes$DbxLocationNode), (String)s);
    }

    public DbxLocationNode(Location location, CallStackProducer producer, int index, boolean showSubNodes) {
        super(Children.LEAF);
        this.producer = producer;
        this.index = index;
        this.frame = (DbxStackFrame)location;
        this.updateName();
        this.updateIcon();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        producer.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLocationNode");
    }

    protected void createProperties() {
        PropFactory pf = new PropFactory(this, this.frame);
        pf.addString("location", "PROP_frame_location", "HINT_frame_location", "getLocation", null);
        pf.addString("number", "PROP_frame_number", "HINT_frame_number", "getNumber", null);
        pf.addString("optimized", "PROP_frame_optimized", "HINT_frame_optimized", "getOptimized", null);
        pf.addObject("currentPC", "PROP_frame_current_pc", "HINT_frame_current_pc", "getCurrentPC", null);
        this.setSheet(pf.getSheet());
    }

    public SystemAction[] getActions() {
        if (this.staticActions == null) {
            this.staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction = DbxLocationNode.class$("org.netbeans.modules.debugger.support.actions.SwitchToLocationAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DbxLocationNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = DbxLocationNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return this.staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction = DbxLocationNode.class$("org.netbeans.modules.debugger.support.actions.SwitchToLocationAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction));
    }

    public void goToSource() {
        Log.prf(1, "NOT IMPLEMENTED");
    }

    public boolean canGoToSource() {
        Log.prf(1, "NOT IMPLEMENTED");
        return false;
    }

    public boolean canSetCurrent() {
        if (this.producer.getCurrentCallStackFrameIndex() == this.index) {
            return false;
        }
        return !this.frame.isSpecial();
    }

    public void setCurrent() {
        this.producer.setCurrentCallStackFrameIndex(this.index);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == null) {
            return;
        }
        if (e.getPropertyName().equals("currentCallstackFrameIndex")) {
            this.updateIcon();
        }
    }

    protected void updateLocation(Location location) {
        this.frame = (DbxStackFrame)location;
        this.updateName();
    }

    protected void updateName() {
        String s = this.frame.getLocationName();
        this.setDisplayName(s);
        this.setName(s);
    }

    private void updateIcon() {
        Log.prf(1, "frame = " + this.producer.getCurrentCallStackFrameIndex() + " me = " + this.index);
        if (this.producer.getCurrentCallStackFrameIndex() == this.index) {
            this.setIconBase(ICON_BASE_CURRENT);
        } else if (this.frame.isSpecial() && !this.frame.isHidden()) {
            this.setIconBase("com/sun/tools/debugger/dbxgui/icons/empty");
        } else {
            this.setIconBase(ICON_BASE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ShowHiddenAction
    extends BooleanStateAction {
        public HelpCtx getHelpCtx() {
            return new HelpCtx("ShowHidden");
        }

        public String getName() {
            return "Show Hidden Frames";
        }

        public void actionPerformed(ActionEvent ev) {
            System.out.println("ShowHiddenAction.actionPerformed");
            this.setBooleanState(!this.getBooleanState());
        }
    }
}

