/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.options;

import com.sun.tools.debugger.dbxgui.debugger.options.BaseOptionUI;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.debugger.options.OptionsDialog;
import com.sun.tools.debugger.dbxgui.debugger.options.TextFieldOptionUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openide.awt.Actions;

public class RadioButtonOptionUI
extends BaseOptionUI
implements ItemListener {
    JRadioButton[] buttons;
    String[] buttonLabels;
    String[] buttonDescrs;
    String[] buttonValues;
    ButtonGroup buttonGroup = new ButtonGroup();
    public static int RB_COLUMNS = 12;

    public RadioButtonOptionUI(DebuggingOption inOption, OptionsDialog dialog) {
        super(inOption, dialog);
    }

    protected JPanel createButtonPanel(int index) {
        this.buttons[index] = new JRadioButton();
        if (index == 0 && this.hasLabel) {
            this.label.setLabelFor(this.buttons[index]);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.buttons[index], "West");
        Actions.setMenuText((AbstractButton)this.buttons[index], (String)this.buttonLabels[index], (boolean)true);
        this.buttons[index].getAccessibleContext().setAccessibleDescription(this.buttonDescrs[index]);
        this.buttonGroup.add(this.buttons[index]);
        if (this.currValue.equals(this.buttonValues[index])) {
            this.buttons[index].setSelected(true);
        }
        return buttonPanel;
    }

    protected int getSelectionIndex() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void itemStateChanged(ItemEvent ie) {
        String value = null;
        JRadioButton rb = (JRadioButton)ie.getItem();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] != rb) continue;
            value = this.buttonValues[i];
        }
        DebuggingOption subOption = DebuggingOption.getSubOption(this.option, value);
        if (subOption != null) {
            boolean b = rb.isSelected();
            if (DebuggingOption.invertOption(this.option)) {
                b = !b;
            }
            ((TextFieldOptionUI)subOption.getUI()).setEnabled(b);
        }
    }

    public void applyChanges() {
        super.applyChanges();
        DebuggingOption subOption = this.option.getSubOption();
        if (subOption != null) {
            TextFieldOptionUI subOptionUI = (TextFieldOptionUI)subOption.getUI();
            subOptionUI.applyChanges();
        }
    }

    public void cancelChanges() {
        DebuggingOption subOption = this.option.getSubOption();
        if (subOption != null) {
            TextFieldOptionUI subOptionUI = (TextFieldOptionUI)subOption.getUI();
            subOptionUI.cancelChanges();
        }
        super.cancelChanges();
    }

    protected String getValueFromUI() {
        return this.buttonValues[this.getSelectionIndex()];
    }

    protected void updateUI() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttonValues[i].equals(this.currValue)) continue;
            this.buttons[i].setSelected(true);
        }
    }

    public void addOption(JPanel parent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.hasLabel) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 12, 5, 12);
            this.label = this.createLabel();
            parent.add((Component)this.label, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        JPanel buttonsPanel = new JPanel(new FlowLayout(0, 2, 2));
        if (DebuggingOption.verticalLayout(this.option)) {
            buttonsPanel.setLayout(new GridLayout(0, 2));
        }
        this.buttonLabels = this.option.getValueLabels();
        this.buttonDescrs = this.option.getValueDescrs();
        this.buttonValues = this.option.getValues();
        this.buttons = new JRadioButton[this.buttonLabels.length];
        for (int i = 0; i < this.buttonLabels.length; ++i) {
            JPanel buttonPanel = this.createButtonPanel(i);
            DebuggingOption subOption = DebuggingOption.getSubOption(this.option, this.buttonValues[i]);
            if (subOption != null) {
                JPanel jp = new JPanel();
                jp.setLayout(new GridBagLayout());
                TextFieldOptionUI tfoui = new TextFieldOptionUI(subOption, LABEL_COLUMNS_MIN, this.dialog);
                tfoui.addOption(jp, 0);
                if (!this.buttons[i].isSelected()) {
                    ((TextFieldOptionUI)subOption.getUI()).setEnabled(false);
                }
                this.buttons[i].addItemListener(this);
                buttonPanel.add((Component)jp, "East");
            }
            buttonsPanel.add(buttonPanel);
        }
        parent.add((Component)buttonsPanel, gridBagConstraints);
    }
}

