/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.options;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.debugger.options.BaseOptionUI;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class DebuggingOption {
    private static Hashtable optionsTable = new Hashtable(100);
    private String name;
    private String label;
    private String tooltip;
    private String currValue;
    private String[] values;
    private String[] valueLabels;
    private String[] valueDescrs;
    private String optionDescr;
    private String defaultValue;
    private boolean dbxOption;
    private int type;
    private BaseOptionUI ui;
    private boolean dirty = false;
    public static final int TEXT_AREA = 1;
    public static final int RADIO_BUTTON = 2;
    public static final int COMBO_BOX = 3;
    public static final int CHECK_BOX = 4;
    public int order;
    private static int upperBound = 0;
    private DebuggingOption prev;
    private DebuggingOption next;
    private static DebuggingOption first = null;
    private static DebuggingOption last = null;
    private static ResourceBundle bundle = null;
    private static String yesString = null;
    private static String noString = null;
    public static final DebuggingOption ARRAY_BOUNDS_CHECK;
    public static final DebuggingOption DISSASSEMLER_VERSION;
    public static final DebuggingOption FIX_VERBOSE;
    public static final DebuggingOption FOLLOW_FORK_INHERIT;
    public static final DebuggingOption FOLLOW_FORK_MODE;
    public static final DebuggingOption INPUT_CASE_SENSITIVE;
    public static final DebuggingOption LANGUAGE_MODE;
    public static final DebuggingOption MAIN_FUNC_WARNING;
    public static final DebuggingOption MT_SCALABLE;
    public static final DebuggingOption OUTPUT_AUTO_FLUSH;
    public static final DebuggingOption OUTPUT_BASE;
    public static final DebuggingOption OUTPUT_DYNAMIC_TYPE;
    public static final DebuggingOption OUTPUT_INHERITED_MEMBERS;
    public static final DebuggingOption OUTPUT_LIST_SIZE;
    public static final DebuggingOption OUTPUT_MAX_STRING_LENGTH;
    public static final DebuggingOption OUTPUT_PRETTY_PRINT;
    public static final DebuggingOption OUTPUT_SHORT_FILE_NAME;
    public static final DebuggingOption OVERLOAD_FUNCTION;
    public static final DebuggingOption OVERLOAD_OPERATOR;
    public static final DebuggingOption POP_AUTO_DESTRUCT;
    public static final DebuggingOption PROC_EXCLUSIVE_ATTACH;
    public static final DebuggingOption RTC_AUTO_CONTINUE;
    public static final DebuggingOption RTC_AUTO_SUPPRESS;
    public static final DebuggingOption RTC_BIU_AT_EXIT;
    public static final DebuggingOption RTC_ERROR_LIMIT;
    public static final DebuggingOption RTC_ERROR_LOG_FILENAME;
    public static final DebuggingOption RTC_MEL_AT_EXIT;
    public static final DebuggingOption RUN_AUTOSTART;
    public static final DebuggingOption RUN_IO;
    public static final DebuggingOption RUN_PTY;
    public static final DebuggingOption RUN_QUICK;
    public static final DebuggingOption RUN_SAVETTY;
    public static final DebuggingOption RUN_SETPGRP;
    public static final DebuggingOption SCOPE_GLOBAL_ENUMS;
    public static final DebuggingOption SCOPE_LOOK_ASIDE;
    public static final DebuggingOption FRONT_DBGWIN;
    public static final DebuggingOption FRONT_PIO;
    public static final DebuggingOption FRONT_DBX;
    public static final DebuggingOption FRONT_ACCESS;
    public static final DebuggingOption FRONT_MEMUSE;
    public static final DebuggingOption OPEN_THREADS;
    public static final DebuggingOption OPEN_SESSIONS;
    public static final DebuggingOption SAVE_BREAKPOINTS;
    public static final DebuggingOption BALLOON_EVAL;
    public static final DebuggingOption STACK_FIND_SOURCE;
    public static final DebuggingOption STACK_MAX_SIZE;
    public static final DebuggingOption STACK_VERBOSE;
    public static final DebuggingOption STEP_EVENTS;
    public static final DebuggingOption STEP_GRANULARITY;
    public static final DebuggingOption SUPPRESS_STARTUP_MESSAGE;
    public static final DebuggingOption SYMBOL_INFO_COMPRESSION;
    public static final DebuggingOption TRACE_SPEED;
    private static boolean needSave;
    private static boolean needOpen;
    static final String TAG_OPTIONS = "DebugOptions";
    static final String TAG_OPTION = "option";
    static final String ATTR_OPTION_NAME = "name";
    static final String ATTR_OPTION_VALUE = "value";
    protected static final String OPTION_DTD_WEB = "nbrescurr:/com/sun/tools/debugger/dbxgui/resources/debugoptions-1_0.dtd";
    protected static final String OPTION_DTD_PUBLIC_ID = "-//SolarisNativeSupport//DTD debugoptions 1.0//EN";
    protected static final String FILENAME = "DbxDebugOptions";
    protected static final String EXT_XML = "xml";
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$options$DebuggingOption;

    public DebuggingOption(String inName, String[] inValues, String inDefaultValue, boolean inIsDbxOption, int inType, boolean hasTooltip) {
        this.name = inName;
        this.label = bundle.getString("LABEL_" + this.name);
        this.tooltip = hasTooltip ? bundle.getString("HINT_" + this.name) : null;
        this.currValue = null;
        this.values = inValues;
        this.defaultValue = inDefaultValue;
        this.dbxOption = inIsDbxOption;
        this.type = inType;
        this.ui = null;
        this.setValueLabels();
        this.order = upperBound++;
        if (first == null) {
            first = this;
        }
        if (last != null) {
            this.prev = last;
            DebuggingOption.last.next = this;
        }
        last = this;
        optionsTable.put(this.name, this);
    }

    public DebuggingOption(String inName, String inDefaultValue, boolean inIsDbxOption, int inType, boolean hasTip) {
        this(inName, null, inDefaultValue, inIsDbxOption, inType, hasTip);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelTip() {
        return this.tooltip;
    }

    public String[] getValues() {
        return this.values;
    }

    public String[] getValueLabels() {
        return this.valueLabels;
    }

    public String[] getValueDescrs() {
        return this.valueDescrs;
    }

    public String getOptionDescription() {
        return this.optionDescr;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDbxOption() {
        return this.dbxOption;
    }

    public int getType() {
        return this.type;
    }

    public BaseOptionUI getUI() {
        return this.ui;
    }

    public String getCurrValue() {
        if (this.currValue == null) {
            return this.getDefaultValue();
        }
        return this.currValue;
    }

    public void setCurrValue(String newValue) {
        if (this.currValue != null && this.currValue.equals(newValue)) {
            return;
        }
        this.currValue = newValue;
        if (this.ui != null) {
            this.ui.setValue(newValue);
        }
        needSave = true;
        this.dirty = true;
    }

    public String getValueLabel(String value) {
        if (this.values == null || this.valueLabels == null) {
            return null;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            return this.valueLabels[i];
        }
        return null;
    }

    public String getValue(String valueLabel) {
        if (this.values == null || this.valueLabels == null) {
            return null;
        }
        for (int i = 0; i < this.valueLabels.length; ++i) {
            if (!valueLabel.equals(this.valueLabels[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public void setUI(BaseOptionUI inUI) {
        this.ui = inUI;
    }

    private void setValueLabels() {
        if (this.type == 1 || this.type == 4) {
            this.valueLabels = null;
            this.setValueDescrs();
            return;
        }
        if (this.isYesNoOption()) {
            this.valueLabels = this.values[0].equals("on") ? new String[]{yesString, noString} : new String[]{noString, yesString};
            this.setValueDescrs();
            return;
        }
        this.valueLabels = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            try {
                this.valueLabels[i] = bundle.getString("VALUE_" + this.name + "_" + this.values[i]);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setValueDescrs();
    }

    private void setValueDescrs() {
        if (this.type == 2) {
            this.valueDescrs = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                try {
                    this.valueDescrs[i] = bundle.getString("ACSD_" + this.name + "_" + this.values[i]);
                    continue;
                }
                catch (MissingResourceException ex) {
                    String pattern = bundle.getString("ACSD_option_pattern");
                    String labTxt = Actions.cutAmpersand((String)this.label);
                    if (labTxt.endsWith(":")) {
                        labTxt = labTxt.substring(0, labTxt.length() - 1);
                    }
                    String valTxt = Actions.cutAmpersand((String)this.valueLabels[i]);
                    this.valueDescrs[i] = MessageFormat.format(pattern, labTxt, valTxt);
                }
            }
        } else {
            try {
                this.optionDescr = bundle.getString("ACSD_" + this.name);
            }
            catch (MissingResourceException ex) {
                String labTxt = Actions.cutAmpersand((String)this.label);
                if (labTxt.endsWith(":")) {
                    labTxt = labTxt.substring(0, labTxt.length() - 1);
                }
                this.optionDescr = labTxt;
            }
        }
    }

    public boolean isEnabled() {
        return this.getCurrValue().equals("on");
    }

    private boolean isYesNoOption() {
        return !(this.type != 2 || this.values.length != 2 || !this.values[0].equals("on") && !this.values[0].equals("off") || !this.values[1].equals("on") && !this.values[1].equals("off"));
    }

    public static Enumeration elements() {
        return new Enumeration(){
            private DebuggingOption curr = DebuggingOption.access$000();

            public boolean hasMoreElements() {
                return this.curr != null;
            }

            public Object nextElement() {
                DebuggingOption c = this.curr;
                this.curr = this.curr.next();
                return c;
            }
        };
    }

    public static int size() {
        return upperBound;
    }

    public static DebuggingOption first() {
        return first;
    }

    public static DebuggingOption last() {
        return last;
    }

    public DebuggingOption prev() {
        return this.prev;
    }

    public DebuggingOption next() {
        return this.next;
    }

    public boolean equals(DebuggingOption option) {
        return option.getName().equals(this.name);
    }

    public static DebuggingOption find(String name) {
        return (DebuggingOption)optionsTable.get(name);
    }

    public static DebuggingOption getSubOption(DebuggingOption option, String value) {
        if (option == RTC_AUTO_CONTINUE && value == "off") {
            return RTC_ERROR_LOG_FILENAME;
        }
        if (option == RUN_IO && value == "pty") {
            return RUN_PTY;
        }
        return null;
    }

    public static boolean invertOption(DebuggingOption option) {
        return option == RTC_AUTO_CONTINUE;
    }

    public static boolean verticalLayout(DebuggingOption option) {
        return option == RUN_IO;
    }

    public static boolean overrideHasLabel(DebuggingOption option) {
        return option != RUN_IO;
    }

    public DebuggingOption getSubOption() {
        if (this == RTC_AUTO_CONTINUE) {
            return RTC_ERROR_LOG_FILENAME;
        }
        if (this == RUN_IO) {
            return RUN_PTY;
        }
        return null;
    }

    public boolean isSubOption() {
        return this == RTC_ERROR_LOG_FILENAME || this == RUN_PTY;
    }

    public static void applyTo(DbxDebugger debugger) {
        Enumeration options = DebuggingOption.elements();
        while (options.hasMoreElements()) {
            DebuggingOption opt = (DebuggingOption)options.nextElement();
            if (opt.currValue == null || !opt.dirty) continue;
            debugger.setOption("DBX_" + opt.name, opt.currValue);
            opt.dirty = false;
        }
    }

    public static void markChanges() {
        Enumeration options = DebuggingOption.elements();
        while (options.hasMoreElements()) {
            DebuggingOption opt = (DebuggingOption)options.nextElement();
            if (opt.currValue == null || opt.currValue.equals(opt.defaultValue)) continue;
            opt.dirty = true;
        }
    }

    public void perhapsToXML(StringBuffer sb) {
        if (this.currValue == null) {
            return;
        }
        if (this.currValue.equals(this.defaultValue)) {
            return;
        }
        if (this == SUPPRESS_STARTUP_MESSAGE || this == RUN_AUTOSTART || this == RUN_PTY) {
            return;
        }
        String xmlval = IpeUtils.stringToXML(this.currValue);
        sb.append("\t<").append(TAG_OPTION).append(" ").append(ATTR_OPTION_NAME).append("=\"").append(this.name).append("\" ").append(ATTR_OPTION_VALUE).append("=\"").append(xmlval).append("\"/>\n");
    }

    public static void save() {
        if (!needSave) {
            return;
        }
        try {
            DebuggingOption.writeDocument();
        }
        catch (IOException ioe) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
        }
        needSave = false;
    }

    public static void open() {
        if (!needOpen) {
            return;
        }
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"readoptions");
        }
        try {
            DebuggingOption.readDocument();
        }
        catch (IOException ioe) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
        }
        if (UsageTracking.enabled) {
            UsageTracking.readTime((String)"readoptions", (String)"Read Global Debug Options", (boolean)true, null, (boolean)true);
        }
        needSave = false;
        needOpen = false;
    }

    private static final String getOptionsPackage() {
        return "DbxGui.DbxDebugOptions";
    }

    public static final DataFolder findOptionsFolder(boolean create) {
        return RunConfig.findFolder(FILENAME, create);
    }

    private static void writeDocument() throws IOException {
        DataFolder optFolder = DebuggingOption.findOptionsFolder(true);
        if (optFolder == null) {
            return;
        }
        final StringBuffer sb = new StringBuffer(256);
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE ").append(TAG_OPTIONS).append(" PUBLIC \"").append(OPTION_DTD_PUBLIC_ID).append("\" \"nbrescurr:/com/sun/tools/debugger/dbxgui/resources/debugoptions-1_0.dtd\">\n\n").append(DebuggingOption.toXMLString());
        final String optPackage = DebuggingOption.getOptionsPackage();
        final FileObject tbFO = optFolder.getPrimaryFile();
        final FileSystem tbFS = tbFO.getFileSystem();
        tbFS.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileLock lock;
                block6: {
                    lock = null;
                    OutputStream os = null;
                    FileObject xmlFO = tbFS.find(optPackage, DebuggingOption.FILENAME, DebuggingOption.EXT_XML);
                    if (xmlFO == null) {
                        xmlFO = tbFO.createData(DebuggingOption.FILENAME, DebuggingOption.EXT_XML);
                    }
                    try {
                        lock = xmlFO.lock();
                        os = xmlFO.getOutputStream(lock);
                        PrintWriter writer = new PrintWriter(os);
                        writer.print(sb.toString());
                        writer.close();
                        Object var6_5 = null;
                        if (os == null) break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (os != null) {
                            os.close();
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        throw throwable;
                    }
                    os.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        });
        needSave = false;
    }

    public static String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(TAG_OPTIONS).append(">\n");
        Enumeration options = DebuggingOption.elements();
        while (options.hasMoreElements()) {
            DebuggingOption opt = (DebuggingOption)options.nextElement();
            opt.perhapsToXML(sb);
        }
        sb.append("</").append(TAG_OPTIONS).append(">\n");
        return sb.toString();
    }

    private static void readDocument() throws IOException {
        DataFolder optFolder = DebuggingOption.findOptionsFolder(false);
        if (optFolder == null) {
            return;
        }
        String optPackage = DebuggingOption.getOptionsPackage();
        FileObject tbFO = optFolder.getPrimaryFile();
        FileSystem tbFS = tbFO.getFileSystem();
        FileObject fo = tbFS.find(optPackage, FILENAME, EXT_XML);
        if (fo == null) {
            return;
        }
        DataObject dao = null;
        try {
            dao = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().annotate((Throwable)e, "No data object associated with " + fo);
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        if (dao == null) {
            return;
        }
        if (!(dao instanceof XMLDataObject)) {
            ErrorManager.getDefault().log(dao + " is not an XMLDataObject");
            return;
        }
        XMLDataObject xml = (XMLDataObject)dao;
        Parser parser = xml.createParser();
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        HandlerBase handler = new HandlerBase(){
            private ArrayList args = null;
            private ArrayList vars = null;
            private ArrayList intercepts = null;
            private ArrayList dontIntercepts = null;
            private ArrayList pathmapList = null;
            private boolean unhandled = true;
            private boolean unexpected = true;

            public void startElement(String name, AttributeList amap) throws SAXException {
                if (DebuggingOption.TAG_OPTION.equals(name)) {
                    name = amap.getValue(DebuggingOption.ATTR_OPTION_NAME);
                    DebuggingOption o = DebuggingOption.find(name);
                    if (o != null) {
                        String value = amap.getValue(DebuggingOption.ATTR_OPTION_VALUE);
                        o.setCurrValue(value);
                    } else {
                        ErrorManager.getDefault().log("Warning: unknown option " + name);
                    }
                }
            }

            public void endElement(String name) throws SAXException {
            }
        };
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(xml.getPrimaryFile().getInputStream()));
        }
        catch (Exception saxe) {
            saxe.printStackTrace();
            IOException ex = new IOException();
            ErrorManager.getDefault().copyAnnotation((Throwable)ex, (Throwable)saxe);
            throw ex;
        }
        needOpen = false;
        needSave = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ DebuggingOption access$000() {
        return first;
    }

    static {
        try {
            bundle = NbBundle.getBundle((Class)(class$com$sun$tools$debugger$dbxgui$debugger$options$DebuggingOption == null ? (class$com$sun$tools$debugger$dbxgui$debugger$options$DebuggingOption = DebuggingOption.class$("com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption")) : class$com$sun$tools$debugger$dbxgui$debugger$options$DebuggingOption));
            yesString = bundle.getString("VALUE_on");
            noString = bundle.getString("VALUE_off");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ARRAY_BOUNDS_CHECK = new DebuggingOption("array_bounds_check", new String[]{"on", "off"}, "on", true, 2, true);
        DISSASSEMLER_VERSION = new DebuggingOption("disassembler_version", new String[]{"autodetect", "v8", "v9", "v9vis"}, "autodetect", true, 2, false);
        FIX_VERBOSE = new DebuggingOption("fix_verbose", new String[]{"on", "off"}, "off", true, 2, false);
        FOLLOW_FORK_INHERIT = new DebuggingOption("follow_fork_inherit", new String[]{"on", "off"}, "off", true, 2, false);
        FOLLOW_FORK_MODE = new DebuggingOption("follow_fork_mode", new String[]{"parent", "child", "both", "ask"}, "parent", true, 2, false);
        INPUT_CASE_SENSITIVE = new DebuggingOption("input_case_sensitive", new String[]{"autodetect", "true", "false"}, "autodetect", true, 2, false);
        LANGUAGE_MODE = new DebuggingOption("language_mode", new String[]{"autodetect", "main", "c", "ansic", "c++", "fortran", "fortran90"}, "autodetect", true, 3, false);
        MAIN_FUNC_WARNING = new DebuggingOption("main_func_warning", new String[]{"on", "off"}, "on", false, 2, false);
        MT_SCALABLE = new DebuggingOption("mt_scalable", new String[]{"on", "off"}, "off", true, 2, true);
        OUTPUT_AUTO_FLUSH = new DebuggingOption("output_auto_flush", new String[]{"on", "off"}, "on", true, 2, false);
        OUTPUT_BASE = new DebuggingOption("output_base", new String[]{"8", "10", "16", "automatic"}, "automatic", true, 2, false);
        OUTPUT_DYNAMIC_TYPE = new DebuggingOption("output_dynamic_type", new String[]{"on", "off"}, "off", true, 4, false);
        OUTPUT_INHERITED_MEMBERS = new DebuggingOption("output_inherited_members", new String[]{"on", "off"}, "off", true, 4, false);
        OUTPUT_LIST_SIZE = new DebuggingOption("output_list_size", "10", true, 1, false);
        OUTPUT_MAX_STRING_LENGTH = new DebuggingOption("output_max_string_length", "512", true, 1, false);
        OUTPUT_PRETTY_PRINT = new DebuggingOption("output_pretty_print", new String[]{"on", "off"}, "off", true, 2, false);
        OUTPUT_SHORT_FILE_NAME = new DebuggingOption("output_short_file_name", new String[]{"on", "off"}, "on", true, 2, false);
        OVERLOAD_FUNCTION = new DebuggingOption("overload_function", new String[]{"on", "off"}, "on", true, 4, false);
        OVERLOAD_OPERATOR = new DebuggingOption("overload_operator", new String[]{"on", "off"}, "on", true, 4, false);
        POP_AUTO_DESTRUCT = new DebuggingOption("pop_auto_destruct", new String[]{"on", "off"}, "on", true, 2, false);
        PROC_EXCLUSIVE_ATTACH = new DebuggingOption("proc_exclusive_attach", new String[]{"on", "off"}, "on", true, 2, false);
        RTC_AUTO_CONTINUE = new DebuggingOption("rtc_auto_continue", new String[]{"on", "off"}, "off", true, 2, false);
        RTC_AUTO_SUPPRESS = new DebuggingOption("rtc_auto_suppress", new String[]{"on", "off"}, "on", true, 2, false);
        RTC_BIU_AT_EXIT = new DebuggingOption("rtc_biu_at_exit", new String[]{"verbose", "on", "off"}, "on", true, 2, false);
        RTC_ERROR_LIMIT = new DebuggingOption("rtc_error_limit", "1000", true, 1, false);
        RTC_ERROR_LOG_FILENAME = new DebuggingOption("rtc_error_log_file_name", "/tmp/dbx.errlog.uniqueID", true, 1, false);
        RTC_MEL_AT_EXIT = new DebuggingOption("rtc_mel_at_exit", new String[]{"verbose", "on", "off"}, "on", true, 2, false);
        RUN_AUTOSTART = new DebuggingOption("run_autostart", new String[]{"on", "off"}, "off", true, 4, false);
        RUN_IO = new DebuggingOption("run_io", new String[]{"window", "stdio", "pty"}, "window", true, 2, false);
        RUN_PTY = new DebuggingOption("run_pty", "", true, 1, false);
        RUN_QUICK = new DebuggingOption("run_quick", new String[]{"on", "off"}, "off", true, 2, false);
        RUN_SAVETTY = new DebuggingOption("run_savetty", new String[]{"on", "off"}, "on", true, 4, false);
        RUN_SETPGRP = new DebuggingOption("run_setpgrp", new String[]{"on", "off"}, "off", true, 4, false);
        SCOPE_GLOBAL_ENUMS = new DebuggingOption("scope_global_enums", new String[]{"on", "off"}, "off", true, 4, false);
        SCOPE_LOOK_ASIDE = new DebuggingOption("scope_look_aside", new String[]{"on", "off"}, "on", true, 4, false);
        FRONT_DBGWIN = new DebuggingOption("front_dbgwin", new String[]{"on", "off"}, "on", false, 2, false);
        FRONT_PIO = new DebuggingOption("front_pio", new String[]{"on", "off"}, "on", false, 2, false);
        FRONT_DBX = new DebuggingOption("front_dbx", new String[]{"on", "off"}, "off", false, 2, false);
        FRONT_ACCESS = new DebuggingOption("front_access", new String[]{"on", "off"}, "on", false, 2, false);
        FRONT_MEMUSE = new DebuggingOption("front_memuse", new String[]{"on", "off"}, "off", false, 2, false);
        OPEN_THREADS = new DebuggingOption("open_threads", new String[]{"on", "off"}, "on", false, 2, false);
        OPEN_SESSIONS = new DebuggingOption("open_sessions", new String[]{"on", "off"}, "on", false, 2, false);
        SAVE_BREAKPOINTS = new DebuggingOption("save_breakpoints", new String[]{"on", "off"}, "on", false, 2, false);
        BALLOON_EVAL = new DebuggingOption("balloon_eval", new String[]{"on", "off"}, "on", false, 2, false);
        STACK_FIND_SOURCE = new DebuggingOption("stack_find_source", new String[]{"on", "off"}, "on", true, 4, false);
        STACK_MAX_SIZE = new DebuggingOption("stack_max_size", "100", true, 1, false);
        STACK_VERBOSE = new DebuggingOption("stack_verbose", new String[]{"on", "off"}, "on", true, 2, false);
        STEP_EVENTS = new DebuggingOption("step_events", new String[]{"on", "off"}, "off", true, 4, false);
        STEP_GRANULARITY = new DebuggingOption("step_granularity", new String[]{"statement", "line"}, "statement", true, 2, false);
        SUPPRESS_STARTUP_MESSAGE = new DebuggingOption("suppress_startup_message", "7.0", true, 1, false);
        SYMBOL_INFO_COMPRESSION = new DebuggingOption("symbol_info_compression", new String[]{"on", "off"}, "on", true, 2, false);
        TRACE_SPEED = new DebuggingOption("trace_speed", "0.50", true, 1, false);
        needSave = false;
        needOpen = true;
    }
}

