/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.options;

import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.debugger.options.OptionsDialog;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.common.utils.UsageTracking;
import javax.swing.JLabel;
import javax.swing.JPanel;

abstract class BaseOptionUI {
    JLabel label = null;
    DebuggingOption option = null;
    static int LABEL_COLUMNS_MAX = 25;
    static int LABEL_COLUMNS_MIN = 10;
    String currValue = null;
    boolean hasLabel = true;
    protected OptionsDialog dialog = null;

    BaseOptionUI(DebuggingOption inOption, OptionsDialog dialog) {
        this(inOption, true, LABEL_COLUMNS_MAX, dialog);
    }

    BaseOptionUI(DebuggingOption inOption, boolean hasLabel, OptionsDialog dialog) {
        this(inOption, hasLabel, LABEL_COLUMNS_MAX, dialog);
    }

    BaseOptionUI(DebuggingOption inOption, int labelColumns, OptionsDialog dialog) {
        this(inOption, true, labelColumns, dialog);
    }

    BaseOptionUI(DebuggingOption inOption, boolean hasLabel, int labelColumns, OptionsDialog dialog) {
        this.option = inOption;
        if (hasLabel) {
            hasLabel = DebuggingOption.overrideHasLabel(inOption);
        }
        this.hasLabel = hasLabel;
        if (this.option != null) {
            this.currValue = this.option.getCurrValue();
            this.option.setUI(this);
        }
        this.dialog = dialog;
    }

    public JLabel createLabel() {
        JLabel l = new JLabel();
        IpeUtils.setLabelText(l, this.option.getLabel(), true);
        if (this.option.getLabelTip() != null) {
            l.setToolTipText(this.option.getLabelTip());
        }
        return l;
    }

    public String getValue() {
        return this.currValue;
    }

    protected abstract String getValueFromUI();

    protected abstract void updateUI();

    public void cancelChanges() {
        String prevValue = this.currValue;
        this.currValue = this.getValueFromUI();
        if (this.currValue.equals(prevValue)) {
            return;
        }
        this.setValue(prevValue);
    }

    public void applyChanges() {
        String prevValue = this.currValue;
        this.currValue = this.getValueFromUI();
        if (this.currValue.equals(prevValue)) {
            return;
        }
        this.option.setCurrValue(this.currValue);
        if (this.option.isDbxOption()) {
            this.dialog.applyDbxOption(this.option.getName(), this.currValue);
        }
        if (UsageTracking.enabled) {
            if (this.option.getType() != 1) {
                UsageTracking.sendAction((String)("Set Debug Option " + this.option.getName() + " to " + this.currValue), null);
            } else {
                UsageTracking.sendAction((String)("Set Debug Option " + this.option.getName()), null);
            }
        }
    }

    public void setValue(String newValue) {
        this.currValue = newValue;
        this.updateUI();
    }

    public void addOption(JPanel parent) {
    }
}

