/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.loadpicklist;

import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.debugger.loadpicklist.LoadCoreElementPanel;
import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.picklist.ElementChangeEvent;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.util.NbBundle;

public class LoadCoreActionElementPanel
extends LoadCoreElementPanel {
    private DataNode foundCorefile = null;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadCoreActionElementPanel;

    public LoadCoreActionElementPanel() {
        super(true);
    }

    public void validate() {
        String corefilePath = this.getCorefile();
        if (corefilePath == null || corefilePath.length() == 0) {
            this.fireChanged(new ElementChangeEvent((Object)this, 5));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundCorefile = null;
            return;
        }
        File corefileFile = new File(corefilePath);
        if (!corefileFile.exists()) {
            this.fireChanged(new ElementChangeEvent((Object)this, 4, this.getString("ERROR_CORE_DONTEXIST")));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundCorefile = null;
            return;
        }
        if (corefileFile.isDirectory()) {
            this.fireChanged(new ElementChangeEvent((Object)this, 4, this.getString("ERROR_NOTACOREFILE")));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundCorefile = null;
            return;
        }
        DataNode corefileNode = PicklistUtils.findCorefileNode((String)corefilePath);
        this.initPanel(corefileNode);
    }

    public void initPanelFromNode(DataNode corefileNode) {
        if (corefileNode != null && corefileNode.getDataObject() != null) {
            this.setCorefile(CppUtils.getPath((FileObject)corefileNode.getDataObject().getPrimaryFile()));
        }
        this.initPanel(corefileNode);
    }

    private void initPanel(DataNode corefileNode) {
        RunConfig config = null;
        if (corefileNode != null) {
            config = RunConfig.findConfig(corefileNode, null);
        }
        if (config == null) {
            this.fireChanged(new ElementChangeEvent((Object)this, 4, this.getString("ERROR_NOTACOREFILE")));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundCorefile = null;
            return;
        }
        this.fireChanged(new ElementChangeEvent((Object)this, 5));
        this.fireChanged(new ElementChangeEvent((Object)this, 2));
        this.setAttrFieldsEnabled(true);
        if (corefileNode != this.foundCorefile) {
            this.setRunConfig(config);
        }
        this.foundCorefile = corefileNode;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadCoreActionElementPanel == null ? (class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadCoreActionElementPanel = LoadCoreActionElementPanel.class$("com.sun.tools.debugger.dbxgui.debugger.loadpicklist.LoadCoreActionElementPanel")) : class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadCoreActionElementPanel));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

