/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.loadpicklist;

import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.debugger.loadpicklist.LoadElementPanel;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.picklist.ElementChangeEvent;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.util.NbBundle;

public class LoadActionElementPanel
extends LoadElementPanel
implements MakefileWizardListener {
    private DataNode foundExecutable = null;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadActionElementPanel;

    public LoadActionElementPanel() {
        super(true);
        MakefileWizard.addMakefileWizardListener((MakefileWizardListener)this);
    }

    public void validate() {
        String executablePath = this.getExecutable();
        if (executablePath == null || executablePath.length() == 0) {
            this.fireChanged(new ElementChangeEvent((Object)this, 5));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        File executableFile = new File(executablePath);
        if (!executableFile.exists()) {
            this.fireChanged(new ElementChangeEvent((Object)this, 4, this.getString("ERROR_DONTEXIST")));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        if (executableFile.isDirectory()) {
            this.fireChanged(new ElementChangeEvent((Object)this, 4, this.getString("ERROR_NOTAEXEFILE")));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        DataNode executableNode = PicklistUtils.findDebuggableNode((String)executablePath);
        this.initPanel(executableNode);
    }

    public void initPanelFromNode(DataNode executableNode) {
        if (executableNode != null && executableNode.getDataObject() != null) {
            this.setExecutable(CppUtils.getPath((FileObject)executableNode.getDataObject().getPrimaryFile()));
        }
        this.initPanel(executableNode);
    }

    private void initPanel(DataNode executableNode) {
        RunConfig config = RunConfig.findConfig(executableNode, null);
        if (config == null) {
            this.fireChanged(new ElementChangeEvent((Object)this, 4, this.getString("ERROR_NOTAEXEFILE")));
            this.fireChanged(new ElementChangeEvent((Object)this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        this.fireChanged(new ElementChangeEvent((Object)this, 5));
        this.fireChanged(new ElementChangeEvent((Object)this, 2));
        this.setAttrFieldsEnabled(true);
        if (executableNode != this.foundExecutable) {
            String args = config.getUnparsedArgs();
            if (args == null) {
                args = "";
            }
            this.setArguments(args);
            if (config.getRunDir() == null || config.getRunDir().length() == 0) {
                this.setRunDirectory(IpeUtils.getDirName(this.getExecutable()));
            } else {
                this.setRunDirectory(config.getRunDir());
            }
            this.setRunConfig(config);
        }
        this.foundExecutable = executableNode;
    }

    public void makefileCreated(MakefileWizardEvent e) {
        String[] executables = e.getExecutables();
        if (executables != null && executables.length > 0) {
            this.setExecutable(executables[0]);
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
        }
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadActionElementPanel == null ? (class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadActionElementPanel = LoadActionElementPanel.class$("com.sun.tools.debugger.dbxgui.debugger.loadpicklist.LoadActionElementPanel")) : class$com$sun$tools$debugger$dbxgui$debugger$loadpicklist$LoadActionElementPanel));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

