/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SignalBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SystemInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.debugger.Controller;

public class SignalBreakpointPanel
extends BreakpointPanel
implements Controller {
    private SignalBreakpoint fb;
    private Vector subcodeValues = null;
    private SystemInfo.Subcodes si_subcodes;
    private ButtonGroup buttonGroup1;
    private JLabel signalLabel;
    private JComboBox signalCombo;
    private JLabel subcodeLabel;
    private JComboBox subcodeCombo;
    private boolean lastWasEmpty = false;
    private String lastSignal = null;

    public SignalBreakpointPanel(SignalBreakpoint event) {
        super(event);
        Document d;
        this.fb = event;
        this.initComponents();
        this.addCommonComponents(2);
        Component c = this.signalCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        this.signalCombo.setEditable(true);
        this.subcodeCombo.setEditable(true);
        c = this.subcodeCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        Vector<String> comboValues = new Vector<String>(250);
        comboValues.add("SIGSEGV");
        SystemInfo.Signals si_signals = new SystemInfo.Signals(comboValues);
        si_signals.stuffInto(this.signalCombo);
        this.subcodeValues = new Vector(30);
        this.si_subcodes = new SystemInfo.Subcodes(this.subcodeValues);
        this.si_subcodes.stuffInto(this.subcodeCombo);
        this.updateSubcodeList();
    }

    private void initComponents() {
        this.signalLabel = new JLabel();
        this.signalCombo = new JComboBox();
        this.subcodeLabel = new JLabel();
        this.subcodeCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.signalLabel.setText(IpeBreakpointEvent.getText("Signal"));
        this.signalLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("SignalMnemonic").charAt(0));
        this.signalLabel.setLabelFor(this.signalCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.signalLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.signalCombo, gridBagConstraints1);
        this.subcodeLabel.setText(IpeBreakpointEvent.getText("Subcode"));
        this.subcodeLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("SubcodeMnemonic").charAt(0));
        this.subcodeLabel.setLabelFor(this.subcodeCombo);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.subcodeLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.subcodeCombo, gridBagConstraints1);
        this.signalCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Signal"));
        this.subcodeCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Subcode"));
    }

    public boolean ok() {
        String code;
        if (!super.ok()) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        String sig = this.signalCombo.getSelectedItem().toString();
        this.fb.setSignal(sig);
        if (this.subcodeCombo.getSelectedItem() != null && !(code = this.subcodeCombo.getSelectedItem().toString()).equals(this.si_subcodes.all())) {
            this.fb.setSubcode(code);
        }
        this.post();
        return true;
    }

    public boolean isValid() {
        this.updateSubcodeList();
        Component c = this.signalCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            String text = ((JTextComponent)c).getText();
            return text != null && text.trim().length() != 0;
        }
        if (this.signalCombo.getSelectedItem() != null && this.signalCombo.getSelectedItem().toString() != null && this.signalCombo.getSelectedItem().toString().trim().length() != 0) {
            return true;
        }
        return true;
    }

    private void clearOutList() {
        if (!this.lastWasEmpty) {
            DefaultComboBoxModel dfm = (DefaultComboBoxModel)this.subcodeCombo.getModel();
            dfm.removeAllElements();
            this.lastWasEmpty = true;
        }
    }

    private void updateSubcodeList() {
        if (this.subcodeValues.size() <= 1) {
            return;
        }
        Component c = this.signalCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            String text = ((JTextComponent)c).getText();
            if (this.lastSignal != null && this.lastSignal.equals(text)) {
                return;
            }
            this.lastSignal = text;
            Vector nw = this.si_subcodes.subcodesFor(text);
            if (nw == null) {
                this.clearOutList();
            } else {
                this.subcodeCombo.setModel(new DefaultComboBoxModel(nw));
            }
        }
    }
}

