/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ProcessBreakpoint;
import com.sun.tools.debugger.dbxgui.props.ProcessEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.debugger.Controller;

public class ProcessBreakpointPanel
extends BreakpointPanel
implements Controller {
    private ProcessEvent processType;
    private ProcessBreakpoint fb;
    private ButtonGroup buttonGroup1;
    private JLabel processLabel;
    private JComboBox processCombo;
    private JLabel exitCodeLabel;
    private JTextField exitCodeField;

    public ProcessBreakpointPanel(ProcessBreakpoint event) {
        super(event);
        this.fb = event;
        this.processType = this.fb.getSubEvent();
        this.initComponents();
        this.addCommonComponents(1);
        this.processCombo.setEditable(false);
        String[] comboValues = ProcessEvent.getTags();
        this.processCombo.setModel(new DefaultComboBoxModel<String>(comboValues));
        this.adjustexitcode();
        this.processCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String value = ProcessBreakpointPanel.this.processCombo.getSelectedItem().toString();
                if (value == null) {
                    return;
                }
                ProcessBreakpointPanel.this.processType = ProcessEvent.byTag(value);
                ProcessBreakpointPanel.this.adjustexitcode();
            }
        });
    }

    public boolean validateFields() {
        try {
            int i = Integer.parseInt(this.exitCodeField.getText());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return super.validateFields();
    }

    private void initComponents() {
        this.processLabel = new JLabel();
        this.processCombo = new JComboBox();
        this.exitCodeLabel = new JLabel();
        this.exitCodeField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.processLabel.setText(IpeBreakpointEvent.getText("Event"));
        this.processLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("EventMnemonic").charAt(0));
        this.processLabel.setLabelFor(this.processCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.ipady = 0;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.processLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.processCombo, gridBagConstraints1);
        this.exitCodeLabel.setText(IpeBreakpointEvent.getText("ExitCode"));
        this.exitCodeLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("EventMnemonic").charAt(0));
        this.exitCodeLabel.setLabelFor(this.exitCodeField);
        this.exitCodeLabel.setEnabled(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 6;
        gridBagConstraints1.ipady = 0;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.exitCodeLabel, gridBagConstraints1);
        this.exitCodeField.setColumns(3);
        this.exitCodeField.setEditable(false);
        this.exitCodeField.setEnabled(false);
        JPanel exitCodePanel = new JPanel();
        exitCodePanel.setLayout(new BorderLayout());
        exitCodePanel.add((Component)this.exitCodeField, "West");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 6;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = 17;
        this.add((Component)exitCodePanel, gridBagConstraints1);
        this.processCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Event"));
    }

    public boolean ok() {
        if (this.processType == ProcessEvent.EXIT) {
            this.fb.setExitCode(this.exitCodeField.getText());
            if (!super.ok()) {
                return false;
            }
        }
        String selection = this.processCombo.getSelectedItem().toString();
        this.fb.setSubEvent(ProcessEvent.byTag(selection));
        this.adjustexitcode();
        this.post();
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private void adjustexitcode() {
        if (this.processType == ProcessEvent.EXIT) {
            this.exitCodeLabel.setEnabled(true);
            this.exitCodeField.setEditable(true);
            this.exitCodeField.setEnabled(true);
        } else {
            this.exitCodeField.setEditable(false);
            this.exitCodeField.setEnabled(false);
        }
    }
}

