/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.LoadObjBreakpoint;
import com.sun.tools.debugger.dbxgui.props.DlEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.debugger.Controller;

public class LoadObjBreakpointPanel
extends BreakpointPanel
implements Controller {
    private LoadObjBreakpoint fb;
    private ButtonGroup buttonGroup1;
    private JLabel loadObjLabel;
    private JComboBox loadObjCombo;
    private JRadioButton openToggle;
    private JRadioButton closeToggle;

    public LoadObjBreakpointPanel(LoadObjBreakpoint event) {
        super(event);
        this.fb = event;
        this.initComponents();
        this.addCommonComponents(3);
        this.openToggle.setSelected(true);
        String[] comboValues = new String[]{DlEvent.all()};
        this.loadObjCombo.setModel(new DefaultComboBoxModel<String>(comboValues));
        this.loadObjCombo.setSelectedIndex(0);
        this.loadObjCombo.setEditable(true);
        Component c = this.loadObjCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.loadObjLabel = new JLabel();
        this.loadObjCombo = new JComboBox();
        this.openToggle = new JRadioButton();
        this.closeToggle = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.loadObjLabel.setText(IpeBreakpointEvent.getText("LoadObject"));
        this.loadObjLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("LoadObjectMnemonic").charAt(0));
        this.loadObjLabel.setLabelFor(this.loadObjCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.loadObjLabel, gridBagConstraints1);
        this.loadObjCombo.setEditable(true);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.loadObjCombo, gridBagConstraints1);
        this.openToggle.setText(IpeBreakpointEvent.getText("OnOpen"));
        this.openToggle.setMnemonic(IpeBreakpointEvent.getText("OnOpenMnemonic").charAt(0));
        this.buttonGroup1.add(this.openToggle);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.openToggle, gridBagConstraints1);
        this.closeToggle.setText(IpeBreakpointEvent.getText("OnClose"));
        this.closeToggle.setMnemonic(IpeBreakpointEvent.getText("OnCloseMnemonic").charAt(0));
        this.buttonGroup1.add(this.closeToggle);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.closeToggle, gridBagConstraints1);
        this.loadObjCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_LoadObject"));
        this.openToggle.getAccessibleContext().setAccessibleDescription(this.openToggle.getText());
        this.closeToggle.getAccessibleContext().setAccessibleDescription(this.closeToggle.getText());
    }

    public boolean ok() {
        if (!super.ok()) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        String loadObj = this.loadObjCombo.getSelectedItem().toString();
        if (loadObj.equals(DlEvent.all())) {
            loadObj = null;
        }
        this.fb.setLoadObj(loadObj);
        if (this.openToggle.isSelected()) {
            this.fb.setDlEvent(DlEvent.OPEN);
        } else {
            this.fb.setDlEvent(DlEvent.CLOSE);
        }
        this.post();
        return true;
    }

    public boolean isValid() {
        Component c = this.loadObjCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            String text = ((JTextComponent)c).getText();
            return text != null && text.trim().length() != 0;
        }
        return this.loadObjCombo.getSelectedItem().toString().trim().length() != 0;
    }
}

