/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.LineBreakpoint;
import com.sun.tools.debugger.dbxgui.utils.UnixFileSystemView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.debugger.Controller;

public class LineBreakpointPanel
extends BreakpointPanel
implements Controller {
    private LineBreakpoint lb;
    private JTextField lineField;
    private JLabel lineLabel;
    private JButton browseButton;
    private JLabel fileLabel;
    private JTextField fileText;

    public LineBreakpointPanel(LineBreakpoint event) {
        super(event);
        String s;
        this.lb = event;
        this.initComponents();
        this.addCommonComponents(2);
        if (this.lb.getLineNumber() >= 1) {
            this.lineField.setText(Integer.toString(this.lb.getLineNumber()));
        }
        if ((s = this.lb.getFileName()) != null && s.trim().length() >= 1) {
            this.fileText.setText(s.trim());
        }
        this.fileText.getDocument().addDocumentListener(this);
        this.lineField.getDocument().addDocumentListener(this);
        this.lineField.selectAll();
        this.fileText.requestDefaultFocus();
        this.fileText.requestFocus();
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileText = new JTextField();
        this.browseButton = new JButton();
        this.lineLabel = new JLabel();
        this.lineField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.fileLabel.setText(IpeBreakpointEvent.getText("File"));
        this.fileLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("FileMnemonic").charAt(0));
        this.fileLabel.setLabelFor(this.fileText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fileText, gridBagConstraints);
        this.browseButton.setMnemonic(IpeBreakpointEvent.getText("BrowseMnemonic").charAt(0));
        this.browseButton.setText(IpeBreakpointEvent.getText("Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LineBreakpointPanel.this.onBrowse(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.lineLabel.setText(IpeBreakpointEvent.getText("Line"));
        this.lineLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("LineMnemonic").charAt(0));
        this.lineLabel.setLabelFor(this.lineField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lineLabel, gridBagConstraints);
        this.lineField.setColumns(12);
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new BorderLayout());
        linePanel.add((Component)this.lineField, "West");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)linePanel, gridBagConstraints);
        this.lineField.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Line"));
        this.fileText.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_File"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(this.browseButton.getText());
    }

    private void onBrowse(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
        chooser.setFileHidingEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.fileText.setText(chooser.getSelectedFile().getParent() + "/" + chooser.getSelectedFile().getName());
        }
    }

    public boolean validateFields() {
        try {
            int i = Integer.parseInt(this.lineField.getText());
            this.lb.setFileAndLine(this.fileText.getText(), i);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return super.validateFields();
    }

    public boolean ok() {
        if (!super.ok()) {
            return false;
        }
        this.post();
        return true;
    }

    public boolean isValid() {
        String l = this.lineField.getText().trim();
        if (l.equals("")) {
            return false;
        }
        try {
            int i = Integer.parseInt(this.lineField.getText());
            if (i < 1) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

