/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.LineBreakpointPanel;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import javax.swing.JComponent;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.actions.SystemAction;

public class LineBreakpoint
extends IpeBreakpointEvent
implements StopEvent {
    private int lineNumber = -1;
    private Line line = null;
    private String fileName;
    static final long serialVersionUID = 1444281317183220550L;
    public static final String TYPE_NAME = "FDLine";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_FILE_NAME = "file";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;

    public LineBreakpoint() {
        this.getCustomizer();
    }

    public LineBreakpoint(LineBreakpointEvent clb) {
        this();
        this.line = clb.getLine();
        this.lineNumber = this.line.getLineNumber();
        DataObject dao = this.line.getDataObject();
        FileObject fo = dao.getPrimaryFile();
        this.fileName = CppUtils.getPath((FileObject)fo);
    }

    public LineBreakpoint(Line line) {
        this();
        this.line = line;
        DataObject dao = line.getDataObject();
        this.fileName = CppUtils.getPath((FileObject)dao.getPrimaryFile());
        this.lineNumber = line.getLineNumber() + 1;
    }

    public static String getPropFileName(Node[] nodes) {
        if (nodes == null) {
            return "";
        }
        if (nodes.length != 1) {
            return "";
        }
        Node n = nodes[0];
        DataObject dO = null;
        if (n instanceof DataNode) {
            dO = ((DataNode)n).getDataObject();
        }
        if (dO == null) {
            dO = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LineBreakpoint.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (dO == null) {
            return "";
        }
        return CppUtils.getPath((FileObject)dO.getPrimaryFile());
    }

    public CoreBreakpoint.Event getNewInstance() {
        return new LineBreakpoint();
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public void setFileName(String cn) {
        if (cn == this.fileName || cn != null && this.fileName != null && this.fileName.equals(cn)) {
            return;
        }
        String old = this.fileName;
        this.fileName = cn;
        int ln = this.getLineNumber();
        this.line = null;
        this.firePropertyChange(PROP_FILE_NAME, old, this.fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPropFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getPropLineNumber() {
        if (this.line != null) {
            int num = this.line.getLineNumber() + 1;
            return num;
        }
        return this.lineNumber;
    }

    public void setLineNumber(int ln) {
        if (ln == this.lineNumber) {
            return;
        }
        int old = this.lineNumber;
        if (ln > 0) {
            this.line = DbxDebugger.getLine(this.fileName, ln);
            this.lineNumber = ln;
            if (this.handler != null) {
                this.handler.removeAnnotations();
                if (this.line != null) {
                    this.handler.addAnnotation(this.line);
                }
            }
        } else {
            this.line = null;
            this.lineNumber = -1;
            if (this.handler != null) {
                this.handler.removeAnnotations();
            }
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(this.getLineNumber()));
    }

    public void setPropLineNumber(int Ln) {
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line l) {
        if (this.line == l) {
            return;
        }
        Line old = this.line;
        this.line = l;
        if (this.line != null) {
            this.fileName = CppUtils.getPath((FileObject)this.line.getDataObject().getPrimaryFile());
            this.firePropertyChange(PROP_LINE_NUMBER, old, this.line);
        }
    }

    public JComponent getCustomizer() {
        String fname = LineBreakpoint.getCurrentFileName();
        if (fname != null) {
            this.setFileAndLine(fname, Utils.getCurrentLineNumber());
        }
        return new LineBreakpointPanel(this);
    }

    private static String getCurrentFileName() {
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = LineBreakpoint.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        Node node = nodes[0];
        DataObject dobj = null;
        if (node instanceof DataNode) {
            dobj = ((DataNode)node).getDataObject();
        }
        if (dobj == null) {
            dobj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LineBreakpoint.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (dobj == null) {
            return null;
        }
        if (dobj instanceof DataShadow) {
            dobj = ((DataShadow)dobj).getOriginal();
        }
        return CppUtils.getPath((FileObject)dobj.getPrimaryFile());
    }

    public Node.Property[] getProperties() {
        PropFactory pf = new PropFactory(this, null);
        super.fillPropertiesPre(pf);
        pf.addString(PROP_FILE_NAME, "PROP_breakpoint_line_file", "HINT_breakpoint_line_file", "getPropFileName", null);
        pf.addInteger(PROP_LINE_NUMBER, "PROP_breakpoint_line_number", "HINT_breakpoint_line_number", "getPropLineNumber", null);
        super.fillPropertiesPost(pf);
        return pf.getProperties();
    }

    public Line[] getLines() {
        if (this.line == null) {
            return null;
        }
        return new Line[]{this.line};
    }

    public String getTypeDisplayName() {
        return IpeBreakpointEvent.getText("CTL_Line_event_type_name");
    }

    public boolean isDefault() {
        return true;
    }

    public void setFileAndLine(String file, int ln) {
        String oldName = this.fileName;
        this.fileName = file;
        int oldLineNo = this.lineNumber;
        if (ln > 0) {
            this.line = DbxDebugger.getLine(this.fileName, ln);
            this.lineNumber = ln;
        } else {
            this.line = null;
            this.lineNumber = -1;
        }
        this.firePropertyChange(PROP_FILE_NAME, oldName, this.fileName);
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(oldLineNo), new Integer(this.getLineNumber()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

