/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeStopAction;
import com.sun.tools.debugger.dbxgui.props.AId;
import com.sun.tools.debugger.dbxgui.props.CountLimit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.debugger.Controller;
import org.netbeans.modules.debugger.support.util.PropertyChangeListeners;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class BreakpointPanel
extends JPanel
implements Controller,
DocumentListener,
HelpCtx.Provider {
    private IpeBreakpointEvent event;
    private PropertyChangeListeners pcl = null;
    private static boolean showingDetails = false;
    private JSeparator separator;
    private JButton moreButton;
    private JLabel whileLabel;
    private JTextField whileField;
    private JLabel conditionLabel;
    private JTextField conditionField;
    private JLabel lwpLabel;
    private JTextField lwpField;
    private JLabel threadLabel;
    private JTextField threadField;
    private JLabel countLimitLabel;
    private JComboBox countLimitCombo;
    private JLabel countLabel;
    private JTextField countField;
    private JLabel tempLabel;
    private JCheckBox tempCheckBox;
    private JLabel javaLabel;
    private JComboBox javaCombo = null;
    private boolean checkPlanned = false;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel;

    public BreakpointPanel(IpeBreakpointEvent newEvent) {
        this.event = newEvent;
    }

    private String trim(JTextField tf) {
        String s = tf.getText();
        if (s != null && s.trim().length() > 0) {
            return s.trim();
        }
        return null;
    }

    protected boolean badField(String f, String err) {
        IllegalArgumentException ex = new IllegalArgumentException();
        String fname = NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel = BreakpointPanel.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel), (String)f);
        String msg = NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel = BreakpointPanel.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$BreakpointPanel), (String)"ERR_invalid_field", (Object)err, (Object)fname);
        ErrorManager.getDefault().annotate((Throwable)ex, msg);
        ErrorManager.getDefault().notify(256, (Throwable)ex);
        return false;
    }

    public boolean validateFields() {
        String javaText;
        if (this.javaCombo != null && (javaText = (String)this.javaCombo.getSelectedItem()) != null) {
            if (javaText.equals(DbxDebugger.getText("Sessions_Table_ModeJava"))) {
                this.event.setJava("java");
            } else if (javaText.equals(DbxDebugger.getText("Sessions_Table_ModeNative"))) {
                this.event.setJava("native");
            } else {
                this.event.setJava(null);
            }
        }
        this.event.setWhileIn(this.trim(this.whileField));
        this.event.setCondition(this.trim(this.conditionField));
        AId tid = new AId(this.threadField.getText(), false, false);
        if (tid.errorMessage != null) {
            return this.badField("PROP_thread", tid.errorMessage);
        }
        this.event.setThread(tid.toString());
        AId lid = new AId(this.lwpField.getText(), true, false);
        if (lid.errorMessage != null) {
            return this.badField("PROP_lwp", lid.errorMessage);
        }
        this.event.setLwp(lid.toString());
        this.event.setTemp(this.tempCheckBox.isSelected());
        String countLimitText = (String)this.countLimitCombo.getEditor().getItem();
        CountLimit countLimit = new CountLimit(countLimitText);
        if (countLimit.errorMessage != null) {
            return this.badField("PROP_count_limit", countLimit.errorMessage);
        }
        if (countLimit.enable) {
            this.event.setCountLimit(countLimit.count, countLimit.enable);
        } else {
            this.event.setCountLimit(1L, countLimit.enable);
        }
        return true;
    }

    public boolean ok() {
        if (!this.validateFields()) {
            return false;
        }
        this.event.setAction(IpeStopAction.getAction());
        this.event.setScript(IpeStopAction.getScript());
        return true;
    }

    protected void post() {
        this.event.set();
    }

    public final boolean cancel() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcl == null) {
            this.pcl = new PropertyChangeListeners((Object)this);
        }
        this.pcl.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcl != null) {
            this.pcl.removePropertyChangeListener(l);
        }
    }

    protected void addCommonComponents(int y) {
        this.moreButton = new JButton();
        this.separator = new JSeparator();
        this.whileLabel = new JLabel();
        this.whileField = new JTextField();
        this.conditionLabel = new JLabel();
        this.conditionField = new JTextField();
        this.lwpLabel = new JLabel();
        this.lwpField = new JTextField();
        this.threadLabel = new JLabel();
        this.threadField = new JTextField();
        this.countLimitLabel = new JLabel();
        this.countLimitCombo = new JComboBox();
        this.countLabel = new JLabel();
        this.countField = new JTextField();
        this.tempLabel = new JLabel();
        this.tempCheckBox = new JCheckBox(" ");
        this.javaLabel = new JLabel();
        this.javaCombo = new JComboBox();
        this.moreButton.setText(IpeBreakpointEvent.getText("More"));
        this.moreButton.setMnemonic(IpeBreakpointEvent.getText("MoreMnemonic").charAt(0));
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BreakpointPanel.this.onLessMore();
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.moreButton, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 13;
        this.add((Component)this.separator, gridBagConstraints2);
        this.javaLabel.setText(IpeBreakpointEvent.getText("JavaBptMode"));
        this.javaLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("JavaBptModeMnemonic").charAt(0));
        this.javaLabel.setLabelFor(this.javaCombo);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.javaLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.javaCombo, gridBagConstraints2);
        this.whileLabel.setText(IpeBreakpointEvent.getText("WhileIn"));
        this.whileLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("WhileInMnemonic").charAt(0));
        this.whileLabel.setLabelFor(this.whileField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.whileLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.add((Component)this.whileField, gridBagConstraints2);
        this.conditionLabel.setText(IpeBreakpointEvent.getText("Condition"));
        this.conditionLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("ConditionMnemonic").charAt(0));
        this.conditionLabel.setLabelFor(this.conditionField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.conditionLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.conditionField, gridBagConstraints2);
        this.lwpLabel.setText(IpeBreakpointEvent.getText("LWP"));
        this.lwpLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("LWPMnemonic").charAt(0));
        this.lwpLabel.setLabelFor(this.lwpField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.lwpLabel, gridBagConstraints2);
        this.lwpField.setColumns(6);
        JPanel lwpPanel = new JPanel();
        lwpPanel.setLayout(new BorderLayout());
        lwpPanel.add((Component)this.lwpField, "West");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        this.add((Component)lwpPanel, gridBagConstraints2);
        this.threadLabel.setText(IpeBreakpointEvent.getText("Thread"));
        this.threadLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("ThreadMnemonic").charAt(0));
        this.threadLabel.setLabelFor(this.threadField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.threadLabel, gridBagConstraints2);
        this.threadField.setColumns(6);
        JPanel threadPanel = new JPanel();
        threadPanel.setLayout(new BorderLayout());
        threadPanel.add((Component)this.threadField, "West");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        this.add((Component)threadPanel, gridBagConstraints2);
        this.countLimitLabel.setText(IpeBreakpointEvent.getText("CountLimit"));
        this.countLimitLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("CountLimitMnemonic").charAt(0));
        this.countLimitLabel.setLabelFor(this.countLimitCombo);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.countLimitLabel, gridBagConstraints2);
        this.countLimitCombo.setEditable(true);
        this.countLimitCombo.addItem(CountLimit.Action_INFINITY);
        this.countLimitCombo.getEditor().setItem("");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.countLimitCombo, gridBagConstraints2);
        Dimension ref_dim = this.threadField.getPreferredSize();
        Dimension combo_dim = this.countLimitCombo.getPreferredSize();
        combo_dim.height = ref_dim.height;
        this.countLimitCombo.setPreferredSize(combo_dim);
        JPanel ccountPanel = new JPanel();
        ccountPanel.setLayout(new BorderLayout());
        ccountPanel.add((Component)this.countLabel, "West");
        ccountPanel.add((Component)this.countField, "Center");
        this.countLabel.setText(IpeBreakpointEvent.getText("CurrentCount"));
        this.countLabel.setLabelFor(this.countField);
        this.countLabel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 10)));
        this.countField.setEditable(false);
        this.countField.setColumns(5);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.1;
        this.add((Component)ccountPanel, gridBagConstraints2);
        this.tempLabel.setText(IpeBreakpointEvent.getText("Temp"));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.tempLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = y++;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.tempCheckBox, gridBagConstraints2);
        this.adjustModifiers();
        if (this.javaCombo != null) {
            String def = IpeBreakpointEvent.getText("Default");
            String nat = DbxDebugger.getText("Sessions_Table_ModeNative");
            String jv = DbxDebugger.getText("Sessions_Table_ModeJava");
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{def, nat, jv});
            this.javaCombo.setModel(model);
        }
        this.whileField.getDocument().addDocumentListener(this);
        this.conditionField.getDocument().addDocumentListener(this);
        this.lwpField.getDocument().addDocumentListener(this);
        this.threadField.getDocument().addDocumentListener(this);
        this.initA11y();
    }

    private void initA11y() {
        this.moreButton.getAccessibleContext().setAccessibleDescription(this.moreButton.getText());
        this.whileField.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_WhileIn"));
        this.conditionField.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Condition"));
        this.lwpField.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_LWP"));
        this.threadField.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Thread"));
        this.countLimitCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_CountLimit"));
        this.countField.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_CurrentCount"));
        this.tempCheckBox.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Temp"));
        this.javaCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_JavaBptMode"));
    }

    private void onLessMore() {
        showingDetails = !showingDetails;
        this.adjustModifiers();
    }

    private void adjustModifiers() {
        this.separator.setVisible(showingDetails);
        this.whileLabel.setVisible(showingDetails);
        this.whileField.setVisible(showingDetails);
        this.conditionLabel.setVisible(showingDetails);
        this.conditionField.setVisible(showingDetails);
        this.lwpLabel.setVisible(showingDetails);
        this.lwpField.setVisible(showingDetails);
        this.threadLabel.setVisible(showingDetails);
        this.threadField.setVisible(showingDetails);
        this.countLimitLabel.setVisible(showingDetails);
        this.countLimitCombo.setVisible(showingDetails);
        this.countLabel.setVisible(showingDetails);
        this.countField.setVisible(showingDetails);
        this.tempLabel.setVisible(showingDetails);
        this.tempCheckBox.setVisible(showingDetails);
        this.javaLabel.setVisible(showingDetails);
        this.javaCombo.setVisible(showingDetails);
        if (showingDetails) {
            this.moreButton.setText(IpeBreakpointEvent.getText("Less"));
            this.moreButton.setMnemonic(IpeBreakpointEvent.getText("LessMnemonic").charAt(0));
        } else {
            this.moreButton.setText(IpeBreakpointEvent.getText("More"));
            this.moreButton.setMnemonic(IpeBreakpointEvent.getText("MoreMnemonic").charAt(0));
        }
        this.moreButton.getAccessibleContext().setAccessibleDescription(this.moreButton.getText());
        this.revalidate();
        Window w = SwingUtilities.windowForComponent(this);
        if (w == null) {
            return;
        }
        w.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValidSoon() {
        if (this.pcl == null) {
            return;
        }
        PropertyChangeListeners propertyChangeListeners = this.pcl;
        synchronized (propertyChangeListeners) {
            if (this.checkPlanned) {
                return;
            }
            this.checkPlanned = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PropertyChangeListeners propertyChangeListeners = BreakpointPanel.this.pcl;
                synchronized (propertyChangeListeners) {
                    BreakpointPanel.this.checkPlanned = false;
                }
                if (BreakpointPanel.this.pcl != null) {
                    BreakpointPanel.this.pcl.firePropertyChange("valid", null, null);
                }
            }
        });
    }

    public void changedUpdate(DocumentEvent e) {
        this.checkValidSoon();
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkValidSoon();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkValidSoon();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("debug.add.breakpoint");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

