/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.actions;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class DebugRecentAction
extends CallableSystemAction
implements Presenter.Menu {
    static final long serialVersionUID = 8679037289261745865L;
    public static final int PICKLISTSIZE = 20;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction;

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }

    public String getName() {
        return DbxDebugger.getText("LBL_DebugRecent");
    }

    public JMenuItem getMenuPresenter() {
        JMenuPlus mainItem = new JMenuPlus();
        Actions.setMenuText((AbstractButton)mainItem, (String)this.getName(), (boolean)true);
        mainItem.setIcon(SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction = DebugRecentAction.class$("com.sun.tools.debugger.dbxgui.debugger.actions.DebugRecentAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction)).getIcon());
        HelpCtx.setHelpIDString((JComponent)mainItem, (String)(class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction = DebugRecentAction.class$("com.sun.tools.debugger.dbxgui.debugger.actions.DebugRecentAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction).getName());
        mainItem.addMenuListener(new MainItemListener());
        return mainItem;
    }

    public JMenuItem getPopupPresenter() {
        JMenuPlus mainItem = new JMenuPlus();
        Actions.setMenuText((AbstractButton)mainItem, (String)this.getName(), (boolean)true);
        HelpCtx.setHelpIDString((JComponent)mainItem, (String)(class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction = DebugRecentAction.class$("com.sun.tools.debugger.dbxgui.debugger.actions.DebugRecentAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$DebugRecentAction).getName());
        mainItem.addMenuListener(new MainItemListener());
        return mainItem;
    }

    public void performAction() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DebugRecentListener
    implements ActionListener {
        private DataObject xmldao;

        public DebugRecentListener(DataObject xmldao) {
            this.xmldao = xmldao;
        }

        public void actionPerformed(ActionEvent evt) {
            if (UsageTracking.enabled) {
                UsageTracking.startTiming((String)"debugrecent");
            }
            RunConfig.setMostRecent(this.xmldao);
            if (!DbxDebugger.debugConfig(this.xmldao)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("MSG_BinaryDeleted")));
            }
            if (UsageTracking.enabled) {
                UsageTracking.readTime((String)"debugrecent", (String)"Debug Recent", (boolean)true, null, (boolean)true);
            }
        }
    }

    private static final class MainItemListener
    implements MenuListener {
        private JMenu menu;
        private int count = 0;

        private MainItemListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
        }

        public void menuSelected(MenuEvent e) {
            this.count = 0;
            this.menu = (JMenu)e.getSource();
            int n = 0;
            DataFolder df = RunConfig.findConfigFolder(false);
            if (df != null) {
                DataFolder fl = df;
                DataObject[] children = fl.getChildren();
                n = children.length;
                if (n > 20) {
                    n = 20;
                }
                df = null;
                for (int i = 0; i < n; ++i) {
                    if (!(children[i] instanceof XMLDataObject)) continue;
                    this.menu.add(this.createMenuItem(RunConfig.demangleName(children[i].getName(), true), children[i]));
                }
            }
            if (n == 0) {
                JMenuItem item = this.createMenuItem(DbxDebugger.getText("MenuEmpty"), null);
                item.setEnabled(false);
                this.menu.add(item);
            }
        }

        private JMenuItem createMenuItem(String name, DataObject xmldao) {
            JMenuItem curMenuItem = new JMenuItem();
            Actions.setMenuText((AbstractButton)curMenuItem, (String)name, (boolean)true);
            if (xmldao != null) {
                curMenuItem.addActionListener(new DebugRecentListener(xmldao));
            }
            return curMenuItem;
        }
    }
}

