/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;

class SignalDialog {
    private Dialog dialog;
    private DialogDescriptor dlg;
    private JPanel panel = new JPanel();
    private JTextArea textArea;
    private JCheckBox jc;
    private JButton BDiscardAndPause;
    private JButton BDiscardAndContinue;
    private JButton BForwardAndContinue;
    private String explanation = null;
    private String senderpid = "?";
    private String session = null;
    private long receiverPid = -1L;

    SignalDialog() {
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints ct = new GridBagConstraints();
        ct.gridwidth = 0;
        ct.anchor = 17;
        ct.fill = 1;
        ct.weightx = 1.0;
        ct.weighty = 1.0;
        ct.insets = new Insets(12, 0, 0, 12);
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setEditable(false);
        this.textArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        this.textArea.setRows(9);
        this.textArea.setColumns(40);
        this.textArea.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.textArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.panel.add((Component)scrollPane, ct);
        ct = new GridBagConstraints();
        ct.gridwidth = 0;
        ct.anchor = 17;
        ct.fill = 1;
        ct.weightx = 1.0;
        ct.weighty = 0.0;
        ct.insets = new Insets(12, 0, 0, 0);
        this.jc = new JCheckBox();
        Actions.setMenuText((AbstractButton)this.jc, (String)DbxDebugger.getText("SignalAddToIgnore"), (boolean)true);
        this.panel.add((Component)this.jc, ct);
        this.jc.setSelected(false);
        this.BDiscardAndPause = new JButton();
        Actions.setMenuText((AbstractButton)this.BDiscardAndPause, (String)DbxDebugger.getText("SignalDiscardAndPause"), (boolean)true);
        this.BDiscardAndContinue = new JButton();
        Actions.setMenuText((AbstractButton)this.BDiscardAndContinue, (String)DbxDebugger.getText("SignalDiscardAndContinue"), (boolean)true);
        this.BForwardAndContinue = new JButton();
        Actions.setMenuText((AbstractButton)this.BForwardAndContinue, (String)DbxDebugger.getText("SignalForwardAndContinue"), (boolean)true);
    }

    void setSignalInfo(String explanation) {
        this.explanation = explanation;
    }

    void setSenderInfo(String senderpid) {
        this.senderpid = senderpid;
    }

    void setReceiverInfo(String session, long receiverPid) {
        this.session = session;
        this.receiverPid = receiverPid;
    }

    void setIgnore(boolean signalKnow, boolean ignore) {
        this.jc.setEnabled(signalKnow);
        this.jc.setSelected(ignore);
    }

    private void fillText() {
        String text = this.explanation + "\n";
        String fmt = DbxDebugger.getText("SignalSrc");
        String origin = MessageFormat.format(fmt, this.senderpid);
        text = text + origin + "\n";
        fmt = DbxDebugger.getText("SignalDst");
        String dest = MessageFormat.format(fmt, this.session, "" + this.receiverPid);
        text = text + dest + "\n\n";
        text = text + DbxDebugger.getText("SignalHelp") + "\n";
        text = text + DbxDebugger.getText("SignalConfigHint");
        this.textArea.setText(text);
    }

    void show() {
        this.fillText();
        String title = MessageFormat.format(DbxDebugger.getText("SignalTitle"), this.session);
        this.dlg = new DialogDescriptor((Object)this.panel, title, true, (Object[])new JButton[]{this.BDiscardAndPause, this.BDiscardAndContinue, this.BForwardAndContinue}, (Object)this.BDiscardAndPause, 0, null, null);
        this.dlg.setMessageType(2);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dialog.show();
    }

    boolean isIgnore() {
        return this.jc.isSelected();
    }

    boolean discardSignal() {
        Object pressedButton = this.dlg.getValue();
        return pressedButton == this.BDiscardAndPause || pressedButton == this.BDiscardAndContinue;
    }

    boolean shouldContinue() {
        Object pressedButton = this.dlg.getValue();
        return pressedButton == this.BDiscardAndContinue || pressedButton == this.BForwardAndContinue;
    }
}

