/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.CollectWindow;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugProgram;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugSession;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerImpl;
import com.sun.tools.debugger.dbxgui.debugger.IpeHandler;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.common.utils.UsageTracking;
import com.sun.tools.swdev.glue.dbx.DbxPathMap;
import com.sun.tools.swdev.glue.dbx.DbxSignalInfo;
import com.sun.tools.swdev.glue.dbx.DbxSignalInfoInit;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.XMLDataObject;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class RunConfig
implements PropertyChangeListener {
    private String name;
    private static int nextSerialNumber;
    private int serialNumber;
    private transient DataObject dao;
    private DbxDebugProgram program = null;
    private String rundir = null;
    private String redirection = null;
    private String[] args = null;
    private String argsUnparsed = null;
    private String[] envvars = null;
    private DbxPathMap[] pathmap = null;
    public CollectWindow windowCol = null;
    private boolean needSave = true;
    public static final String PROP_RUNARGS_CHANGED = "runargs-ch";
    public static final String PROP_RUNDIR_CHANGED = "rundir-ch";
    public static final String PROP_ENVVARS_CHANGED = "envvars-ch";
    public static final String PROP_PATHMAP_CHANGED = "pathmap-ch";
    public static final String PROP_SIGNAL_CHANGED = "signal-ch";
    public static final String PROP_SIGNALS_CHANGED = "signals-ch";
    public static final String PROP_OPTION_CHANGED = "option-ch";
    public static final String PROP_INTERCEPTLIST_CHANGED = "intrcpt-ch";
    public static final String PROP_INTERCEPTEXLIST_CHANGED = "exintrcpt-ch";
    private boolean quickMode = false;
    private boolean exclusiveAttach = true;
    private boolean tradeOffSpeedForResources = false;
    private boolean allowBreakDuringStep = false;
    private boolean showFirstSourceFunc = true;
    private boolean executeDestructors = true;
    private boolean checkFortranSubscripts = true;
    private boolean inheritBreakpoints = false;
    private String stepGranularity = "statement";
    private String language = "autodetect";
    private String forkfollow = "parent";
    private String[] interceptList = null;
    private boolean interceptUnhandled = true;
    private boolean interceptUnexpected = true;
    private String[] interceptExceptList = null;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ArrayList pendingBreakpoints = null;
    private int numHandlers = 0;
    private IpeHandler[] handlers = null;
    private DbxSignalInfoInit[] signals = null;
    private ArrayList signalOverrides = null;
    protected static final String CONFIGURATION_DTD_WEB = "nbres:/com/sun/tools/debugger/dbxgui/resources/debugconfiguration-1_0.dtd";
    protected static final String CONFIGURATION_DTD_PUBLIC_ID = "-//SolarisNativeSupport//DTD debugconfiguration 1.0//EN";
    protected static final String EXT_XML = "xml";
    static final String TAG_CONFIGURATION = "DebugConfiguration";
    static final String ATTR_CONFIGURATION_NAME = "name";
    static final String ATTR_CONFIGURATION_EXECUTABLE = "executable";
    static final String ATTR_CONFIGURATION_RUNDIR = "rundir";
    static final String TAG_ARGUMENTS = "arguments";
    static final String TAG_ARG = "arg";
    static final String ATTR_ARG_VALUE = "value";
    static final String TAG_RUNARGS = "runargs";
    static final String TAG_ENVIRONMENT = "environment";
    static final String TAG_VAR = "var";
    static final String ATTR_VAR_VALUE = "value";
    static final String TAG_SIGNALS = "signals";
    static final String TAG_SIGNAL = "signal";
    static final String ATTR_SIGNAL_NUMBER = "number";
    static final String ATTR_SIGNAL_DO = "do";
    static final String TAG_BREAKPOINTS = "breakpoints";
    static final String TAG_BREAKPOINT = "breakpoint";
    static final String ATTR_BREAKPOINT_DBX = "dbx";
    static final String TAG_PATHMAP = "pathmap";
    static final String TAG_PATHPREFIX = "pathprefix";
    static final String ATTR_PATHPREFIX_REPLACE = "replace";
    static final String ATTR_PATHPREFIX_WITH = "with";
    static final String TAG_OPTIONS = "options";
    static final String TAG_OPTION = "option";
    static final String ATTR_OPTION_NAME = "name";
    static final String ATTR_OPTION_VALUE = "value";
    static final String TAG_EXCEPTIONS = "exceptions";
    static final String ATTR_EXCEPTIONS_UNHANDLED = "unhandled";
    static final String ATTR_EXCEPTIONS_UNEXPECTED = "unexpected";
    static final String TAG_INTERCEPT = "intercept";
    static final String ATTR_INTERCEPT_TYPENAME = "typename";
    static final String TAG_IGNORE = "ignore";
    static final String ATTR_IGNORE_TYPENAME = "typename";
    static final String OPTION_ON = "on";
    static final String OPTION_OFF = "off";
    static final String OPTION_QUICKMODE = "run_quick";
    static final String OPTION_EXCLATTACH = "proc_exclusive_attach";
    static final String OPTION_TRADEOFFSPEEDFORRESOURCES = "mt_scalable";
    static final String OPTION_BREAKDURINGSTEP = "step_events";
    static final String OPTION_FINDSOURCE = "stack_find_source";
    static final String OPTION_STACKDESTRUCTORS = "pop_auto_destruct";
    static final String OPTION_FSUBSCRIPTS = "array_bounds_check";
    static final String OPTION_INHERITBREAKPOINTS = "follow_fork_inherit";
    static final String OPTION_STEPGRANULARITY = "step_granularity";
    static final String OPTION_LANGUAGE = "language_mode";
    static final String OPTION_FORKFOLLOW = "follow_fork_mode";
    private String configName;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public RunConfig(String name, DataObject dao, DbxDebugProgram program) {
        this.name = name;
        this.dao = dao;
        this.program = program;
        this.serialNumber = nextSerialNumber++;
    }

    public void init() {
        Thread.dumpStack();
        this.dao = null;
        this.program = null;
        this.name = null;
    }

    public RunConfig(XMLDataObject xml) throws IOException {
        this(null, null, null);
        this.readConfig(xml);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if ((newName = newName.trim()).length() == 0 && (newName = this.program.getExecutableName()) == null) {
            newName = "<placeholder-name>";
        }
        String oldName = this.name;
        this.name = newName;
        this.needSave = true;
        if (oldName != this.name && this.program != null && this.program.getExecutableName() != null) {
            RunConfig.deleteConfig(oldName, this.program.getExecutableName());
        }
    }

    public DbxDebugProgram getProgram() {
        return this.program;
    }

    public void setProgram(DbxDebugProgram p) {
        this.program = p;
    }

    public void OLD_setSession(DbxDebugSession newSession) {
    }

    public String getRunDir() {
        return this.rundir;
    }

    public void setRunDir(String newdir) {
        String exename;
        if (newdir == null && this.program != null && (exename = this.program.getExecutableName()) != null) {
            newdir = IpeUtils.getDirName(exename);
        }
        if (this.rundir == null ? this.rundir == newdir : this.rundir.equals(newdir)) {
            return;
        }
        this.rundir = newdir;
        this.pcs.firePropertyChange(PROP_RUNDIR_CHANGED, null, this);
        this.needSave = true;
    }

    public void OLD_setArgs(String[] newargs) {
        this.args = newargs;
        this.updateFlattenedArgs();
        this.needSave = true;
    }

    public void setArgsOnly(String[] newargs) {
        this.args = newargs;
        this.updateFlattenedArgs();
        this.needSave = true;
    }

    private void updateFlattenedArgs() {
        StringBuffer sb = new StringBuffer();
        if (this.args != null && this.args.length > 0) {
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i] == null) continue;
                if (i > 0) {
                    sb.append(' ');
                }
                if (this.args[i].length() == 0) {
                    sb.append('\"');
                    sb.append('\"');
                    continue;
                }
                sb.append(IpeUtils.quoteIfNecessary(this.args[i]));
            }
            sb.append(' ');
        }
        if (this.redirection != null) {
            sb.append(this.redirection);
        }
        this.setUnparsedArgs(sb.toString());
    }

    public String getUnparsedArgs() {
        return this.argsUnparsed;
    }

    public void setUnparsedArgs(String newargs) {
        if (this.argsUnparsed == null ? this.argsUnparsed == newargs : this.argsUnparsed.equals(newargs)) {
            return;
        }
        this.argsUnparsed = newargs.trim();
        this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, null, this);
        this.needSave = true;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public void setRedirection(String infile, String outfile, boolean append) {
        boolean in;
        StringBuffer sb = new StringBuffer();
        boolean bl = in = infile != null && infile.length() != 0;
        if (in) {
            sb.append("< ");
            sb.append(infile);
        }
        if (outfile != null && outfile.length() != 0) {
            if (in) {
                sb.append(" ");
            }
            if (append) {
                sb.append(">> ");
            } else {
                sb.append("> ");
            }
            sb.append(outfile);
        }
        this.redirection = sb.toString();
        this.updateFlattenedArgs();
        this.needSave = true;
    }

    private String onoff(boolean on) {
        if (on) {
            return OPTION_ON;
        }
        return OPTION_OFF;
    }

    public void setQuickMode(boolean v) {
        this.quickMode = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_QUICKMODE, this.onoff(v));
        this.needSave = true;
    }

    public boolean getQuickMode() {
        return this.quickMode;
    }

    public boolean isDefaultQuickMode() {
        return !this.quickMode;
    }

    public void setExclusiveAttach(boolean v) {
        this.exclusiveAttach = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_EXCLATTACH, this.onoff(v));
        this.needSave = true;
    }

    public boolean getExclusiveAttach() {
        return this.exclusiveAttach;
    }

    public boolean isDefaultExclusiveAttach() {
        return this.exclusiveAttach;
    }

    public void setTradeOffSpeedForResources(boolean v) {
        this.tradeOffSpeedForResources = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_TRADEOFFSPEEDFORRESOURCES, this.onoff(v));
        this.needSave = true;
    }

    public boolean getTradeOffSpeedForResources() {
        return this.tradeOffSpeedForResources;
    }

    public boolean isDefaultTradeOffSpeedForResources() {
        return !this.tradeOffSpeedForResources;
    }

    public void setAllowBreakDuringStep(boolean v) {
        this.allowBreakDuringStep = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_BREAKDURINGSTEP, this.onoff(v));
        this.needSave = true;
    }

    public boolean getAllowBreakDuringStep() {
        return this.allowBreakDuringStep;
    }

    public boolean isDefaultAllowBreakDuringStep() {
        return !this.allowBreakDuringStep;
    }

    public void setShowFirstSourceFunc(boolean v) {
        this.showFirstSourceFunc = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_FINDSOURCE, this.onoff(v));
        this.needSave = true;
    }

    public boolean getShowFirstSourceFunc() {
        return this.showFirstSourceFunc;
    }

    public boolean isDefaultShowFirstSourceFunc() {
        return this.showFirstSourceFunc;
    }

    public void setExecuteDestructors(boolean v) {
        this.executeDestructors = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_STACKDESTRUCTORS, this.onoff(v));
        this.needSave = true;
    }

    public boolean getExecuteDestructors() {
        return this.executeDestructors;
    }

    public boolean isDefaultExecuteDestructors() {
        return this.executeDestructors;
    }

    public void setCheckFortranSubscripts(boolean v) {
        this.checkFortranSubscripts = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_FSUBSCRIPTS, this.onoff(v));
        this.needSave = true;
    }

    public boolean getCheckFortranSubscripts() {
        return this.checkFortranSubscripts;
    }

    public boolean isDefaultCheckFortranSubscripts() {
        return this.checkFortranSubscripts;
    }

    public void setInheritBreakpoints(boolean v) {
        this.inheritBreakpoints = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_INHERITBREAKPOINTS, this.onoff(v));
        this.needSave = true;
    }

    public boolean getInheritBreakpoints() {
        return this.inheritBreakpoints;
    }

    public boolean isDefaultInheritBreakpoints() {
        return !this.inheritBreakpoints;
    }

    public void setStepGranularity(String v) {
        this.stepGranularity = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_STEPGRANULARITY, v);
        this.needSave = true;
    }

    public String getStepGranularity() {
        return this.stepGranularity;
    }

    public boolean isDefaultStepGranularity() {
        return this.stepGranularity.equals("statement");
    }

    public void setLanguage(String v) {
        this.language = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_LANGUAGE, v);
        this.needSave = true;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isDefaultLanguage() {
        return this.language.equals("autodetect");
    }

    public void setForkfollow(String v) {
        this.forkfollow = v;
        this.pcs.firePropertyChange(PROP_OPTION_CHANGED, OPTION_FORKFOLLOW, v);
        this.needSave = true;
    }

    public String getForkfollow() {
        return this.forkfollow;
    }

    public boolean isDefaultForkfollow() {
        return this.forkfollow.equals("parent");
    }

    public String[] getEnvVars() {
        return this.envvars;
    }

    public void setEnvVars(String[] newvars) {
        this.envvars = newvars;
        this.pcs.firePropertyChange(PROP_ENVVARS_CHANGED, null, this);
        this.needSave = true;
    }

    public DbxPathMap[] getPathmap() {
        return this.pathmap;
    }

    public void setPathmap(DbxPathMap[] newmap) {
        DbxPathMap[] old = this.pathmap;
        this.pathmap = newmap;
        if (old == newmap) {
            return;
        }
        if (old != null && newmap != null && old.length == newmap.length) {
            int i;
            for (i = 0; i < old.length && newmap[i].from.equals(old[i].from) && IpeUtils.sameString(newmap[i].to, old[i].to); ++i) {
            }
            if (i == old.length) {
                return;
            }
        }
        this.pcs.firePropertyChange(PROP_PATHMAP_CHANGED, old, this.pathmap);
        this.needSave = true;
    }

    public String[] getInterceptList() {
        return this.interceptList;
    }

    public void setInterceptList(String[] typenames, boolean unhandled, boolean unexpected) {
        String[] old = this.interceptList;
        this.interceptList = typenames;
        this.interceptUnhandled = unhandled;
        this.interceptUnexpected = unexpected;
        this.pcs.firePropertyChange(PROP_INTERCEPTLIST_CHANGED, old, this.interceptList);
        this.needSave = true;
    }

    public boolean isInterceptUnhandled() {
        return this.interceptUnhandled;
    }

    public boolean isInterceptExpected() {
        return this.interceptUnexpected;
    }

    public String[] getInterceptExceptList() {
        return this.interceptExceptList;
    }

    public void setInterceptExceptList(String[] typenames) {
        String[] old = this.interceptExceptList;
        this.interceptExceptList = typenames;
        this.pcs.firePropertyChange(PROP_INTERCEPTEXLIST_CHANGED, old, this.interceptExceptList);
        this.needSave = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void handlerListUpdated(int numHandlers, IpeHandler[] handlers) {
        this.numHandlers = numHandlers;
        this.handlers = handlers;
        this.needSave = true;
    }

    public ArrayList getPendingBreakpoints() {
        return this.pendingBreakpoints;
    }

    public void clearPendingBreakpoints() {
        this.pendingBreakpoints = null;
    }

    public ArrayList getSignalOverrides() {
        return this.signalOverrides;
    }

    public void setSignalState(DbxSignalInfo s) {
        int i;
        if (this.signalOverrides == null) {
            this.signalOverrides = new ArrayList();
        }
        int n = this.signalOverrides.size();
        for (i = 0; i < n; ++i) {
            DbxSignalInfo dsi = (DbxSignalInfo)this.signalOverrides.get(i);
            if (dsi.signo != s.signo) continue;
            if (s.caught == dsi.caught) {
                return;
            }
            dsi.caught = s.caught;
            if (this.signals == null || s.caught != this.signals[s.signo - 1].caught_by_default) break;
            this.signalOverrides.remove(dsi);
            break;
        }
        if (i == n) {
            this.signalOverrides.add(s);
        }
        if (this.signals != null && this.signals.length > s.signo) {
            this.signals[s.signo - 1].caught = s.caught;
        }
        this.pcs.firePropertyChange(PROP_SIGNAL_CHANGED, new Integer(s.signo), new Boolean(!s.caught));
        this.needSave = true;
    }

    public DbxSignalInfoInit[] getSignals() {
        return this.signals;
    }

    public void setSignals(DbxSignalInfoInit[] s) {
        int i;
        int n;
        if (this.signals != null && s != null) {
            n = s.length;
            for (i = 0; i < n; ++i) {
                if (s[i] == null || s[i].caught == this.signals[i].caught) continue;
                this.pcs.firePropertyChange(PROP_SIGNAL_CHANGED, new Integer(s[i].signo), new Boolean(!s[i].caught));
            }
        }
        this.signalOverrides = null;
        n = 0;
        if (s != null) {
            n = s.length;
        }
        for (i = 0; i < n; ++i) {
            if (s[i] == null || s[i].caught == s[i].caught_by_default) continue;
            DbxSignalInfo dsi = new DbxSignalInfo();
            dsi.signo = s[i].signo;
            dsi.caught = s[i].caught;
            if (this.signalOverrides == null) {
                this.signalOverrides = new ArrayList();
            }
            this.signalOverrides.add(dsi);
        }
        this.signals = s;
        this.pcs.firePropertyChange(PROP_SIGNALS_CHANGED, null, null);
        this.needSave = true;
    }

    public void setSignalOverrides(ArrayList newSignalOverrides) {
        if (newSignalOverrides == null) {
            this.signalOverrides = null;
            return;
        }
        this.signalOverrides = new ArrayList();
        for (int sx = 0; sx < newSignalOverrides.size(); ++sx) {
            DbxSignalInfo dsi = (DbxSignalInfo)newSignalOverrides.get(sx);
            this.signalOverrides.add(dsi);
        }
    }

    public void save() {
        String exename = this.program.getExecutableName();
        String exeBase = this.program.getExecutableBaseName();
        String why = "configuration unchanged";
        if (exename.charAt(0) != File.separatorChar) {
            ErrorManager.getDefault().log("not saving configuration for " + exename);
            Toolkit.getDefaultToolkit().beep();
            this.needSave = false;
            why = "non-absolute program name";
        } else if (exeBase.equals("-")) {
            this.needSave = false;
            why = "- program name";
        }
        if (this.name == null) {
            ErrorManager.getDefault().log("Couldn't save configuration - no name!");
            Toolkit.getDefaultToolkit().beep();
            why = "no name";
            this.needSave = false;
        }
        if (!this.needSave) {
            return;
        }
        try {
            this.writeDocument(this.name);
        }
        catch (IOException ioe) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
        }
    }

    private void readConfig(XMLDataObject xml) throws IOException {
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"readconfig");
        }
        Parser parser = xml.createParser();
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        HandlerBase handler = new HandlerBase(){
            private ArrayList args = null;
            private String runargs = null;
            private ArrayList vars = null;
            private ArrayList intercepts = null;
            private ArrayList dontIntercepts = null;
            private ArrayList pathmapList = null;
            private boolean unhandled = true;
            private boolean unexpected = true;

            public void startElement(String name, AttributeList amap) throws SAXException {
                if (RunConfig.TAG_CONFIGURATION.equals(name)) {
                    String nm = amap.getValue("name");
                    RunConfig.this.setName(nm);
                    RunConfig.this.rundir = amap.getValue(RunConfig.ATTR_CONFIGURATION_RUNDIR);
                    String exename = amap.getValue(RunConfig.ATTR_CONFIGURATION_EXECUTABLE);
                    RunConfig.this.program = new DbxDebugProgram(exename, null);
                    if (exename != null) {
                        try {
                            FileObject fo = IpeUtils.findFileObject(exename, false);
                            if (fo != null) {
                                RunConfig.this.dao = DataObject.find((FileObject)fo);
                            }
                        }
                        catch (Exception e) {}
                    }
                } else if (RunConfig.TAG_ARG.equals(name)) {
                    String arg = amap.getValue("value");
                    if (arg != null) {
                        this.args.add(arg);
                    }
                } else if (RunConfig.TAG_RUNARGS.equals(name)) {
                    this.runargs = "";
                } else if (RunConfig.TAG_ARGUMENTS.equals(name)) {
                    this.args = new ArrayList();
                } else if (RunConfig.TAG_BREAKPOINTS.equals(name)) {
                    RunConfig.this.pendingBreakpoints = new ArrayList();
                } else if (RunConfig.TAG_BREAKPOINT.equals(name)) {
                    String spec = amap.getValue(RunConfig.ATTR_BREAKPOINT_DBX);
                    RunConfig.this.pendingBreakpoints.add(spec);
                } else if (RunConfig.TAG_SIGNAL.equals(name)) {
                    String numberString = amap.getValue(RunConfig.ATTR_SIGNAL_NUMBER);
                    String doString = amap.getValue(RunConfig.ATTR_SIGNAL_DO);
                    int number = 0;
                    try {
                        number = Integer.parseInt(numberString);
                        boolean caught = true;
                        if (RunConfig.TAG_IGNORE.equals(doString)) {
                            caught = false;
                        }
                        DbxSignalInfo dsi = new DbxSignalInfo();
                        dsi.signo = number;
                        dsi.caught = caught;
                        RunConfig.this.signalOverrides.add(dsi);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(16, (Throwable)e);
                    }
                } else if (RunConfig.TAG_SIGNALS.equals(name)) {
                    RunConfig.this.signalOverrides = new ArrayList();
                } else if (RunConfig.TAG_PATHMAP.equals(name)) {
                    this.pathmapList = new ArrayList();
                } else if (RunConfig.TAG_PATHPREFIX.equals(name)) {
                    String from = amap.getValue(RunConfig.ATTR_PATHPREFIX_REPLACE);
                    String to = amap.getValue(RunConfig.ATTR_PATHPREFIX_WITH);
                    if (from != null) {
                        DbxPathMap p = new DbxPathMap();
                        p.from = from;
                        p.to = to;
                        this.pathmapList.add(p);
                    }
                } else if (RunConfig.TAG_VAR.equals(name)) {
                    String var = amap.getValue("value");
                    if (var != null) {
                        this.vars.add(var);
                    }
                } else if (RunConfig.TAG_EXCEPTIONS.equals(name)) {
                    this.intercepts = new ArrayList();
                    this.dontIntercepts = new ArrayList();
                    String unh = amap.getValue(RunConfig.ATTR_EXCEPTIONS_UNHANDLED);
                    String une = amap.getValue(RunConfig.ATTR_EXCEPTIONS_UNEXPECTED);
                    if (unh != null) {
                        this.unhandled = false;
                    }
                    if (une != null) {
                        this.unexpected = false;
                    }
                } else if (RunConfig.TAG_IGNORE.equals(name)) {
                    String typename = amap.getValue("typename");
                    this.dontIntercepts.add(typename);
                } else if (RunConfig.TAG_INTERCEPT.equals(name)) {
                    String typename = amap.getValue("typename");
                    this.intercepts.add(typename);
                } else if (RunConfig.TAG_ENVIRONMENT.equals(name)) {
                    this.vars = new ArrayList();
                } else if (!RunConfig.TAG_OPTIONS.equals(name)) {
                    if (RunConfig.TAG_OPTION.equals(name)) {
                        String optname = amap.getValue("name");
                        String optvalue = amap.getValue("value");
                        if (optname.equals(RunConfig.OPTION_QUICKMODE)) {
                            RunConfig.this.setQuickMode(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_EXCLATTACH)) {
                            RunConfig.this.setExclusiveAttach(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_TRADEOFFSPEEDFORRESOURCES)) {
                            RunConfig.this.setTradeOffSpeedForResources(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_BREAKDURINGSTEP)) {
                            RunConfig.this.setAllowBreakDuringStep(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_FINDSOURCE)) {
                            RunConfig.this.setShowFirstSourceFunc(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_STACKDESTRUCTORS)) {
                            RunConfig.this.setExecuteDestructors(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_FSUBSCRIPTS)) {
                            RunConfig.this.setCheckFortranSubscripts(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_INHERITBREAKPOINTS)) {
                            RunConfig.this.setInheritBreakpoints(optvalue.equals(RunConfig.OPTION_ON));
                        } else if (optname.equals(RunConfig.OPTION_STEPGRANULARITY)) {
                            RunConfig.this.setStepGranularity(optvalue);
                        } else if (optname.equals(RunConfig.OPTION_LANGUAGE)) {
                            RunConfig.this.setLanguage(optvalue);
                        } else if (optname.equals(RunConfig.OPTION_FORKFOLLOW)) {
                            RunConfig.this.setForkfollow(optvalue);
                        }
                    } else {
                        ErrorManager.getDefault().log("RunConfig: Ignored: startElement(" + name + ")");
                    }
                }
            }

            public void characters(char[] ch, int start, int length) {
                if (this.runargs != null) {
                    this.runargs = this.runargs + new String(ch, start, length);
                }
            }

            public void endElement(String name) throws SAXException {
                if (RunConfig.TAG_ARGUMENTS.equals(name)) {
                    if (this.args != null) {
                        String[] ar = new String[this.args.size()];
                        ar = this.args.toArray(ar);
                        RunConfig.this.OLD_setArgs(ar);
                        this.args = null;
                    }
                } else if (RunConfig.TAG_RUNARGS.equals(name)) {
                    RunConfig.this.setUnparsedArgs(this.runargs);
                    this.runargs = null;
                } else if (RunConfig.TAG_ENVIRONMENT.equals(name)) {
                    if (this.vars != null) {
                        String[] e = new String[this.vars.size()];
                        e = this.vars.toArray(e);
                        RunConfig.this.setEnvVars(e);
                        this.vars = null;
                    }
                } else if (RunConfig.TAG_PATHMAP.equals(name)) {
                    if (this.pathmapList != null) {
                        DbxPathMap[] e = new DbxPathMap[this.pathmapList.size()];
                        e = this.pathmapList.toArray(e);
                        RunConfig.this.setPathmap(e);
                        this.pathmapList = null;
                    }
                } else if (RunConfig.TAG_EXCEPTIONS.equals(name)) {
                    String[] e;
                    if (this.intercepts != null && this.intercepts.size() > 0) {
                        e = new String[this.intercepts.size()];
                        e = this.intercepts.toArray(e);
                        RunConfig.this.setInterceptList(e, this.unhandled, this.unexpected);
                        this.intercepts = null;
                    }
                    if (this.dontIntercepts != null && this.dontIntercepts.size() > 0) {
                        e = new String[this.dontIntercepts.size()];
                        e = this.dontIntercepts.toArray(e);
                        RunConfig.this.setInterceptExceptList(e);
                        this.dontIntercepts = null;
                    }
                }
            }
        };
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(xml.getPrimaryFile().getInputStream()));
            if (UsageTracking.enabled) {
                UsageTracking.readTime((String)"readconfig", (String)"Read Debug Configuration", (boolean)true, null, (boolean)true);
            }
        }
        catch (Exception saxe) {
            UsageTracking.stopTiming((String)"readconfig");
            ErrorManager.getDefault().notify(1, (Throwable)saxe);
            IOException ex = new IOException();
            ErrorManager.getDefault().copyAnnotation((Throwable)ex, (Throwable)saxe);
            throw ex;
        }
        this.needSave = false;
    }

    private static void appendEscaped(StringBuffer escaped, String text) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                escaped.append('#');
                String hex = Integer.toString(c, 16).toUpperCase();
                if (hex.length() < 4) {
                    escaped.append('0');
                }
                if (hex.length() < 3) {
                    escaped.append('0');
                }
                if (hex.length() < 2) {
                    escaped.append('0');
                }
                escaped.append(hex);
                continue;
            }
            escaped.append(c);
        }
    }

    private static StringBuffer unescape(String text) {
        int len = text.length();
        StringBuffer unesc = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '#') {
                if (i + 4 >= len) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                    System.err.println("trailing garbage in instance name: " + text);
                    break;
                }
                try {
                    char[] hex = new char[4];
                    text.getChars(i + 1, i + 5, hex, 0);
                    unesc.append((char)Integer.parseInt(new String(hex), 16));
                }
                catch (NumberFormatException nfe) {
                    ErrorManager.getDefault().notify(1, (Throwable)nfe);
                }
                i += 4;
                continue;
            }
            unesc.append(c);
        }
        return unesc;
    }

    private static String mangleName(String name, String executable) {
        StringBuffer sb = new StringBuffer(256);
        if (name != null) {
            if (name.length() > 60) {
                int i;
                int l = name.length();
                for (i = l - 60; i < l && name.charAt(i) != '/'; ++i) {
                }
                name = i == l ? name.substring(l - 60) : name.substring(i + 1);
            }
            RunConfig.appendEscaped(sb, name);
        }
        sb.append("#0001");
        if (executable != null) {
            StringBuffer psb = new StringBuffer(251);
            int cnl = sb.length();
            int enl = executable.length();
            int start = enl - (251 - cnl);
            if (start < 0) {
                RunConfig.appendEscaped(psb, executable);
            } else {
                RunConfig.appendEscaped(psb, executable.substring(start));
            }
            if (psb.length() + cnl > 251) {
                int targetPos = psb.length() - (251 - cnl);
                int i = 0;
                while (i < targetPos) {
                    if (psb.charAt(i) == '#') {
                        i += 5;
                        continue;
                    }
                    ++i;
                }
                sb.append(psb.substring(i));
            } else {
                sb.append(psb.toString());
            }
        }
        return sb.toString();
    }

    public static String demangleName(String mn, boolean getname) {
        StringBuffer mnsb = RunConfig.unescape(mn);
        int n = mnsb.length();
        StringBuffer sb = new StringBuffer(n);
        int l = 0;
        boolean escaped = false;
        boolean readingName = true;
        while (l < n) {
            char c;
            if ((c = mnsb.charAt(l++)) == '\u0001') {
                readingName = false;
                if (!getname) continue;
                return sb.toString();
            }
            if ((!readingName || !getname) && (readingName || getname)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private void writeDocument(String ncn) throws IOException {
        String exename = this.program.getExecutableName();
        final String cn = RunConfig.mangleName(ncn, exename);
        final StringBuffer sb = new StringBuffer(256);
        sb.append("<?xml version=\"1.0\" ");
        String lang = IpeUtils.getenv("LANG");
        if (lang != null) {
            if (lang.equals("zh") || lang.equals("zh.GBK") || lang.equals("zh_CN.EUC") || lang.equals("zh_CN.GB18030") || lang.equals("zh_CN") || lang.equals("zh_CN.GBK")) {
                sb.append("encoding=\"EUC-CN\" ");
            } else if (lang.equals("ja") || lang.equals("ja_JP.eucJP")) {
                sb.append("encoding=\"EUC-JP\" ");
            } else {
                sb.append("encoding=\"UTF-8\" ");
            }
        }
        sb.append("?>\n<!DOCTYPE ");
        sb.append(TAG_CONFIGURATION);
        sb.append(" PUBLIC \"");
        sb.append(CONFIGURATION_DTD_PUBLIC_ID);
        sb.append("\" \"nbres:/com/sun/tools/debugger/dbxgui/resources/debugconfiguration-1_0.dtd\">\n\n");
        sb.append(this.toXMLString());
        DataFolder configFolder = RunConfig.findConfigFolder(true);
        if (configFolder == null) {
            return;
        }
        final String configPackage = RunConfig.getConfigPackage((DataObject)configFolder);
        final FileObject tbFO = configFolder.getPrimaryFile();
        final FileSystem tbFS = tbFO.getFileSystem();
        DataObject[] siblings = configFolder.getChildren();
        tbFS.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileLock lock;
                block6: {
                    lock = null;
                    OutputStream os = null;
                    FileObject xmlFO = tbFS.find(configPackage, cn, RunConfig.EXT_XML);
                    if (xmlFO == null) {
                        xmlFO = tbFO.createData(cn, RunConfig.EXT_XML);
                    }
                    try {
                        lock = xmlFO.lock();
                        os = xmlFO.getOutputStream(lock);
                        PrintWriter writer = new PrintWriter(os);
                        writer.print(sb.toString());
                        writer.close();
                        Object var6_5 = null;
                        if (os == null) break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (os != null) {
                            os.close();
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        throw throwable;
                    }
                    os.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        });
        DataObject[] updated_siblings = configFolder.getChildren();
        if (updated_siblings.length > siblings.length) {
            RunConfig.setMostRecent(updated_siblings[updated_siblings.length - 1]);
        }
        RunConfig.purgeConfigs(configFolder);
        this.needSave = false;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (!"document".equals(ev.getPropertyName())) {
            return;
        }
        final XMLDataObject obj = (XMLDataObject)ev.getSource();
        long mod = obj.getPrimaryFile().lastModified().getTime();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    String oldName = RunConfig.this.name;
                    RunConfig.this.init();
                    RunConfig.this.readConfig(obj);
                    if (RunConfig.this.name == null && oldName != null) {
                        RunConfig.this.name = oldName;
                        try {
                            throw new IllegalArgumentException();
                        }
                        catch (Exception e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        });
    }

    private void optionToXML(boolean writeHeaderTag, StringBuffer sb, String name, String value) {
        if (writeHeaderTag) {
            sb.append("\n<").append(TAG_OPTIONS).append(">\n");
        }
        sb.append("\t<").append(TAG_OPTION).append(" ").append("name").append("=\"").append(name).append("\" ").append("value").append("=\"").append(IpeUtils.stringToXML(value)).append("\"/>\n");
    }

    private void optionToXML(boolean writeHeaderTag, StringBuffer sb, String name, boolean value) {
        if (value) {
            this.optionToXML(writeHeaderTag, sb, name, OPTION_ON);
        } else {
            this.optionToXML(writeHeaderTag, sb, name, OPTION_OFF);
        }
    }

    public String toXMLString() {
        int i;
        int i2;
        int n;
        boolean saveEnv;
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(TAG_CONFIGURATION).append("\n");
        sb.append("\t").append("name").append("=\"").append(IpeUtils.stringToXML(this.name)).append("\"\n");
        if (this.program != null && this.program.getExecutableName() != null) {
            String executable = this.program.getExecutableName();
            sb.append("\t").append(ATTR_CONFIGURATION_EXECUTABLE).append("=\"").append(IpeUtils.stringToXML(executable)).append("\"\n");
        }
        if (this.rundir != null) {
            sb.append("\t").append(ATTR_CONFIGURATION_RUNDIR).append("=\"").append(IpeUtils.stringToXML(this.rundir)).append("\"\n");
        }
        sb.append(">\n");
        if (this.argsUnparsed != null && this.argsUnparsed.length() != 0) {
            sb.append("\n<").append(TAG_RUNARGS).append(">\n");
            sb.append(IpeUtils.stringToXML(this.argsUnparsed));
            sb.append("\n</").append(TAG_RUNARGS).append(">\n");
        }
        boolean bl = saveEnv = System.getProperty("spro.saveenv") == null;
        if (saveEnv && this.envvars != null && this.envvars.length != 0) {
            sb.append("\n<").append(TAG_ENVIRONMENT).append(">\n");
            n = this.envvars.length;
            for (i2 = 0; i2 < n; ++i2) {
                sb.append("\t<").append(TAG_VAR).append(" ").append("value").append("=\"").append(IpeUtils.stringToXML(this.envvars[i2])).append("\"/>\n");
            }
            sb.append("</").append(TAG_ENVIRONMENT).append(">\n");
        }
        if (saveEnv && this.pathmap != null && this.pathmap.length != 0) {
            sb.append("\n<").append(TAG_PATHMAP).append(">\n");
            n = this.pathmap.length;
            for (i2 = 0; i2 < n; ++i2) {
                DbxPathMap p = this.pathmap[i2];
                sb.append("\t<").append(TAG_PATHPREFIX).append(" ").append(ATTR_PATHPREFIX_REPLACE).append("=\"").append(IpeUtils.stringToXML(p.from)).append("\" ");
                if (p.to != null) {
                    sb.append(ATTR_PATHPREFIX_WITH).append("=\"").append(IpeUtils.stringToXML(p.to)).append("\"/>\n");
                    continue;
                }
                sb.append("/>\n");
            }
            sb.append("</").append(TAG_PATHMAP).append(">\n");
        }
        if (saveEnv && this.signalOverrides != null) {
            int signalHeader = 0;
            int n2 = this.signalOverrides.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                DbxSignalInfo dsi = (DbxSignalInfo)this.signalOverrides.get(i3);
                if (signalHeader == 0) {
                    sb.append("\n<").append(TAG_SIGNALS).append(">\n");
                    ++signalHeader;
                }
                sb.append("\t<").append(TAG_SIGNAL).append(" ").append(ATTR_SIGNAL_NUMBER).append("=\"").append(dsi.signo).append("\" ").append(ATTR_SIGNAL_DO).append("=\"").append(dsi.caught ? "catch" : TAG_IGNORE).append("\"/>\n");
            }
            if (signalHeader != 0) {
                sb.append("</").append(TAG_SIGNALS).append(">\n");
            }
        }
        if (saveEnv && this.interceptList != null && this.interceptList.length != 0 || this.interceptExceptList != null && this.interceptExceptList.length != 0) {
            sb.append("\n<").append(TAG_EXCEPTIONS);
            if (!this.interceptUnhandled) {
                sb.append("\n\t").append(ATTR_EXCEPTIONS_UNHANDLED).append("=\"no\"");
            }
            if (!this.interceptUnexpected) {
                sb.append("\n\t").append(ATTR_EXCEPTIONS_UNEXPECTED).append("=\"no\"");
            }
            sb.append(">\n");
            if (this.interceptList != null && this.interceptList.length != 0) {
                n = this.interceptList.length;
                for (i2 = 0; i2 < n; ++i2) {
                    String typename = IpeUtils.stringToXML(this.interceptList[i2]);
                    sb.append("\t<").append(TAG_INTERCEPT).append(" ").append("typename").append("=\"").append(typename).append("\"/>\n");
                }
            }
            if (this.interceptExceptList != null && this.interceptExceptList.length != 0) {
                n = this.interceptExceptList.length;
                for (i2 = 0; i2 < n; ++i2) {
                    String typename = IpeUtils.stringToXML(this.interceptExceptList[i2]);
                    sb.append("\t<").append(TAG_IGNORE).append(" ").append("typename").append("=\"").append(typename).append("\"/>\n");
                }
            }
            sb.append("</").append(TAG_EXCEPTIONS).append(">\n");
        }
        if (this.pendingBreakpoints != null && DebuggingOption.SAVE_BREAKPOINTS.isEnabled()) {
            sb.append("\n<").append(TAG_BREAKPOINTS).append(">\n");
            for (i = 0; i < this.pendingBreakpoints.size(); ++i) {
                String bp = (String)this.pendingBreakpoints.get(i);
                String bpXML = IpeUtils.stringToXML(bp);
                sb.append("\t<").append(TAG_BREAKPOINT).append(" ").append(ATTR_BREAKPOINT_DBX).append("=\"").append(bpXML).append("\"/>\n");
            }
            sb.append("</").append(TAG_BREAKPOINTS).append(">\n");
        }
        if (this.numHandlers > 0 && DebuggingOption.SAVE_BREAKPOINTS.isEnabled()) {
            sb.append("\n<").append(TAG_BREAKPOINTS).append(">\n");
            for (i = 0; i < this.numHandlers; ++i) {
                String handlerXML = this.handlers[i].toXMLString();
                sb.append("\t<").append(TAG_BREAKPOINT).append(" ").append(ATTR_BREAKPOINT_DBX).append("=\"").append(handlerXML).append("\"/>\n");
            }
            sb.append("</").append(TAG_BREAKPOINTS).append(">\n");
        }
        int optionHeaderState = 0;
        if (!this.isDefaultQuickMode()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_QUICKMODE, this.getQuickMode());
        }
        if (!this.isDefaultExclusiveAttach()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_EXCLATTACH, this.getExclusiveAttach());
        }
        if (!this.isDefaultTradeOffSpeedForResources()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_TRADEOFFSPEEDFORRESOURCES, this.getTradeOffSpeedForResources());
        }
        if (!this.isDefaultAllowBreakDuringStep()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_BREAKDURINGSTEP, this.getAllowBreakDuringStep());
        }
        if (!this.isDefaultShowFirstSourceFunc()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_FINDSOURCE, this.getShowFirstSourceFunc());
        }
        if (!this.isDefaultExecuteDestructors()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_STACKDESTRUCTORS, this.getExecuteDestructors());
        }
        if (!this.isDefaultCheckFortranSubscripts()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_FSUBSCRIPTS, this.getCheckFortranSubscripts());
        }
        if (!this.isDefaultInheritBreakpoints()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_INHERITBREAKPOINTS, this.getInheritBreakpoints());
        }
        if (!this.isDefaultStepGranularity()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_STEPGRANULARITY, this.getStepGranularity());
        }
        if (!this.isDefaultLanguage()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_LANGUAGE, this.getLanguage());
        }
        if (!this.isDefaultForkfollow()) {
            this.optionToXML(optionHeaderState++ == 0, sb, OPTION_FORKFOLLOW, this.getForkfollow());
        }
        if (optionHeaderState > 0) {
            sb.append("</").append(TAG_OPTIONS).append(">\n");
        }
        sb.append("\n</").append(TAG_CONFIGURATION).append(">\n");
        return sb.toString();
    }

    private static String getConfigPackage(DataObject folder) {
        return "DbxGui.DbxDebugConfigs";
    }

    public static final DataFolder findFolder(String what, boolean create) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        DataObject dao = null;
        FileObject fo = fs.findResource("DbxGui/" + what);
        if (fo != null) {
            try {
                dao = DataObject.find((FileObject)fo);
                if (dao instanceof DataFolder) {
                    return (DataFolder)dao;
                }
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        if (create && (fo = fs.findResource("DbxGui")) != null && fo.isFolder()) {
            try {
                dao = DataObject.find((FileObject)fo);
                if (dao instanceof DataFolder) {
                    return DataFolder.create((DataFolder)((DataFolder)dao), (String)what);
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        return null;
    }

    public static final DataFolder findConfigFolder(boolean create) {
        return RunConfig.findFolder("DbxDebugConfigs", create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeConfigs(DataFolder configFolder) {
        int keep = 10;
        DataFolder dataFolder = configFolder;
        synchronized (dataFolder) {
            DataObject[] siblings = configFolder.getChildren();
            int n = siblings.length;
            if (keep > n) {
                return;
            }
            for (int i = keep; i < n; ++i) {
                try {
                    siblings[i].delete();
                    continue;
                }
                catch (IOException ioe) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
                }
            }
        }
    }

    public static void deleteConfig(String name, String executable) {
        DataFolder configFolder = RunConfig.findConfigFolder(true);
        if (configFolder == null) {
            ErrorManager.getDefault().log("Internal error - couldn't find configs folder.");
            return;
        }
        String configPackage = RunConfig.getConfigPackage((DataObject)configFolder);
        FileObject tbFO = configFolder.getPrimaryFile();
        FileSystem tbFS = null;
        try {
            tbFS = tbFO.getFileSystem();
        }
        catch (IOException ioe) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
            return;
        }
        String cn = RunConfig.mangleName(name, executable);
        FileObject fo = tbFS.find(configPackage, cn, EXT_XML);
        if (fo == null) {
            return;
        }
        try {
            fo.delete();
        }
        catch (IOException ioe) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
        }
    }

    public static RunConfig createConfig(String progname, DbxDebugProgram program) {
        DataObject dao = null;
        FileObject fo = IpeUtils.findFileObject(progname, true);
        if (fo == null) {
            ErrorManager.getDefault().log(16, "Cannot get DO for " + progname);
        } else {
            try {
                dao = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return RunConfig.createConfig(progname, dao, program);
    }

    public static RunConfig createConfig(String name, DataObject dao, DbxDebugProgram program) {
        RunConfig config = new RunConfig(name, dao, program);
        return config;
    }

    public static RunConfig findConfig(DbxDebugProgram program) {
        DataFolder df = RunConfig.findConfigFolder(false);
        if (df == null) {
            return null;
        }
        DataFolder fl = df;
        DataObject[] children = fl.getChildren();
        int n = children.length;
        String progname = program.getExecutableName();
        for (int i = 0; i < n; ++i) {
            String executable;
            if (!(children[i] instanceof XMLDataObject) || !(executable = RunConfig.demangleName(children[i].getName(), false)).equals(progname) && !progname.endsWith(executable)) continue;
            InstanceCookie ic = (InstanceCookie)children[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = RunConfig.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            RunConfig config = null;
            if (ic == null) {
                ErrorManager.getDefault().log("No instance cookie for " + progname);
                return null;
            }
            try {
                config = (RunConfig)ic.instanceCreate();
                if (config.program == null) {
                    config.program = program;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
            RunConfig.setMostRecent(children[i]);
            return config;
        }
        return null;
    }

    public static RunConfig findConfig(DataNode dataNode, String path) {
        RunConfig config = null;
        DbxDebugger debugger = DbxDebuggerImpl.getCurrentDebugger();
        if (dataNode == null) {
            return null;
        }
        if (path == null) {
            DataObject dao = dataNode.getDataObject();
            FileObject fo = dao.getPrimaryFile();
            path = CppUtils.getPath((FileObject)fo);
        }
        if (debugger != null && debugger.getConfig() != null) {
            config = debugger.getConfig();
        }
        if (config == null || config.getName() == null || !config.getName().equals(path)) {
            DbxDebugProgram program = null;
            program = new DbxDebugProgram(path, null);
            if (program != null) {
                config = RunConfig.findConfig(program);
            }
            if (config == null) {
                config = RunConfig.createConfig(program.getExecutableName(), dataNode.getDataObject(), program);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMostRecent(DataObject xmldao) {
        DataFolder parent;
        DataFolder dataFolder = parent = xmldao.getFolder();
        synchronized (dataFolder) {
            DataObject[] siblings = parent.getChildren();
            int n = siblings.length;
            for (int i = 1; i < n; ++i) {
                if (siblings[i] != xmldao) continue;
                for (int j = i - 1; j >= 0; --j) {
                    siblings[j + 1] = siblings[j];
                }
                siblings[0] = xmldao;
                try {
                    parent.setOrder(siblings);
                }
                catch (IOException ioe) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe, 0));
                }
                break;
            }
        }
    }

    public String toString() {
        return super.toString() + ": name=" + this.name;
    }

    public DataObject getDao() {
        return this.dao;
    }

    public CollectWindow getCollectorInfo() {
        if (this.windowCol != null) {
            return this.windowCol;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

