/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugProgram;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugSession;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerEngine;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.utils.UnixFileSystemView;
import com.sun.tools.swdev.common.nbtext.Hyperlink;
import com.sun.tools.swdev.common.nbtext.UnixTabTerm;
import com.sun.tools.swdev.common.utils.UsageTracking;
import com.sun.tools.swdev.glue.dbx.DbxFrame;
import com.sun.tools.swdev.glue.dbx.DbxMprofHeader;
import com.sun.tools.swdev.glue.dbx.DbxMprofItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.modules.debugger.support.DelegatingView2;
import org.netbeans.modules.debugger.support.View2;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public final class MemuseWindow
extends UnixTabTerm
implements PropertyChangeListener,
ComponentListener,
ActionListener,
FocusListener {
    static final long serialVersionUID = 8415779626223L;
    private Dbx dbx = null;
    private ActiveTerm currentLTerm = null;
    private ActiveTerm currentBTerm = null;
    private StringBuffer saveAsString = null;
    private ActiveTermListener termListener = null;
    private Component lastFocusOwner = null;
    private JTabbedPane jTabbedPane1;
    private JPanel leaksPanel;
    private JButton jButton1;
    private JPanel blocksPanel;
    private JPanel jPanel3;
    private boolean firstTime = true;
    private boolean reportBlocksDetailed = true;
    private boolean reportLeaksDetailed = true;
    private int reportLeaksType;
    private JMenuItem clearItem = null;
    private JMenuItem suppressItem = null;
    private JMenuItem showNewItem = null;
    private JMenuItem showAllItem = null;
    private JMenuItem detailedReportItem = null;
    private JMenuItem summaryReportItem = null;
    private JMenuItem saveAsItem = null;
    private ActiveTerm currentTerm = null;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction;

    public MemuseWindow(Dbx dbx) {
        super(DbxDebugger.getText("CTL_Memuse") + " (OFF)");
        this.dbx = dbx;
        this.currentLTerm = new ActiveTerm();
        dbx.setupTerm(this.currentLTerm, true);
        this.currentBTerm = new ActiveTerm();
        dbx.setupTerm(this.currentBTerm, true);
        this.currentBTerm.getCanvas().addFocusListener(this);
        this.currentLTerm.getCanvas().addFocusListener(this);
        this.initComponents();
        this.leaksPanel.add("Center", (Component)this.currentLTerm);
        this.blocksPanel.add("Center", (Component)this.currentBTerm);
        this.initializeA11y();
        this.jButton1.addFocusListener(this);
        this.jTabbedPane1.addFocusListener(this);
        this.leaksPanel.addFocusListener(this);
        this.blocksPanel.addFocusListener(this);
        this.addPopupListener(this.currentLTerm.getCanvas());
        this.addPopupListener(this.currentBTerm.getCanvas());
        this.addPopupListener((JComponent)((Object)this));
        this.addPopupListener(this.jPanel3);
        this.addPopupListener(this.jButton1);
        this.addPopupListener(this.leaksPanel);
        this.addPopupListener(this.blocksPanel);
        this.termListener = new ActiveTermListener(){

            public void action(ActiveRegion r, InputEvent e) {
                Hyperlink link = (Hyperlink)r.getUserObject();
                if (link != null) {
                    link.activate((Object)this);
                }
            }
        };
        this.currentLTerm.setActionListener(this.termListener);
        dbx.setLeaksTerm(this.currentLTerm);
        this.currentBTerm.setActionListener(this.termListener);
        dbx.setBlocksTerm(this.currentBTerm);
        this.setupHyperlinkProcessing(this.currentLTerm);
        this.setupHyperlinkProcessing(this.currentBTerm);
    }

    public void topComponentOpened(String tab_name, boolean open) {
        if (this.dbx != null && this.dbx.getDebugger() != null) {
            this.dbx.getDebugger().openOutputTab(this);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        }
    }

    public void focusGained(FocusEvent event) {
        this.lastFocusOwner = (Component)event.getSource();
    }

    public void focusLost(FocusEvent event) {
    }

    private void setBold(ActiveTerm term) {
        term.setAttribute(1);
    }

    private void addSeparator(ActiveTerm term) {
        if (term.getCursorCol() != 0) {
            term.putChar('\r');
            term.putChar('\n');
        }
        int width = term.getColumns();
        for (int i = 0; i < width; ++i) {
            term.putChar('_');
        }
        if (this.saveAsString == null) {
            this.saveAsString = new StringBuffer(1000);
        }
        this.saveAsString.append("\n________________________________________________________________________________\n");
    }

    private void setNormal(ActiveTerm term) {
        term.setAttribute(0);
    }

    private void append(ActiveTerm term, String str, String saveStr, boolean repaint) {
        term.appendText(str, repaint);
        if (this.saveAsString == null) {
            this.saveAsString = new StringBuffer(1000);
        }
        this.saveAsString.append(saveStr);
    }

    private void append(ActiveTerm term, String str, boolean repaint) {
        this.append(term, str, str, repaint);
    }

    private void append(ActiveTerm term, String str) {
        this.append(term, str, str, false);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.leaksPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.blocksPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.leaksPanel.setLayout(new BorderLayout());
        this.jButton1.setText(DbxDebugger.getText("SuppressLast"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemuseWindow.this.suppressLast(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.leaksPanel.add((Component)this.jPanel3, "South");
        this.jTabbedPane1.addTab(DbxDebugger.getText("Leaks"), this.leaksPanel);
        this.blocksPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab(DbxDebugger.getText("Blocks"), this.blocksPanel);
        this.add(this.jTabbedPane1, "Center");
    }

    private void suppressLast(ActionEvent evt) {
        if (DebuggingOption.RTC_AUTO_SUPPRESS.isEnabled()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("AlreadySuppressedLast")));
            return;
        }
        DbxDebugSession session = this.dbx.getSession();
        if (session != null && this.dbx != null) {
            this.dbx.suppressLastError();
        }
    }

    private void additionalInitComponents() {
        this.setName(DbxDebugger.getText("TITLE_MemuseWindow"));
        this.setIcon(Utilities.loadImage((String)"com/sun/tools/dbxgui/icons/memuse.gif"));
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void reportLeaksBegin(Dbx dbx, DbxMprofHeader hp) {
        ActiveTerm leaksTerm = dbx.getLeaksTerm();
        this.reportLeaksDetailed = hp.verbose;
        this.reportLeaksType = hp.type;
        if (DebuggingOption.FRONT_MEMUSE.isEnabled()) {
            this.requestVisible();
        }
        this.jTabbedPane1.setSelectedComponent(this.leaksPanel);
        if (dbx.leaksNew) {
            DbxDebugSession session = dbx.getSession();
            if (session != null) {
                DbxDebugProgram program = session.getConfig().getProgram();
                String path = program.getExecutableName();
                if (path == null) {
                    path = MessageFormat.format(DbxDebugger.getText("AttachedProcessPid"), Long.toString(session.getPid()));
                }
                this.append(leaksTerm, MessageFormat.format(DbxDebugger.getText("MemleaksStarted"), path));
            }
            dbx.leaksNew = false;
        }
        this.setBold(leaksTerm);
        this.append(leaksTerm, hp.buf, true);
        this.setNormal(leaksTerm);
    }

    public void reportLeaksEnd(Dbx dbx) {
        ActiveTerm leaksTerm = dbx.getLeaksTerm();
        if (this.reportLeaksType == 0) {
            this.addSeparator(leaksTerm);
        }
        this.append(leaksTerm, "", true);
    }

    public void leaksItem(Dbx dbx, DbxMprofItem item) {
        DbxDebuggerEngine engine;
        ActiveTerm leaksTerm = dbx.getLeaksTerm();
        if (DebuggingOption.FRONT_MEMUSE.isEnabled()) {
            this.requestVisible();
        }
        this.jTabbedPane1.setSelectedComponent(this.leaksPanel);
        this.append(leaksTerm, item.buf);
        boolean sixtyfourbit = false;
        DbxDebugSession session = dbx.getSession();
        if (session != null && (engine = session.getEngine()) != null) {
            sixtyfourbit = engine.getState().is64bit();
        }
        for (int i = 0; i < item.stack.nframes; ++i) {
            if (i > 0) {
                this.append(leaksTerm, "<-");
            } else if (this.reportLeaksDetailed) {
                this.append(leaksTerm, "\t");
            }
            DbxFrame frame = item.stack.frame[i];
            if (frame.source != null) {
                ActiveRegion region = leaksTerm.beginRegion(true);
                region.setFeedbackEnabled(false);
                region.setSelectable(false);
                String text = null;
                text = frame.func != null ? frame.func : (sixtyfourbit ? Long.toHexString(frame.pc) : Integer.toHexString((int)frame.pc));
                this.append(leaksTerm, text);
                Hyperlink link = new Hyperlink(text, "editor:" + frame.source + ":" + frame.lineno + "::");
                region.setUserObject((Object)link);
                leaksTerm.endRegion();
                continue;
            }
            if (frame.func != null) {
                this.append(leaksTerm, frame.func);
                continue;
            }
            if (sixtyfourbit) {
                this.append(leaksTerm, Long.toHexString(frame.pc));
                continue;
            }
            this.append(leaksTerm, Integer.toHexString((int)frame.pc));
        }
        this.append(leaksTerm, "\n", true);
    }

    public void reportBlocksBegin(Dbx dbx, DbxMprofHeader hp) {
        ActiveTerm blocksTerm = dbx.getBlocksTerm();
        this.reportBlocksDetailed = hp.verbose;
        if (dbx.blocksNew) {
            DbxDebugSession session = dbx.getSession();
            if (session != null) {
                DbxDebugProgram program = session.getConfig().getProgram();
                String path = program.getExecutableName();
                if (path == null) {
                    path = MessageFormat.format(DbxDebugger.getText("AttachedProcessPid"), Long.toString(session.getPid()));
                }
                this.append(blocksTerm, MessageFormat.format(DbxDebugger.getText("MemuseStarted"), path));
            }
            dbx.blocksNew = false;
        }
        this.setBold(blocksTerm);
        this.append(blocksTerm, hp.buf, true);
        this.setNormal(blocksTerm);
    }

    public void reportBlocksEnd(Dbx dbx) {
        ActiveTerm blocksTerm = dbx.getBlocksTerm();
        this.addSeparator(blocksTerm);
        this.append(blocksTerm, "", true);
    }

    public void blocksItem(Dbx dbx, DbxMprofItem item) {
        DbxDebuggerEngine engine;
        ActiveTerm blocksTerm = dbx.getBlocksTerm();
        if (DebuggingOption.FRONT_MEMUSE.isEnabled()) {
            this.requestVisible();
        }
        this.jTabbedPane1.setSelectedComponent(this.blocksPanel);
        this.append(blocksTerm, item.buf);
        boolean sixtyfourbit = false;
        DbxDebugSession session = dbx.getSession();
        if (session != null && (engine = session.getEngine()) != null) {
            sixtyfourbit = engine.getState().is64bit();
        }
        for (int i = 0; i < item.stack.nframes; ++i) {
            if (i > 0) {
                this.append(blocksTerm, "<-");
            } else if (this.reportBlocksDetailed) {
                this.append(blocksTerm, "\t");
            }
            DbxFrame frame = item.stack.frame[i];
            if (frame.source != null) {
                ActiveRegion region = blocksTerm.beginRegion(true);
                region.setFeedbackEnabled(false);
                region.setSelectable(false);
                String text = null;
                text = frame.func != null ? frame.func : (sixtyfourbit ? Long.toHexString(frame.pc) : Integer.toHexString((int)frame.pc));
                this.append(blocksTerm, text);
                Hyperlink link = new Hyperlink(text, "editor:" + frame.source + ":" + frame.lineno + "::");
                region.setUserObject((Object)link);
                blocksTerm.endRegion();
                continue;
            }
            if (frame.func != null) {
                this.append(blocksTerm, frame.func);
                continue;
            }
            if (sixtyfourbit) {
                this.append(blocksTerm, Long.toHexString(frame.pc));
                continue;
            }
            this.append(blocksTerm, Integer.toHexString((int)frame.pc));
        }
        this.append(blocksTerm, "\n", true);
    }

    public void showNewLeaks() {
        if (this.dbx != null) {
            this.dbx.showLeaks(false, this.reportLeaksDetailed);
        }
    }

    public void showNewBlocks() {
        if (this.dbx != null) {
            this.dbx.showBlocks(false, this.reportBlocksDetailed);
        }
    }

    public void showAllLeaks() {
        if (this.dbx != null) {
            this.dbx.showLeaks(true, this.reportLeaksDetailed);
        }
    }

    public void showAllBlocks() {
        if (this.dbx != null) {
            this.dbx.showBlocks(true, this.reportBlocksDetailed);
        }
    }

    public void showLeaksDetails() {
        this.reportLeaksDetailed = true;
    }

    public void showLeaksSummary() {
        this.reportLeaksDetailed = false;
    }

    public void showBlocksDetails() {
        this.reportBlocksDetailed = true;
    }

    public void showBlocksSummary() {
        this.reportBlocksDetailed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(DbxDebugger.getText("Rtc_SaveAsText"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
        chooser.setFileHidingEnabled(false);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            try {
                FileWriter fw = new FileWriter(f);
                try {
                    if (this.saveAsString != null) {
                        fw.write(this.saveAsString.toString());
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] rtcActions = new SystemAction[]{null};
        return rtcActions;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("leaks-end" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getNewValue();
            this.reportLeaksEnd(dbx);
        } else if ("memuse-end" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getNewValue();
            this.reportBlocksEnd(dbx);
        } else if ("memuse-start" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getOldValue();
            DbxMprofHeader header = (DbxMprofHeader)evt.getNewValue();
            this.reportBlocksBegin(dbx, header);
        } else if ("leaks-start" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getOldValue();
            DbxMprofHeader header = (DbxMprofHeader)evt.getNewValue();
            this.reportLeaksBegin(dbx, header);
        } else if ("leak-item" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getOldValue();
            DbxMprofItem item = (DbxMprofItem)evt.getNewValue();
            this.leaksItem(dbx, item);
        } else if ("memuse-item" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getOldValue();
            DbxMprofItem item = (DbxMprofItem)evt.getNewValue();
            this.blocksItem(dbx, item);
        } else if ("memuse-state" == evt.getPropertyName()) {
            if (!this.dbx.isMemuseEnabled()) {
                this.setName(DbxDebugger.getText("CTL_Memuse") + " (OFF)");
            } else {
                this.setName(DbxDebugger.getText("CTL_Memuse") + " (ON)");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.clearItem) {
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Memuse Check: Clear", null);
            }
            this.currentTerm.clearHistory();
            this.currentTerm.clear();
        } else if (actionEvent.getSource() == this.suppressItem) {
            this.suppressLast(null);
        } else if (actionEvent.getSource() == this.showNewItem) {
            if (this.currentTerm == this.currentLTerm) {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show New Leaks", null);
                }
                this.showNewLeaks();
            } else {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show New Blocks", null);
                }
                this.showNewBlocks();
            }
        } else if (actionEvent.getSource() == this.showAllItem) {
            if (this.currentTerm == this.currentLTerm) {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show All Leaks", null);
                }
                this.showAllLeaks();
            } else {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show All Blocks", null);
                }
                this.showAllBlocks();
            }
        } else if (actionEvent.getSource() == this.detailedReportItem) {
            if (this.currentTerm == this.currentLTerm) {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show Leaks Details", null);
                }
                this.showLeaksDetails();
            } else {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show Blocks Details", null);
                }
                this.showBlocksDetails();
            }
        } else if (actionEvent.getSource() == this.summaryReportItem) {
            if (this.currentTerm == this.currentLTerm) {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show Leaks Summary", null);
                }
                this.showLeaksSummary();
            } else {
                if (UsageTracking.enabled) {
                    UsageTracking.sendAction((String)"Memuse Check: Show Blocks Summary", null);
                }
                this.showBlocksSummary();
            }
        } else if (actionEvent.getSource() == this.saveAsItem) {
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Memuse Check: Save As", null);
            }
            this.saveAs();
        }
    }

    protected void populateMenu(Object source, int xpos, int ypos, JPopupMenu popup) {
        boolean leaksMenu;
        CallableSystemAction tmca = (CallableSystemAction)SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction = MemuseWindow.class$("com.sun.tools.debugger.dbxgui.debugger.actions.ToggleMemuseChecksAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction));
        JMenuItem jmi = tmca.getPopupPresenter();
        popup.add(jmi);
        popup.addSeparator();
        this.suppressItem = new JMenuItem(DbxDebugger.getText("Rtc_Suppress"));
        popup.add(this.suppressItem);
        this.suppressItem.addActionListener(this);
        popup.addSeparator();
        boolean enabled = false;
        if (this.dbx != null && this.dbx.isMemuseEnabled()) {
            enabled = true;
        }
        if (source == this.leaksPanel || this.currentLTerm != null && source == this.currentLTerm.getCanvas()) {
            leaksMenu = true;
        } else if (source == this.blocksPanel || this.currentBTerm != null && source == this.currentBTerm.getCanvas()) {
            leaksMenu = false;
        } else {
            Component tabSel = this.jTabbedPane1.getSelectedComponent();
            leaksMenu = this.currentLTerm != null && tabSel == this.currentLTerm.getCanvas() ? true : this.currentBTerm == null || tabSel != this.currentBTerm.getCanvas();
        }
        if (leaksMenu) {
            this.currentTerm = this.currentLTerm;
            this.showNewItem = new JMenuItem(DbxDebugger.getText("Memuse_ShowNewLeaks"));
            popup.add(this.showNewItem);
            this.showNewItem.addActionListener(this);
            this.showAllItem = new JMenuItem(DbxDebugger.getText("Memuse_ShowAllLeaks"));
            popup.add(this.showAllItem);
            this.showAllItem.addActionListener(this);
        } else {
            this.currentTerm = this.currentBTerm;
            this.showNewItem = new JMenuItem(DbxDebugger.getText("Memuse_ShowNewBlocks"));
            popup.add(this.showNewItem);
            this.showNewItem.addActionListener(this);
            this.showAllItem = new JMenuItem(DbxDebugger.getText("Memuse_ShowAllBlocks"));
            popup.add(this.showAllItem);
            this.showAllItem.addActionListener(this);
        }
        popup.addSeparator();
        this.saveAsItem = new JMenuItem(DbxDebugger.getText("Rtc_SaveAsText"));
        popup.add(this.saveAsItem);
        this.saveAsItem.addActionListener(this);
        this.clearItem = new JMenuItem(DbxDebugger.getText("Rtc_Clear"));
        popup.add(this.clearItem);
        this.clearItem.addActionListener(this);
        popup.addSeparator();
        boolean details = leaksMenu ? this.reportLeaksDetailed : this.reportBlocksDetailed;
        this.detailedReportItem = new JRadioButtonMenuItem(DbxDebugger.getText("Memuse_DetailedReport"), details);
        popup.add(this.detailedReportItem);
        this.detailedReportItem.addActionListener(this);
        this.summaryReportItem = new JRadioButtonMenuItem(DbxDebugger.getText("Memuse_SummaryReport"), !details);
        popup.add(this.summaryReportItem);
        this.summaryReportItem.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.detailedReportItem);
        bg.add(this.summaryReportItem);
        if (!enabled) {
            this.clearItem.setEnabled(false);
            this.suppressItem.setEnabled(false);
            this.showNewItem.setEnabled(false);
            this.showAllItem.setEnabled(false);
            this.detailedReportItem.setEnabled(false);
            this.summaryReportItem.setEnabled(false);
            this.saveAsItem.setEnabled(false);
        }
        this.addSystemActionsToMenu(popup);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Debugging_RTC");
    }

    public View2 getView() {
        return null;
    }

    public DelegatingView2 getDelegatingView() {
        return null;
    }

    public void initializeA11y() {
        super.initializeA11y();
        this.jButton1.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_SuppressLast"));
        this.jButton1.setMnemonic(DbxDebugger.getText("SuppressLastMnemonic").charAt(0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

