/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.utils.ImageLabel;
import com.sun.tools.debugger.dbxgui.utils.Log;
import com.sun.tools.swdev.glue.dbx.DbxThread;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadsRoot;

public final class IpeThread
extends AbstractThread
implements CallStackProducer {
    private ThreadsRoot threadsRoot;
    private DbxThread thread;
    private int currentCallStackFrameIndex = -1;
    private ImageLabel tid;
    private ImageIcon normalIcon = null;
    private ImageIcon suspendedIcon = null;
    private ImageIcon currentIcon = null;
    private ImageIcon eventIcon = null;
    private ImageIcon currentEventIcon = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler;

    IpeThread(ThreadsRoot threadsRoot, DbxThread thread) {
        this.threadsRoot = threadsRoot;
        this.thread = thread;
        if (this.thread == null) {
            this.thread = new DbxThread();
        }
        this.refresh();
    }

    public int getId() {
        if (this.thread == null) {
            return -1;
        }
        return this.thread.tid;
    }

    public boolean isCurrent() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.current;
    }

    DbxThread getThread() {
        return this.thread;
    }

    public void refresh() {
        this.tid = null;
    }

    public String getState() {
        if (this.thread.stop_reason != null) {
            return this.thread.stop_reason;
        }
        switch (this.thread.state) {
            case 0: {
                return DbxDebugger.getText("ThreadState_UNKNOWN");
            }
            case 1: {
                return DbxDebugger.getText("ThreadState_ACTIVE");
            }
            case 2: {
                return DbxDebugger.getText("ThreadState_SLEEP");
            }
            case 3: {
                return DbxDebugger.getText("ThreadState_RUN");
            }
            case 4: {
                return DbxDebugger.getText("ThreadState_SUSPENDED");
            }
            case 5: {
                return DbxDebugger.getText("ThreadState_ZOMBIE");
            }
        }
        return DbxDebugger.getText("ThreadState_DEFAULT");
    }

    public boolean getSuspended() {
        return this.thread.db_suspended;
    }

    public Integer getPriority() {
        return new Integer(-1);
    }

    public String getLWP() {
        switch ((char)this.thread.lrelation) {
            case 'a': {
                return "a l@" + Integer.toString(this.thread.lid);
            }
            case 'b': {
                return "b l@" + Integer.toString(this.thread.lid);
            }
        }
        return "";
    }

    public String getStartupFlags() {
        return "<unknown>";
    }

    public String getCurrentFunction() {
        if (this.thread.current_function == null) {
            return "<unknown>";
        }
        return this.thread.current_function;
    }

    public String getStartFunction() {
        if (this.thread.root_function == null) {
            return "<unknown>";
        }
        return this.thread.root_function;
    }

    public String getAddress() {
        String address = "0x" + Long.toHexString(this.thread.address);
        return address;
    }

    public Integer getStackSize() {
        return new Integer(-1);
    }

    public static String tidToString(int id) {
        switch (id) {
            case -1: {
                return "t@null";
            }
            case -2: {
                return "t@all";
            }
            case -3: {
                return "t@X";
            }
            case -4: {
                return "t@?";
            }
            case -5: {
                return "t@idle";
            }
        }
        return "t@" + Integer.toString(id);
    }

    public static String lidToString(byte lrelation, int id) {
        if (lrelation != 97 && lrelation != 98) {
            return "";
        }
        return "l@" + id;
    }

    public ImageLabel getTID() {
        if (this.tid == null) {
            String label = this.thread == null ? "<none>" : IpeThread.tidToString(this.thread.tid);
            ImageIcon icon = null;
            icon = this.thread == null ? this.getNormalIcon() : (this.thread.event != 0 ? (this.thread.current ? this.getCurrentEventIcon() : this.getEventIcon()) : (this.thread.current ? this.getCurrentIcon() : this.getNormalIcon()));
            this.tid = new ImageLabel(label, icon);
        }
        return this.tid;
    }

    public void changeCurrentCallStackFrameIndex(int index) {
        if (index != this.currentCallStackFrameIndex) {
            int old = this.currentCallStackFrameIndex;
            this.currentCallStackFrameIndex = index;
            this.pcs.firePropertyChange("currentCallstackFrameIndex", new Integer(old), new Integer(this.currentCallStackFrameIndex));
        }
    }

    private final ImageIcon getNormalIcon() {
        if (this.normalIcon == null) {
            this.normalIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler == null ? (class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler = IpeThread.class$("com.sun.tools.debugger.dbxgui.debugger.IpeHandler")) : class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler).getResource("/com/sun/tools/debugger/dbxgui/icons/thread.gif"));
        }
        return this.normalIcon;
    }

    private final ImageIcon getCurrentIcon() {
        if (this.currentIcon == null) {
            this.currentIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler == null ? (class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler = IpeThread.class$("com.sun.tools.debugger.dbxgui.debugger.IpeHandler")) : class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler).getResource("/com/sun/tools/debugger/dbxgui/icons/threadCurrent.gif"));
        }
        return this.currentIcon;
    }

    private final ImageIcon getEventIcon() {
        if (this.eventIcon == null) {
            this.eventIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler == null ? (class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler = IpeThread.class$("com.sun.tools.debugger.dbxgui.debugger.IpeHandler")) : class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler).getResource("/com/sun/tools/debugger/dbxgui/icons/eventThread.gif"));
        }
        return this.eventIcon;
    }

    private final ImageIcon getCurrentEventIcon() {
        if (this.currentEventIcon == null) {
            this.currentEventIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler == null ? (class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler = IpeThread.class$("com.sun.tools.debugger.dbxgui.debugger.IpeHandler")) : class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler).getResource("/com/sun/tools/debugger/dbxgui/icons/eventThreadCurrent.gif"));
        }
        return this.currentEventIcon;
    }

    public String getName() {
        return IpeThread.tidToString(this.getId());
    }

    public void setCurrent(boolean current) {
        if (this.thread == null) {
            return;
        }
        Log.prfa(1, this.getName() + ", " + current);
        if (this.thread.current == current) {
            return;
        }
        AbstractThread aot = this.threadsRoot.getCurrentThread();
        final IpeThread ot = (IpeThread)aot;
        if (ot != null) {
            if (ot.thread != null) {
                ot.thread.current = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ot.pcs.firePropertyChange("current", null, null);
                }
            });
        }
        this.thread.current = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IpeThread.this.pcs.firePropertyChange("current", null, null);
            }
        });
        if (current) {
            String cmd = "thread " + this.getName();
            DbxDebugger debugger = (DbxDebugger)Register.getCurrentDebugger();
            debugger.getEngine().sendCommand(0, 0, cmd);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public CallStackFilter getCallStackFilter() {
        DbxDebugger debugger = (DbxDebugger)Register.getCurrentDebugger();
        return debugger.getCallStackFilter();
    }

    public void setCallStackFilter(CallStackFilter filter) {
    }

    public Location[] getCallStack() {
        DbxDebugger debugger = (DbxDebugger)Register.getCurrentDebugger();
        return debugger.getEngine().getStackFrames();
    }

    public void setCurrentCallStackFrameIndex(int n) {
        DbxDebugger debugger = (DbxDebugger)Register.getCurrentDebugger();
        debugger.getEngine().gotoFrame(n);
    }

    public int getCurrentCallStackFrameIndex() {
        return this.currentCallStackFrameIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

