/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.common.nbtext.UnixTabTerm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.netbeans.lib.terminalemulator.Term;
import org.openide.actions.CopyAction;
import org.openide.actions.PasteAction;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;

public final class DbxWindow
extends UnixTabTerm
implements PropertyChangeListener,
ComponentListener {
    static final long serialVersionUID = -659344684076746769L;
    private transient Term term = null;
    private Dbx dbx = null;
    private boolean firstTime = true;
    private boolean oldBlock = false;
    private ActionPerformer copyActionPerformer = null;
    private static CopyAction copy = null;
    private static PasteAction paste = null;
    private CBListener cblistener;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;

    public DbxWindow(Dbx dbx) {
        super(DbxDebugger.getText("CTL_Debugger_console"));
        this.term = dbx.getTerm();
        this.dbx = dbx;
        this.createComponents();
        this.initializeA11y();
    }

    private void createComponents() {
        this.addPopupListener((JComponent)((Object)this));
        this.setLayout(new BorderLayout());
        if (this.term != null) {
            this.add((Component)this.term, "Center");
            this.addPopupListener(this.term.getCanvas());
        }
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] termActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DbxWindow.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = DbxWindow.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null};
        return termActions;
    }

    public void componentShown(ComponentEvent e) {
        if (this.firstTime) {
            this.firstTime = false;
            this.setSize(this.getPreferredSize());
            this.validate();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    private void blockInput(boolean block) {
        if (block == this.oldBlock) {
            return;
        }
        this.oldBlock = block;
        if (block) {
            JOptionPane.getFrameForComponent((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        } else {
            JOptionPane.getFrameForComponent((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
        }
    }

    public JComponent removeTerm() {
        Term result = this.term;
        this.setTerm(null);
        return result;
    }

    public void setTerm(Term newTerm) {
        if (newTerm == this.term) {
            return;
        }
        if (this.term != null) {
            this.remove((Component)this.term);
            this.removePopupListener(this.term.getCanvas());
            this.term = null;
        }
        this.term = newTerm;
        if (this.term != null) {
            this.add((Component)this.term, "Center");
            this.addPopupListener(this.term.getCanvas());
        }
        this.validate();
        this.repaint();
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.term != null) {
            this.term.getCanvas().requestFocus();
        }
    }

    protected void componentActivated() {
        Clipboard c;
        if (this.cblistener == null) {
            this.cblistener = new CBListener();
        }
        if ((c = IpeUtils.getClipboard()) instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.addClipboardListener((ClipboardListener)this.cblistener);
        }
        this.activateActions();
        super.componentActivated();
    }

    protected void componentDeactivated() {
        Clipboard c = IpeUtils.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.removeClipboardListener((ClipboardListener)this.cblistener);
        }
        this.deactivateActions();
        super.componentDeactivated();
    }

    private void activateActions() {
        this.enableCopy();
        this.updatePasteAction();
    }

    private void deactivateActions() {
        if (this.copyActionPerformer != null) {
            copy.setActionPerformer(null);
        }
        if (paste != null) {
            paste.setPasteTypes(null);
        }
    }

    private void enableCopy() {
        ActionPerformer perf;
        if (this.copyActionPerformer == null) {
            this.copyActionPerformer = new CopyActionPerformer();
            copy = (CopyAction)CopyAction.findObject((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DbxWindow.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), (boolean)true);
        }
        if ((perf = copy.getActionPerformer()) != this.copyActionPerformer) {
            copy.setActionPerformer(this.copyActionPerformer);
        }
    }

    private void disableCutCopyDelete() {
        if (this.copyActionPerformer != null) {
            copy.setActionPerformer(null);
        }
    }

    private void updatePasteAction() {
        Clipboard clipboard;
        Transferable trans;
        if (paste == null) {
            paste = (PasteAction)PasteAction.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = DbxWindow.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), (boolean)true);
        }
        if ((trans = (clipboard = IpeUtils.getClipboard()).getContents(this)) != null) {
            DataFlavor[] df = trans.getTransferDataFlavors();
            int n = 0;
            if (df != null) {
                n = df.length;
            }
            for (int i = 0; i < n; ++i) {
                if (!df[i].getMimeType().startsWith("text/plain")) continue;
                PasteType[] pasteTypes = new PasteType[]{new Paste()};
                paste.setPasteTypes(pasteTypes);
                return;
            }
        }
        paste.setPasteTypes(null);
    }

    public void topComponentOpened(String tab_name, boolean open) {
        if (this.dbx != null && this.dbx.getDebugger() != null) {
            this.dbx.getDebugger().openOutputTab(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("dbxbusy" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getNewValue();
            if (dbx != null) {
                this.blockInput(dbx.isDbxBusy());
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CBListener
    implements ClipboardListener {
        private CBListener() {
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                DbxWindow.this.updatePasteAction();
            }
        }
    }

    class CopyActionPerformer
    implements ActionPerformer {
        public void performAction(SystemAction action) {
            if (DbxWindow.this.term == null) {
                return;
            }
            String txt = DbxWindow.this.term.getSelectedText();
            if (txt != null) {
                DbxWindow.this.term.copy();
                DbxWindow.this.updatePasteAction();
            }
        }
    }

    private class Paste
    extends PasteType {
        private Paste() {
        }

        public Transferable paste() throws IOException {
            DbxWindow.this.term.paste();
            return null;
        }
    }
}

