/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.VDLActions;
import com.sun.tools.debugger.dbxgui.debugger.VDLParser;
import com.sun.tools.debugger.dbxgui.debugger.Variable;
import com.sun.tools.debugger.dbxgui.utils.Log;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;

public class DbxVariable
implements Variable {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected DbxDebugger debugger;
    private String name = "<unset name>";
    private String deref_name = "<unset name>";
    private String assign_str = null;
    private String type = "<unset type>";
    private String atype = "<unset atype>";
    private String value = "<unset value>";
    private boolean delta = false;
    private boolean isLeaf = true;
    private boolean isExpanded = false;
    private boolean isPtr = false;
    private boolean isJava = false;
    private DbxVariable[] variables = null;
    private String rhs;
    private String rhs_vdl;
    private VDLParser parser;
    private String deref_expr;
    private String root_name = null;
    private Func func = null;
    private ArrayList open_node_chain = new ArrayList();
    private CtxStack valueStack;

    public DbxVariable(DbxDebugger debugger, String name, String deref_name, String type, String atype, String value, String funcname, String rootname) {
        this.debugger = debugger;
        if (name != null) {
            this.name = name;
        }
        if (deref_name != null) {
            this.deref_name = deref_name;
        }
        if (type != null) {
            this.type = type;
        }
        if (atype != null) {
            this.atype = atype;
        }
        if (value != null) {
            this.value = value;
        }
        if (funcname != null) {
            this.func = this.getFuncFromDbx(funcname);
        }
        if (rootname != null) {
            this.root_name = rootname;
        }
    }

    public String getVariableName() {
        return this.name;
    }

    public String getDerefName() {
        return this.deref_name;
    }

    public String getAsText() {
        return this.value;
    }

    public void setAsText(String value) {
        String ovalue = this.value;
        this.value = value;
        this.pcs.firePropertyChange("asText", ovalue, this.value);
    }

    public void setVariableValue(String value) {
        this.debugger.getEngine().execute(this.assign_str + value);
    }

    public void setVariableName(String name) {
        this.name = name;
    }

    public void setDerefName(String deref_name) {
        this.deref_name = deref_name;
    }

    public String getType() {
        return this.type;
    }

    public String getAType() {
        return this.atype;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String getInfo() {
        return null;
    }

    public VariablesFilter getVariablesFilter() {
        Log.prf(1, "NOT IMPLEMENTED");
        return null;
    }

    public void setVariablesFilter(VariablesFilter filter) {
        Log.prf(1, "NOT IMPLEMENTED");
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public void setDelta(boolean d) {
        this.delta = d;
    }

    public AbstractVariable[] getVariables() {
        if (this.variables != null) {
            Log.prf(1, "variables");
            return this.variables;
        }
        Log.prf(1, "NO variables");
        return new DbxVariable[]{null};
    }

    public void setVariables(DbxVariable[] variables) {
        this.variables = variables;
        this.pcs.firePropertyChange("variables", null, null);
    }

    public void requestChildren() {
        Log.prf(1, "");
        if (!this.isJava && this.isPtr) {
            if (this.deref_expr != null) {
                this.setExpanded(this.root_name, true);
                if (this.debugger.getEngine() != null) {
                    this.debugger.getEngine().expr_heval(this, this.deref_expr);
                }
            }
        } else {
            this.setExpanded(this.root_name, true);
            this.pcs.firePropertyChange("variables", null, null);
        }
    }

    public boolean getDelta() {
        return this.delta;
    }

    public void setExpanded(String root, boolean e) {
        this.isExpanded = e;
        Func f = this.getFunc();
        if (f != null) {
            if (e) {
                f.addOpen(root, this.deref_name);
            } else {
                f.removeOpen(root, this.deref_name);
            }
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setJava(boolean e) {
        this.isJava = e;
    }

    public boolean isJava() {
        return this.isJava;
    }

    public void setPtr(boolean e) {
        this.isPtr = e;
    }

    public boolean isPtr() {
        return this.isPtr;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAType(String atype) {
        this.atype = atype;
    }

    public String getRHS() {
        return this.rhs;
    }

    public String getRHS_VDL() {
        return this.rhs_vdl;
    }

    public void setRHS(String rhs, String rhs_vdl) {
        Log.prf(1, "'" + rhs + "'");
        this.rhs = rhs;
        this.rhs_vdl = rhs_vdl;
        this.setAsText(rhs);
        this.parser = new VDLParser(new DerefVDLActions(this));
        this.valueStack = new CtxStack();
        Ctx firstCtx = new Ctx();
        firstCtx.currentVariable = this;
        firstCtx.children = null;
        this.valueStack.push(firstCtx);
        this.parser.parse(rhs_vdl);
    }

    public void setChildren(String rhs_vdl) {
        Log.prf(1);
        this.parser = new VDLParser(new DerefVDLActions(this));
        this.valueStack = new CtxStack();
        Ctx firstCtx = new Ctx();
        firstCtx.currentVariable = this;
        firstCtx.children = null;
        this.valueStack.push(firstCtx);
        this.parser.parse(rhs_vdl);
        Ctx lastCtx = (Ctx)this.valueStack.pop();
        if (lastCtx.children != null) {
            int size = lastCtx.children.size();
            if (size == 0) {
                this.setVariables(null);
            } else {
                DbxVariable[] vars = new DbxVariable[size];
                for (int vx = 0; vx < size; ++vx) {
                    vars[vx] = (DbxVariable)lastCtx.children.elementAt(vx);
                }
                this.setVariables(vars);
            }
        }
    }

    public DbxDebugger getDebugger() {
        return this.debugger;
    }

    public ArrayList getOpenNode() {
        return this.open_node_chain;
    }

    public String getRootName() {
        return this.root_name;
    }

    public String getAssignStr() {
        return this.assign_str;
    }

    public Func getFunc() {
        return this.func;
    }

    public boolean inOpenList() {
        return this.func != null && this.func.inOpenList(this.root_name, this.deref_name);
    }

    public void remove() {
        this.setExpanded(this.root_name, false);
        this.removeAllDescendantFromOpenList();
    }

    public void removeAllDescendantFromOpenList() {
        AbstractVariable[] children = this.getVariables();
        if (children != null) {
            for (int vx = 0; vx < children.length; ++vx) {
                String root;
                DbxVariable child = (DbxVariable)children[vx];
                if (child == null || (root = child.root_name) == null || !child.inOpenList()) continue;
                child.setExpanded(this.root_name, false);
                if (child.isLeaf()) continue;
                child.removeAllDescendantFromOpenList();
            }
        }
    }

    public Func getFuncFromDbx(String funcname) {
        ArrayList flist = null;
        if (this.debugger.getEngine() != null) {
            flist = this.debugger.getEngine().getFuncList();
        }
        if (flist != null) {
            int size = flist.size();
            Func[] ff = new Func[size];
            ff = flist.toArray(ff);
            for (int i = 0; i < size; ++i) {
                if (!ff[i].getFuncName().equals(funcname)) continue;
                return ff[i];
            }
            Func f = new Func(funcname);
            flist.add(f);
            return f;
        }
        return null;
    }

    class DerefVDLActions
    implements VDLActions {
        DbxVariable var;

        DerefVDLActions(DbxVariable var) {
            this.var = var;
        }

        public void setLeaf(boolean l) {
            this.var.setLeaf(l);
        }

        public void setType(String type, String atype) {
            this.var.setType(type);
            this.var.setAType(atype);
        }

        public void setDelta(boolean e) {
            this.var.delta = e;
        }

        public void setJava(boolean e) {
            this.var.setJava(e);
        }

        public void derefExpr(String expr) {
            DbxVariable currentVariable = ((DbxVariable)this.var).valueStack.top().currentVariable;
            if (currentVariable != null) {
                currentVariable.deref_expr = expr;
                currentVariable.deref_name = expr;
            } else {
                Log.prf(1, " no currentvariable:" + expr);
            }
        }

        public void newSmplval(String name, String deref_name, String type, String atype, String value, String set_str, String ptr_type_str, boolean delta) {
            DbxVariable currentVariable = null;
            String funcname = null;
            Func func = this.var.getFunc();
            if (func != null) {
                funcname = func.getFuncName();
            }
            if (this.var.valueStack.size() == 1 && set_str != null && !name.startsWith("*") && !name.startsWith("(*")) {
                currentVariable = ((DbxVariable)this.var).valueStack.top().currentVariable;
                currentVariable.setType(type);
                currentVariable.setAType(atype);
            } else {
                this.var.setLeaf(false);
                currentVariable = new DbxVariable(this.var.debugger, name, deref_name, type, atype, value, funcname, DbxVariable.this.root_name);
                if (((DbxVariable)this.var).valueStack.top().children == null) {
                    ((DbxVariable)this.var).valueStack.top().children = new Vector();
                }
                ((DbxVariable)this.var).valueStack.top().children.add(currentVariable);
            }
            currentVariable.setLeaf(true);
            currentVariable.setDelta(delta);
            if (set_str != null) {
                currentVariable.assign_str = set_str;
            }
            if (ptr_type_str != null) {
                String deref_exp = ptr_type_str.substring(8);
                if (!currentVariable.getAsText().equals("(nil)")) {
                    currentVariable.setLeaf(false);
                }
                currentVariable.setPtr(true);
                if (this.var.valueStack.size() > 1 || !this.var.getVariableName().equals(name)) {
                    Ctx newCtx = new Ctx();
                    newCtx.currentVariable = currentVariable;
                    this.var.valueStack.push(newCtx);
                    this.derefExpr(deref_exp);
                    this.var.valueStack.pop();
                } else {
                    this.derefExpr(deref_exp);
                }
                String disp_name = currentVariable.getVariableName();
                if (disp_name != null) {
                    int dot = disp_name.lastIndexOf(46);
                    if (dot != -1) {
                        disp_name = disp_name.substring(dot + 1);
                    }
                    if ((dot = disp_name.lastIndexOf(58)) != -1) {
                        disp_name = disp_name.substring(dot + 1);
                    }
                    currentVariable.setVariableName(disp_name);
                }
                if (currentVariable.inOpenList() && (DbxVariable.this.open_node_chain.isEmpty() || !DbxVariable.this.open_node_chain.contains(currentVariable))) {
                    DbxVariable.this.open_node_chain.add(currentVariable);
                    currentVariable.setExpanded(DbxVariable.this.root_name, true);
                }
            }
            currentVariable.setAsText(value);
        }

        public DbxVariable findChild(DbxVariable parent, String child_name) {
            AbstractVariable[] children = parent.getVariables();
            if (children != null) {
                for (int vx = 0; vx < children.length; ++vx) {
                    String c_name;
                    DbxVariable child = (DbxVariable)children[vx];
                    if (child == null || (c_name = child.getVariableName()) == null || !c_name.equals(child_name)) continue;
                    return child;
                }
            }
            return null;
        }

        public void startAggregate(String name, String deref_name, String type, String atype, boolean delta) {
            Ctx newCtx = new Ctx();
            DbxVariable current_var = null;
            if (this.var.valueStack.size() == 1 && !this.var.isPtr()) {
                current_var = this.var;
            }
            if (this.var.valueStack.size() > 1) {
                current_var = this.findChild(((DbxVariable)this.var).valueStack.top().currentVariable, name);
            }
            String funcname = null;
            Func func = this.var.getFunc();
            if (func != null) {
                funcname = func.getFuncName();
            }
            if (current_var == null) {
                newCtx.currentVariable = new DbxVariable(this.var.debugger, name, deref_name, type, atype, null, funcname, DbxVariable.this.root_name);
            } else {
                current_var.setType(type);
                current_var.setAType(atype);
                newCtx.currentVariable = current_var;
            }
            newCtx.currentVariable.setLeaf(false);
            newCtx.currentVariable.setDelta(delta);
            if (this.var.valueStack.size() > 1) {
                ((DbxVariable)this.var).valueStack.top().children.add(newCtx.currentVariable);
            }
            newCtx.children = new Vector();
            this.var.valueStack.push(newCtx);
            if (newCtx.currentVariable.inOpenList() && (DbxVariable.this.open_node_chain.isEmpty() || !DbxVariable.this.open_node_chain.contains(newCtx.currentVariable))) {
                DbxVariable.this.open_node_chain.add(newCtx.currentVariable);
                newCtx.currentVariable.setExpanded(DbxVariable.this.root_name, true);
            }
        }

        public void endAggregate() {
            Ctx top;
            DbxVariable parent;
            String fvalue = "(";
            if (this.var.valueStack.size() > 2) {
                parent = ((DbxVariable)this.var).valueStack.top().currentVariable;
                this.derefExpr(parent.deref_name);
                top = (Ctx)this.var.valueStack.pop();
            } else {
                top = (Ctx)this.var.valueStack.pop();
                parent = ((DbxVariable)this.var).valueStack.top().currentVariable;
                this.derefExpr(DbxVariable.this.deref_name);
            }
            if (top.children.size() == 0) {
                parent.setVariables(null);
            } else {
                int vx;
                DbxVariable[] vars = new DbxVariable[top.children.size()];
                for (vx = 0; vx < top.children.size() - 1; ++vx) {
                    vars[vx] = (DbxVariable)top.children.elementAt(vx);
                    fvalue = fvalue + vars[vx].getAsText();
                    fvalue = fvalue + ",";
                }
                vars[vx] = (DbxVariable)top.children.elementAt(vx);
                fvalue = fvalue + vars[vx].getAsText();
                fvalue = fvalue + ")";
                if (!parent.isPtr() || parent.isJava()) {
                    parent.setAsText(fvalue);
                }
                parent.setVariables(vars);
            }
        }
    }

    class CtxStack
    extends Stack {
        CtxStack() {
        }

        public Ctx top() {
            return (Ctx)super.peek();
        }
    }

    class Ctx {
        public DbxVariable currentVariable;
        public Vector children;

        Ctx() {
        }
    }

    class Func {
        private ArrayList root_list = new ArrayList();
        private String func_name = null;

        public Func(String name) {
            this.func_name = name;
        }

        public String getFuncName() {
            return this.func_name;
        }

        public Root findRoot(String r) {
            int size = this.root_list.size();
            Root[] rl = new Root[size];
            rl = this.root_list.toArray(rl);
            for (int i = 0; i < size; ++i) {
                if (!rl[i].getRootName().equals(r)) continue;
                return rl[i];
            }
            Root newroot = new Root(r);
            this.root_list.add(newroot);
            return newroot;
        }

        public void addOpen(String root, String s) {
            Root r = this.findRoot(root);
            r.addOpen(s);
        }

        public void removeOpen(String root, String s) {
            Root r = this.findRoot(root);
            r.removeOpen(s);
        }

        public boolean inOpenList(String root, String s) {
            Root r = this.findRoot(root);
            return r.inOpenList(s);
        }

        class Root {
            private ArrayList open_node = new ArrayList();
            private String root_name = null;

            public Root(String name) {
                this.root_name = name;
            }

            public String getRootName() {
                return this.root_name;
            }

            public void addOpen(String s) {
                if (this.open_node.isEmpty() || !this.open_node.contains(s)) {
                    this.open_node.add(s);
                }
            }

            public void removeOpen(String s) {
                if (!this.open_node.isEmpty() && this.open_node.contains(s)) {
                    this.open_node.remove(s);
                }
            }

            public boolean inOpenList(String s) {
                return this.open_node.contains(s);
            }
        }
    }
}

