/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.jdi.ThreadGroupReference;
import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.IpeThread;
import com.sun.tools.debugger.dbxgui.utils.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.support.ThreadPAdapter;

public class DbxThreadGroup
extends AbstractThread
implements ThreadsProducer,
PropertyChangeListener {
    public static final String PROP_CURRENT = "current";
    private boolean current = false;
    private Vector threads = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ThreadGroupReference threadGroup;
    private String name = null;
    private DbxDebugger debugger = null;
    private ThreadPAdapter threadProducer = new ThreadPAdapter();

    DbxThreadGroup(DbxDebugger debugger, String name) {
        this((DbxThreadGroup)null, null);
        this.name = name;
        this.debugger = debugger;
    }

    DbxThreadGroup(DbxThreadGroup parentThreadGroup, ThreadGroupReference threadGroup) {
        this.threadGroup = threadGroup;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        try {
            return this.threadGroup.name();
        }
        catch (Exception exception) {
            return "Thread";
        }
    }

    void setName(String name) {
        this.name = name;
        this.firePropertyChange(null, null, null);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        if (this.current == current) {
            return;
        }
        this.current = current;
        this.firePropertyChange(PROP_CURRENT, !current ? Boolean.TRUE : Boolean.FALSE, current ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    void markSuspended(boolean suspended) {
    }

    ThreadGroupReference getThreadGroupReference() {
        return this.threadGroup;
    }

    public String toString() {
        try {
            return "Thread Group: " + this.getName() + " (" + super.toString() + ")";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    void addThreadGroup(DbxThreadGroup threadGroup) {
    }

    void removeThreadGroup(DbxThreadGroup threadGroup) {
    }

    protected void addThread(IpeThread thread) {
        this.threads.add(thread);
        this.threadProducer.addThread((AbstractThread)thread);
    }

    protected void removeThread(IpeThread thread) {
        this.threads.remove((Object)thread);
        this.threadProducer.removeThread((AbstractThread)thread);
    }

    protected void removeAll() {
        for (int i = this.threads.size() - 1; i >= 0; --i) {
            IpeThread t = (IpeThread)((Object)this.threads.get(i));
            this.removeThread(t);
        }
    }

    void refresh() {
        Log.prf(1, "");
        this.firePropertyChange(null, null, null);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        Dbx dbx = (Dbx)ev.getSource();
        if ("stack-changed".equals(ev.getPropertyName())) {
            Log.prf(1, "stack changed!");
        } else if ("locals-changed".equals(ev.getPropertyName())) {
            Log.prf(1, "locals changed!");
        } else {
            Log.prf(1, "threads changed!");
        }
    }

    public AbstractThread[] getThreads() {
        AbstractThread[] threads = this.threadProducer.getThreads();
        return threads;
    }

    public void addThreadListener(ThreadListener l) {
        this.threadProducer.addThreadListener(l);
    }

    public void removeThreadListener(ThreadListener l) {
        this.threadProducer.removeThreadListener(l);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }
}

