/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxVariable;
import com.sun.tools.debugger.dbxgui.utils.ImageLabel;
import com.sun.tools.swdev.glue.dbx.DbxFrame;
import com.sun.tools.swdev.glue.dbx.DbxLocalItem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public final class DbxStackFrame
implements Location,
VariablesProducer {
    private DbxFrame frame = null;
    private Object location = null;
    private String address = null;
    private Boolean optimized = null;
    private ImageLabel function = null;
    private String signal = null;
    private VariablesFilter filter = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    DbxDebugger debugger;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger;

    DbxStackFrame(DbxDebugger debugger, DbxFrame frame) {
        this.debugger = debugger;
        this.frame = frame;
        if (this.frame == null) {
            this.frame = new DbxFrame();
        }
    }

    DbxStackFrame(DbxDebugger debugger) {
        this(debugger, null);
    }

    private static String getText(String key) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger == null ? (class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger = DbxStackFrame.class$("com.sun.tools.debugger.dbxgui.debugger.DbxDebugger")) : class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger), (String)key);
    }

    DbxFrame getFrame() {
        return this.frame;
    }

    public boolean isHidden() {
        return this.frame.range_of_hidden;
    }

    public boolean isSpecial() {
        return this.frame.range_of_hidden || this.frame.attr_user_call || this.frame.attr_sig != 0;
    }

    public String getLocationName() {
        if (this.frame.range_of_hidden) {
            return "---- " + DbxStackFrame.getText("MSG_HIDDDEN_FRAMES") + " ----";
        }
        if (this.frame.attr_user_call) {
            return "---- " + DbxStackFrame.getText("MSG_DEBUGGER_CALL") + " ----";
        }
        if (this.frame.attr_sig != 0) {
            return "---- " + MessageFormat.format(DbxStackFrame.getText("MSG_SIGNAL_HANDLER"), this.frame.attr_signame, "" + this.frame.attr_sig) + " ----";
        }
        if (this.frame.func == null) {
            return "?()";
        }
        if (this.frame.args == null) {
            return this.frame.func + "(?)";
        }
        return this.frame.func + this.frame.args;
    }

    private boolean hasDebuggingInfo() {
        return this.frame.source != null && this.frame.source.length() != 0;
    }

    public String getLocation() {
        if (this.isSpecial()) {
            return "";
        }
        if (!this.hasDebuggingInfo()) {
            return "";
        }
        return this.frame.source + ":" + this.frame.lineno;
    }

    public String getNumber() {
        if (this.isHidden()) {
            return "";
        }
        if (this.isSpecial()) {
            return "";
        }
        String index = Integer.toString(this.frame.frameno);
        return index;
    }

    public String getOptimized() {
        if (this.isSpecial()) {
            return "";
        }
        if (this.hasDebuggingInfo()) {
            if (this.frame.optimized) {
                return "-g/-O";
            }
            return "-g";
        }
        return "";
    }

    public String getCurrentPC() {
        if (this.isSpecial()) {
            return "";
        }
        String address = "0x" + Long.toHexString(this.frame.pc);
        return address;
    }

    public String getSignal() {
        if (this.signal == null) {
            this.signal = this.frame == null || this.frame.attr_signame != null ? this.frame.attr_signame : "";
        }
        return this.signal;
    }

    public int getFrameNo() {
        if (this.frame == null) {
            return -1;
        }
        return this.frame.frameno;
    }

    public Line getLine() {
        return null;
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        this.filter = filter;
    }

    public String getInfo() {
        return "DbxStackFre.getInfo(): NOT IMPLEMENTED";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean isLeaf() {
        return false;
    }

    public AbstractVariable[] getVariables() {
        if (this.debugger.getEngine() == null) {
            return new AbstractVariable[0];
        }
        try {
            if (this.frame == null) {
                return new AbstractVariable[0];
            }
            DbxLocalItem[] locals = this.debugger.getEngine().getLocalVars();
            if (locals != null) {
                AbstractVariable[] variables = new DbxVariable[locals.length - 1];
                for (int i = 0; i < variables.length; ++i) {
                    if (locals[i] != null) {
                        if (locals[i].flags == 0) {
                            variables[i] = new DbxVariable(this.debugger, locals[i].plain_lhs, locals[i].plain_lhs, null, null, locals[i].rhs, this.getLocationName(), locals[i].plain_lhs);
                            variables[i].setRHS(locals[i].rhs, locals[i].rhs_vdl);
                            continue;
                        }
                        if ((locals[i].flags & 8) != 0) {
                            variables[i] = new DbxVariable(this.debugger, locals[i].plain_lhs, null, null, null, "<TOO_BIG>", this.getLocationName(), null);
                            continue;
                        }
                        variables[i] = new DbxVariable(this.debugger, locals[i].plain_lhs, null, null, null, "<ERROR>", this.getLocationName(), null);
                        continue;
                    }
                    variables[i] = new DbxVariable(this.debugger, null, null, null, null, null, this.getLocationName(), null);
                }
                this.delayTraverseLocals(variables);
                return variables;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new AbstractVariable[0];
    }

    public void delayTraverseLocals(final AbstractVariable[] vv) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    for (int i = 0; i < vv.length; ++i) {
                        ArrayList openlist = ((DbxVariable)vv[i]).getOpenNode();
                        int size = openlist.size();
                        if (openlist == null || size == 0) continue;
                        DbxVariable[] ol = new DbxVariable[size];
                        ol = openlist.toArray(ol);
                        for (int j = 0; j < size; ++j) {
                            if (!ol[j].isExpanded()) continue;
                            ol[j].requestChildren();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

