/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

public final class DbxDebuggerState {
    private final int RUNNING = 1;
    private final int LOADED = 2;
    private final int PROCESS = 4;
    private final int CORE = 8;
    private final int TERMINATED = 16;
    private final int IS64BIT = 32;
    private final int MULTITHREADED = 64;
    private final int SAMPLING = 128;
    private final int UPALLOWED = 256;
    private final int DOWNALLOWED = 512;
    private final int DBXCALL = 1024;
    private int mask;
    public static DbxDebuggerState EMPTY = new DbxDebuggerState();
    public static DbxDebuggerState FULL = new DbxDebuggerState(-1);

    DbxDebuggerState() {
        this.mask = 0;
    }

    DbxDebuggerState(DbxDebuggerState m) {
        this.mask = m.mask;
    }

    private DbxDebuggerState(int m) {
        this.mask = m;
    }

    public final boolean isRunning() {
        return (this.mask & 1) != 0;
    }

    public final boolean isProcess() {
        return (this.mask & 4) != 0;
    }

    public final boolean isCore() {
        return (this.mask & 8) != 0;
    }

    public final boolean isTerminated() {
        return (this.mask & 0x10) != 0;
    }

    public final boolean is64bit() {
        return (this.mask & 0x20) != 0;
    }

    public final boolean isMultiThreaded() {
        return (this.mask & 0x40) != 0;
    }

    public final boolean isLoaded() {
        return (this.mask & 2) != 0;
    }

    public final boolean isSampling() {
        return (this.mask & 0x80) != 0;
    }

    public final boolean isUpAllowed() {
        return (this.mask & 0x100) != 0;
    }

    public final boolean isDownAllowed() {
        return (this.mask & 0x200) != 0;
    }

    public final boolean isDbxCall() {
        return (this.mask & 0x400) != 0;
    }

    public final int getHashCode() {
        return this.mask;
    }

    public final void setRunning(boolean running) {
        this.mask = running ? (this.mask |= 1) : (this.mask &= 0xFFFFFFFE);
    }

    public final void setLoaded(boolean loaded) {
        this.mask = loaded ? (this.mask |= 2) : (this.mask &= 0xFFFFFFFD);
    }

    public final void setProcess(boolean process) {
        this.mask = process ? (this.mask |= 4) : (this.mask &= 0xFFFFFFFB);
    }

    public final void setCore(boolean core) {
        this.mask = core ? (this.mask |= 8) : (this.mask &= 0xFFFFFFF7);
    }

    public final void set64bit(boolean is64bit) {
        this.mask = is64bit ? (this.mask |= 0x20) : (this.mask &= 0xFFFFFFDF);
    }

    public final void setTerminated(boolean terminated) {
        this.mask = terminated ? (this.mask |= 0x10) : (this.mask &= 0xFFFFFFEF);
    }

    public final void setMultithreaded(boolean multithreaded) {
        this.mask = multithreaded ? (this.mask |= 0x40) : (this.mask &= 0xFFFFFFBF);
    }

    public final void setSampling(boolean sampling) {
        this.mask = sampling ? (this.mask |= 0x80) : (this.mask &= 0xFFFFFF7F);
    }

    public final void setUpAllowed(boolean nottop) {
        this.mask = nottop ? (this.mask |= 0x100) : (this.mask &= 0xFFFFFEFF);
    }

    public final void setDownAllowed(boolean notbottom) {
        this.mask = notbottom ? (this.mask |= 0x200) : (this.mask &= 0xFFFFFDFF);
    }

    public final void setDbxCall(boolean called) {
        this.mask = called ? (this.mask |= 0x400) : (this.mask &= 0xFFFFFBFF);
    }

    public final boolean isEmpty() {
        return this.mask == 0;
    }

    public final void clear() {
        this.mask = 0;
    }

    public final void setAll() {
        this.mask = -1;
    }

    public final void negate() {
        this.mask ^= 0xFFFFFFFF;
    }

    public void union(DbxDebuggerState s) {
        this.mask |= s.mask;
    }

    public void intersect(DbxDebuggerState s) {
        this.mask &= s.mask;
    }

    public void xor(DbxDebuggerState s) {
        this.mask ^= s.mask;
    }

    public String toString() {
        return "DebugState (" + this.mask + "): " + (this.isRunning() ? "|RUNNING" : "") + (this.isProcess() ? "|PROCESS" : "") + (this.isCore() ? "|CORE" : "") + (this.isTerminated() ? "|TERMINATED" : "") + (this.is64bit() ? "|64BIT" : "") + (this.isMultiThreaded() ? "|MULTITHREADED" : "") + (this.isLoaded() ? "|LOADED" : "") + (this.isSampling() ? "|SAMPLING" : "") + (this.isUpAllowed() ? "|UPALLOWED" : "") + (this.isDownAllowed() ? "|DOWNALLOWED" : "") + (this.isDbxCall() ? "|DBXCALL" : "") + "  ";
    }
}

