/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.AccessWindow;
import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugProgram;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugSession;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerEngine;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerImpl;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerState;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerType;
import com.sun.tools.debugger.dbxgui.debugger.DbxThreadGroup;
import com.sun.tools.debugger.dbxgui.debugger.DbxWatch;
import com.sun.tools.debugger.dbxgui.debugger.DbxWindow;
import com.sun.tools.debugger.dbxgui.debugger.EditorLinkListener;
import com.sun.tools.debugger.dbxgui.debugger.IpeHandler;
import com.sun.tools.debugger.dbxgui.debugger.IpeThread;
import com.sun.tools.debugger.dbxgui.debugger.MemuseWindow;
import com.sun.tools.debugger.dbxgui.debugger.ProgramIOWindow;
import com.sun.tools.debugger.dbxgui.debugger.RoutingToken;
import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.debugger.actions.DbxRunToCursorAction;
import com.sun.tools.debugger.dbxgui.debugger.actions.DbxStepIntoAction;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.LineBreakpointDelegator;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.debugger.dbxgui.utils.Log;
import com.sun.tools.swdev.common.base.UnixPty;
import com.sun.tools.swdev.common.nbtext.Hyperlink;
import com.sun.tools.swdev.common.nbtext.HyperlinkEventListener;
import com.sun.tools.swdev.common.nbtext.UnixTabTerm;
import com.sun.tools.swdev.common.text.UnixTerm;
import com.sun.tools.swdev.common.utils.UsageTracking;
import com.sun.tools.swdev.glue.Notifier;
import com.sun.tools.swdev.glue.NotifierSwing;
import com.sun.tools.swdev.glue.dbx.DbxLocation;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.Keymap;
import org.netbeans.core.output.OutputSettings;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.cpp.loaders.CoreElfObject;
import org.netbeans.modules.cpp.loadpicklist.LoadExecutablePicklistElement;
import org.netbeans.modules.cpp.loadpicklist.LoadPicklist;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CallStackFilter;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CallStackRoot;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.DebuggerListener;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.VariablesRoot;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.SecondaryDebuggerSupport;
import org.netbeans.modules.debugger.support.View2;
import org.netbeans.modules.debugger.support.actions.DebuggerWindowPerformer;
import org.netbeans.modules.debugger.support.nodes.BreakpointsRootNode;
import org.netbeans.modules.debugger.support.nodes.DebuggerWindow;
import org.netbeans.modules.debugger.support.nodes.ToolbarView;
import org.netbeans.modules.debugger.support.nodes.TreeTableExplorerViewSupport;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.ToolbarToggleButton;
import org.openide.cookies.InstanceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class DbxDebugger
extends SecondaryDebuggerSupport
implements PropertyChangeListener,
DebuggerListener,
ThreadsRoot,
ValidatorHolder,
VariablesRoot,
CallStackRoot {
    public static final String PROP_SESSION = "DbxSession";
    static final int PARAM_NAMES = 1;
    static final int PARAM_VALUES = 2;
    static final int PARAM_TYPES = 4;
    public static final int LOADPROGRAM = 0;
    public static final int STEPPROGRAM = 1;
    public static final int RUNPROGRAM = 2;
    private static AbstractDebugger currentDebugger;
    private static boolean tabBug;
    private boolean gone = false;
    private boolean done_createOutputTabs = false;
    private static Hashtable debuggerToPIOTab;
    private static Hashtable debuggerToDbxTab;
    private static Hashtable debuggerToMemUseTab;
    private static Hashtable debuggerToAccessTab;
    private static Notifier notifier;
    private static Thread listenerThread;
    private DbxDebugSession currentSession;
    private static CoreDebugger cored;
    private Dbx engine = null;
    private Timer runTimer;
    private static CoreBreakpoint.Event[] breakpointEvents;
    private static CoreBreakpoint.Action[] breakpointActions;
    private boolean msgio = false;
    private ProgressMonitor popup = null;
    EditorLinkListener editorListener = null;
    private transient DebuggerAnnotation currentPCMarker = null;
    private transient DebuggerAnnotation visitMarker = null;
    private ResourceBundle bundle;
    private static final DebuggerChangeListener listener;
    private LocalViewChangeListener lv_listener;
    private static int nextSerialNumber;
    private int serialNumber = 0;
    private static Object tabMutex;
    private static HashSet keyStrokeSet;
    private static final int QuitInitiatedFrom_UNKNOWN = 0;
    private static final int QuitInitiatedFrom_GUI = 1;
    private static final int QuitInitiatedFrom_DBX = 2;
    private int quitInitiatedFrom = 0;
    private boolean updateActionButtons = false;
    private DbxDebuggerEngine delayedEngine = null;
    private int runDelay = -1;
    protected transient DbxThreadGroup threadGroup = new DbxThreadGroup(this, "All Threads");
    protected transient IpeThread currentThread = null;
    private DbxDebuggerState lastState = DbxDebuggerState.EMPTY;
    private DbxDebuggerState debugStateDirty = DbxDebuggerState.FULL;
    private SystemAction rerunA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$RerunAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$RerunAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.RerunAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$RerunAction));
    private SystemAction terminateA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$TerminateProcessAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$TerminateProcessAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.TerminateProcessAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$TerminateProcessAction));
    private SystemAction detachA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$DetachAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$DetachAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.DetachAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$DetachAction));
    private SystemAction pauseA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PauseAction == null ? (class$org$netbeans$modules$debugger$support$actions$PauseAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.PauseAction")) : class$org$netbeans$modules$debugger$support$actions$PauseAction));
    private SystemAction continueA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ContinueAction == null ? (class$org$netbeans$modules$debugger$support$actions$ContinueAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.ContinueAction")) : class$org$netbeans$modules$debugger$support$actions$ContinueAction));
    private SystemAction stepOverA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOverAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOverAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOverAction")) : class$org$netbeans$modules$debugger$support$actions$StepOverAction));
    private SystemAction stepIntoA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepIntoAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepIntoAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.StepIntoAction")) : class$org$netbeans$modules$debugger$support$actions$StepIntoAction));
    private SystemAction stepOutA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOutAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOutAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOutAction")) : class$org$netbeans$modules$debugger$support$actions$StepOutAction));
    private SystemAction runToCursorA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$RunToCursorAction == null ? (class$org$netbeans$modules$debugger$support$actions$RunToCursorAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.RunToCursorAction")) : class$org$netbeans$modules$debugger$support$actions$RunToCursorAction));
    private SystemAction runIntoLastFunctionCallA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$RunIntoLastFunctionCallAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$RunIntoLastFunctionCallAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.RunIntoLastFunctionCallAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$RunIntoLastFunctionCallAction));
    private SystemAction fixA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FixAction == null ? (class$org$netbeans$modules$debugger$support$actions$FixAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.FixAction")) : class$org$netbeans$modules$debugger$support$actions$FixAction));
    private SystemAction goToCallingMethodA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction));
    private SystemAction goToCalledMethodA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction));
    private SystemAction popTopmostA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction == null ? (class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.PopTopmostFrameAction")) : class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction));
    private SystemAction popLastCallA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$PopLastDebuggerCallAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$PopLastDebuggerCallAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.PopLastDebuggerCallAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$PopLastDebuggerCallAction));
    private SystemAction popToCurrentFrameA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$PopToCurrentFrameAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$PopToCurrentFrameAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.PopToCurrentFrameAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$PopToCurrentFrameAction));
    private SystemAction toggleAccessChecksA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.ToggleMemuseChecksAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction));
    private SystemAction toggleMemuseChecksA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.ToggleAccessChecksAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction));
    private SystemAction enableCollA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$StartCollector == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$StartCollector = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.StartCollector")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$StartCollector));
    private SystemAction disableCollA = SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.actions.StopCollector")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector));
    private SystemAction addWatchA = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddWatchAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddWatchAction = DbxDebugger.class$("org.netbeans.modules.debugger.support.actions.AddWatchAction")) : class$org$netbeans$modules$debugger$support$actions$AddWatchAction));
    private State debuggerState = null;
    private boolean ignoreNewSession = false;
    private static transient CallStackFilter csFilter;
    private VariablesFilter filter = new NullVariablesFilter();
    private transient Validator validator = new ValidatorImpl();
    private static int ignoreUpdates;
    private static Object ignoreUpdatesSync;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$RerunAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$TerminateProcessAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$DetachAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PauseAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$ContinueAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOverAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepIntoAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOutAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$RunToCursorAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$RunIntoLastFunctionCallAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FixAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$PopLastDebuggerCallAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$PopToCurrentFrameAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleMemuseChecksAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$StartCollector;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddWatchAction;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public DbxDebugger() {
        this.debuggerState = new MyState(this);
        this.setDebuggerState(this.debuggerState);
        this.currentSession = new DbxDebugSession(this);
        OutputSettings os = (OutputSettings)OutputSettings.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = DbxDebugger.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
        os.addPropertyChangeListener((PropertyChangeListener)this);
        this.bundle = NbBundle.getBundle((Class)(class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor == null ? (class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.FixExecutor")) : class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor));
        CoreDebugger new_cored = (CoreDebugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        if (new_cored != cored) {
            if (tabBug) {
                System.out.println("@@@@@@@ new_cored != cored");
            }
            new_cored.addPropertyChangeListener((PropertyChangeListener)listener);
            cored = new_cored;
        } else if (tabBug) {
            System.out.println("@@@@@@@ new_cored == cored");
        }
        this.addDebuggerListener(this);
        CoreDebugger d = (CoreDebugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        d.addDebuggerListener((DebuggerListener)this);
        DebuggerWindow dbw = DebuggerWindowPerformer.getDebuggerWindow();
        TopComponent tc = dbw.getComponent((GUIManager.View)DebuggerModule.VARIABLES_VIEW);
        this.lv_listener = new LocalViewChangeListener();
        if (tc != null) {
            tc.addPropertyChangeListener((PropertyChangeListener)this.lv_listener);
        }
        this.serialNumber = nextSerialNumber++;
        BreakpointsRootNode.setBreakpointsComparator((Comparator)new BreakpointComparator());
    }

    public Session getCurrentSession() {
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        if (d instanceof EnterpriseDebugger) {
            return ((EnterpriseDebugger)d).getCurrentSession();
        }
        return null;
    }

    public void makeWindowVisible(DebuggerWindow w) {
        GUIManager.View[] view = w.getViews();
    }

    private void pushViewButton_UglyHack(GUIManager.View view) {
        DebuggerWindow dbw = DebuggerWindowPerformer.getDebuggerWindow();
        if (dbw.isVisible(view)) {
            return;
        }
        String viewDesc = view.getDisplayName();
        int k = dbw.getComponentCount();
        Component c = null;
        for (int i = 0; i < k; ++i) {
            c = dbw.getComponent(i);
            if (!(c instanceof ToolbarView)) continue;
            ToolbarView tbv = (ToolbarView)c;
            int k2 = tbv.getComponentCount();
            for (int j = 0; j < k2; ++j) {
                c = tbv.getComponent(j);
                if (!(c instanceof JToolBar)) continue;
                JToolBar toolbar = (JToolBar)c;
                int n = toolbar.getComponentCount();
                for (int l = 0; l < n; ++l) {
                    ToolbarToggleButton tb;
                    c = toolbar.getComponentAtIndex(l);
                    if (!(c instanceof ToolbarToggleButton) || (tb = (ToolbarToggleButton)c).getToolTipText() == null || !tb.getToolTipText().equals(viewDesc)) continue;
                    tb.doClick();
                    return;
                }
            }
        }
    }

    public void close() {
        Hyperlink.removeEventListener((HyperlinkEventListener)this.editorListener);
    }

    private DbxDebuggerInfo convertToDbxDebuggerInfo(DebuggerInfo info) {
        DbxDebuggerInfo dinfo = null;
        if (info instanceof DbxDebuggerInfo) {
            dinfo = (DbxDebuggerInfo)info;
        } else {
            String className = info.getClassName();
            String executable = null;
            DataObject dao = null;
            FileObject fo = Repository.getDefault().findResource(className + ".class");
            if (fo == null) {
                fo = Repository.getDefault().findResource(className);
            }
            if (fo != null) {
                executable = CppUtils.getPath((FileObject)fo);
                try {
                    dao = DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException e) {}
            } else {
                executable = className.endsWith(".class") ? className : className + ".class";
            }
            int startupBehavior = 0;
            dinfo = new DbxDebuggerInfo(startupBehavior, dao, executable, -1L, null, className, info.getArguments(), null, null, null, null, className);
        }
        return dinfo;
    }

    public void startDebugger(DebuggerInfo info) throws DebuggerException {
        super.startDebugger(info);
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"debuggerstartup");
        }
        DebuggingOption.open();
        this.currentPCMarker = new DebuggerAnnotation.CurrentPC();
        this.visitMarker = new DebuggerAnnotation.CallSite();
        this.updatePopup(DbxDebugger.getText("StartingDbg"), DbxDebugger.getText("StartingDbx"), 10);
        this.setState(2);
        this.setLastAction(6);
        this.continueStartup(this.convertToDbxDebuggerInfo(info));
    }

    public void continueStartup(DbxDebuggerInfo info) throws DebuggerException {
        String exename = info.getExecutable();
        long pid = info.getPid();
        String corefile = info.getCorefile();
        String[] arguments = info.getArguments();
        DbxDebugProgram program = new DbxDebugProgram(exename, null);
        RunConfig newConfig = info.getConfig();
        if (newConfig == null) {
            newConfig = RunConfig.findConfig(program);
        }
        if (newConfig == null) {
            String dirname;
            newConfig = RunConfig.createConfig(program.getExecutableName(), info.getDataObject(), program);
            if (arguments != null) {
                newConfig.setArgsOnly(arguments);
            }
            if (exename != null && !exename.equals("-") && !exename.startsWith("jar:") && (dirname = IpeUtils.getDirName(exename)) != null) {
                newConfig.setRunDir(dirname);
            }
        } else if (arguments != null) {
            newConfig.setArgsOnly(arguments);
        }
        this.setConfig(newConfig);
        if (pid != -1L) {
            this.currentSession.setPid(pid);
        }
        if (corefile != null) {
            this.currentSession.setCorefile(corefile);
        }
        this.startDbx(this.currentSession, 0, null, info);
    }

    public static void runNotifier() {
        if (listenerThread != null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                boolean done = false;
                while (!done && !Thread.interrupted()) {
                    notifier.loop();
                    if (notifier.fell_out()) {
                        ErrorManager.getDefault().log("DbxDebugger.run(): unexpected fallout");
                        continue;
                    }
                    ErrorManager.getDefault().log("DbxDebugger.run(): no more events from notifier");
                    break;
                }
                listenerThread = null;
            }
        };
        listenerThread = new Thread(r, "GlueListener");
        listenerThread.setDaemon(true);
        listenerThread.start();
    }

    public static Notifier getNotifier() {
        if (notifier == null) {
            notifier = new NotifierSwing();
        }
        return notifier;
    }

    public Dbx startDbx(DbxDebugSession session, int dbxArgc, String[] dbxArgv, DbxDebuggerInfo info) {
        int flags = 0;
        String args = this.getConfig().getUnparsedArgs();
        if (args == null) {
            args = "";
        }
        if (info.getDataObject() != null && !(info.getDataObject() instanceof CoreElfObject)) {
            LoadPicklist.getInstance().addElement((PicklistElement)new LoadExecutablePicklistElement(info.getExecutable(), args, this.getConfig().getRunDir()));
            LoadPicklist.getInstance().savePicklist();
        }
        if (this.msgio) {
            flags += 16;
        }
        Dbx dbx = new Dbx(DbxDebugger.getNotifier(), ++flags, this, session);
        session.setEngine(dbx);
        if (info != null) {
            dbx.setStartupBehavior(info.getStartupBehavior());
            if (info.isCaptured()) {
                dbx.setCaptureState(1);
            }
            dbx.setCaptureInfo(info.getCaptureInfo());
        } else {
            dbx.setStartupBehavior(2);
        }
        UnixPty dbxPty = new UnixPty();
        try {
            dbxPty.setup();
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, DbxDebugger.getText("DbxPtyFail"));
            ErrorManager.getDefault().notify((Throwable)e);
            dbxPty = null;
        }
        UnixTerm dbxTerm = new UnixTerm(dbxPty);
        this.setupTerm((Term)dbxTerm);
        UnixPty pioPty = new UnixPty();
        pioPty.setPacketMode(true);
        try {
            pioPty.setup();
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, DbxDebugger.getText("PioPtyFail"));
            ErrorManager.getDefault().notify((Throwable)e);
            pioPty = null;
        }
        UnixTerm pioTerm = new UnixTerm(pioPty);
        this.setupTerm((Term)pioTerm);
        OutputStream pin = pioPty.getOutputStream();
        InputStream pout = pioPty.getInputStream();
        pioTerm.connect(pin, pout, null);
        if (!dbx.start(dbxTerm, dbxPty, pioTerm, pioPty, dbxArgc, dbxArgv)) {
            try {
                super.finishDebugger();
            }
            catch (DebuggerException e) {
                // empty catch block
            }
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"debuggerstartup");
            }
            this.cancelPopup();
            return null;
        }
        return dbx;
    }

    public void finishStartDebugger(Dbx dbx) {
        this.updatePopup(null, DbxDebugger.getText("CreatingWin"), 70);
        this.createOutputTabs(dbx);
        this.ignoreUpdates(true);
        try {
            this.setState(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ignoreUpdates(false);
        this.setCurrentEngine(dbx);
        this.bindThreadGroup();
    }

    public void openOutputTab(UnixTabTerm tab) {
        if (this.done_createOutputTabs) {
            UnixTabTerm local_tab;
            if (tab instanceof ProgramIOWindow) {
                UnixTabTerm local_tab2 = (UnixTabTerm)debuggerToPIOTab.get(currentDebugger);
                if (local_tab2 == tab) {
                    local_tab2.setTabVisible(true);
                }
            } else if (tab instanceof DbxWindow) {
                UnixTabTerm local_tab3 = (UnixTabTerm)debuggerToDbxTab.get(currentDebugger);
                if (local_tab3 == tab) {
                    local_tab3.setTabVisible(true);
                }
            } else if (tab instanceof AccessWindow) {
                UnixTabTerm local_tab4 = (UnixTabTerm)debuggerToAccessTab.get(currentDebugger);
                if (local_tab4 == tab) {
                    local_tab4.setTabVisible(true);
                }
            } else if (tab instanceof MemuseWindow && (local_tab = (UnixTabTerm)debuggerToMemUseTab.get(currentDebugger)) == tab) {
                local_tab.setTabVisible(true);
            }
        }
    }

    private void NEW_createOutputTabs(Dbx dbx) {
        if (tabBug) {
            System.out.println("DbxDebugger.createOutputTabs()");
        }
        this.editorListener = new EditorLinkListener();
        Hyperlink.addEventListener((HyperlinkEventListener)this.editorListener);
        DbxWindow con_tab = new DbxWindow(dbx);
        debuggerToDbxTab.put(this, con_tab);
        con_tab.setTabVisible(true);
        ProgramIOWindow pio_tab = new ProgramIOWindow(dbx);
        debuggerToPIOTab.put(this, pio_tab);
        pio_tab.setTabVisible(true);
        AccessWindow access_tab = new AccessWindow(dbx);
        debuggerToAccessTab.put(this, access_tab);
        access_tab.setTabVisible(true);
        dbx.addAccessListener(access_tab);
        MemuseWindow memuse_tab = new MemuseWindow(dbx);
        debuggerToMemUseTab.put(this, memuse_tab);
        memuse_tab.setTabVisible(true);
        dbx.addMemuseListener(memuse_tab);
        con_tab.requestVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOutputTabs(Dbx dbx) {
        Object object = tabMutex;
        synchronized (object) {
            this.NEW_createOutputTabs(dbx);
            this.done_createOutputTabs = true;
        }
    }

    private void addKey(HashSet ksset, int key) {
        ksset.add(KeyStroke.getKeyStroke(key, 0));
        ksset.add(KeyStroke.getKeyStroke(key, 1));
        ksset.add(KeyStroke.getKeyStroke(key, 2));
        ksset.add(KeyStroke.getKeyStroke(key, 3));
        ksset.add(KeyStroke.getKeyStroke(key, 8));
        ksset.add(KeyStroke.getKeyStroke(key, 9));
        ksset.add(KeyStroke.getKeyStroke(key, 10));
        ksset.add(KeyStroke.getKeyStroke(key, 11));
        ksset.add(KeyStroke.getKeyStroke(key, 1));
        ksset.add(KeyStroke.getKeyStroke(key, 2));
    }

    public void setupTerm(Term t) {
        this.setupTerm(t, false);
    }

    public void setupTerm(Term t, boolean rdonly) {
        t.setHorizontallyScrollable(false);
        t.setRowsColumns(7, 80);
        t.setEmulation("dtterm");
        t.setClickToType(false);
        HashSet ksset = t.getKeyStrokeSet();
        this.addKey(ksset, 112);
        this.addKey(ksset, 113);
        this.addKey(ksset, 114);
        this.addKey(ksset, 115);
        this.addKey(ksset, 116);
        this.addKey(ksset, 117);
        this.addKey(ksset, 118);
        this.addKey(ksset, 119);
        this.addKey(ksset, 120);
        this.addKey(ksset, 121);
        this.addKey(ksset, 122);
        this.addKey(ksset, 123);
        if (rdonly) {
            ksset = DbxDebugger.getKeyStrokeSet();
            t.setKeyStrokeSet(ksset);
        }
        this.applyTermSettings(t, null);
    }

    private static void updateKeyStrokeSet() {
        keyStrokeSet.clear();
        keyStrokeSet.addAll(Arrays.asList(((Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = DbxDebugger.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap)).getBoundKeyStrokes()));
        for (int ks = 65; ks <= 90; ++ks) {
            keyStrokeSet.add(KeyStroke.getKeyStroke(ks, 8));
        }
        KeyStroke ks1 = KeyStroke.getKeyStroke(new Character('\u0014'), 3);
        KeyStroke ks2 = KeyStroke.getKeyStroke(new Character('\u0014'), 2);
        keyStrokeSet.add(ks1);
        keyStrokeSet.add(ks2);
    }

    private static HashSet getKeyStrokeSet() {
        if (keyStrokeSet != null) {
            return keyStrokeSet;
        }
        keyStrokeSet = new HashSet();
        Keymap map = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = DbxDebugger.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        if (map instanceof Observable) {
            Observable o = (Observable)((Object)map);
            o.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    DbxDebugger.updateKeyStrokeSet();
                }
            });
        }
        DbxDebugger.updateKeyStrokeSet();
        return keyStrokeSet;
    }

    public void applyTermSettings(Term t, OutputSettings os) {
        Font font;
        if (t == null) {
            return;
        }
        if (os == null) {
            os = (OutputSettings)OutputSettings.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = DbxDebugger.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
        }
        if ((font = t.getFont()) == null || !font.isPlain() || font.getSize() != os.getFontSize()) {
            Font nf = new Font("monospaced", 0, os.getFontSize());
            t.setFont(nf);
        }
        t.setForeground(os.getBaseForeground());
        t.setBackground(os.getBaseBackground());
        t.setActiveColor(os.getJumpCursorBackground());
        t.setHistorySize(os.getHistorySize());
        t.setTabSize(os.getTabSize());
    }

    public void absorbBreakpointsIntoConfig() {
        this.ignoreUpdates(true);
        try {
            Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            Breakpoint[] b = d.getBreakpoints();
            int k = b.length;
            for (int i = 0; i < k; ++i) {
                if (!(b[i] instanceof CoreBreakpoint)) continue;
                CoreBreakpoint.Event be = ((CoreBreakpoint)b[i]).getEvent();
                if (be instanceof IpeBreakpointEvent) {
                    IpeBreakpointEvent ev = (IpeBreakpointEvent)((CoreBreakpoint)b[i]).getEvent();
                    ev.set(this.getEngine());
                    b[i].remove();
                    continue;
                }
                if (!(be instanceof LineBreakpointEvent)) continue;
                LineBreakpointDelegator lb = this.createBreakpointProxy(b[i], (LineBreakpointEvent)be);
                lb.set();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ignoreUpdates(false);
    }

    public boolean createHandler(IpeBreakpointEvent event, int routingToken) {
        if (this.engine != null) {
            this.engine.createHandler(event, routingToken);
            return true;
        }
        return false;
    }

    public void removeBreakpoint(int hid) {
        if (this.engine != null) {
            this.engine.deleteHandler(hid);
        }
    }

    public String getCurrentFunction() {
        if (this.engine != null) {
            return this.engine.getCurrentFunction();
        }
        return null;
    }

    public String getCurrentClass() {
        if (this.engine != null) {
            return this.engine.getCurrentClass();
        }
        return null;
    }

    public void sessionExited(DbxDebugSession session) {
        EnterpriseDebugger e = (EnterpriseDebugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        Session s = e.findSession((AbstractDebugger)this);
        if (s != null) {
            if (this.quitInitiatedFrom == 0) {
                this.quitInitiatedFrom = 2;
            }
            s.finish();
        }
    }

    public void finishDebugger() throws DebuggerException {
        boolean cleanup = false;
        boolean tellDbx = false;
        if (this.quitInitiatedFrom == 0) {
            if (tabBug) {
                System.out.println("DbxDebugger.finishDebugger() UNKNOWN");
            }
            this.quitInitiatedFrom = 1;
            cleanup = true;
            tellDbx = true;
        } else if (this.quitInitiatedFrom == 1) {
            if (tabBug) {
                System.out.println("DbxDebugger.finishDebugger() GUI");
            }
            cleanup = false;
            tellDbx = false;
        } else if (this.quitInitiatedFrom == 2) {
            if (tabBug) {
                System.out.println("DbxDebugger.finishDebugger() DBX");
            }
            cleanup = true;
            tellDbx = false;
        }
        Dbx oldEngine = this.engine;
        if (cleanup) {
            DebuggingOption.save();
            RunConfig config = this.getConfig();
            if (config != null) {
                config.save();
            }
            this.enableCollA.setEnabled(false);
            this.disableCollA.setEnabled(false);
            this.deregisterBreakpoints();
            this.wipeoutWatch();
            this.done_createOutputTabs = false;
            this.close();
            if (tabBug) {
                System.out.println("DbxDebugger.finishDebugger(): setting gone");
            }
            this.gone = true;
            this.ignoreUpdates(true);
            try {
                if (tabBug) {
                    System.out.println("DbxDebugger.finishDebugger() -> super");
                    CoreDebugger newCoreDebugger = Register.getCoreDebugger();
                    if (cored != newCoreDebugger) {
                        System.out.println("##### cored changed in finishDebugger");
                    } else {
                        System.out.println("##### cored is fine in finishDebugger");
                    }
                }
                super.finishDebugger();
            }
            catch (Exception x) {
                // empty catch block
            }
            this.ignoreUpdates(false);
            this.updateState(null);
            this.setCurrentEngine(null);
        }
        if (tellDbx && oldEngine != null) {
            oldEngine.quit();
        }
    }

    public static void start() {
        int count = Integer.parseInt(System.getProperty("spro.debugger.count"));
        String[] argv = null;
        for (int i = 0; i < count; ++i) {
            File file;
            int idx;
            String type = System.getProperty("spro.debugger.session" + i + ".type");
            String line = System.getProperty("spro.debugger.session" + i + ".line");
            String program = null;
            long pid = -1L;
            String core = null;
            switch (type.charAt(0)) {
                case 'E': {
                    String[] tmp = Utilities.parseParameters((String)line);
                    program = tmp[0];
                    argv = new String[tmp.length - 1];
                    System.arraycopy(tmp, 1, argv, 0, tmp.length - 1);
                    break;
                }
                case 'C': {
                    idx = line.indexOf(58);
                    if (idx >= 0) {
                        program = line.substring(idx + 1);
                        core = line.substring(0, idx);
                    } else {
                        core = line;
                    }
                    argv = new String[]{core};
                    break;
                }
                case 'A': {
                    idx = line.indexOf(58);
                    if (idx >= 0) {
                        program = line.substring(idx + 1);
                        line = line.substring(0, idx);
                    }
                    try {
                        pid = Long.parseLong(line);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    argv = new String[]{line};
                    break;
                }
                case 'D': {
                    program = line;
                    argv = new String[]{program};
                    String extra = System.getProperty("spro.debugger.session" + i + ".extra");
                    if (extra == null || extra.length() <= 0) break;
                    File file2 = new File(extra);
                    if (file2.exists()) {
                        core = extra;
                        break;
                    }
                    try {
                        pid = Long.parseLong(extra);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            String processName = program == null || program.length() == 0 ? (program = "-") : ((idx = program.lastIndexOf(File.separatorChar)) >= 0 ? program.substring(idx + 1) : program);
            if (program.charAt(0) != '/' && (file = new File(program)).exists()) {
                program = file.getAbsolutePath();
            }
            if (i != 0 && System.getProperty("spro.debugger.multisession") == null) continue;
            DbxDebuggerInfo info = new DbxDebuggerInfo(0, null, program, pid, core, null, argv, null, null, null, null, processName);
            DebuggerModule.changeWorkspace();
            Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? DbxDebugger.class$("org.openide.debugger.Debugger") : class$org$openide$debugger$Debugger);
            try {
                d.startDebugger((DebuggerInfo)info);
                continue;
            }
            catch (DebuggerException e) {
                // empty catch block
            }
        }
    }

    public void traceInto() throws DebuggerException {
        this.setLastAction(3);
        StatusDisplayer.getDefault().setStatusText(this.getString("CTL_Debugger_running"));
        if (this.engine != null) {
            this.engine.stepInto();
        }
    }

    public void traceOver() throws DebuggerException {
        this.setLastAction(2);
        StatusDisplayer.getDefault().setStatusText(this.getString("CTL_Debugger_running"));
        if (this.engine != null) {
            this.engine.stepOver();
        }
    }

    public void go() throws DebuggerException {
        this.setLastAction(5);
        StatusDisplayer.getDefault().setStatusText(this.getString("CTL_Debugger_running"));
        if (this.engine != null) {
            this.engine.go();
        }
    }

    public void pause() {
        if (this.engine != null) {
            this.engine.interrupt();
        }
    }

    public void runToCursor(Line l) {
        if (l == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.setLastAction(10);
        StatusDisplayer.getDefault().setStatusText(this.getString("CTL_Debugger_running"));
        if (this.engine != null) {
            DataObject dao = l.getDataObject();
            FileObject fo = dao.getPrimaryFile();
            String filename = CppUtils.getPath((FileObject)fo);
            int number = l.getLineNumber() + 1;
            this.engine.goTo(filename, number);
        }
    }

    public void stepOut() throws DebuggerException {
        this.setLastAction(4);
        StatusDisplayer.getDefault().setStatusText(this.getString("CTL_Debugger_running"));
        if (this.engine != null) {
            this.engine.stepOut();
        }
    }

    public void stepTo() {
        this.setLastAction(3);
        StatusDisplayer.getDefault().setStatusText(this.getString("CTL_Debugger_running"));
        if (this.engine != null) {
            this.engine.stepTo();
        }
    }

    public Watch createWatch() {
        return null;
    }

    public Watch createWatch(String expr, boolean hidden) {
        DebuggerSupport mux = (DebuggerSupport)cored;
        Watch[] w = mux.getWatches();
        for (int i = w.length - 1; i >= 0; --i) {
            AbstractWatch ww = (AbstractWatch)w[i];
            if (!ww.getVariableName().equals(expr)) continue;
            mux.removeWatch(ww);
            break;
        }
        if (!hidden && this.engine != null) {
            this.engine.addWatch(expr, RoutingToken.TREETABLE);
        }
        return null;
    }

    public Watch[] getWatches() {
        return null;
    }

    public void removeAllWatches() {
    }

    public CoreBreakpoint.Action[] getBreakpointActions() {
        return breakpointActions;
    }

    public CoreBreakpoint.Event[] getBreakpointEvents() {
        return breakpointEvents;
    }

    public String getClasspath() {
        return "";
    }

    public JComponent getConnectPanel() {
        return null;
    }

    public int getFreeMemory() throws DebuggerException {
        return 0;
    }

    public boolean supportsExpressions() {
        return true;
    }

    public void setState(int newState) {
        if (tabBug) {
            System.out.println("DbxDebugger.setState()");
        }
        if (newState == 4) {
            this.updateActionButtons = false;
        } else if (newState == 3) {
            this.updateActionButtons = true;
        }
        if (tabBug) {
            System.out.println("DbxDebugger.setState() calling super.setState()");
        }
        super.setState(newState);
        DbxStepIntoAction.getInstance().checkEnabled();
        DbxRunToCursorAction.getInstance().checkEnabled();
    }

    public static void printDebuggerState(int state) {
        System.out.print("Debugger State (" + state + ") is now: ");
        switch (state) {
            case 3: {
                System.out.println("DEBUGGER_RUNNING");
                break;
            }
            case 4: {
                System.out.println("DEBUGGER_STOPPED");
                break;
            }
            case 1: {
                System.out.println("DEBUGGER_NOT_RUNNING");
                break;
            }
            case 2: {
                System.out.println("DEBUGGER_STARTING");
            }
        }
    }

    public static Line getLine(String fileName, int lineNumber) {
        FileObject fo = IpeUtils.findFileObject(fileName, true);
        if (fo == null) {
            ErrorManager.getDefault().log("FileObject for " + fileName + " not found.");
            return null;
        }
        DataObject mdo = null;
        try {
            mdo = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().log("No data object could be found for file object " + fo);
            return null;
        }
        try {
            return IpeUtils.lineNumberToLine(mdo, lineNumber);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    public void showLine(Line l) {
        DbxDebugger.showInEditor(l);
    }

    public void makeCurrent(String fileName, int lineNumber, String methodName, boolean hasSource, boolean setcurrent, boolean warnAboutNoSource, boolean visited) {
        if (this.getState() != 4) {
            this.setState(4);
        }
        if (warnAboutNoSource && DebuggingOption.MAIN_FUNC_WARNING.isEnabled()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("MSG_NoSource")));
        } else if (hasSource && fileName != null) {
            Line l = DbxDebugger.getLine(fileName, lineNumber);
            if (l != null) {
                if (setcurrent) {
                    this.setCurrentLine(l, visited);
                } else {
                    this.showLine(l);
                }
            }
        } else if (hasSource && fileName == null) {
            this.setCurrentLine(null);
        }
        DbxDebugger debugger = this;
        String line = Integer.toString(lineNumber);
    }

    public void processRunning() {
        this.setCurrentLine(null);
        this.setCurrentLine(null, true);
    }

    public void processTerminated(String reason, int exitCode) {
        this.setState(4);
        this.setCurrentLine(null);
        this.setCurrentLine(null, true);
        if (reason != null) {
            String msg = "";
            msg = reason.equals("kill") ? DbxDebugger.getText("ProgTerminated") : (reason.equals("detach") ? DbxDebugger.getText("ProgDetached") : (reason.equals("signal") ? MessageFormat.format(DbxDebugger.getText("ProgAborted"), Integer.toString(exitCode)) : (reason.equals("exit") ? MessageFormat.format(DbxDebugger.getText("ProgCompletedExit"), Integer.toString(exitCode)) : MessageFormat.format(DbxDebugger.getText("ProgCompleted"), reason, Integer.toString(exitCode)))));
            StatusDisplayer.getDefault().setStatusText(msg);
        }
    }

    public void error(String error) {
        this.setState(4);
        StatusDisplayer.getDefault().setStatusText(error);
    }

    public static String getText(String key) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger == null ? (class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.DbxDebugger")) : class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger), (String)key);
    }

    public void OLD_switchTo(DbxDebugSession s) {
        RunConfig OLD_currentConfig = null;
        if (OLD_currentConfig != null) {
            OLD_currentConfig.save();
        }
        if (this.engine != null) {
            this.cancelPopup();
        }
        if (this.runTimer != null) {
            this.runTimer.stop();
            this.updateActionButtons = false;
            this.delayedEngine = null;
        }
        DbxDebugSession old = s;
        this.currentSession = s;
        if (this.currentSession != null) {
            this.setCurrentEngine((Dbx)this.currentSession.getEngine());
            OLD_currentConfig = this.currentSession.getConfig();
        } else {
            this.setCurrentEngine(null);
            OLD_currentConfig = null;
        }
        this.setDebuggerState(this.debuggerState);
        this.updateState(this.engine);
        this.updateActionStates();
    }

    public void enableStoppedActions(DbxDebuggerEngine actor) {
        if (this.runTimer != null) {
            this.runTimer.stop();
        }
        if (this.updateActionButtons && this.delayedEngine != null) {
            this.updateState(this.delayedEngine);
            this.delayedEngine = null;
        }
        this.updateActionButtons = false;
    }

    private int getRunDelay() {
        if (this.runDelay == -1) {
            this.runDelay = 250;
            String delay = System.getProperty("spro.rundelay");
            if (delay != null) {
                try {
                    this.runDelay = Integer.parseInt(delay);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.runDelay;
    }

    public void disableStoppedActions(DbxDebuggerEngine actor) {
        if (!this.updateActionButtons) {
            this.delayedEngine = actor;
            if (this.runTimer == null) {
                this.runTimer = new Timer(this.getRunDelay(), new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        DbxDebugger.this.stoppedActionExpired();
                    }
                });
                this.runTimer.setRepeats(false);
                this.runTimer.setCoalesce(true);
                this.runTimer.start();
            } else {
                this.runTimer.restart();
            }
            this.updateActionButtons = true;
        }
    }

    private void stoppedActionExpired() {
        if (this.updateActionButtons) {
            this.setState(3);
            if (this.delayedEngine != null) {
                this.updateState(this.delayedEngine);
                this.delayedEngine = null;
            }
        }
    }

    public void updatePopup(final String message, final String note, final int progress) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updatePopupSameThread(message, note, progress);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DbxDebugger.this.updatePopupSameThread(message, note, progress);
                }
            });
        }
    }

    private void updatePopupSameThread(String message, String note, int progress) {
        StatusDisplayer.getDefault().setStatusText(message != null ? message : note);
        if (this.popup == null) {
            this.popup = new ProgressMonitor(null, message != null ? message : note, note != null ? note : "", 0, 100);
            this.popup.setMillisToPopup(0);
            this.popup.setMillisToDecideToPopup(0);
            if (progress != -1) {
                this.popup.setProgress(progress);
            } else {
                this.popup.setProgress(0);
            }
        } else {
            if (progress != -1) {
                this.popup.setProgress(progress);
            }
            if (note != null) {
                this.popup.setNote(note);
            }
        }
    }

    public void cancelPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cancelPopupSameThread();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DbxDebugger.this.cancelPopupSameThread();
                }
            });
        }
    }

    public void cancelPopupSameThread() {
        StatusDisplayer.getDefault().setStatusText("");
        if (this.popup != null) {
            this.popup.close();
            this.popup = null;
        }
    }

    public void setOption(String name, String value) {
        if (this.engine != null) {
            this.engine.setOption(name, value);
        }
    }

    public void OLD_setOption(DbxDebugSession session, String name, String value) {
        if (this.engine != null) {
            this.engine.setOption(name, value);
        }
    }

    public Dbx getEngine() {
        return this.engine;
    }

    public void balloonEvaluate(int pos, String expr, Object result) {
        if (this.engine != null) {
            this.engine.balloonEvaluate(pos, expr, result);
        }
    }

    public DbxDebugSession getSession() {
        return this.currentSession;
    }

    public RunConfig getConfig() {
        if (this.currentSession == null) {
            return null;
        }
        return this.currentSession.getConfig();
    }

    public void setConfig(RunConfig newConfig) {
        if (this.getConfig() == newConfig) {
            return;
        }
        if (this.getConfig() != null) {
            this.getConfig().removePropertyChangeListener(this);
        }
        this.currentSession.setConfig(newConfig);
        if (this.getConfig() != null) {
            this.getConfig().addPropertyChangeListener(this);
        }
        this.invalidateSessionData();
    }

    private void setCurrentEngine(Dbx newEngine) {
        if (this.engine == newEngine) {
            return;
        }
        if (this.engine != null) {
            this.engine.removeAccessListener(this);
        }
        this.engine = newEngine;
        if (this.engine != null) {
            this.engine.addAccessListener(this);
        }
        this.invalidateSessionData();
    }

    private void bindThreadGroup() {
        this.engine.addThreadsListener(this.threadGroup);
        this.engine.addStackListener(this.threadGroup);
        this.engine.addLocalVarListener(this.threadGroup);
    }

    public void updateLocalViewState() {
        int i;
        GUIManager.View[] vs = GUIManager.getDefault().getViews();
        int k = vs.length;
        for (i = 0; i < k && vs[i] != DebuggerModule.VARIABLES_VIEW; ++i) {
        }
        this.lv_listener = new LocalViewChangeListener();
        TopComponent tc = DebuggerModule.VARIABLES_VIEW.getComponent();
        if (tc != null) {
            tc.addPropertyChangeListener((PropertyChangeListener)this.lv_listener);
        }
        if (((View2)vs[i]).isVisible()) {
            this.engine.sendLocalVarUpdates(true);
        } else {
            this.engine.sendLocalVarUpdates(false);
        }
    }

    DbxThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public AbstractThread getThreadGroupRoot() {
        return this.getThreadGroup();
    }

    public void setCurrentThread(AbstractThread thread) {
        Log.prf(1, "-----------------");
        if (this.currentThread == thread) {
            return;
        }
        IpeThread old = this.currentThread;
        this.currentThread = (IpeThread)thread;
        this.firePropertyChange("currentThread", (Object)old, thread);
    }

    public void refreshThread(AbstractThread thread) {
        this.firePropertyChange("currentThread", null, thread);
    }

    public AbstractThread getCurrentThread() {
        return this.currentThread;
    }

    public ThreadsProducer getThreadsRoot() {
        return this.getThreadGroup();
    }

    public static Line showInEditor(Line line) {
        if (line == null) {
            return null;
        }
        try {
            line.show(1);
        }
        catch (Throwable e) {
            ErrorManager.getDefault().notify(65536, e);
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(e, (Object)DbxDebugger.getText("EXC_Editor")));
        }
        return line;
    }

    public void setCurrentLine(Line l) {
        this.setCurrentLine(l, false);
    }

    public void setCurrentLine(Line l, boolean visited) {
        if (l != null) {
            DbxDebugger.showInEditor(l);
            if (visited) {
                this.visitMarker.detachLine();
                this.visitMarker.attachLine(l);
            } else {
                this.visitMarker.detachLine();
                this.currentPCMarker.detachLine();
                this.currentPCMarker.attachLine(l);
            }
        } else if (visited) {
            this.visitMarker.detachLine();
        } else {
            this.currentPCMarker.detachLine();
        }
    }

    public boolean canBeCurrent(Line l, boolean onBreakpoint) {
        return l.canBeMarkedCurrent(onBreakpoint ? 1 : this.getLastAction(), this.getCurrentLine());
    }

    public static void executeCommand(String cmd) {
        DbxDebugger debugger = DbxDebuggerImpl.getCurrentDebugger();
        if (debugger == null) {
            return;
        }
        if (debugger.engine != null) {
            debugger.engine.execute(cmd);
        }
    }

    public void updateState(DbxDebuggerEngine statefulEngine) {
        boolean down;
        boolean up;
        if (statefulEngine != this.engine) {
            this.pauseA.setEnabled(false);
            this.stepIntoA.setEnabled(true);
            this.stepOverA.setEnabled(false);
            this.stepOutA.setEnabled(false);
            this.runToCursorA.setEnabled(true);
            this.runIntoLastFunctionCallA.setEnabled(true);
            this.continueA.setEnabled(false);
            this.addWatchA.setEnabled(false);
            this.detachA.setEnabled(false);
            this.terminateA.setEnabled(false);
            this.fixA.setEnabled(false);
            this.rerunA.setEnabled(false);
            this.enableCollA.setEnabled(false);
            return;
        }
        DbxDebuggerState state = DbxDebuggerState.EMPTY;
        if (statefulEngine != null) {
            state = statefulEngine.getState();
        }
        DbxDebuggerState changed = new DbxDebuggerState(this.lastState);
        changed.xor(state);
        changed.union(this.debugStateDirty);
        this.debugStateDirty.clear();
        this.lastState = new DbxDebuggerState(state);
        if (!changed.isEmpty()) {
            this.invalidateSessionData();
        }
        if (changed.isCore()) {
            if (state.isCore()) {
                up = state.isUpAllowed();
                down = state.isDownAllowed();
                this.goToCallingMethodA.setEnabled(up);
                this.goToCalledMethodA.setEnabled(down);
                this.addWatchA.setEnabled(true);
                this.pauseA.setEnabled(false);
                this.stepIntoA.setEnabled(false);
                this.stepOverA.setEnabled(false);
                this.stepOutA.setEnabled(false);
                this.runToCursorA.setEnabled(false);
                this.runIntoLastFunctionCallA.setEnabled(false);
                this.continueA.setEnabled(false);
                this.rerunA.setEnabled(true);
                this.terminateA.setEnabled(true);
                this.detachA.setEnabled(false);
                this.fixA.setEnabled(false);
                this.popTopmostA.setEnabled(false);
                this.popToCurrentFrameA.setEnabled(false);
            } else {
                changed.setLoaded(true);
                changed.setProcess(true);
                changed.setTerminated(true);
            }
        }
        if (state.isCore()) {
            return;
        }
        if (changed.isRunning()) {
            if (state.isRunning()) {
                this.pauseA.setEnabled(true);
                this.stepIntoA.setEnabled(false);
                this.stepOverA.setEnabled(false);
                this.stepOutA.setEnabled(false);
                this.runToCursorA.setEnabled(false);
                this.runIntoLastFunctionCallA.setEnabled(false);
                this.continueA.setEnabled(false);
                this.addWatchA.setEnabled(false);
                this.detachA.setEnabled(true);
                this.terminateA.setEnabled(true);
                this.fixA.setEnabled(false);
                this.rerunA.setEnabled(false);
                this.enableCollA.setEnabled(statefulEngine.isCollAvailable());
                this.toggleAccessChecksA.setEnabled(statefulEngine.isRtcAvailable());
                this.toggleMemuseChecksA.setEnabled(statefulEngine.isRtcAvailable());
                this.setStackState(null);
            } else {
                changed.setLoaded(true);
                changed.setProcess(true);
                changed.setTerminated(true);
            }
        }
        if (state.isRunning()) {
            return;
        }
        if (changed.isLoaded()) {
            if (state.isLoaded()) {
                this.stepIntoA.setEnabled(true);
                this.stepOverA.setEnabled(true);
                this.runToCursorA.setEnabled(true);
                this.runIntoLastFunctionCallA.setEnabled(true);
                this.continueA.setEnabled(true);
                this.addWatchA.setEnabled(true);
                this.fixA.setEnabled(statefulEngine.isFixAvailable());
                this.rerunA.setEnabled(true);
                this.toggleAccessChecksA.setEnabled(statefulEngine.isRtcAvailable());
                this.toggleMemuseChecksA.setEnabled(statefulEngine.isRtcAvailable());
                this.enableCollA.setEnabled(statefulEngine.isCollAvailable());
            } else {
                this.stepIntoA.setEnabled(false);
                this.stepOverA.setEnabled(false);
                this.runToCursorA.setEnabled(false);
                this.runIntoLastFunctionCallA.setEnabled(false);
                this.continueA.setEnabled(false);
                this.addWatchA.setEnabled(false);
                this.fixA.setEnabled(false);
                this.rerunA.setEnabled(false);
                this.toggleMemuseChecksA.setEnabled(false);
                this.toggleAccessChecksA.setEnabled(false);
                this.enableCollA.setEnabled(false);
                this.disableCollA.setEnabled(false);
            }
        }
        if (changed.isProcess()) {
            if (state.isProcess()) {
                up = state.isUpAllowed();
                down = state.isDownAllowed();
                this.stepOutA.setEnabled(true);
                this.pauseA.setEnabled(false);
                this.detachA.setEnabled(true);
                this.terminateA.setEnabled(true);
                this.setStackState(statefulEngine);
            } else {
                this.stepOutA.setEnabled(false);
                this.pauseA.setEnabled(false);
                this.detachA.setEnabled(false);
                this.terminateA.setEnabled(false);
                this.setStackState(null);
            }
        }
    }

    public void updateActionStates() {
        DbxDebuggerState st;
        boolean running = false;
        if (this.engine != null && (st = this.engine.getState()) != null && st.isRunning()) {
            running = true;
        }
        if (running) {
            this.setState(3);
        } else {
            this.setState(4);
        }
    }

    public void setStackState(DbxDebuggerEngine statefulEngine) {
        boolean enable;
        DbxDebuggerState state = null;
        boolean bl = enable = statefulEngine != null && (state = statefulEngine.getState()) != null && !state.isRunning() && (state.isProcess() || state.isCore());
        if (enable) {
            boolean down = state.isDownAllowed();
            boolean up = state.isUpAllowed();
            this.goToCalledMethodA.setEnabled(down);
            this.goToCallingMethodA.setEnabled(up);
            this.popTopmostA.setEnabled(up);
            this.popLastCallA.setEnabled(state.isDbxCall());
            this.popToCurrentFrameA.setEnabled(down);
        } else {
            this.goToCallingMethodA.setEnabled(false);
            this.goToCalledMethodA.setEnabled(false);
            this.popTopmostA.setEnabled(false);
            this.popLastCallA.setEnabled(false);
            this.popToCurrentFrameA.setEnabled(false);
        }
    }

    public static boolean debugConfig(DataObject xmldao) {
        InstanceCookie ic = (InstanceCookie)xmldao.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DbxDebugger.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
        RunConfig config = null;
        if (ic == null) {
            return false;
        }
        try {
            config = (RunConfig)ic.instanceCreate();
        }
        catch (Exception e) {
            String emsg = NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger == null ? (class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger = DbxDebugger.class$("com.sun.tools.debugger.dbxgui.debugger.DbxDebugger")) : class$com$sun$tools$debugger$dbxgui$debugger$DbxDebugger), (String)"MSG_CREATE_CONFIG_ERROR", (Object)xmldao.getName());
            ErrorManager.getDefault().annotate((Throwable)e, emsg);
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return false;
        }
        DbxDebugProgram program = config.getProgram();
        if (program == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        String path = program.getExecutableName();
        if (path == null && (path = program.getCorefileName()) == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        FileObject fo = IpeUtils.findFileObject(path, true);
        if (fo == null) {
            return false;
        }
        DataObject mdo = null;
        try {
            mdo = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
        DbxDebuggerType idt = (DbxDebuggerType)DbxDebuggerType.getDefault();
        DbxDebuggerInfo info = idt.getDbxDebuggerInfo(mdo, 0);
        info.setConfig(config);
        if (info == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"loadprogram");
        }
        DebuggerModule.changeWorkspace();
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        try {
            d.startDebugger((DebuggerInfo)info);
        }
        catch (DebuggerException e) {
            // empty catch block
        }
        return true;
    }

    public void goToCallingMethod() {
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"upstackframe");
        }
        if (this.engine != null) {
            Dbx dbx = this.engine;
            dbx.upStack();
            if (UsageTracking.enabled) {
                UsageTracking.readTime((String)"upstackframe", (String)"Up Stack Frame", (boolean)true, null, (boolean)true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"upstackframe");
            }
        }
    }

    public void goToCalledMethod() {
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"downstackframe");
        }
        if (this.engine != null) {
            Dbx dbx = this.engine;
            dbx.downStack();
            if (UsageTracking.enabled) {
                UsageTracking.readTime((String)"downstackframe", (String)"Down Stack Frame", (boolean)true, null, (boolean)true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"downstackframe");
            }
        }
    }

    public void popTopmostFrame() {
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"popTopmostFrame");
        }
        if (this.engine != null) {
            Dbx dbx = this.engine;
            dbx.pop();
            if (UsageTracking.enabled) {
                UsageTracking.readTime((String)"popTopmostFrame", (String)"Pop Topmost Stack Frame", (boolean)true, null, (boolean)true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"popTopmostFrame");
            }
        }
    }

    public boolean isStepIntoEnabled() {
        return !this.lastState.isRunning() && !this.lastState.isCore() && this.lastState.isLoaded();
    }

    public boolean isStepOverEnabled() {
        return !this.lastState.isRunning() && !this.lastState.isCore() && this.lastState.isLoaded();
    }

    public boolean isStepOutEnabled() {
        return !this.lastState.isRunning() && !this.lastState.isCore() && this.lastState.isProcess();
    }

    public boolean isRunToCursorEnabled() {
        return !this.lastState.isRunning() && !this.lastState.isCore() && this.lastState.isLoaded();
    }

    public boolean isPauseEnabled() {
        return this.lastState.isRunning();
    }

    public boolean isContinueEnabled() {
        return !this.lastState.isRunning() && !this.lastState.isCore() && this.lastState.isLoaded();
    }

    public boolean isGoToCallingMethodEnabled() {
        return this.lastState.isUpAllowed();
    }

    public boolean isGoToCalledMethodEnabled() {
        return this.lastState.isDownAllowed();
    }

    public boolean isFixEnabled() {
        return false;
    }

    public boolean isPopTopmostFrameEnabled() {
        return false;
    }

    private void setTermSettings() {
        OutputSettings os = (OutputSettings)OutputSettings.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = DbxDebugger.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
        if (this.engine != null) {
            Dbx dbx = this.engine;
            Term t = dbx.getTerm();
            if (t != null) {
                this.applyTermSettings(t, os);
            }
            if ((t = dbx.getPioTerm()) != null) {
                this.applyTermSettings(t, os);
            }
            if ((t = dbx.getAccessTerm()) != null) {
                this.applyTermSettings(t, os);
            }
            if ((t = dbx.getLeaksTerm()) != null) {
                this.applyTermSettings(t, os);
            }
            if ((t = dbx.getBlocksTerm()) != null) {
                this.applyTermSettings(t, os);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("runargs-ch".equals(name)) {
            this.invalidateSessionData();
        } else if ("access-state".equals(name)) {
            this.invalidateSessionData();
        } else if ("memuse-state".equals(name)) {
            this.invalidateSessionData();
        } else if (!("views".equals(name) || "ancestor".equals(name) && !"activatedNodes".equals(name))) {
            this.setTermSettings();
        }
    }

    public void wipeoutWatch() {
        Dbx dbx = this.getEngine();
        HashMap watches = null;
        if (dbx != null && (watches = dbx.getwatches()) != null) {
            int size = watches.size();
            Collection c = watches.values();
            DebuggerSupport mux = (DebuggerSupport)cored;
            int i = 0;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                DbxWatch w = (DbxWatch)iter.next();
                mux.removeWatch((AbstractWatch)w);
                ++i;
            }
            watches.clear();
        }
    }

    private void deregisterBreakpoints() {
        if (this.engine == null) {
            return;
        }
        IpeHandler[] handlers = this.engine.getHandlers();
        int nh = this.engine.getNumHandlers();
        this.ignoreUpdates(true);
        try {
            for (int hx = 0; hx < nh; ++hx) {
                IpeHandler h = handlers[hx];
                h.removeAnnotations();
                IpeBreakpointEvent ibe = h.getEvent();
                CoreBreakpoint enclosing = ibe.getBreakpoint();
                enclosing.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ignoreUpdates(false);
    }

    private void registerBreakpoints() {
        if (this.engine == null) {
            return;
        }
        IpeHandler[] handlers = this.engine.getHandlers();
        int nh = this.engine.getNumHandlers();
        this.ignoreUpdates(true);
        try {
            for (int hx = 0; hx < nh; ++hx) {
                IpeHandler h = handlers[hx];
                boolean wasEnabled = h.getEvent().isEnabled();
                this.engine.insertBreakpoint(h.getEvent());
                h.getEvent().setEnabled(wasEnabled);
                h.reinstateAnnotations();
            }
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
        this.ignoreUpdates(false);
    }

    private LineBreakpointDelegator createBreakpointProxy(Breakpoint brpt, LineBreakpointEvent be) {
        LineBreakpointDelegator lb = new LineBreakpointDelegator(be);
        this.ignoreUpdates(true);
        brpt.remove();
        this.ignoreUpdates(false);
        LineBreakpointDelegator e = lb;
        Debugger debugger = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebugger.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        CoreBreakpoint br = ((BreakpointProducer)debugger).createBreakpoint(false);
        br.setEvent((CoreBreakpoint.Event)e);
        return lb;
    }

    public void breakpointAdded(final Breakpoint breakpoint) {
        if (this.engine == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!(6.access$600(this.this$1) instanceof CoreBreakpoint)) {
                            return;
                        }
                        CoreBreakpoint.Event be = ((CoreBreakpoint)6.access$600(this.this$1)).getEvent();
                        if (be != null && be instanceof LineBreakpointEvent && !(be instanceof LineBreakpointDelegator)) {
                            DbxDebugger.access$800(6.access$700(this.this$1), 6.access$600(this.this$1), (LineBreakpointEvent)be);
                        }
                    }
                });
            }

            static /* synthetic */ Breakpoint access$600(6 x0) {
                return x0.breakpoint;
            }

            static /* synthetic */ DbxDebugger access$700(6 x0) {
                return x0.DbxDebugger.this;
            }
        });
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
    }

    public void watchAdded(AbstractWatch watch) {
        if (this.engine == null) {
            return;
        }
    }

    public void watchRemoved(AbstractWatch watch) {
    }

    public IpeBreakpointEvent locateBreakpoint(Line l) {
        if (this.engine != null) {
            return this.engine.locateBreakpoint(l);
        }
        return null;
    }

    public void fix() {
        Dbx dbx = this.engine;
        if (dbx != null) {
            dbx.fix(0, null);
        }
    }

    protected String getString(String s) {
        return this.bundle.getString(s);
    }

    private static void NEW_switchOutputWork(AbstractDebugger old, AbstractDebugger New) {
        UnixTabTerm tab;
        UnixTabTerm con_tab = null;
        if (tabBug) {
            System.out.println("DbxDebugger.NEW_switchOutputWork()");
        }
        if (New != null) {
            if (tabBug) {
                System.out.println("\tbringup new");
            }
            if ((tab = (UnixTabTerm)debuggerToPIOTab.get(New)) != null) {
                tab.setTabVisible(true);
            }
            if ((tab = (UnixTabTerm)debuggerToMemUseTab.get(New)) != null) {
                tab.setTabVisible(true);
            }
            if ((tab = (UnixTabTerm)debuggerToAccessTab.get(New)) != null) {
                tab.setTabVisible(true);
            }
        }
        if ((currentDebugger = New) != null && (con_tab = (UnixTabTerm)debuggerToDbxTab.get(currentDebugger)) != null) {
            con_tab.setTabVisible(true);
            con_tab.requestVisible();
        }
        if (old != null) {
            if (tabBug) {
                System.out.println("\thide old");
            }
            if ((tab = (UnixTabTerm)debuggerToPIOTab.get(old)) != null) {
                tab.setTabVisible(false);
            }
            if ((tab = (UnixTabTerm)debuggerToDbxTab.get(old)) != null) {
                tab.setTabVisible(false);
            }
            if ((tab = (UnixTabTerm)debuggerToMemUseTab.get(old)) != null) {
                tab.setTabVisible(false);
            }
            if ((tab = (UnixTabTerm)debuggerToAccessTab.get(old)) != null) {
                tab.setTabVisible(false);
            }
            if (((DbxDebugger)old).gone) {
                if (tabBug) {
                    System.out.println("\tgone is set. clearing maps");
                }
                debuggerToPIOTab.remove(old);
                debuggerToDbxTab.remove(old);
                debuggerToMemUseTab.remove(old);
                debuggerToAccessTab.remove(old);
            }
        }
    }

    private static void OLD_switchOutputWork() {
        UnixTabTerm tab;
        AbstractDebugger cd = Register.getCurrentDebugger();
        if (currentDebugger != null && currentDebugger != cd && cd != null) {
            tab = (UnixTabTerm)debuggerToPIOTab.get(currentDebugger);
            if (tab != null) {
                tab.setTabVisible(false);
            }
            if ((tab = (UnixTabTerm)debuggerToDbxTab.get(currentDebugger)) != null) {
                tab.setTabVisible(false);
            }
            if ((tab = (UnixTabTerm)debuggerToMemUseTab.get(currentDebugger)) != null) {
                tab.setTabVisible(false);
            }
            if ((tab = (UnixTabTerm)debuggerToAccessTab.get(currentDebugger)) != null) {
                tab.setTabVisible(false);
            }
            currentDebugger = null;
        }
        if (cd != null) {
            tab = (UnixTabTerm)debuggerToPIOTab.get(cd);
            if (tab != null) {
                tab.setTabVisible(true);
            }
            if ((tab = (UnixTabTerm)debuggerToMemUseTab.get(cd)) != null) {
                tab.setTabVisible(true);
            }
            if ((tab = (UnixTabTerm)debuggerToAccessTab.get(cd)) != null) {
                tab.setTabVisible(true);
            }
            UnixTabTerm con_tab = (UnixTabTerm)debuggerToDbxTab.get(cd);
            currentDebugger = cd;
            if (con_tab != null) {
                con_tab.setTabVisible(true);
                con_tab.requestVisible();
            }
        }
    }

    public static void switchOutput(final AbstractDebugger old, final AbstractDebugger New) {
        if (tabBug) {
            System.out.println("DbxDebugger.switchOutput()");
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = tabMutex;
                synchronized (object) {
                    DbxDebugger.NEW_switchOutputWork(old, New);
                }
            }
        });
    }

    private static void switchSource(final Session newSession, final Session oldSession) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dbx dbx;
                DbxDebugger d;
                if (oldSession != null && (d = (DbxDebugger)oldSession.getDebugger()) != null && (dbx = d.engine) != null) {
                    d.setCurrentLine(null);
                }
                if (newSession != null && (d = (DbxDebugger)newSession.getDebugger()) != null && (dbx = d.engine) != null) {
                    DbxLocation loc = dbx.getCurrentLocation();
                    DbxLocation vloc = dbx.getVisitedLocation();
                    DbxLocation sloc = dbx.getStartLocation();
                    if (loc != null && loc.src != null) {
                        d.makeCurrent(loc.src, loc.line, loc.func, (loc.flags & 2) == 0 && loc.src != null, true, false, false);
                    } else if (vloc != null && vloc.src != null) {
                        d.makeCurrent(vloc.src, vloc.line, vloc.func, (vloc.flags & 2) == 0 && vloc.src != null, true, false, true);
                    } else if (sloc != null && sloc.src != null) {
                        d.makeCurrent(sloc.src, sloc.line, sloc.func, (sloc.flags & 2) == 0 && sloc.src != null, false, false, false);
                    } else {
                        d.setCurrentLine(null);
                    }
                }
            }
        });
    }

    public void removeWatch(Watch w) {
        DbxWatch dw = (DbxWatch)w;
        Dbx dbx = this.getEngine();
        if (dbx != null) {
            dbx.removeWatch(dw.getId());
        }
    }

    private static void switchWatch(Session newSession, Session oldSession) {
        Dbx ndbx;
        DbxWatch w;
        Iterator iter;
        int i;
        Collection c;
        HashMap watches;
        Dbx odbx;
        DbxDebugger odd = (DbxDebugger)oldSession.getDebugger();
        DbxDebugger ndd = (DbxDebugger)newSession.getDebugger();
        DebuggerSupport mux = (DebuggerSupport)cored;
        if (odd != null && (odbx = odd.engine) != null && (watches = odbx.getwatches()) != null) {
            c = watches.values();
            i = 0;
            iter = c.iterator();
            while (iter.hasNext()) {
                w = (DbxWatch)iter.next();
                mux.removeWatch((AbstractWatch)w);
                ++i;
            }
        }
        if (ndd != null && (ndbx = ndd.engine) != null && (watches = ndbx.getwatches()) != null) {
            c = watches.values();
            i = 0;
            iter = c.iterator();
            while (iter.hasNext()) {
                w = (DbxWatch)iter.next();
                mux.addWatch((AbstractWatch)w);
                w.getVar().setRHS(w.getRHS(), w.getRHS_VDL());
                ++i;
            }
        }
    }

    private static DbxDebugger toDbxDebugger(Session session) {
        if (session == null) {
            return null;
        }
        AbstractDebugger debugger = session.getDebugger();
        if (debugger == null) {
            return null;
        }
        DbxDebugger dbxDebugger = (DbxDebugger)debugger;
        return dbxDebugger;
    }

    private static void switchBreakpoint(final Session newSession, final Session oldSession) {
        if (newSession == oldSession) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    DbxDebugger ndebugger;
                    DbxDebugger odebugger = DbxDebugger.toDbxDebugger(oldSession);
                    if (odebugger != null) {
                        odebugger.deregisterBreakpoints();
                    }
                    if ((ndebugger = DbxDebugger.toDbxDebugger(newSession)) != null) {
                        ndebugger.registerBreakpoints();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateStates() {
        if (this.runTimer != null) {
            this.runTimer.stop();
            this.updateActionButtons = false;
            this.delayedEngine = null;
        }
        this.setDebuggerState(this.debuggerState);
        this.lastState = DbxDebuggerState.EMPTY;
        this.updateState(this.engine);
        this.updateActionStates();
    }

    public CallStackFilter getCallStackFilter() {
        return csFilter;
    }

    public void setCallStackFilter(CallStackFilter csFilter) {
        if (csFilter == DbxDebugger.csFilter) {
            return;
        }
        if (csFilter != null) {
            if (csFilter.equals(DbxDebugger.csFilter)) {
                return;
            }
        }
        CallStackFilter old = DbxDebugger.csFilter;
        DbxDebugger.csFilter = csFilter;
        this.firePropertyChange("callStackFilter", old, csFilter);
    }

    public VariablesFilter getVariablesFilter() {
        return this.filter;
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        VariablesFilter old = this.filter;
        this.filter = filter;
        this.firePropertyChange("variablesFilter", old, filter);
    }

    public static TreeTableExplorerViewSupport getView(View2 target) {
        if (target == null) {
            return null;
        }
        GUIManager.View[] vs = GUIManager.getDefault().getViews();
        DebuggerWindow dbw = DebuggerWindowPerformer.getDebuggerWindow();
        for (int i = 0; i < vs.length; ++i) {
            if (vs[i] != target) continue;
            TopComponent c = dbw.getComponent(vs[i]);
            if (c instanceof TreeTableExplorerViewSupport) {
                return (TreeTableExplorerViewSupport)c;
            }
            return null;
        }
        return null;
    }

    public String getInfo() {
        return null;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public Hashtable getDbxTab() {
        return debuggerToDbxTab;
    }

    public Hashtable getPioTab() {
        return debuggerToPIOTab;
    }

    public void invalidateSessionData() {
        this.firePropertyChange(PROP_SESSION, null, null);
    }

    public String getSessionState() {
        int state = this.getState();
        switch (state) {
            case 3: {
                return DbxDebugger.getText("DEBUGGER_RUNNING");
            }
            case 4: {
                return DbxDebugger.getText("DEBUGGER_STOPPED");
            }
            case 1: {
                return DbxDebugger.getText("DEBUGGER_NOT_RUNNING");
            }
            case 2: {
                return DbxDebugger.getText("DEBUGGER_STARTING");
            }
        }
        return DbxDebugger.getText("DEBUGGER_UNKNOWN");
    }

    public String getSessionMode() {
        StringBuffer mode = new StringBuffer();
        Dbx engine = this.getEngine();
        if (engine != null) {
            if (engine.getState().isMultiThreaded()) {
                mode.append(" MT");
            }
            if (engine.isAccessCheckingEnabled()) {
                mode.append(" Access");
            }
            if (engine.isMemuseEnabled()) {
                mode.append(" MemUse");
            }
        }
        return mode.toString().trim();
    }

    public String getSessionName() {
        RunConfig config = this.getConfig();
        if (config == null) {
            return "";
        }
        DbxDebugProgram pg = config.getProgram();
        String name = pg.getExecutableBaseName();
        boolean programUnique = true;
        AbstractDebugger[] debuggers = null;
        debuggers = Register.getCoreDebugger().getDebuggers();
        for (int dx = 0; dx < debuggers.length; ++dx) {
            DbxDebugger dbxDebugger = (DbxDebugger)debuggers[dx];
            String thatName = dbxDebugger.getConfig().getProgram().getExecutableBaseName();
            if (dbxDebugger == this || !name.equals(thatName)) continue;
            programUnique = false;
            break;
        }
        if (!programUnique) {
            name = name + " # " + this.serialNumber;
        }
        return name;
    }

    public String getSessionLocation() {
        RunConfig config = this.getConfig();
        if (config == null) {
            return "";
        }
        DbxDebugProgram pg = config.getProgram();
        return pg.getExecutableName();
    }

    public String getSessionArguments() {
        RunConfig config = this.getConfig();
        if (config == null) {
            return "";
        }
        String runargs = config.getUnparsedArgs();
        if (runargs == null) {
            return "";
        }
        return runargs;
    }

    public long getSessionPid() {
        return this.currentSession.getPid();
    }

    public String getSessionCoreLocation() {
        return this.currentSession.getCorefile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreUpdates(boolean ignore) {
        Object object = ignoreUpdatesSync;
        synchronized (object) {
            if (ignore) {
                ++ignoreUpdates;
            } else if (--ignoreUpdates < 0) {
                ignoreUpdates = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ignoreUpdates() {
        Object object = ignoreUpdatesSync;
        synchronized (object) {
            return ignoreUpdates > 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ LineBreakpointDelegator access$800(DbxDebugger x0, Breakpoint x1, LineBreakpointEvent x2) {
        return x0.createBreakpointProxy(x1, x2);
    }

    static {
        tabBug = false;
        debuggerToPIOTab = new Hashtable();
        debuggerToDbxTab = new Hashtable();
        debuggerToMemUseTab = new Hashtable();
        debuggerToAccessTab = new Hashtable();
        cored = Register.getCoreDebugger();
        breakpointEvents = null;
        breakpointActions = null;
        listener = new DebuggerChangeListener();
        nextSerialNumber = 0;
        tabMutex = new Object();
        keyStrokeSet = null;
        csFilter = new NullStackFilter();
        ignoreUpdates = 0;
        ignoreUpdatesSync = new Object();
    }

    private static class NullVariablesFilter
    extends VariablesFilter {
        private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

        private NullVariablesFilter() {
        }

        public JComponent getToolbar() {
            JButton dummy = new JButton("dummy");
            dummy.setVisible(false);
            return dummy;
        }

        public JComponent getCustomizer() {
            return null;
        }

        public String getDisplayName(AbstractVariable v) {
            return v.getVariableName();
        }

        public Node.Property[] getProperties(AbstractVariable v) {
            return new Node.Property[0];
        }

        public SystemAction[] getActions(AbstractVariable v) {
            return new SystemAction[0];
        }

        public AbstractVariable[] getVariables(VariablesProducer v) {
            Log.prf(1);
            return v.getVariables();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private static class NullStackFilter
    extends CallStackFilter {
        private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

        private NullStackFilter() {
        }

        public Location[] filterCallStack(CallStackProducer producer) {
            return producer.getCallStack();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private static class DebuggerChangeListener
    implements PropertyChangeListener {
        public DebuggerChangeListener() {
            cored.addPropertyChangeListener((PropertyChangeListener)this);
            if (tabBug) {
                System.out.println("DbxDebugger registered DebuggerChangeListener with\n\t" + cored);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() != null) {
                if (tabBug) {
                    System.out.println("DbxDebugger.propertyChange(): " + e.getPropertyName());
                }
                if (e.getPropertyName() == "currentDebugger") {
                    AbstractDebugger old = (AbstractDebugger)e.getOldValue();
                    AbstractDebugger New = (AbstractDebugger)e.getNewValue();
                    DbxDebugger.switchOutput(old, New);
                }
                if (e.getPropertyName() == "currentSession") {
                    DbxDebugger dbxDebugger;
                    Session oldSession = (Session)e.getOldValue();
                    Session newSession = (Session)e.getNewValue();
                    if (newSession != null && oldSession != null && oldSession != newSession) {
                        DbxDebugger.switchSource(newSession, oldSession);
                        DbxDebugger.switchWatch(newSession, oldSession);
                    }
                    DbxDebugger.switchBreakpoint(newSession, oldSession);
                    DbxDebugger ndebugger = DbxDebugger.toDbxDebugger(newSession);
                    if (ndebugger != null) {
                        DbxThreadGroup tg = (DbxThreadGroup)ndebugger.getThreadGroupRoot();
                        tg.refresh();
                    }
                    if ((dbxDebugger = DbxDebugger.toDbxDebugger(newSession)) != null) {
                        dbxDebugger.updateStates();
                    }
                }
            } else if (tabBug) {
                System.out.println("DbxDebugger.propertyChange(): NO PROP NAME!");
            }
        }
    }

    private class LocalViewChangeListener
    implements PropertyChangeListener {
        private LocalViewChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (DbxDebugger.this.getEngine() != null && evt.getPropertyName().equals("ancestor")) {
                if (evt.getNewValue() == null) {
                    DbxDebugger.this.getEngine().sendLocalVarUpdates(false);
                } else {
                    DbxDebugger.this.getEngine().sendLocalVarUpdates(true);
                }
            }
        }
    }

    class MyState
    extends State {
        private DbxDebugger debugger;

        MyState(DbxDebugger d) {
            this.debugger = d;
        }

        public boolean isStepIntoEnabled() {
            return this.debugger.isStepIntoEnabled();
        }

        public boolean isStepOverEnabled() {
            return this.debugger.isStepOverEnabled();
        }

        public boolean isStepOutEnabled() {
            return this.debugger.isStepOutEnabled();
        }

        public boolean isRunToCursorEnabled() {
            return this.debugger.isRunToCursorEnabled();
        }

        public boolean isPauseEnabled() {
            return this.debugger.isPauseEnabled();
        }

        public boolean isContinueEnabled() {
            return this.debugger.isContinueEnabled();
        }

        public boolean isGoToCallingMethodEnabled() {
            return this.debugger.isGoToCallingMethodEnabled();
        }

        public boolean isGoToCalledMethodEnabled() {
            return this.debugger.isGoToCalledMethodEnabled();
        }

        public boolean isFixEnabled() {
            return this.debugger.isFixEnabled();
        }

        public boolean isPopTopmostFrameEnabled() {
            return this.debugger.isPopTopmostFrameEnabled();
        }
    }

    class BreakpointComparator
    implements Comparator {
        BreakpointComparator() {
        }

        public int compare(Object o1, Object o2) {
            CoreBreakpoint.Event event1 = null;
            CoreBreakpoint.Event event2 = null;
            IpeBreakpointEvent ibe1 = null;
            IpeBreakpointEvent ibe2 = null;
            if (o1 instanceof CoreBreakpoint && (event1 = ((CoreBreakpoint)o1).getEvent()) instanceof IpeBreakpointEvent) {
                ibe1 = (IpeBreakpointEvent)event1;
            }
            if (o2 instanceof CoreBreakpoint && (event2 = ((CoreBreakpoint)o2).getEvent()) instanceof IpeBreakpointEvent) {
                ibe2 = (IpeBreakpointEvent)event2;
            }
            if (ibe1 == null || ibe2 == null) {
                return 0;
            }
            return ibe1.getId() - ibe2.getId();
        }
    }
}

