/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.CollectPanel;
import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerImpl;
import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.debugger.actions.StopCollector;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.debugger.dbxgui.utils.UnixFileSystemView;
import com.sun.tools.swdev.glue.dbx.DbxHWCounter;
import com.sun.tools.swdev.glue.dbx.DbxPerfOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class CollectWindow
extends JPanel
implements ActionListener {
    private static localLock ulock;
    private static boolean opts_updated;
    private static boolean file_updated;
    private static boolean interrupted;
    private static RunConfig config;
    private Dbx engine;
    private final ColPanel cdpanel;
    private int max_allowed;
    private String hwstr;
    private String[][] hwlist;
    private String[][] reglist;
    public String[][] hwtype;
    public String[] atrlist;
    private final JButton[] buttons = new JButton[5];
    private Dialog hwc_idepop;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector;

    public CollectWindow(RunConfig config) {
        CollectWindow.config = config;
        this.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_CWindow"));
        DbxDebugger debugger = DbxDebuggerImpl.getCurrentDebugger();
        if (debugger != null) {
            this.engine = debugger.getEngine();
        }
        ulock = new localLock();
        this.procControl(true);
        this.engine.sendCollectorUpdates(true);
        this.procControl(false);
        while (Dbx.CollectorOpts == null) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        this.buildHwcList(Dbx.CollectorOpts);
        this.cdpanel = new ColPanel(this.hwlist, this.hwtype, this.reglist, this.atrlist, (ActionListener)new PanelListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.cdpanel.work_panel, "Center");
        config.windowCol = this;
    }

    public void showWindow(boolean new_win) {
        String name = config.getName();
        String title = MessageFormat.format(DbxDebugger.getText("CollectorTitle"), name);
        CollectWindow.ulock.val = 0;
        opts_updated = false;
        file_updated = false;
        this.cdpanel.exp_dir.setValue(".");
        this.buttons[0] = new JButton(this.cdpanel.getLocaleStr("Pause"));
        this.buttons[0].setMnemonic(this.cdpanel.getLocaleStr('u', "MNEM_COLLECTOR_PAUSE"));
        this.buttons[1] = new JButton(this.cdpanel.getLocaleStr("Resume"));
        this.buttons[1].setMnemonic(this.cdpanel.getLocaleStr('e', "MNEM_COLLECTOR_RESUME"));
        this.buttons[1].setEnabled(false);
        this.buttons[2] = new JButton(this.cdpanel.getLocaleStr("Sample"));
        this.buttons[2].setMnemonic(this.cdpanel.getLocaleStr('S', "MNEM_COLLECTOR_SAMPLE"));
        this.buttons[3] = new JButton(this.cdpanel.getLocaleStr("OK"));
        this.buttons[4] = new JButton(this.cdpanel.getLocaleStr("Cancel"));
        if (this.engine.getState().isRunning()) {
            this.buttons[0].setEnabled(true);
            this.buttons[2].setEnabled(true);
        } else {
            this.buttons[0].setEnabled(false);
            this.buttons[2].setEnabled(false);
        }
        this.procControl(true);
        this.engine.sendCollectorUpdates(true);
        while (CollectWindow.ulock.val == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {}
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)this, title, true, (Object[])this.buttons, (Object)this.buttons[4], 0, new HelpCtx("Debugging_Collect"), (ActionListener)this);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        Object[] close_opt = new Object[]{this.buttons[3], this.buttons[4]};
        dlg.setClosingOptions(close_opt);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dialog.show();
            }
        });
        this.procControl(false);
    }

    public synchronized void procControl(boolean to_be_stopped) {
        if (interrupted && !to_be_stopped) {
            this.engine.getState().setRunning(false);
            this.engine.go();
            this.engine.getState().setRunning(true);
            interrupted = false;
        } else if (this.engine.getState().isRunning() && to_be_stopped) {
            this.engine.interruptQuietly();
            interrupted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDbxCollState(DbxPerfOptions options, String[] cfiles) {
        localLock localLock2 = ulock;
        synchronized (localLock2) {
            if (!opts_updated && cfiles == null) {
                String ssample;
                String ssync;
                String sclock;
                int varch;
                if (options.size_limit > 0) {
                    this.cdpanel.exp_limit.setCValue(true, new Integer(options.size_limit).toString());
                }
                String sarch = (varch = options.archive_mode) == 0 ? "off" : (varch == 1 ? "on" : "copy");
                this.cdpanel.arch_exp.setCValue(true, sarch);
                int vclock = options.profile_resolution;
                String string = vclock == 997 ? "high" : (vclock == 10007 ? "on" : (sclock = vclock == 100003 ? "low" : new Integer(Math.round(vclock / 1000)).toString()));
                if (options.profile_mode == 1) {
                    this.cdpanel.clock_prof.setCValue(true, sclock);
                } else {
                    this.cdpanel.clock_prof.setCValue(false, "on");
                }
                int vsync = options.synctrace_threshold;
                String string2 = vsync == 0 ? "all" : (ssync = vsync == -1 ? "calibrate" : new Integer(vsync).toString());
                if (options.synctrace_mode == 1) {
                    this.cdpanel.sync_trace.setCValue(true, ssync);
                } else {
                    this.cdpanel.sync_trace.setCValue(false, "calibrate");
                }
                this.cdpanel.sel_counters.removeAllElements();
                if (options.hw_mode == 1) {
                    this.cdpanel.hwc1_prof.setCValue(true, null);
                    int nsel = options.hw_nselected_ctrs;
                    DbxHWCounter[] selhwc = new DbxHWCounter[nsel];
                    selhwc = options.hw_selected_ctrs;
                    for (int j = 0; j < nsel; ++j) {
                        String strval1 = selhwc[j].name + "," + selhwc[j].norm_res;
                        this.cdpanel.sel_counters.add(strval1);
                    }
                } else {
                    this.cdpanel.hwc1_prof.setCValue(false, null);
                }
                this.cdpanel.SetButtons();
                if (options.heaptrace_mode == 1) {
                    this.cdpanel.heap_trace.setCValue(true, null);
                } else {
                    this.cdpanel.heap_trace.setCValue(false, null);
                }
                if (options.mpitrace_mode == 1) {
                    this.cdpanel.mpi_trace.setCValue(true, null);
                } else {
                    this.cdpanel.mpi_trace.setCValue(false, null);
                }
                int vsample = options.sample_interval;
                String string3 = ssample = vsample == 1 ? "on" : new Integer(vsample).toString();
                if (options.sample_mode == 1) {
                    this.cdpanel.sample.setCValue(false, "on");
                } else {
                    this.cdpanel.sample.setCValue(true, ssample);
                }
                if (options.dbxsample) {
                    this.cdpanel.dbxsample.setCValue(true, null);
                } else {
                    this.cdpanel.dbxsample.setCValue(false, null);
                }
                opts_updated = true;
            }
            this.cdpanel.work_dir.setValue(config.getRunDir());
            if (!file_updated && cfiles != null) {
                if (cfiles[0] != null) {
                    this.cdpanel.exp_dir.setValue(cfiles[0]);
                }
                if (cfiles[1] != null) {
                    this.cdpanel.exp_name.setValue(cfiles[1]);
                }
                if (cfiles[2] != null) {
                    this.cdpanel.exp_group.setValue(cfiles[2]);
                }
                file_updated = true;
            }
            if (opts_updated && file_updated) {
                CollectWindow.ulock.val = 1;
            }
        }
    }

    private static String GetThreshStr(String ctrname, int hw_interval, DbxPerfOptions options) {
        String hthresh = "normal";
        for (int i = 0; i < options.hw_number; ++i) {
            if (!ctrname.equals(options.hw_array[i].name)) continue;
            if (hw_interval == options.hw_array[i].low_res) {
                hthresh = "low";
                break;
            }
            if (hw_interval == options.hw_array[i].hi_res) {
                hthresh = "high";
                break;
            }
            if (hw_interval == options.hw_array[i].norm_res) {
                hthresh = "on";
                break;
            }
            hthresh = new Integer(hw_interval).toString();
            break;
        }
        return hthresh;
    }

    private void buildHwcList(DbxPerfOptions options) {
        int k;
        int hwNumber = options.hw_number;
        int nattr = options.hw_nattrs;
        this.atrlist = new String[nattr + 1];
        this.atrlist[0] = DbxDebugger.getText("None");
        for (int k2 = 0; k2 < nattr; ++k2) {
            this.atrlist[k2 + 1] = options.hw_attr_names[k2];
        }
        this.max_allowed = options.hw_max_selected_ctrs;
        DbxHWCounter[] hwArray = new DbxHWCounter[hwNumber + 1];
        if (hwNumber > 0) {
            for (int i = 0; i < hwNumber; ++i) {
                hwArray[i] = new DbxHWCounter();
                hwArray[i].name = options.hw_array[i].name;
                hwArray[i].int_name = options.hw_array[i].int_name;
                hwArray[i].low_res = options.hw_array[i].low_res;
                hwArray[i].norm_res = options.hw_array[i].norm_res;
                hwArray[i].hi_res = options.hw_array[i].hi_res;
                hwArray[i].descr = options.hw_array[i].descr;
                hwArray[i].nreg_list = options.hw_array[i].nreg_list;
                hwArray[i].reg_list = options.hw_array[i].reg_list;
            }
        }
        String[][] tmparr = new String[2][hwNumber];
        for (k = 0; k < hwNumber; ++k) {
            tmparr[0][k] = hwArray[k].descr;
            tmparr[1][k] = hwArray[k].name;
        }
        this.hwlist = tmparr;
        this.reglist = new String[hwNumber][];
        for (int i = 0; i < hwNumber; ++i) {
            int[] regis = hwArray[i].reg_list;
            if (regis == null) {
                this.reglist = null;
                continue;
            }
            this.reglist[i] = new String[regis.length];
            for (int j = 0; j < regis.length; ++j) {
                if (j == hwArray[i].nreg_list) {
                    regis[j] = -1;
                }
                this.reglist[i][j] = new Integer(regis[j]).toString();
            }
        }
        this.hwtype = new String[2][hwNumber];
        this.hwtype[0] = this.hwlist[0];
        this.hwtype[1] = new String[hwNumber];
        for (k = 0; k < hwNumber; ++k) {
            this.hwtype[1][k] = hwArray[k].int_name == null ? "raw" : "std";
        }
    }

    public void showHwcDialog() {
        String title = DbxDebugger.getText("Collector_HWCconfiguration");
        JPanel base = this.cdpanel.setHwcPanel();
        Object[] buttons = new JButton[]{this.cdpanel.updateButton, this.cdpanel.cancelButton};
        Object[] close_opt = new JButton[]{buttons[1]};
        DialogDescriptor dlg = new DialogDescriptor((Object)base, title, true, buttons, (Object)buttons[0], 0, null, null);
        dlg.setClosingOptions(close_opt);
        this.hwc_idepop = DialogDisplayer.getDefault().createDialog(dlg);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CollectWindow.this.hwc_idepop.show();
            }
        });
    }

    void updateCtrList() {
        String msg;
        int user_choice;
        String regval = "";
        String attr = "";
        if (ColPanel.attr_warn && (user_choice = JOptionPane.showConfirmDialog(this, msg = this.cdpanel.getLocaleStr("Attribute selection changed and Add Attribute was not clicked, do you want to discard changes"), this.cdpanel.getLocaleStr("Question"), 0, 3)) == 1) {
            return;
        }
        String hwc1 = this.cdpanel.hwc2_prof.getValue();
        if (hwc1 != null) {
            String aggr_prof1 = this.cdpanel.dspace_hwc1.getValue() != null && this.cdpanel.dspace_hwc1.getValue().equals("on") ? "+" : "";
            String[] hwcs = hwc1.split(",");
            for (int i = 0; i < this.cdpanel.sel_attr.size(); ++i) {
                attr = attr + (String)this.cdpanel.sel_attr.elementAt(i);
            }
            if (!this.cdpanel.reg_alloc.getValue().equals("None")) {
                regval = "/" + this.cdpanel.reg_alloc.getValue();
            }
            String ctrstr = aggr_prof1 + hwcs[0] + attr + regval + "," + this.cdpanel.hwc1_val.getValue();
            this.cdpanel.sel_counters.add(ctrstr);
            this.cdpanel.SetButtons();
        }
        this.hwc_idepop.setVisible(false);
        ColPanel.attr_warn = false;
    }

    void deleteCtrFromList() {
        int idx = this.cdpanel.hwc_list.getSelectedIndex();
        this.cdpanel.sel_counters.remove(idx);
        this.cdpanel.SetButtons();
    }

    void addAttribute() {
        ColPanel.attr_warn = false;
        String attrname = (String)this.cdpanel.ctr_attr.combo.getSelectedItem();
        String attrStr = "~" + attrname + "=";
        String attrEntry = attrStr + this.cdpanel.ctr_attr.getValue();
        boolean found = false;
        int i = 0;
        Enumeration en = this.cdpanel.sel_attr.elements();
        while (en.hasMoreElements()) {
            String cur_elem = (String)en.nextElement();
            if (cur_elem.indexOf(attrStr) != -1) {
                this.cdpanel.sel_attr.set(i, attrEntry);
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.cdpanel.sel_attr.add(attrEntry);
        }
        this.cdpanel.SetAttrButtons();
    }

    void removeAttribute() {
        int idx = this.cdpanel.attr_list.getSelectedIndex();
        this.cdpanel.sel_attr.remove(idx);
        this.cdpanel.SetAttrButtons();
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (this.engine == null) {
            return;
        }
        if (cmd.equals(this.cdpanel.getLocaleStr("OK"))) {
            this.handle_ok();
        } else if (cmd.equals(this.cdpanel.getLocaleStr("Pause"))) {
            this.procControl(true);
            this.engine.setPauseCollector(true);
            this.buttons[0].setEnabled(false);
            this.buttons[1].setEnabled(true);
            this.procControl(false);
        } else if (cmd.equals(this.cdpanel.getLocaleStr("Resume"))) {
            this.procControl(true);
            this.engine.setPauseCollector(false);
            this.buttons[0].setEnabled(true);
            this.buttons[1].setEnabled(false);
            this.procControl(false);
        } else if (cmd.equals(this.cdpanel.getLocaleStr("Sample"))) {
            this.procControl(true);
            this.engine.recordManualSample("manual");
            this.procControl(false);
        }
    }

    private void handle_ok() {
        block8: {
            block5: {
                block7: {
                    block6: {
                        if (this.engine == null) break block5;
                        if (!this.engine.getState().isRunning()) break block6;
                        if (!this.engine.getState().isRunning()) break block7;
                        if (Dbx.CollectorOpts.collector_mode != 1) break block7;
                    }
                    this.sendDbxCmds(this.engine);
                }
                if (Dbx.CollectorOpts.collector_mode != 3) {
                    this.procControl(true);
                    this.engine.setCollectorEnabled(true, false);
                    StopCollector stopCollectorAction = (StopCollector)SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector = CollectWindow.class$("com.sun.tools.debugger.dbxgui.debugger.actions.StopCollector")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$StopCollector));
                    stopCollectorAction.setEnabled(true);
                    this.procControl(false);
                }
                break block8;
            }
            System.out.println("engine is null");
        }
    }

    private void handle_show() {
        JPanel hwcPanel = new JPanel();
        if (!this.engine.getState().isRunning()) {
            this.hwstr = this.engine.getHWCList();
        }
        JTextArea jt = new JTextArea(this.hwstr);
        hwcPanel.add(jt);
        JButton closeButton = new JButton();
        Object[] jb = new JButton[]{closeButton};
        Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)this.cdpanel.getLocaleStr("Close"));
        DialogDescriptor dlg = new DialogDescriptor((Object)hwcPanel, DbxDebugger.getText("HWCLIST"), true, jb, (Object)closeButton, 0, new HelpCtx("Debugging_HWCList"), (ActionListener)this);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setButtonListener((ActionListener)new PanelListener());
        dlg.setClosingOptions(jb);
        dialog.show();
    }

    /*
     * WARNING - void declaration
     */
    private void handle_browse(String cmd) {
        CollectPanel.CollectExp text;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileHidingEnabled(false);
        if (cmd.equals(CollectPanel.CSTR_DIR)) {
            chooser.setFileFilter(new CFilter());
            text = this.cdpanel.exp_dir;
        } else if (cmd.equals(CollectPanel.CSTR_GROUP)) {
            text = this.cdpanel.exp_group;
        } else {
            return;
        }
        chooser.setDialogTitle(cmd);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            void var2_3;
            String fvalue = chooser.getSelectedFile().getParent() + "/" + chooser.getSelectedFile().getName();
            var2_3.setValue(fvalue);
        }
    }

    private void sendDbxCmds(Dbx engine) {
        String sdir = this.cdpanel.exp_dir.getText().equals("") ? "." : this.cdpanel.exp_dir.getText();
        engine.setCollectorStoreLocation(sdir, this.cdpanel.exp_name.getText());
        if (CollectWindow.readVal(this.cdpanel.exp_group.getText())) {
            engine.setCollectorGroupFile(this.cdpanel.exp_group.getText());
        }
        if (this.cdpanel.exp_limit.getValue().equals("")) {
            this.cdpanel.showError(this.cdpanel.getLocaleStr("Experiment Data Limit cannot be null"));
        } else {
            engine.setCollectorExpSizeLimit(this.cdpanel.exp_limit.getValue());
        }
        String cval = this.cdpanel.clock_prof.getValue();
        if (CollectWindow.readVal(cval)) {
            engine.setCollectorProfiling(true);
            engine.setProfileTimerPeriod(cval);
        } else {
            engine.setCollectorProfiling(false);
        }
        String sval = this.cdpanel.sync_trace.getValue();
        if (CollectWindow.readVal(sval)) {
            engine.setSyncTrace(true);
            engine.setSynctraceThreshold(sval);
        } else {
            engine.setSyncTrace(false);
        }
        String h1val = this.cdpanel.hwc1_prof.getValue();
        if (CollectWindow.readVal(h1val) && this.cdpanel.sel_counters.size() > 0) {
            engine.setHardwareProfiling(true);
            if (this.cdpanel.sel_counters.size() > 0) {
                String ctrlist = (String)this.cdpanel.sel_counters.elementAt(0);
                for (int i = 1; i < this.cdpanel.sel_counters.size(); ++i) {
                    ctrlist = ctrlist + "," + (String)this.cdpanel.sel_counters.elementAt(i);
                }
                String ctrname = ctrlist;
                engine.setHardwareCounter(ctrname);
            }
        } else if (CollectWindow.readVal(h1val) && this.cdpanel.sel_counters.size() == 0) {
            this.cdpanel.showWarn(this.cdpanel.getLocaleStr("No counters were selected, so HW counter profiling is disabled"));
            engine.setHardwareProfiling(false);
        } else {
            engine.setHardwareProfiling(false);
        }
        engine.toggleHeapTrace(CollectWindow.readVal(this.cdpanel.heap_trace.getValue()));
        engine.toggleMpiTrace(CollectWindow.readVal(this.cdpanel.mpi_trace.getValue()));
        String pval = this.cdpanel.sample.getValue();
        if (CollectWindow.readVal(pval)) {
            engine.setManualSampling(false);
            engine.setSamplePeriod(pval);
        } else {
            engine.setManualSampling(true);
            engine.setSamplePeriod("off");
        }
        engine.setdbxsampleToggle(CollectWindow.readVal(this.cdpanel.dbxsample.getValue()));
        String aval = this.cdpanel.arch_exp.getValue();
        engine.setArchiveExp(aval);
    }

    private static boolean readVal(String sval) {
        return sval != null && sval.length() > 0;
    }

    private void printCtr(DbxHWCounter ctr) {
        System.out.println("  name:             " + ctr.name);
        System.out.println("  low/norm/hi_res:  " + ctr.low_res + "/" + ctr.norm_res + "/" + ctr.hi_res);
        System.out.println("  descr:            " + ctr.descr);
        System.out.println("  long_descr:       " + ctr.long_descr);
        System.out.println("  int_name:         " + ctr.int_name);
        System.out.println("  timecvt/memop:    " + ctr.timecvt + "/" + ctr.memop);
        System.out.print("  reg_list:         ");
        for (int i = 0; i < ctr.nreg_list; ++i) {
            System.out.print(ctr.reg_list[i] + " ");
        }
        System.out.println("");
    }

    private void printOptions(DbxPerfOptions options) {
        int i;
        System.out.println("*****HWC options*****");
        System.out.println("hw_mode              " + options.hw_mode);
        System.out.println("----");
        System.out.println("hw_counter           " + options.hw_counter);
        System.out.println("hw_interval          " + options.hw_interval);
        System.out.println("hw_flags             " + options.hw_flags);
        System.out.println("hw_counter2          " + options.hw_counter2);
        System.out.println("hw_interval2         " + options.hw_interval2);
        System.out.println("hw_flags2            " + options.hw_flags2);
        System.out.println("----");
        System.out.println("hw_number            " + options.hw_number);
        for (i = 0; i < options.hw_number; ++i) {
            System.out.println(i + ". ");
            this.printCtr(options.hw_array[i]);
        }
        System.out.println("----");
        System.out.println("hw_nattrs            " + options.hw_nattrs);
        System.out.println("----");
        System.out.println("hw_max_selected_ctrs " + options.hw_max_selected_ctrs);
        System.out.println("hw_nselected_ctrs    " + options.hw_nselected_ctrs);
        for (i = 0; i < options.hw_nselected_ctrs; ++i) {
            System.out.print(i + ". ");
            this.printCtr(options.hw_array[i]);
        }
        System.out.println("----");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        opts_updated = false;
        file_updated = false;
        interrupted = false;
    }

    private final class CFilter
    extends FileFilter {
        private CFilter() {
        }

        public String getDescription() {
            return CollectWindow.this.cdpanel.getLocaleStr("ExperimentFiles");
        }

        public boolean accept(File f) {
            return f != null && f.isDirectory();
        }
    }

    public class PanelListener
    implements ActionListener {
        public final void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Available Counters"))) {
                CollectWindow.this.handle_show();
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Add Counters"))) {
                if (((CollectWindow)CollectWindow.this).cdpanel.sel_counters.size() == CollectWindow.this.max_allowed) {
                    String msg = CollectWindow.this.cdpanel.getLocaleStr("The maximum number of counters allowed is ") + CollectWindow.this.max_allowed;
                    CollectWindow.this.cdpanel.showError(msg);
                } else {
                    CollectWindow.this.showHwcDialog();
                }
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Modify"))) {
                CollectWindow.this.showHwcDialog();
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Delete"))) {
                CollectWindow.this.deleteCtrFromList();
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Add Attribute"))) {
                CollectWindow.this.addAttribute();
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Delete Attribute"))) {
                CollectWindow.this.removeAttribute();
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Update List"))) {
                CollectWindow.this.updateCtrList();
            } else if (cmd.equals(CollectWindow.this.cdpanel.getLocaleStr("Cancel"))) {
                CollectWindow.this.hwc_idepop.setVisible(false);
            } else if (cmd.equals(CollectPanel.CSTR_DIR) || cmd.equals(CollectPanel.CSTR_GROUP)) {
                CollectWindow.this.handle_browse(cmd);
            }
        }
    }

    private final class ColPanel
    extends CollectPanel {
        public ColPanel(String[][] hwlist, String[][] hwtype, String[][] reglist, String[] atr_list, ActionListener alisten) {
            super(true, hwlist, hwtype, reglist, atr_list, alisten);
        }

        public String getLocaleStr(String str) {
            String str1 = str.replaceAll(" ", "");
            str1 = str1.replaceAll(":", "");
            str1 = str1.replaceAll("/", "");
            String tmp = DbxDebugger.getText("Collector_" + str1);
            return tmp;
        }

        public char getLocaleStr(char c, String key) {
            return DbxDebugger.getText(key).charAt(0);
        }

        public final String CGetExpName(String str) {
            return "test.1.er";
        }

        public final String CGetCurDir() {
            return config.getRunDir();
        }

        public final String[][] getHwCounters() {
            return CollectWindow.this.hwlist;
        }

        public final ImageIcon get_brwsicon() {
            ImageIcon brwsIcon = null;
            return brwsIcon;
        }

        public final void showError(final String msg) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                }
            });
        }

        public final void showWarn(String msg) {
            SwingUtilities.invokeLater(new Runnable(this, msg){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ ColPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$msg = val$msg;
                }

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.val$msg, 2));
                }
            });
        }

        public final String getenv(String name) {
            return IpeUtils.getenv(name);
        }

        public final int getTargetType(String path) {
            return -1;
        }

        public final Component getOutputPane() {
            return null;
        }

        public final void updateTitle(String target) {
        }
    }

    private class localLock {
        public int val = 0;

        private localLock() {
        }
    }
}

