/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.accessibility.AccessibleContext;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.DefaultCaret;

public final class CollectUtility {
    private static final int TEXT_LEFT = 1;
    public static final int TEXT_RIGHT = 3;
    public static final Font text_font;
    public static final Color text_color;
    private static final Color LABEL_COLOR;
    private static final int sizeLabel = 4;
    private static final Border labelBorder;
    public static final Insets buttonMargin;

    public static JComponent getItem(String text) {
        return new CLabel(text, 4);
    }

    static {
        LABEL_COLOR = Color.black;
        labelBorder = new EmptyBorder(0, 4, 0, 4);
        buttonMargin = new Insets(1, 1, 1, 1);
        Font org_font = UIManager.getDefaults().getFont("TextField.font");
        text_font = new Font("Monospaced", org_font.getStyle(), org_font.getSize());
        text_color = new Color(UIManager.getDefaults().getColor("TextArea.background").getRGB());
    }

    public static interface Browseable {
        public void setValue(String var1);

        public String getValue();
    }

    public static class AnComboBox
    extends JComboBox
    implements ActionListener {
        public static final int COMBO_TEXT = 0;
        public static final int COMBO_ITEM = 1;
        private ComboObj current_obj = null;
        private final int width;

        public AnComboBox(int width) {
            this.width = width;
            this.setRenderer(new AnComboRenderer());
            this.setEditor(new AnComboEditor());
            this.setEditable(true);
            this.setBorder(new EtchedBorder(1));
        }

        public AnComboBox() {
            this(14);
        }

        public final void add(int type, String header, String str, boolean changable) {
            this.addItem(new ComboObj(type, false, header, str, changable));
        }

        public final void setText(String str) {
            ComboObj obj = (ComboObj)this.getEditor().getEditorComponent();
            if (obj.getType() == 0) {
                obj.setText(str);
                if (this.current_obj.changable) {
                    this.current_obj.setText(str);
                }
            }
        }

        public final String getText() {
            ComboObj obj = (ComboObj)this.getEditor().getEditorComponent();
            if (obj.getType() == 1) {
                return null;
            }
            return obj.getText();
        }

        public final String getHeader() {
            ComboObj obj = (ComboObj)this.getEditor().getEditorComponent();
            return obj.getHeader();
        }

        public final Component getEditorText() {
            return ((ComboObj)this.getEditor().getEditorComponent()).getTextField();
        }

        public final Point getEditorLocation() {
            return ((AnComboEditor)this.getEditor()).getTextLocation();
        }

        public final void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src instanceof JTextField) {
                this.current_obj.setText(((JTextField)src).getText());
            }
        }

        private final class AnComboEditor
        implements ComboBoxEditor,
        FocusListener {
            private final ComboObj editor;
            private final JTextField text;

            public AnComboEditor() {
                this.editor = new ComboObj(0, true, "", "", true);
                this.editor.setBorder(null);
                this.text = this.editor.getTextField();
                this.text.addFocusListener(this);
            }

            public Component getEditorComponent() {
                return this.editor;
            }

            public void setItem(Object anObject) {
                ComboObj obj = (ComboObj)anObject;
                if (obj != null) {
                    AnComboBox.this.current_obj = obj;
                    int type = obj.getType();
                    if (type == 0) {
                        this.text.requestFocus();
                    }
                    this.editor.setType(type);
                    this.editor.setHeader(obj.getHeader());
                    this.editor.setText(obj.getText());
                }
            }

            public Object getItem() {
                return this.editor;
            }

            public Point getTextLocation() {
                return this.text.getLocationOnScreen();
            }

            public void selectAll() {
                this.editor.selectAll();
            }

            public void addActionListener(ActionListener l) {
                this.editor.addActionListener(l);
            }

            public void removeActionListener(ActionListener l) {
                this.editor.removeActionListener(l);
            }

            public void focusLost(FocusEvent event) {
                if (event.isTemporary()) {
                    return;
                }
                if (AnComboBox.this.current_obj.changable) {
                    AnComboBox.this.current_obj.setText(this.text.getText());
                } else {
                    this.text.setText(AnComboBox.this.current_obj.getText());
                }
            }

            public void focusGained(FocusEvent event) {
            }
        }

        private final class AnComboRenderer
        extends DefaultListCellRenderer {
            private AnComboRenderer() {
            }

            public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ComboObj obj = (ComboObj)value;
                if (isSelected) {
                    obj.setBackground(list.getSelectionBackground());
                    obj.setForeground(list.getSelectionForeground());
                } else {
                    obj.setBackground(list.getBackground());
                    obj.setForeground(list.getForeground());
                }
                return obj;
            }
        }

        private final class ComboObj
        extends JPanel {
            private final boolean editor;
            private final boolean changable;
            private int type;
            private String header;
            private final JLabel label;
            private final JTextField text;

            public ComboObj(int type, boolean editor, String header, String str, boolean changable) {
                this.editor = editor;
                this.type = type;
                this.header = header;
                this.changable = changable;
                BoxLayout layout = new BoxLayout(this, 0);
                this.setLayout(layout);
                this.setBorder(new EmptyBorder(0, 1, 0, 0));
                this.label = new CLabel(header, 2);
                AccessibleContext context = this.label.getAccessibleContext();
                context.setAccessibleName(header);
                context.setAccessibleDescription(header);
                this.text = new JTextField(type == 0 ? AnComboBox.this.width : 0);
                this.text.setFont(text_font);
                this.text.setBorder(null);
                this.add(this.label);
                this.add(this.text);
                this.setText(str);
                layout.layoutContainer(this);
            }

            public final int getType() {
                return this.type;
            }

            public final void setType(int type) {
                this.type = type;
            }

            public final String getHeader() {
                return this.header;
            }

            public final void setHeader(String header) {
                this.header = header;
                this.label.setText(header);
            }

            public final String getText() {
                return this.text.getText();
            }

            public final void setText(String str) {
                this.text.setText(str);
                this.text.setEditable(this.editor && this.type == 0);
            }

            public final JTextField getTextField() {
                return this.text;
            }

            public final void selectAll() {
                this.text.selectAll();
                this.text.requestFocus();
            }

            public void addActionListener(ActionListener l) {
                this.text.addActionListener(l);
            }

            public final void removeActionListener(ActionListener l) {
                this.text.removeActionListener(l);
            }

            public final void setBackground(Color bg) {
                super.setBackground(bg);
                if (this.text != null) {
                    this.text.setBackground(bg);
                }
                if (this.label != null) {
                    this.label.setBackground(bg);
                }
            }

            public final void setForeground(Color fg) {
                super.setForeground(fg);
                if (this.text != null) {
                    this.text.setForeground(fg);
                }
                if (this.label != null) {
                    this.label.setForeground(fg);
                }
            }
        }
    }

    public static class CText
    extends JTextField {
        int text_align = 1;

        public CText(String text, int columns, int alignment) {
            super(text, columns);
            this.setFont(text_font);
            this.setBackground(text_color);
            this.setEditable(false);
            this.setHorizontalAlignment(alignment);
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.setCaret(new DefaultCaret(this){
                private final /* synthetic */ CText this$0;
                {
                    this.this$0 = this$0;
                }

                public void focusGained(FocusEvent event) {
                    if (this.getComponent().isEnabled()) {
                        this.setVisible(true);
                    }
                    this.setSelectionVisible(true);
                    if (this.this$0.text_align == 1) {
                        this.setDot(this.this$0.getDocument().getLength());
                        this.moveDot(0);
                    } else {
                        this.setDot(0);
                        this.moveDot(this.this$0.getDocument().getLength());
                    }
                }

                public void focusLost(FocusEvent event) {
                    super.focusLost(event);
                    this.setDot(this.this$0.text_align == 1 ? 0 : this.this$0.getDocument().getLength());
                }
            });
        }

        public final void setVisibleAlign(int text_align, boolean delay) {
            this.text_align = text_align;
            if (delay) {
                this.setCaretPosition(text_align == 1 ? 0 : this.getDocument().getLength());
            } else {
                BoundedRangeModel visibility = this.getHorizontalVisibility();
                visibility.setValue(text_align == 1 ? visibility.getMinimum() : visibility.getMaximum());
            }
        }
    }

    public static final class CList
    extends JPanel {
        private final boolean resizable;
        private final JPanel label;
        private final JPanel value;

        public CList(boolean resizable) {
            this.resizable = resizable;
            this.label = new JPanel();
            this.label.setLayout(new BoxLayout(this.label, 1));
            this.value = new JPanel();
            this.value.setLayout(new BoxLayout(this.value, 1));
            if (resizable) {
                this.setLayout(new BorderLayout());
                this.add((Component)this.label, "West");
                this.add((Component)this.value, "Center");
            } else {
                this.add(this.label);
                this.add(this.value);
            }
        }

        public JComponent addLabel(JComponent item) {
            return (JComponent)this.label.add(item != null ? item : new JPanel());
        }

        public JComponent addValue(JComponent item) {
            return (JComponent)this.value.add(item != null ? item : new JPanel());
        }

        public void add(JComponent litem, JComponent vitem) {
            this.setAlignmentY(this.addLabel(litem), this.addValue(vitem));
        }

        public void setAlignmentY(JComponent litem, JComponent vitem) {
            Dimension msize;
            Dimension lsize = new Dimension(litem.getPreferredSize());
            Dimension vsize = new Dimension(vitem.getPreferredSize());
            if (lsize.height < vsize.height) {
                lsize.height = vsize.height;
            } else {
                vsize.height = lsize.height;
            }
            if (this.resizable) {
                msize = litem.getMaximumSize();
                msize.height = lsize.height;
                litem.setMaximumSize(msize);
            } else {
                litem.setMaximumSize(new Dimension(lsize));
            }
            litem.setMinimumSize(new Dimension(lsize));
            litem.setPreferredSize(new Dimension(lsize));
            if (this.resizable) {
                msize = vitem.getMaximumSize();
                msize.height = vsize.height;
                vitem.setMaximumSize(msize);
            } else {
                vitem.setMaximumSize(new Dimension(vsize));
            }
            vitem.setMinimumSize(new Dimension(vsize));
            vitem.setPreferredSize(new Dimension(vsize));
        }

        public void setAlignmentY() {
            Component[] labels = this.label.getComponents();
            Component[] values = this.value.getComponents();
            int size = Math.min(labels.length, values.length);
            for (int i = 0; i < size; ++i) {
                this.setAlignmentY((JComponent)labels[i], (JComponent)values[i]);
            }
        }

        public void setAlignmentX(Component[] items) {
            int i;
            int size = items.length;
            int max_width = 0;
            for (i = 0; i < size; ++i) {
                int width = items[i].getPreferredSize().width;
                if (max_width >= width) continue;
                max_width = width;
            }
            for (i = 0; i < size; ++i) {
                Dimension psize = items[i].getPreferredSize();
                psize.width = max_width;
                ((JComponent)items[i]).setPreferredSize(psize);
            }
        }

        public void setAlignmentX() {
            this.setAlignmentX(this.value.getComponents());
        }

        public void removeAll() {
            this.label.removeAll();
            this.value.removeAll();
        }
    }

    public static final class CLabel
    extends JLabel {
        public CLabel(String text, int alignment) {
            super(text, alignment);
            float falignment = alignment == 4 ? 1.0f : (alignment == 2 ? 0.0f : 0.5f);
            this.setAlignmentX(falignment);
            this.setForeground(LABEL_COLOR);
            this.setBorder(labelBorder);
        }
    }
}

