/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.CollectUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public abstract class CollectPanel
extends JPanel {
    private static final int CEXP_NA = 0;
    private static final int CEXP_TARGET = 1;
    private static final int CEXP_NAME = 2;
    private static final int CEXP_DIR = 3;
    private static final int CEXP_GROUP = 4;
    private static final int CEXP_WORK = 5;
    private static final int CEXP_LNCH = 6;
    private static final int CEXP_ENV = 7;
    protected static String CSTR_TARGET;
    protected static String CSTR_DIR;
    protected static String CSTR_GROUP;
    protected static String CSTR_WORK;
    protected static String CSTR_TARGET_JDK;
    public TargetJDK target_jdk;
    public CollectExp target;
    public CollectExp args;
    public CollectExp exp_name;
    public CollectExp exp_dir;
    public CollectExp exp_group;
    public CollectExp work_dir;
    public CollectExp env_vars;
    public CollectExp launcher;
    public CollectExp vm_args;
    public CollectData descendant;
    public CollectData pause_sig;
    public CollectData sample_sig;
    public CollectData exp_limit;
    public CollectData arch_exp;
    public CollectData clock_prof;
    public CollectData sync_trace;
    public CollectData hwc1_prof;
    public CollectData hwc1_val;
    public CollectData dspace_hwc1;
    public CollectData hwc2_prof;
    public CollectData hwc2_val;
    public CollectData dspace_hwc2;
    public CollectData heap_trace;
    public CollectData mpi_trace;
    public CollectData jvm_prof;
    public CollectData sample;
    public CollectData dbxsample;
    public CollectData ctr_attr;
    public CollectData reg_alloc;
    public JTextField preview_cmd;
    public JScrollPane work_panel;
    public JTabbedPane tab_pane;
    public JRadioButton startPaused;
    public JRadioButton startResumed;
    public Vector sel_counters;
    public Vector sel_attr;
    public JList hwc_list;
    public JList attr_list;
    public JButton updateButton;
    public JButton cancelButton;
    public JPanel buttonPanel;
    public static boolean attr_warn;
    private JButton selbutton;
    private JButton showButton;
    private JButton remAttr;
    private JButton addAttr;
    private JButton modAttr;
    private JButton ubutton;
    private JButton dbutton;
    private JLabel counter_label;
    private JLabel attribute_label;
    private JPanel hwc_panel;
    private JScrollPane hwclist_scroll;
    private JScrollPane attrlist_scroll;
    private final String[][] arch_data = new String[][]{{this.getLocaleStr("On"), this.getLocaleStr("Off"), this.getLocaleStr("Copy")}, {"on", "off", "copy"}};
    private final String[][] desc_data = new String[][]{{this.getLocaleStr("Off"), this.getLocaleStr("On"), this.getLocaleStr("All")}, {"off", "on", "all"}};
    private final String[][] sig_data = new String[][]{{this.getLocaleStr("Off"), "USR1", "USR2", "PROF", this.getLocaleStr("Custom")}, {"off", "USR1", "USR2", "PROF", "USR1"}};
    private final String[][] clock_data = new String[][]{{this.getLocaleStr("Normal"), this.getLocaleStr("High"), this.getLocaleStr("Low"), this.getLocaleStr("Custom")}, {"on", "high", "low", "10"}};
    private final String[][] hwc_data = new String[][]{{this.getLocaleStr("Normal"), this.getLocaleStr("High"), this.getLocaleStr("Low"), this.getLocaleStr("Custom")}, {"on", "high", "low", "9999991"}};
    private final String[][] sync_data = new String[][]{{this.getLocaleStr("Calibrate"), this.getLocaleStr("All"), this.getLocaleStr("Custom")}, {"calibrate", "all", "0"}};
    private final String[][] samp_data = new String[][]{{this.getLocaleStr("Normal"), this.getLocaleStr("Custom")}, {"on", "1"}};
    private final String[][] limit_data = new String[][]{{this.getLocaleStr("Default"), this.getLocaleStr("Unlimited"), this.getLocaleStr("Custom")}, {this.getLocaleStr("default"), "none", ""}};
    private final String[][] hwc_dsp_data = new String[][]{{this.getLocaleStr("Off"), this.getLocaleStr("On")}, {"off", "on"}};
    private static String[][] hwc_name;
    private static String[][] hwc_reg_data;
    private static String[][] reg_data;
    private static String[][] hwc_att_data;
    private final ArrayList data_list;
    private final ArrayList left_list;
    private static boolean in_dbx;
    private final ActionListener actlisten;
    private String[] alist;
    private String[][] hw_type;

    public abstract String getLocaleStr(String var1);

    public abstract char getLocaleStr(char var1, String var2);

    public abstract String CGetExpName(String var1);

    public abstract String CGetCurDir();

    public abstract String[][] getHwCounters();

    public abstract ImageIcon get_brwsicon();

    public abstract void showError(String var1);

    public abstract String getenv(String var1);

    public abstract int getTargetType(String var1);

    public abstract Component getOutputPane();

    public abstract void updateTitle(String var1);

    public CollectPanel(boolean indbx, String[][] hwlist, String[][] hwtype, String[][] reglist, String[] atr_list, ActionListener listen) {
        CSTR_TARGET = this.getLocaleStr("Target");
        CSTR_DIR = this.getLocaleStr("Experiment Directory");
        CSTR_GROUP = this.getLocaleStr("Experiment Group");
        CSTR_WORK = this.getLocaleStr("Working Directory");
        CSTR_TARGET_JDK = this.getLocaleStr("Target JDK");
        in_dbx = indbx;
        this.data_list = new ArrayList();
        this.left_list = new ArrayList();
        this.actlisten = listen;
        hwc_name = hwlist;
        this.hw_type = hwtype;
        reg_data = reglist;
        this.alist = atr_list;
        if (hwc_name[0].length != 0) {
            hwc_reg_data = this.setRegData(hwc_name[0][0]);
            this.initAttrList();
        }
        this.initComponents();
    }

    private void initAttrList() {
        if (this.alist == null || this.alist[0] == null) {
            hwc_att_data = new String[2][1];
            CollectPanel.hwc_att_data[0][0] = this.getLocaleStr("None");
            CollectPanel.hwc_att_data[1][0] = "0";
            return;
        }
        hwc_att_data = new String[2][this.alist.length];
        CollectPanel.hwc_att_data[0] = this.alist;
        for (int i = 0; i < hwc_att_data[0].length; ++i) {
            CollectPanel.hwc_att_data[1][i] = "0";
        }
    }

    private String[][] setRegData(String hwname) {
        String[] regis = null;
        for (int k = 0; k < hwc_name[0].length; ++k) {
            if (!hwc_name[0][k].equals(hwname)) continue;
            if (reg_data == null) {
                regis = new String[]{"-1"};
                break;
            }
            regis = reg_data[k];
            break;
        }
        int ct = 0;
        while (!regis[ct].equals("-1")) {
            ++ct;
        }
        int count = ct + 1;
        String[][] reg_data = new String[2][count];
        reg_data[0][0] = this.getLocaleStr("None");
        reg_data[1][0] = "None";
        for (int i = 1; i < count; ++i) {
            reg_data[0][i] = regis[i - 1];
            reg_data[1][i] = regis[i - 1];
        }
        if (this.reg_alloc != null && this.reg_alloc.combo != null) {
            this.reg_alloc.combo.setSelectedItem(this.getLocaleStr("None"));
            int max = this.reg_alloc.combo.getItemCount();
            for (int n = 1; n < max; ++n) {
                this.reg_alloc.combo.removeItemAt(1);
            }
            for (int k = 1; k < count; ++k) {
                this.reg_alloc.combo.addItem(reg_data[0][k]);
            }
        }
        return reg_data;
    }

    public JPanel setHwcPanel() {
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BoxLayout(basePanel, 1));
        JPanel hwcpanel = new JPanel(new FlowLayout(0));
        hwcpanel.setLayout(new BoxLayout(hwcpanel, 1));
        hwcpanel.setBorder(new EtchedBorder(1));
        hwcpanel.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Counter Selection"));
        hwcpanel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.hwc2_prof = new CollectData(this.hwc1_prof, '0', null, this.getLocaleStr('N', "MNEM_COUNTER"), this.getLocaleStr("Counter Name :"), hwc_name, 2, true, true);
        hwcpanel.add(this.hwc2_prof);
        hwcpanel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.hwc1_val = new CollectData(this.hwc2_prof, '0', null, this.getLocaleStr('O', "MNEM_COLLECTOR_OVERFLOW_VALUE"), this.getLocaleStr("Overflow Value :"), this.hwc_data, 2, true, true);
        hwcpanel.add(this.hwc1_val);
        hwcpanel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.dspace_hwc1 = new CollectData(this.hwc1_val, '0', null, this.getLocaleStr('H', "MNEM_COLLECTOR_DATA_SPACE_HWC"), this.getLocaleStr("HWC dataspace :"), this.hwc_dsp_data, 2, true, false);
        hwcpanel.add(this.dspace_hwc1);
        hwcpanel.add(Box.createRigidArea(new Dimension(4, 4)));
        if (hwc_name[0].length != 0) {
            hwc_reg_data = this.setRegData(hwc_name[0][0]);
        }
        this.reg_alloc = new CollectData(this.hwc1_val, '0', null, this.getLocaleStr('r', "MNEM_COLLECTOR_REG_ALLOC"), this.getLocaleStr("HWC register :"), hwc_reg_data, 2, true, false);
        hwcpanel.add(this.reg_alloc);
        hwcpanel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.ctr_attr = new CollectData(this.hwc1_val, '0', null, this.getLocaleStr('t', "MNEM_COLLECTOR_COUNTER_ATTR"), this.getLocaleStr("Counter Attribute :"), hwc_att_data, 2, true, false);
        hwcpanel.add(this.ctr_attr);
        JPanel attr_base = new JPanel(new BorderLayout());
        attr_base.setBorder(new EmptyBorder(new Insets(1, 8, 1, 8)));
        JPanel btn_panel = new JPanel();
        this.addAttr = new JButton(this.getLocaleStr("Add Attribute"));
        this.addAttr.setMnemonic(this.getLocaleStr('A', "MNEM_COLLECTOR_ADD_ATTRIBUTE"));
        this.addAttr.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Add Attribute"));
        this.addAttr.addActionListener(this.actlisten);
        this.addAttr.setEnabled(false);
        btn_panel.add(this.addAttr);
        this.modAttr = new JButton(this.getLocaleStr("Modify Attribute"));
        this.modAttr.setMnemonic(this.getLocaleStr('f', "MNEM_COLLECTOR_MODIFY_ATTRIBUTE"));
        this.addAttr.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Modify Attribute"));
        this.modAttr.addActionListener(this.actlisten);
        this.remAttr = new JButton(this.getLocaleStr("Delete Attribute"));
        this.remAttr.setMnemonic(this.getLocaleStr('R', "MNEM_COLLECTOR_DELETE_ATTRIBUTE"));
        this.addAttr.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Delete Attribute"));
        this.remAttr.addActionListener(this.actlisten);
        btn_panel.add(this.remAttr);
        hwcpanel.add(btn_panel);
        this.attribute_label = new JLabel(this.getLocaleStr("Selected Attributes:"));
        this.attribute_label.setAlignmentX(0.0f);
        attr_base.add((Component)this.attribute_label, "North");
        this.sel_attr = new Vector();
        this.attr_list = new JList(this.sel_attr);
        this.attr_list.getAccessibleContext().setAccessibleName(this.getLocaleStr("Attribute Selection"));
        this.attr_list.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Attribute Selection"));
        this.attrlist_scroll = new JScrollPane();
        this.attrlist_scroll.setViewportView(this.attr_list);
        Dimension newSize = new Dimension(hwcpanel.getPreferredSize().width - 600, 50);
        this.attrlist_scroll.setPreferredSize(newSize);
        attr_base.add((Component)this.attrlist_scroll, "Center");
        hwcpanel.add(attr_base);
        this.SetAttrButtons();
        this.SetAttributeCombo();
        this.buttonPanel = new JPanel();
        this.updateButton = new JButton(this.getLocaleStr("Update List"));
        this.updateButton.setMnemonic(this.getLocaleStr('U', "MNEM_COLLECTOR_UPDATE_LIST"));
        this.updateButton.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Update List"));
        this.updateButton.addActionListener(this.actlisten);
        this.cancelButton = new JButton(this.getLocaleStr("Cancel"));
        this.cancelButton.setMnemonic(this.getLocaleStr('C', "MNEM_COLLECTOR_CANCEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Cancel"));
        this.cancelButton.addActionListener(this.actlisten);
        basePanel.add(hwcpanel);
        this.buttonPanel.add(this.updateButton);
        this.buttonPanel.add(this.cancelButton);
        return basePanel;
    }

    private void initComponents() {
        this.tab_pane = new JTabbedPane();
        CollectUtility.CList list = new CollectUtility.CList(false);
        if (!in_dbx) {
            this.target = new CollectExp(1, list, "", this.getLocaleStr('T', "MNEM_COLLECTOR_TARGET"), CSTR_TARGET, true, '4');
            this.args = new CollectExp(0, list, "", this.getLocaleStr('A', "MNEM_COLLECTOR_ARGUMENTS"), this.getLocaleStr("Arguments"), false, '0');
        }
        this.exp_name = new CollectExp(2, list, this.CGetExpName(null), this.getLocaleStr('x', "MNEM_COLLECTOR_EXPERIMENT_NAME"), this.getLocaleStr("Experiment Name"), false, '0');
        this.exp_dir = new CollectExp(3, list, "", this.getLocaleStr('y', "MNEM_COLLECTOR_EXPERIMENT_DIR"), CSTR_DIR, true, '5');
        this.exp_group = new CollectExp(4, list, "", this.getLocaleStr('o', "MNEM_COLLECTOR_EXPERIMENT_GROUP"), CSTR_GROUP, true, '6');
        this.work_dir = new CollectExp(5, list, this.CGetCurDir(), this.getLocaleStr('W', "MNEM_COLLECTOR_WORKING_DIR"), CSTR_WORK, !in_dbx, '7');
        this.work_dir.setEditable(!in_dbx);
        if (!in_dbx) {
            this.env_vars = new CollectExp(7, list, "", this.getLocaleStr('V', "MNEM_COLLECTOR_ENVIRONMENT_VARIABLES"), this.getLocaleStr("Environment Variables"), false, '0');
            this.launcher = new CollectExp(6, list, "", this.getLocaleStr('n', "MNEM_COLLECTOR_LAUNCHER"), this.getLocaleStr("Launcher"), false, '0');
        }
        list.setAlignmentX();
        list.setAlignmentY();
        JPanel exp_panel = new JPanel();
        exp_panel.setLayout(new BoxLayout(exp_panel, 1));
        exp_panel.add(list);
        this.exp_limit = new CollectData(true, this.getLocaleStr('B', "MNEM_COLLECTOR_DATA_LIMIT_MB"), null, '0', this.getLocaleStr("Data Limit (MB):"), this.limit_data, 4, false);
        exp_panel.add(this.exp_limit);
        this.left_list.add(this.exp_limit);
        exp_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.arch_exp = new CollectData(true, this.getLocaleStr('i', "MNEM_COLLECTOR_ARCHIVED_COPIED"), null, '0', this.getLocaleStr("Archived/Copied into Experiment:"), this.arch_data, 4, false);
        exp_panel.add(this.arch_exp);
        exp_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.left_list.add(this.arch_exp);
        if (!in_dbx) {
            this.descendant = new CollectData(true, this.getLocaleStr('8', "MNEM_COLLECTOR_RECORD_ON_DESC_PROCESS_8"), null, '0', this.getLocaleStr("Record on Descendant Processes (8):"), this.desc_data, 4, false);
            exp_panel.add(this.descendant);
            exp_panel.add(Box.createRigidArea(new Dimension(4, 4)));
            this.left_list.add(this.descendant);
            this.pause_sig = new CollectData(true, this.getLocaleStr('l', "MNEM_COLLECTOR_SELECT_PAUSE_SIGNAL"), null, '0', this.getLocaleStr("Select Pause Signal:"), this.sig_data, 4, false);
            exp_panel.add(this.pause_sig);
            this.left_list.add(this.pause_sig);
            ButtonGroup group = new ButtonGroup();
            this.startPaused = new JRadioButton(this.getLocaleStr("Start Paused"), true);
            group.add(this.startPaused);
            this.startPaused.setMnemonic(this.getLocaleStr('d', "MNEM_COLLECTOR_START_PAUSED"));
            this.startResumed = new JRadioButton(this.getLocaleStr("Start Resumed"), false);
            group.add(this.startResumed);
            this.startResumed.setMnemonic(this.getLocaleStr('m', "MNEM_COLLECTOR_START_RESUMED"));
            JPanel bg_panel = new JPanel();
            bg_panel.add(this.startPaused);
            bg_panel.add(this.startResumed);
            this.startPaused.setEnabled(false);
            this.startResumed.setEnabled(false);
            this.pause_sig.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    boolean selected = !event.getItem().equals(CollectPanel.this.getLocaleStr("Off"));
                    CollectPanel.this.startPaused.setEnabled(selected);
                    CollectPanel.this.startResumed.setEnabled(selected);
                }
            });
            exp_panel.add(bg_panel);
            this.sample_sig = new CollectData(true, this.getLocaleStr('g', "MNEM_COLLECTOR_SELECT_SAMPLE_SIGNAL"), null, '0', this.getLocaleStr("Select Sample Signal:"), this.sig_data, 4, false);
            exp_panel.add(this.sample_sig);
            exp_panel.add(Box.createRigidArea(new Dimension(4, 4)));
            this.left_list.add(this.sample_sig);
            this.sample_sig.setAlignmentX(this.left_list);
        } else {
            this.arch_exp.setAlignmentX(this.left_list);
        }
        JPanel data_panel = new JPanel();
        data_panel.setLayout(new BoxLayout(data_panel, 1));
        data_panel.setBorder(new EmptyBorder(5, 5, 0, 0));
        data_panel.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Data to Collect"));
        this.clock_prof = new CollectData(true, this.getLocaleStr('k', "MNEM_COLLECTOR_CLOCK_BASED_PROF"), this.getLocaleStr("Clock-based Profiling"), this.getLocaleStr('i', "MNEM_COLLECTOR_PROFILING_INTERVAL"), this.getLocaleStr("Profiling Interval (ms.):"), this.clock_data, 4, true);
        data_panel.add(this.clock_prof);
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.sync_trace = new CollectData(false, this.getLocaleStr('z', "MNEM_COLLECTOR_SYNC_WAIT_TRACING"), this.getLocaleStr("Synchronization Wait Tracing"), this.getLocaleStr('y', "MNEM_COLLECTOR_MINIMUM_DELAY"), this.getLocaleStr("Minimum Delay (ms.):"), this.sync_data, 4, true);
        data_panel.add(this.sync_trace);
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.hwc1_prof = new CollectData(false, this.getLocaleStr('a', "MNEM_COLLECTOR_HW_COUNTER_OVFL_PROF_1"), this.getLocaleStr("Hardware Counter Overflow Profiling"), '0', null, null, 2, true);
        data_panel.add(this.hwc1_prof);
        if (hwc_name[0].length == 0) {
            this.hwc1_prof.check.setEnabled(false);
        }
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.initHwcPanel(data_panel);
        final boolean hwc1_available = this.hwc1_prof.check.isEnabled();
        this.hwc1_prof.check.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                boolean selected = ((JCheckBox)event.getItem()).isSelected();
                if (hwc1_available) {
                    CollectPanel.this.selbutton.setEnabled(selected);
                    CollectPanel.this.showButton.setEnabled(selected);
                    CollectPanel.this.SetButtons();
                }
            }
        });
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.sample = new CollectData(true, this.getLocaleStr('o', "MNEM_COLLECTOR_PERIODIC_SAMPLES"), this.getLocaleStr("Periodic Samples"), this.getLocaleStr('l', "MNEM_COLLECTOR_SAMPLE_INTERVAL"), this.getLocaleStr("Sample Interval (sec.):"), this.samp_data, 4, true);
        data_panel.add(this.sample);
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.heap_trace = new CollectData(false, this.getLocaleStr('g', "MNEM_COLLECTOR_HEAP_TRACING"), this.getLocaleStr("Heap Tracing"), '0', null, null, 4, true);
        data_panel.add(this.heap_trace);
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        this.mpi_trace = new CollectData(false, this.getLocaleStr('M', "MNEM_COLLECTOR_MPI_TRACING"), this.getLocaleStr("MPI Tracing"), '0', null, null, 4, true);
        data_panel.add(this.mpi_trace);
        data_panel.add(Box.createRigidArea(new Dimension(4, 4)));
        if (!in_dbx) {
            CollectUtility.CList list_jdk = new CollectUtility.CList(true);
            this.jvm_prof = new CollectData(false, this.getLocaleStr('J', "MNEM_COLLECTOR_JAVA_PROFILING"), this.getLocaleStr("Java Profiling"), '0', null, null, 4, false);
            data_panel.add(this.jvm_prof);
            this.target_jdk = new TargetJDK(list_jdk, this.jvm_prof, this.getLocaleStr('T', "MNEM_COLLECTOR_TARGET_JDK"), CSTR_TARGET_JDK, this.getLocaleStr('B', "MNEM_COLLECTOR_JDK_BROWSE"));
            this.vm_args = new CollectExp(0, list_jdk, "", this.getLocaleStr('V', "MNEM_COLLECTOR_JAVA_VM_PARAMETERS"), this.getLocaleStr("JVM parameters"), false, '0', 0);
            data_panel.add(Box.createRigidArea(new Dimension(0, 12)));
            this.vm_args.setEnabled(this.jvm_prof.isChecked());
            data_panel.add(list_jdk);
            Component[] comps = new Component[]{this.target_jdk, this.vm_args};
            list_jdk.setAlignmentX(comps);
        }
        if (in_dbx) {
            this.dbxsample = new CollectData(false, this.getLocaleStr('b', "MNEM_COLLECTOR_RECORD_WHEN_DBX_STOPS_PROCESS"), this.getLocaleStr("Record Sample When dbx Stops Process"), '0', null, null, 4, true);
            data_panel.add(this.dbxsample);
        }
        this.sample.setAlignmentX(this.data_list);
        this.tab_pane.add("1. " + this.getLocaleStr("Collect Experiment"), exp_panel);
        this.tab_pane.add("2. " + this.getLocaleStr("Data to Collect"), data_panel);
        JPanel cmd_panel = new JPanel(new BorderLayout());
        cmd_panel.add((Component)this.tab_pane, "Center");
        if (!in_dbx) {
            JButton button = new JButton(this.getLocaleStr("Preview Command:"));
            button.setMargin(CollectUtility.buttonMargin);
            button.setMnemonic(this.getLocaleStr('P', "MNEM_COLLECTOR_PREVIEW_COMMAND"));
            button.addActionListener(this.actlisten);
            button.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Preview Command:"));
            this.preview_cmd = new JTextField(40);
            this.preview_cmd.setEditable(false);
            this.preview_cmd.setBorder(new SoftBevelBorder(1));
            JPanel preview = new JPanel(new BorderLayout());
            preview.add((Component)button, "West");
            preview.add((Component)this.preview_cmd, "Center");
            cmd_panel.add((Component)preview, "South");
            this.tab_pane.add("3. " + this.getLocaleStr("Input/Output"), this.getOutputPane());
        }
        this.tab_pane.setVerifyInputWhenFocusTarget(false);
        for (int i = 0; i < this.tab_pane.getTabCount(); ++i) {
            this.tab_pane.setMnemonicAt(i, new Integer(i + 1).toString().charAt(0));
        }
        this.work_panel = new JScrollPane();
        this.work_panel.setViewportView(cmd_panel);
    }

    public void initHwcPanel(JPanel data_panel) {
        JPanel top_panel = new JPanel();
        this.selbutton = new JButton(this.getLocaleStr("Add Counters"));
        this.selbutton.setMnemonic(this.getLocaleStr('n', "MNEM_COLLECTOR_ADD_COUNTERS"));
        this.selbutton.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Add Counters"));
        this.selbutton.setEnabled(false);
        this.selbutton.addActionListener(this.actlisten);
        top_panel.add(this.selbutton);
        this.ubutton = new JButton(this.getLocaleStr("Modify"));
        this.ubutton.setMnemonic(this.getLocaleStr('f', "MNEM_COLLECTOR_MODIFY"));
        this.ubutton.addActionListener(this.actlisten);
        this.dbutton = new JButton(this.getLocaleStr("Delete"));
        this.dbutton.setMnemonic(this.getLocaleStr('D', "MNEM_COLLECTOR_DELETE"));
        this.dbutton.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Delete"));
        this.dbutton.addActionListener(this.actlisten);
        top_panel.add(this.dbutton);
        this.showButton = new JButton(this.getLocaleStr("Available Counters"));
        this.showButton.setMnemonic(this.getLocaleStr('b', "MNEM_COLLECTOR_AVAILABLE_COUNTERS"));
        this.showButton.getAccessibleContext().setAccessibleDescription(this.getLocaleStr("Available Counters"));
        this.showButton.setEnabled(false);
        this.showButton.addActionListener(this.actlisten);
        top_panel.add(this.showButton);
        data_panel.add(top_panel);
        this.sel_counters = new Vector();
        this.hwc_panel = new JPanel(new BorderLayout(10, 0));
        this.hwc_panel.setBorder(new EmptyBorder(new Insets(1, 8, 1, 8)));
        this.counter_label = new JLabel(this.getLocaleStr("Selected Counters:"));
        this.hwc_panel.add((Component)this.counter_label, "North");
        this.hwc_list = new JList(this.sel_counters);
        this.hwclist_scroll = new JScrollPane();
        this.hwclist_scroll.setViewportView(this.hwc_list);
        Dimension newSize = new Dimension(data_panel.getPreferredSize().width - 600, 70);
        this.hwclist_scroll.setPreferredSize(newSize);
        this.hwc_panel.add((Component)this.hwclist_scroll, "Center");
        data_panel.add(this.hwc_panel);
        this.SetButtons();
    }

    public void SetButtons() {
        if (this.sel_counters.size() == 0 || !this.hwc1_prof.check.isSelected()) {
            this.ubutton.setEnabled(false);
            this.dbutton.setEnabled(false);
            this.hwclist_scroll.setEnabled(false);
            this.counter_label.setEnabled(false);
        } else {
            this.hwc_list.setListData(this.sel_counters);
            this.hwc_list.setSelectedIndex(0);
            this.ubutton.setEnabled(true);
            this.dbutton.setEnabled(true);
            this.hwclist_scroll.setEnabled(true);
            this.counter_label.setEnabled(true);
        }
        this.hwclist_scroll.revalidate();
        this.hwclist_scroll.repaint();
    }

    public void SetAttrButtons() {
        if (this.sel_attr.size() == 0) {
            this.remAttr.setEnabled(false);
            this.modAttr.setEnabled(false);
            this.attrlist_scroll.setEnabled(false);
            this.attribute_label.setEnabled(false);
        } else {
            this.attr_list.setListData(this.sel_attr);
            this.attr_list.setSelectedIndex(0);
            this.remAttr.setEnabled(true);
            this.modAttr.setEnabled(true);
            this.attrlist_scroll.setEnabled(true);
            this.attribute_label.setEnabled(true);
        }
        this.attrlist_scroll.revalidate();
        this.attrlist_scroll.repaint();
    }

    public void SetAttributeCombo() {
        String select_ctr = (String)this.hwc2_prof.combo.getSelectedItem();
        if (!this.hasAttributes(select_ctr)) {
            this.sel_attr.removeAllElements();
            this.SetAttrButtons();
            attr_warn = false;
            this.ctr_attr.combo.setEnabled(false);
            this.addAttr.setEnabled(false);
            this.attrlist_scroll.setEnabled(false);
            this.ctr_attr.field.setEnabled(false);
        } else {
            String select_attr = (String)this.ctr_attr.combo.getSelectedItem();
            if (select_attr != null && select_attr.equals(this.getLocaleStr("None"))) {
                if (hwc_att_data[0].length == 1) {
                    this.ctr_attr.combo.setEnabled(false);
                } else {
                    this.ctr_attr.combo.setEnabled(true);
                }
                this.addAttr.setEnabled(false);
                this.attrlist_scroll.setEnabled(false);
                this.ctr_attr.field.setEnabled(false);
            } else {
                this.addAttr.setEnabled(true);
                this.ctr_attr.combo.setEnabled(true);
                this.attrlist_scroll.setEnabled(true);
                this.ctr_attr.field.setEnabled(true);
            }
        }
    }

    public boolean hasAttributes(String ctr_name) {
        if (hwc_att_data[0].length == 0) {
            return false;
        }
        if (this.hw_type == null) {
            return false;
        }
        for (int i = 0; i < this.hw_type[0].length; ++i) {
            if (!this.hw_type[0][i].equals(ctr_name) || !this.hw_type[1][i].equals("raw")) continue;
            return true;
        }
        return false;
    }

    public final void setVisible(boolean set) {
        super.setVisible(set);
        if (!set) {
            return;
        }
        if (!in_dbx) {
            this.target.setVisibleAlign(3, true);
        }
        this.exp_name.setVisibleAlign(3, true);
        this.exp_dir.setVisibleAlign(3, true);
        this.exp_group.setVisibleAlign(3, true);
        this.work_dir.setVisibleAlign(3, false);
    }

    static /* synthetic */ String[][] access$402(String[][] x0) {
        hwc_reg_data = x0;
        return x0;
    }

    public final class CollectData
    extends JPanel
    implements ItemListener {
        final JCheckBox check;
        final JButton button;
        JLabel text;
        JComboBox combo;
        JTextField field;
        final String[][] data;
        CollectData parent;
        CollectData child;
        String cust_val;
        boolean add_child_data;

        public CollectData(boolean set, char mnemonic, String title, char mnemonic_r, String label, String[][] data, int alignment, boolean do_align) {
            this.data = data;
            this.parent = null;
            this.child = null;
            this.button = null;
            this.add_child_data = false;
            this.setLayout(new FlowLayout(0, 4, 0));
            if (title != null) {
                this.check = new JCheckBox(title, set);
                this.check.setMargin(CollectUtility.buttonMargin);
                this.check.setMnemonic(mnemonic);
                this.check.getAccessibleContext().setAccessibleDescription(title);
                this.add(this.check);
            } else {
                this.check = null;
            }
            if (data != null) {
                this.setOption(set, mnemonic_r, label, alignment);
            }
            if (title == null) {
                this.text.setDisplayedMnemonic(mnemonic);
                this.text.setLabelFor(this.combo);
            } else if (this.text != null && this.combo != null) {
                this.text.setLabelFor(this.combo);
            }
            if (do_align) {
                CollectPanel.this.data_list.add(this);
            }
        }

        public CollectData(CollectData parent, char mnemonic, String title, char mnemonic_r, String label, String[][] data, int alignment, boolean do_align, boolean add_child_data) {
            this.data = data;
            this.parent = parent;
            this.child = null;
            parent.child = this;
            parent.add_child_data = add_child_data;
            this.check = parent.check;
            this.setLayout(new FlowLayout(0, 4, 0));
            if (title != null) {
                this.button = new JButton(title);
                this.button.setMargin(CollectUtility.buttonMargin);
                this.button.setMnemonic(mnemonic);
                this.button.addActionListener(CollectPanel.this.actlisten);
                this.button.getAccessibleContext().setAccessibleDescription(title);
                JPanel head_panel = new JPanel(new FlowLayout(1, 0, 0));
                head_panel.add(this.button);
                this.add(head_panel);
            } else {
                this.button = null;
                this.add(new JPanel());
            }
            this.setOption(this.check.isSelected(), mnemonic_r, label, alignment);
            if (do_align) {
                CollectPanel.this.data_list.add(this);
            }
        }

        public void setOption(boolean set, char mnemonic, String label, int alignment) {
            String init_val;
            String[] list;
            this.text = (JLabel)CollectUtility.getItem(label);
            this.add(this.text);
            this.text.getAccessibleContext().setAccessibleName(label);
            this.text.getAccessibleContext().setAccessibleDescription(label);
            this.text.setDisplayedMnemonic(mnemonic);
            if (this.data[0].length == 0) {
                this.check.setEnabled(false);
                this.text.setEnabled(false);
                set = false;
                list = new String[1];
                init_val = this.cust_val = CollectPanel.this.getLocaleStr("N/A");
                list[0] = this.cust_val;
            } else {
                list = this.data[0];
                if (this.data[1] == null) {
                    init_val = this.cust_val = this.data[0][0];
                } else if (this.parent != null && this.parent.data != null && this.parent.data[0].length == 0) {
                    if (this.button != null) {
                        this.button.setEnabled(false);
                    }
                    this.text.setEnabled(false);
                    init_val = this.cust_val = this.data[1][0];
                } else {
                    init_val = this.data[1][0];
                    this.cust_val = this.data[1][this.data[1].length - 1];
                }
            }
            this.combo = new JComboBox<String>(list);
            this.add(this.combo);
            this.field = new JTextField(init_val, 8);
            this.add(this.field);
            this.combo.setEnabled(set);
            JLabel lab = (JLabel)CollectUtility.getItem(label);
            lab.setLabelFor(this.combo);
            lab.getAccessibleContext().setAccessibleName(label);
            lab.getAccessibleContext().setAccessibleDescription(label);
            this.combo.getAccessibleContext().setAccessibleName(label);
            this.combo.getAccessibleContext().setAccessibleDescription(label);
            this.field.getAccessibleContext().setAccessibleName(label);
            this.field.getAccessibleContext().setAccessibleDescription(label);
            this.field.setEnabled(set && this.data[1] == null);
            this.field.setHorizontalAlignment(alignment);
            if (this.check != null) {
                this.check.addItemListener(this);
            }
            this.combo.addItemListener(this);
        }

        public String getValue() {
            if (this.check == null) {
                return this.field.getText();
            }
            if (!this.check.isSelected()) {
                return null;
            }
            if (this.field == null) {
                return "on";
            }
            String value = this.field.getText();
            if (this.child == null || !this.add_child_data) {
                return value;
            }
            return value + "," + this.child.getValue();
        }

        public boolean isChecked() {
            return this.check != null && this.check.isSelected();
        }

        public void setChecked(boolean checked) {
            if (this.check != null) {
                this.check.setSelected(checked);
            }
        }

        public void setCValue(boolean select, String info) {
            boolean update = false;
            if (this.check != null) {
                this.check.setSelected(select);
            }
            if (this.combo != null) {
                int size = this.data[0].length;
                for (int i = 0; i < size; ++i) {
                    if (!info.equals(this.data[1][i])) continue;
                    this.combo.setSelectedItem(this.data[0][i]);
                    update = true;
                    break;
                }
                if (!update) {
                    this.combo.setSelectedItem(CollectPanel.this.getLocaleStr("Custom"));
                }
            }
            if (this.field != null) {
                this.field.setText(info);
            }
        }

        public void itemStateChanged(ItemEvent event) {
            block10: {
                Object src;
                block8: {
                    int state;
                    block9: {
                        src = event.getSource();
                        if (src != this.check) break block8;
                        state = event.getStateChange();
                        if (state != 1) break block9;
                        this.combo.setEnabled(true);
                        String item = (String)this.combo.getSelectedItem();
                        this.field.setEnabled(this.data[1] == null || item.equals(CollectPanel.this.getLocaleStr("Custom")));
                        break block10;
                    }
                    if (state != 2) break block10;
                    this.combo.setEnabled(false);
                    this.field.setEnabled(false);
                    break block10;
                }
                if (src == this.combo) {
                    String item;
                    if (this.text.getText().equals(CollectPanel.this.getLocaleStr("Counter Attribute :"))) {
                        CollectPanel.this.SetAttributeCombo();
                        attr_warn = true;
                    }
                    if (this.text.getText().equals(CollectPanel.this.getLocaleStr("Counter Name :"))) {
                        String select_ctr = (String)CollectPanel.this.hwc2_prof.combo.getSelectedItem();
                        CollectPanel.this.SetAttributeCombo();
                        CollectPanel.access$402(CollectPanel.this.setRegData(select_ctr));
                    }
                    if (this.text.getText().equals(CollectPanel.this.getLocaleStr("HWC register :"))) {
                        this.field.setText((String)this.combo.getSelectedItem());
                    }
                    if ((item = (String)this.combo.getSelectedItem()).equals(CollectPanel.this.getLocaleStr("Custom"))) {
                        int sidx = this.combo.getSelectedIndex();
                        this.cust_val = this.data[1][sidx];
                    }
                    if ((item = (String)event.getItem()).equals(CollectPanel.this.getLocaleStr("Custom")) || this.text.getText().equals(CollectPanel.this.getLocaleStr("Counter Attribute :"))) {
                        this.field.setEnabled(true);
                        this.field.setText(this.cust_val);
                        return;
                    }
                    if (this.data[1] == null) {
                        this.field.setText(item);
                        return;
                    }
                    this.field.setEnabled(false);
                    int size = this.data[0].length;
                    for (int i = 0; i < size; ++i) {
                        if (!item.equals(this.data[0][i])) continue;
                        this.field.setText(this.data[1][i]);
                        break;
                    }
                }
            }
        }

        public void setAlignmentX(ArrayList data_list) {
            for (int i = 0; i < 4; ++i) {
                this.setAlignmentX(i, data_list);
            }
        }

        public void setAlignmentX(int index, ArrayList data_list) {
            JComponent cmp;
            CollectData cd;
            Iterator iter = data_list.iterator();
            int max_width = 0;
            while (iter.hasNext()) {
                cd = (CollectData)iter.next();
                if (index >= cd.getComponentCount()) continue;
                cmp = (JComponent)cd.getComponent(index);
                int width = cmp.getPreferredSize().width;
                if (max_width >= width) continue;
                max_width = width;
            }
            iter = data_list.iterator();
            while (iter.hasNext()) {
                cd = (CollectData)iter.next();
                if (index >= cd.getComponentCount()) continue;
                cmp = (JComponent)cd.getComponent(index);
                Dimension psize = cmp.getPreferredSize();
                psize.width = max_width;
                cmp.setPreferredSize(psize);
            }
        }
    }

    public final class CollectExp
    extends CollectUtility.CText
    implements FocusListener,
    CollectUtility.Browseable {
        final int type;
        String value;
        final JLabel item;
        final JPanel panel;

        public CollectExp(int type, CollectUtility.CList list, String value, char mnemonic, String label, boolean browser, char browser_mnem, int width) {
            super(value, width, 2);
            this.type = type;
            this.value = value;
            this.setEditable(true);
            this.addFocusListener(this);
            this.item = (JLabel)CollectUtility.getItem(label + ":");
            this.item.setDisplayedMnemonic(mnemonic);
            this.item.getAccessibleContext().setAccessibleName(label);
            this.item.getAccessibleContext().setAccessibleDescription(label);
            this.item.setLabelFor(this);
            this.panel = new JPanel(new FlowLayout(0));
            this.panel.add(this);
            if (browser) {
                JButton button = new JButton(CollectPanel.this.getLocaleStr("Browse") + '(' + browser_mnem + ')', CollectPanel.this.get_brwsicon());
                button.setMargin(CollectUtility.buttonMargin);
                button.addActionListener(CollectPanel.this.actlisten);
                button.setActionCommand(label);
                button.setToolTipText(CollectPanel.this.getLocaleStr("Browse..."));
                button.setMnemonic(browser_mnem);
                this.panel.add(button);
            }
            list.add(this.item, this.panel);
        }

        public CollectExp(int type, CollectUtility.CList list, String value, char mnemonic, String label, boolean browser, char browser_mnem) {
            this(type, list, value, mnemonic, label, browser, browser_mnem, 60);
        }

        public void setValue(String path) {
            if (this.checkValue(path)) {
                this.setText(path);
            }
        }

        public String getValue() {
            return this.getText();
        }

        public boolean checkValue(String path) {
            switch (this.type) {
                case 1: {
                    int targ_type = CollectPanel.this.getTargetType(path);
                    CollectPanel.this.jvm_prof.setChecked(targ_type == 1 || targ_type == 2);
                    CollectPanel.this.updateTitle(path);
                    break;
                }
                case 2: {
                    if (path.length() == 0 || path.endsWith(".er")) break;
                    CollectPanel.this.showError(CollectPanel.this.getLocaleStr("The experiment name must end in the string .er"));
                    return false;
                }
                case 3: {
                    if (!CollectPanel.this.exp_name.getValue().startsWith("test.")) break;
                    CollectPanel.this.exp_name.setText(CollectPanel.this.CGetExpName(path.length() == 0 ? "." : path));
                    break;
                }
                case 4: {
                    if (path.length() == 0 || path.endsWith(".erg")) break;
                    CollectPanel.this.showError(CollectPanel.this.getLocaleStr("The group name must end in the string .erg"));
                    return false;
                }
            }
            this.value = path;
            return true;
        }

        public void focusLost(FocusEvent event) {
            if (event.isTemporary()) {
                return;
            }
            if (!this.checkValue(this.getText())) {
                this.setText(this.value);
            }
        }

        public void focusGained(FocusEvent event) {
        }
    }

    public final class TargetJDK
    extends CollectUtility.AnComboBox
    implements CollectUtility.Browseable,
    ItemListener {
        final JPanel panel;
        final JCheckBox check;
        final JButton button;

        public TargetJDK(CollectUtility.CList list, CollectData cdata, char mnemonic, String label, char browser_mnem) {
            super(50);
            this.check = cdata.check;
            Vector<String> headers = new Vector<String>(6);
            headers.add(CollectPanel.this.getLocaleStr("Path:"));
            headers.add("$JDK_1_4_HOME");
            headers.add("$JDK_HOME");
            headers.add("$JAVA_PATH");
            headers.add(CollectPanel.this.getLocaleStr("Current JVM"));
            headers.add(CollectPanel.this.getLocaleStr("Default (PATH based)"));
            this.add(0, (String)headers.get(0), "", true);
            for (int i = 1; i < 6; ++i) {
                String str;
                String head = (String)headers.get(i);
                if (head.startsWith("$")) {
                    str = CollectPanel.this.getenv(head.substring(1));
                    if (str == null || str == "") continue;
                    head = head + ":";
                    this.add(0, head, str, false);
                    continue;
                }
                if (head.equals(CollectPanel.this.getLocaleStr("Current JVM"))) {
                    head = head + ":";
                    str = System.getProperty("java.home");
                    this.add(0, head, str, false);
                    continue;
                }
                if (!head.equals(CollectPanel.this.getLocaleStr("Default (PATH based)"))) continue;
                str = "";
                this.add(1, head, str, false);
            }
            this.setSelectedIndex(1);
            JLabel item = (JLabel)CollectUtility.getItem(label + ":");
            item.setDisplayedMnemonic(mnemonic);
            item.getAccessibleContext().setAccessibleName(label);
            item.getAccessibleContext().setAccessibleDescription(label);
            item.setLabelFor(this);
            this.panel = new JPanel(new FlowLayout(0));
            this.panel.add(this);
            this.button = new JButton(CollectPanel.this.getLocaleStr("Browse"), CollectPanel.this.get_brwsicon());
            this.button.setMnemonic(browser_mnem);
            this.button.setMargin(CollectUtility.buttonMargin);
            this.button.addActionListener(CollectPanel.this.actlisten);
            this.button.setActionCommand(label);
            this.button.setToolTipText(CollectPanel.this.getLocaleStr("Browse..."));
            this.button.setMnemonic(browser_mnem);
            this.panel.add(this.button);
            list.add(item, this.panel);
            if (this.check != null) {
                this.check.addItemListener(this);
            }
            this.button.setEnabled(cdata.isChecked());
            this.setEnabled(cdata.isChecked());
            this.setEditable(cdata.isChecked());
        }

        public void setValue(String path) {
            String java_bin = path + File.separatorChar + "bin" + File.separatorChar + "java";
            if (!new File(java_bin).exists()) {
                CollectPanel.this.showError(java_bin + CollectPanel.this.getLocaleStr(" doesnt't exist"));
            } else {
                this.setSelectedIndex(0);
                this.setText(path);
            }
        }

        public String getValue() {
            return this.getText();
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getSource() == this.check) {
                this.setEnabled(this.check.isSelected());
                this.setEditable(this.check.isSelected());
                this.button.setEnabled(this.check.isSelected());
                CollectPanel.this.vm_args.setEnabled(this.check.isSelected());
            }
        }
    }
}

