/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.ABundle;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class SelectFolderPanel
implements WizardDescriptor.Panel,
PropertyChangeListener,
FocusListener {
    private Node top;
    private String name;
    private String hint;
    private String prop;
    private boolean stripAmps;
    private static DataFolder menuFolder = null;
    private static DataFolder toolbarFolder = null;
    private static String propMenuFolder = "WizardData_menuFolder";
    private static String menuResource = "org/netbeans/core/resources/menu.gif";
    private static String toolbarResource = "org/netbeans/core/resources/toolbars.gif";
    private JTextArea hintsArea;
    private ExplorerPanel explorerPanel;
    private BeanTreeView treeView;
    private JPanel spacerPanel;
    private JLabel explorerLabel;
    private JPanel topPanel;
    private JPanel mainPanel;
    private final Set listeners = new HashSet(1);
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public SelectFolderPanel(String name, String hint, Node top, boolean stripAmps, String prop) {
        this.top = top;
        this.name = name;
        this.hint = hint;
        this.prop = prop;
        this.stripAmps = stripAmps;
    }

    private void expandNodes(FolderFilter ff) {
        Node[] nodes = ff.getFolderFilterNodes();
        for (int i = 0; i < nodes.length; ++i) {
            this.treeView.expandNode(nodes[i]);
            if (nodes[i].getChildren().getNodesCount() <= 0) continue;
            this.treeView.collapseNode(nodes[i]);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.topPanel = new JPanel();
        this.hintsArea = new JTextArea();
        this.spacerPanel = new JPanel();
        this.explorerLabel = new JLabel();
        if (this.prop.equals(propMenuFolder)) {
            this.mainPanel.getAccessibleContext().setAccessibleDescription(ABundle.getText("LBL_menuLabel"));
            this.explorerLabel.setText(ABundle.getText("LBL_menuLabel"));
            String menuLabelMnemonic = ABundle.getText("MNE_menuLabel");
            this.explorerLabel.setDisplayedMnemonic(menuLabelMnemonic.charAt(0));
        } else {
            this.mainPanel.getAccessibleContext().setAccessibleDescription(ABundle.getText("LBL_toolbarLabel"));
            this.explorerLabel.setText(ABundle.getText("LBL_toolbarLabel"));
            String toolbarLabelMnemonic = ABundle.getText("MNE_toolbarLabel");
            this.explorerLabel.setDisplayedMnemonic(toolbarLabelMnemonic.charAt(0));
        }
        this.explorerPanel = new ExplorerPanel();
        this.treeView = new BeanTreeView();
        this.explorerLabel.setLabelFor((Component)this.treeView);
        this.explorerPanel.add((Component)this.treeView, (Object)"Center");
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setEditable(false);
        this.hintsArea.setOpaque(false);
        this.hintsArea.setEnabled(false);
        this.hintsArea.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.hintsArea, "North");
        this.topPanel.add((Component)this.spacerPanel, "Center");
        this.topPanel.add((Component)this.explorerLabel, "South");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.topPanel, "North");
        this.mainPanel.add((Component)this.explorerPanel, "Center");
        this.treeView.getAccessibleContext().setAccessibleDescription(this.hintsArea.getText());
    }

    public Component getComponent() {
        if (this.mainPanel == null) {
            this.initComponents();
            this.mainPanel.setName(this.name);
            this.hintsArea.setText(this.hint);
            this.hintsArea.addFocusListener(this);
            this.hintsArea.setNextFocusableComponent((Component)this.treeView);
            FolderFilter ff = new FolderFilter(this.top, this.stripAmps, this.prop);
            this.explorerPanel.getExplorerManager().setRootContext((Node)ff);
            this.explorerPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            this.treeView.setPopupAllowed(false);
            this.treeView.setDefaultActionAllowed(false);
            this.treeView.setPreferredSize(new Dimension(400, 180));
            this.expandNodes(ff);
            ExplorerManager mgr = this.explorerPanel.getExplorerManager();
            try {
                mgr.setSelectedNodes(new Node[]{mgr.getRootContext()});
            }
            catch (PropertyVetoException pve) {
                ErrorManager.getDefault().notify((Throwable)pve);
            }
        }
        IpeUtils.requestFocus((Component)this.treeView);
        return this.mainPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("Debugging_custom_action");
    }

    public boolean isValid() {
        if (this.mainPanel != null) {
            if (this.prop.equals(propMenuFolder)) {
                return true;
            }
            Node[] nodes = this.explorerPanel.getExplorerManager().getSelectedNodes();
            return menuFolder != null || nodes.length == 1 && nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = SelectFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null && nodes[0] != this.explorerPanel.getExplorerManager().getRootContext();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        if (this.mainPanel != null) {
            DataFolder folder = null;
            Node[] nodes = this.explorerPanel.getExplorerManager().getSelectedNodes();
            if (nodes.length == 1 && nodes[0].getName().compareTo("Toolbars") != 0 && nodes[0].getName().compareTo("Menu") != 0) {
                folder = (DataFolder)nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = SelectFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (folder != null) {
                    ((WizardDescriptor)settings).putProperty(this.prop, (Object)folder);
                    if (this.prop.equals(propMenuFolder)) {
                        menuFolder = folder;
                    }
                }
            } else if (this.prop.equals(propMenuFolder)) {
                menuFolder = null;
            }
            ((WizardDescriptor)settings).putProperty(this.prop, folder);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.fireChangeEvent();
        }
    }

    public void focusGained(FocusEvent evt) {
        ((JTextArea)evt.getComponent()).selectAll();
    }

    public void focusLost(FocusEvent evt) {
        ((JTextArea)evt.getComponent()).setSelectionEnd(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class FolderFilterChildren
    extends FilterNode.Children {
        private final boolean stripAmps;
        private final String panelType;

        public FolderFilterChildren(Node orig, boolean stripAmps, String panel) {
            super(orig);
            this.stripAmps = stripAmps;
            this.panelType = panel;
        }

        protected Node[] createNodes(Object key) {
            Node child = (Node)key;
            if (child.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = SelectFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null) {
                return new Node[]{new FolderFilter(child, this.stripAmps, this.panelType)};
            }
            return new Node[0];
        }
    }

    private static final class FolderFilter
    extends FilterNode {
        private final boolean stripAmps;
        private final String panelType;
        private final Node[] nodes;

        public FolderFilter(Node orig, boolean stripAmps, String panel) {
            super(orig, (Children)new FolderFilterChildren(orig, stripAmps, panel));
            this.stripAmps = stripAmps;
            this.panelType = panel;
            this.nodes = this.getChildren().getNodes();
        }

        private Node[] getFolderFilterNodes() {
            return this.nodes;
        }

        public String getDisplayName() {
            int idx;
            String name = super.getDisplayName();
            if (this.stripAmps && (idx = name.indexOf(38)) != -1) {
                name = name.substring(0, idx) + name.substring(idx + 1);
            }
            return name;
        }

        public boolean canRename() {
            return false;
        }

        public Image getIcon(int type) {
            if (this.panelType.equals(propMenuFolder)) {
                return Utilities.loadImage((String)menuResource);
            }
            return Utilities.loadImage((String)toolbarResource);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }
}

