/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.ABundle;
import com.sun.tools.debugger.dbxgui.customactions.CAWizardDescriptor;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.awt.Dialog;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class NewDbxButtonAction
extends CallableSystemAction {
    private static String dot = ".";
    public static String fileExt = "dbxaction";
    private static String baseName = "DbxCustomAction_";
    private CAWizardDescriptor wiz = null;
    private Dialog dlg = null;

    public void performAction() {
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Start Custom Actions Wizard", null);
        }
        this.wiz = new CAWizardDescriptor();
        this.dlg = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wiz);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    NewDbxButtonAction.this.dlg.show();
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        if (this.wiz.getValue() == WizardDescriptor.FINISH_OPTION) {
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Custom Action was generated", null);
            }
            HashMap map = this.createPropertyMap(this.wiz);
            try {
                DataFolder toolbar;
                DataFolder menu = (DataFolder)this.wiz.getProperty("WizardData_menuFolder");
                if (menu != null) {
                    this.createNewCustomAction(map, menu);
                }
                if ((toolbar = (DataFolder)this.wiz.getProperty("WizardData_toolbarFolder")) != null) {
                    this.createNewCustomAction(map, toolbar);
                }
            }
            catch (IOException err) {
                ErrorManager.getDefault().notify((Throwable)err);
            }
        } else if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Custom Actions Wizard was cancelled", null);
        }
    }

    public HashMap createPropertyMap(CAWizardDescriptor wiz) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("WizardData_name", (String)wiz.getProperty("WizardData_name"));
        map.put("WizardData_tooltip", (String)wiz.getProperty("WizardData_tooltip"));
        map.put("WizardData_iconpath", (String)wiz.getProperty("WizardData_iconpath"));
        map.put("WizardData_script", (String)wiz.getProperty("WizardData_script"));
        return map;
    }

    private void createNewCustomAction(final HashMap map, DataFolder f) throws FileStateInvalidException, IOException {
        int counter = 1;
        String filename = null;
        final FileObject folder = f.getPrimaryFile();
        while (true) {
            FileSystem fs = folder.getFileSystem();
            filename = new String(baseName + counter);
            if (folder.getFileObject(filename, fileExt) == null) break;
            ++counter;
        }
        final FileObject[] caFile = new FileObject[1];
        final String filePrefix = new String(filename);
        String fname = new String(filePrefix + dot + fileExt);
        folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                caFile[0] = folder.createData(filePrefix, fileExt);
                FileLock lock = caFile[0].lock();
                try {
                    OutputStream os = caFile[0].getOutputStream(lock);
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    try {
                        oos.writeObject(map);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        });
    }

    public String getName() {
        return ABundle.getText("LBL_CAWizardAction");
    }

    protected String iconResource() {
        return "com/sun/tools/debugger/dbxgui/icons/NewDbxActions.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }
}

