/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.ABundle;
import com.sun.tools.debugger.dbxgui.icons.IpeIcons;
import java.io.File;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class IconChooser
extends JFileChooser
implements EnhancedCustomPropertyEditor {
    private static String dotGif = ".gif";
    private static String slash = "/";
    private HashMap map;
    private PropertyEnv propEnv = null;

    public IconChooser() {
        this.setFileView(new IconFileView());
        this.setFileFilter(new GifFilter());
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
    }

    public boolean accept(File file) {
        if (this.propEnv != null) {
            this.propEnv.setState(PropertyEnv.STATE_VALID);
        }
        if (file.isDirectory()) {
            return true;
        }
        return IpeIcons.hasGifExtension(file);
    }

    public void setMap(HashMap propMap) {
        this.map = propMap;
    }

    public void setPropertyEnv(PropertyEnv env) {
        this.propEnv = env;
    }

    public Object getPropertyValue() {
        String newValue = null;
        ((BasicFileChooserUI)this.getUI()).getApproveSelectionAction().actionPerformed(null);
        File file = this.getSelectedFile();
        if (file != null) {
            newValue = this.getCurrentDirectory() + slash + file.getName();
            if ((file.isDirectory() || !file.isFile()) && this.propEnv != null) {
                this.propEnv.setState(PropertyEnv.STATE_INVALID);
                newValue = (String)this.map.get("WizardData_iconpath");
            }
        } else {
            if (this.propEnv != null) {
                this.propEnv.setState(PropertyEnv.STATE_INVALID);
            }
            newValue = (String)this.map.get("WizardData_iconpath");
        }
        return newValue;
    }

    public class IconFileView
    extends FileView {
        public Icon getIcon(File file) {
            if (IconChooser.this.propEnv != null) {
                IconChooser.this.propEnv.setState(PropertyEnv.STATE_VALID);
            }
            if (IpeIcons.hasGifExtension(file)) {
                return new ImageIcon(file.getPath());
            }
            return null;
        }

        public String getTypeDescription(File file) {
            return ABundle.getText("LBL_GIFImages");
        }
    }

    public class GifFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return IpeIcons.hasGifExtension(file);
        }

        public String getDescription() {
            return ABundle.getText("LBL_GIFImages");
        }
    }
}

