/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.ABundle;
import java.io.File;
import javax.swing.JEditorPane;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class Command {
    private static String filename = "file";
    private static String location = "location";
    private static String selection = "selection";
    private static String space = " ";
    private static char leftBrace = (char)123;
    private static char rightBrace = (char)125;
    private static char eol = (char)10;
    private boolean hasColonPreceedingLocation = false;
    private boolean cmdParsed = false;
    private StringBuffer cmd = null;
    private JEditorPane[] editorPanes = null;
    private String currFile = null;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public Command(String origCmd) {
        this.cmd = new StringBuffer(origCmd);
        this.editorPanes = this.findEditorPanes();
        this.cmdParsed = this.findAndReplaceStringBuffer();
    }

    public String getCmd() {
        if (this.cmdParsed) {
            return this.cmd.toString();
        }
        return null;
    }

    public boolean cmdSuccessfullyParsed() {
        return this.cmdParsed;
    }

    private boolean findAndReplaceStringBuffer() {
        int leftPos = 0;
        int rightPos = 0;
        for (int i = 0; i < this.cmd.length(); ++i) {
            if (this.cmd.charAt(i) == leftBrace) {
                leftPos = i;
                continue;
            }
            if (this.cmd.charAt(i) != rightBrace) continue;
            rightPos = i;
            if (this.isFilename(leftPos + 1, rightPos)) {
                if (this.currFile != null) {
                    this.currFile = space + this.currFile;
                    this.cmd.replace(leftPos, rightPos + 1, this.currFile);
                    i = leftPos + this.currFile.length();
                    this.removeBlanksAfterFilename(i);
                    continue;
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ABundle.getText("MSG_NoFilename")));
                return false;
            }
            if (this.isLocation(leftPos + 1, rightPos)) {
                if (this.editorPanes != null) {
                    String currLocation = this.findLocation();
                    if (currLocation != null) {
                        int newLeftPos = this.removeBlanksPreceedingLocation(leftPos);
                        if (this.hasColonPreceedingLocation) {
                            currLocation = currLocation.substring(1);
                        }
                        this.cmd.replace(newLeftPos, rightPos + 1 - (leftPos - newLeftPos), currLocation);
                        i = newLeftPos + currLocation.length();
                        continue;
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ABundle.getText("MSG_NoLocation")));
                    return false;
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ABundle.getText("MSG_NoEditorPane")));
                return false;
            }
            if (!this.isSelection(leftPos + 1, rightPos)) continue;
            if (this.editorPanes != null) {
                String currSelection = this.findSelection();
                if (currSelection != null) {
                    this.cmd.replace(leftPos, rightPos + 1, currSelection);
                    i = leftPos + currSelection.length();
                    continue;
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ABundle.getText("MSG_NoSelection")));
                return false;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ABundle.getText("MSG_NoEditorPane")));
            return false;
        }
        return true;
    }

    private int removeBlanksPreceedingLocation(int startPos) {
        int countSpaces = -1;
        int colonLoc = 0;
        this.hasColonPreceedingLocation = false;
        for (int j = startPos - 1; j > 0; --j) {
            if (this.cmd.charAt(j) == ' ') {
                ++countSpaces;
                continue;
            }
            if (this.cmd.charAt(j) == ':') {
                this.hasColonPreceedingLocation = true;
                colonLoc = j;
                break;
            }
            return startPos;
        }
        if (countSpaces > -1 && colonLoc > 0) {
            this.cmd = this.cmd.delete(colonLoc + 1, startPos);
        }
        return colonLoc + 1;
    }

    private void removeBlanksAfterFilename(int startPos) {
        int countSpaces = -1;
        int colonLoc = 0;
        for (int j = startPos; j < this.cmd.length(); ++j) {
            if (this.cmd.charAt(j) == ' ') {
                ++countSpaces;
                continue;
            }
            if (this.cmd.charAt(j) == ':') {
                colonLoc = j;
                break;
            }
            return;
        }
        if (countSpaces > -1 && colonLoc > 0) {
            this.cmd = this.cmd.delete(startPos, colonLoc);
        }
    }

    private String findLocation() {
        int lineCounter = 1;
        int cursorPos = this.editorPanes[0].getCaretPosition();
        String text = this.editorPanes[0].getText();
        if (text.length() > 0) {
            for (int i = 0; i < cursorPos; ++i) {
                if (text.charAt(i) != eol) continue;
                ++lineCounter;
            }
            return space + Integer.toString(lineCounter) + space;
        }
        return null;
    }

    private String findSelection() {
        String text = this.editorPanes[0].getSelectedText();
        if (text == null || text.length() == 0) {
            return null;
        }
        return space + text + space;
    }

    private boolean isFilename(int left, int right) {
        String substring = this.cmd.substring(left, right).trim();
        return substring.equals(filename);
    }

    private boolean isLocation(int left, int right) {
        String substring = this.cmd.substring(left, right).trim();
        return substring.equals(location);
    }

    private boolean isSelection(int left, int right) {
        String substring = this.cmd.substring(left, right).trim();
        return substring.equals(selection);
    }

    private JEditorPane[] findEditorPanes() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                EditorCookie ec = (EditorCookie)nodes[i].getCookie(class$org$openide$cookies$EditorCookie == null ? Command.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
                if (ec == null) continue;
                this.editorPanes = ec.getOpenedPanes();
                DataObject dataObj = null;
                dataObj = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Command.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (dataObj == null) break;
                File f = FileUtil.toFile((FileObject)dataObj.getPrimaryFile());
                this.currFile = f.getAbsolutePath();
                break;
            }
        }
        return this.editorPanes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

