/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.CADataLoader;
import com.sun.tools.debugger.dbxgui.customactions.CADataNode;
import com.sun.tools.debugger.dbxgui.customactions.CustomAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class CADataObject
extends MultiDataObject
implements Serializable,
PropertyChangeListener {
    private static final long serialVersionUID = -5884496732335713660L;
    private HashMap map = new HashMap();
    private CustomAction caAction = null;
    private FileObject fileObj = null;
    private String fname = null;

    public CADataObject(FileObject file, CADataLoader loader) throws DataObjectExistsException {
        super(file, (MultiFileLoader)loader);
        this.fileObj = file;
        this.loadPropertyMap();
        CookieSet cookies = this.getCookieSet();
        this.caAction = new CustomAction(this.map);
        cookies.add((Node.Cookie)this.caAction);
        this.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertyMap() {
        InputStream in = null;
        try {
            in = this.fileObj.getInputStream();
            ObjectInputStream ois = new ObjectInputStream(in);
            this.map = (HashMap)ois.readObject();
        }
        catch (ClassNotFoundException noclass) {
            ErrorManager.getDefault().notify((Throwable)noclass);
        }
        catch (FileNotFoundException nofile) {
            ErrorManager.getDefault().notify((Throwable)nofile);
        }
        catch (IOException ioerr) {
            ErrorManager.getDefault().notify((Throwable)ioerr);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioerr) {
                ErrorManager.getDefault().notify((Throwable)ioerr);
            }
        }
    }

    public HashMap getPropertyMap() {
        return this.map;
    }

    public FileObject getFileObj() {
        return this.fileObj;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }

    protected Node createNodeDelegate() {
        return new CADataNode(this, this.caAction);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

