/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.ABundle;
import com.sun.tools.debugger.dbxgui.customactions.CADataObject;
import com.sun.tools.debugger.dbxgui.customactions.CAIconPropertySupport;
import com.sun.tools.debugger.dbxgui.customactions.CAPropertySupport;
import com.sun.tools.debugger.dbxgui.customactions.CustomAction;
import com.sun.tools.debugger.dbxgui.customactions.IconChooser;
import com.sun.tools.debugger.dbxgui.icons.IpeIcons;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class CADataNode
extends DataNode
implements PropertyChangeListener {
    private HashMap map = null;
    private FileObject fileObj = null;
    private CustomAction action = null;
    private CADataNode node = this;
    private IconChooser chooser = null;
    private PropertyEnv propEnv = null;
    private static String defaultIcon = IpeIcons.getIconPath() + "NewDbxActions.gif";
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public CADataNode(CADataObject dataObj, CustomAction action) {
        super((DataObject)dataObj, Children.LEAF);
        this.action = action;
        this.fileObj = dataObj.getFileObj();
        this.map = dataObj.getPropertyMap();
        this.addPropertyChangeListener(this);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CADataNode.this.updateDisplayName();
            }
        }, 500);
    }

    protected void updateDisplayName() {
        String name = (String)this.map.get("WizardData_name");
        this.setDisplayName(name);
        this.setName(name, false);
        this.setShortDescription((String)this.map.get("WizardData_tooltip"));
    }

    public Image getIcon(int type) {
        String iconPath = (String)this.map.get("WizardData_iconpath");
        if (iconPath != null) {
            if (IpeIcons.isForteIcon(iconPath)) {
                return Utilities.loadImage((String)iconPath);
            }
            File file = new File(iconPath);
            if (file.isFile() && IpeIcons.hasGifExtension(iconPath)) {
                return new ImageIcon(iconPath).getImage();
            }
        }
        this.map.put("WizardData_iconpath", defaultIcon);
        this.firePropertyChange("WizardData_iconpath", null, defaultIcon);
        return IpeIcons.findImage(defaultIcon);
    }

    protected HashMap getPropertyMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("WizardData_name")) {
            this.action.setMenuName((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("WizardData_tooltip")) {
            this.action.setToolbarTooltip((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("WizardData_iconpath")) {
            this.action.setComponentIcon((String)evt.getNewValue());
        } else if (!evt.getPropertyName().equals("WizardData_script")) {
            return;
        }
        this.map.put(evt.getPropertyName(), evt.getNewValue());
        try {
            FileLock lock = this.fileObj.lock();
            OutputStream os = this.fileObj.getOutputStream(lock);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            try {
                oos.writeObject(this.map);
            }
            finally {
                os.flush();
                os.close();
                lock.releaseLock();
            }
        }
        catch (IOException ioerr) {
            ErrorManager.getDefault().notify((Throwable)ioerr);
        }
        this.updateDisplayName();
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = CADataNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set props = Sheet.createPropertiesSet();
        props.put((Node.Property)new CAPropertySupport("WizardData_name", ABundle.getText("PROP_Name"), ABundle.getText("HINT_CustomActionName"), this.map, this.node));
        props.put((Node.Property)new CAPropertySupport("WizardData_script", ABundle.getText("PROP_Script"), ABundle.getText("HINT_Script"), this.map, this.node));
        props.put((Node.Property)new CAPropertySupport("WizardData_tooltip", ABundle.getText("PROP_tooltip"), ABundle.getText("HINT_tooltip"), this.map, this.node));
        props.put((Node.Property)new CAIconPropertySupport("WizardData_iconpath", ABundle.getText("PROP_iconPath"), ABundle.getText("HINT_iconPath"), this.map, this.node));
        sheet.put(props);
        sheet.addPropertyChangeListener((PropertyChangeListener)this);
        return sheet;
    }

    public void caFirePropertyChange(String prop, Object old, Object newVal) {
        this.firePropertyChange(prop, old, newVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

