/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.customactions;

import com.sun.tools.debugger.dbxgui.customactions.ABundle;
import com.sun.tools.debugger.dbxgui.customactions.IconChooser;
import com.sun.tools.debugger.dbxgui.icons.IpeIcons;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class ActionInfoPanel
implements WizardDescriptor.Panel,
FocusListener {
    private static final String slash = "/";
    private static final String space = " ";
    private static final String iconPath = IpeIcons.getIconPath();
    private String iconFilePath = null;
    private static String[] fileList;
    private static JFileChooser chooser;
    private int chooserValue = 1;
    private int initialIconCBoxCount = 0;
    private String mnemonic;
    private JPanel mainPanel = null;
    private JPanel nullPanel;
    private JTextArea infoHelpTA;
    private JLabel iconLabel;
    private JButton iconChooserBtn;
    private JTextField tooltipField;
    private JLabel tooltipLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JLabel infoHelpLabel;
    private JPanel iconButtonsPanel;
    private JComboBox iconCBox;
    private final Set listeners = new HashSet(1);

    private void initComponents() {
        this.infoHelpLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.tooltipLabel = new JLabel();
        this.tooltipField = new JTextField();
        this.iconLabel = new JLabel();
        this.iconButtonsPanel = new JPanel();
        this.iconCBox = new JComboBox();
        this.iconChooserBtn = new JButton();
        this.infoHelpTA = new JTextArea();
        this.nullPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.infoHelpLabel.setHorizontalTextPosition(2);
        this.infoHelpLabel.setText(ABundle.getText("FMT_infoHelpLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 17, 11);
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.infoHelpLabel, gridBagConstraints);
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(ABundle.getText("LBL_nameLabel"));
        this.mnemonic = ABundle.getText("MNE_nameLabel");
        this.nameLabel.setDisplayedMnemonic(this.mnemonic.charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setText(ABundle.getText("FMT_nameField"));
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ActionInfoPanel.this.keyReleasedHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.nameField, gridBagConstraints);
        this.tooltipLabel.setLabelFor(this.tooltipField);
        this.tooltipLabel.setText(ABundle.getText("LBL_tooltipLabel"));
        this.mnemonic = ABundle.getText("MNE_tooltipLabel");
        this.tooltipLabel.setDisplayedMnemonic(this.mnemonic.charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.mainPanel.add((Component)this.tooltipLabel, gridBagConstraints);
        this.tooltipField.setText(ABundle.getText("FMT_tooltipField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.tooltipField, gridBagConstraints);
        this.iconLabel.setLabelFor(this.iconCBox);
        this.iconLabel.setText(ABundle.getText("LBL_iconLabel"));
        this.mnemonic = ABundle.getText("MNE_iconLabel");
        this.iconLabel.setDisplayedMnemonic(this.mnemonic.charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 17, 12);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.iconLabel, gridBagConstraints);
        this.iconButtonsPanel.setLayout(new GridBagLayout());
        this.iconCBox.setMaximumRowCount(30);
        this.iconCBox.setToolTipText(ABundle.getText("HINT_iconCBox"));
        this.iconCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionInfoPanel.this.iconCBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        this.iconButtonsPanel.add((Component)this.iconCBox, gridBagConstraints);
        this.iconChooserBtn.setText(ABundle.getText("LBL_iconChooserBtn"));
        this.mnemonic = ABundle.getText("MNE_iconChooserBtn");
        this.iconChooserBtn.setMnemonic(this.mnemonic.charAt(0));
        this.iconChooserBtn.setToolTipText(ABundle.getText("HINT_iconChooserBtn"));
        this.iconChooserBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionInfoPanel.this.iconChooserBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.iconButtonsPanel.add((Component)this.iconChooserBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 17, 11);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.iconButtonsPanel, gridBagConstraints);
        this.infoHelpTA.setEditable(false);
        this.infoHelpTA.setLineWrap(true);
        this.infoHelpTA.setWrapStyleWord(true);
        this.infoHelpTA.setOpaque(false);
        this.infoHelpTA.setEnabled(false);
        this.infoHelpTA.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.infoHelpTA.setFont(UIManager.getFont("Label.font"));
        this.infoHelpTA.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        this.infoHelpTA.setRows(3);
        this.infoHelpTA.setColumns(30);
        this.infoHelpTA.setText(ABundle.getText("FMT_infoHelpTA"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.infoHelpTA, gridBagConstraints);
        this.nameField.getAccessibleContext().setAccessibleDescription(this.infoHelpTA.getText());
        this.tooltipField.getAccessibleContext().setAccessibleDescription(this.infoHelpTA.getText());
        this.iconCBox.getAccessibleContext().setAccessibleDescription(this.infoHelpTA.getText());
    }

    private void keyReleasedHandler(KeyEvent evt) {
        this.fireChangeEvent();
    }

    private void iconCBoxActionPerformed(ActionEvent evt) {
        int selectedIndex = this.iconCBox.getSelectedIndex();
        if (selectedIndex < this.initialIconCBoxCount) {
            this.iconFilePath = iconPath + fileList[selectedIndex];
        } else {
            ImageIcon icon = (ImageIcon)this.iconCBox.getItemAt(selectedIndex);
            this.iconFilePath = icon.getDescription();
        }
        this.iconCBox.requestFocus();
    }

    private void iconChooserBtnActionPerformed(ActionEvent evt) {
        if (chooser == null) {
            chooser = new IconChooser();
        }
        this.chooserValue = chooser.showOpenDialog(this.mainPanel);
        if (this.chooserValue == 0) {
            File file = chooser.getSelectedFile();
            this.iconFilePath = chooser.getCurrentDirectory() + slash + file.getName();
            this.iconCBox.addItem(new ImageIcon(this.iconFilePath, this.iconFilePath));
            int count = this.iconCBox.getItemCount();
            this.iconCBox.setSelectedIndex(count - 1);
        }
    }

    public static String getIconPath() {
        return iconPath;
    }

    private void initIconComboBox() {
        fileList = IpeIcons.getGifList();
        for (int i = 0; i < fileList.length; ++i) {
            ImageIcon icon = IpeIcons.findImageIcon(fileList[i]);
            if (icon == null) continue;
            this.iconCBox.addItem(icon);
        }
        this.initialIconCBoxCount = this.iconCBox.getItemCount();
        if (this.initialIconCBoxCount < 1) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ABundle.getText("MSG_NoComboBoxItems")));
            this.iconCBox.setVisible(false);
        } else {
            this.iconCBox.setSelectedIndex(0);
        }
    }

    public Component getComponent() {
        if (this.mainPanel == null) {
            this.initComponents();
            this.initIconComboBox();
            this.mainPanel.setName(ABundle.getText("LBL_step_2"));
            this.mainPanel.getAccessibleContext().setAccessibleDescription(ABundle.getText("FMT_infoHelpLabel"));
            this.nameField.addFocusListener(this);
            this.tooltipField.addFocusListener(this);
            this.infoHelpTA.addFocusListener(this);
            this.nameField.selectAll();
        }
        IpeUtils.requestFocus(this.nameField);
        return this.mainPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("Debugging_custom_action");
    }

    public boolean isValid() {
        if (this.mainPanel != null) {
            return !this.nameField.getText().equals(ABundle.getText("FMT_nameField")) && !this.nameField.getText().equals(space) && this.nameField.getText().length() != 0 && this.iconFilePath != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        if (this.mainPanel != null) {
            if (this.nameField != null) {
                ((WizardDescriptor)settings).putProperty("WizardData_name", (Object)this.nameField.getText().trim());
            }
            if (this.tooltipField != null) {
                ((WizardDescriptor)settings).putProperty("WizardData_tooltip", (Object)this.tooltipField.getText().trim());
            }
            if (this.iconFilePath != null) {
                ((WizardDescriptor)settings).putProperty("WizardData_iconpath", (Object)this.iconFilePath.trim());
            }
        }
    }

    public void focusGained(FocusEvent evt) {
        Component comp = evt.getComponent();
        if (comp == this.infoHelpTA) {
            ((JTextComponent)comp).selectAll();
        }
    }

    public void focusLost(FocusEvent evt) {
        ((JTextComponent)evt.getComponent()).setSelectionEnd(0);
    }

    static {
        chooser = null;
    }
}

