/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.utils;

import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class UnixRE {
    RE re;
    boolean starPattern;
    boolean debugRE = false;

    public UnixRE(String pattern) throws RESyntaxException {
        StringBuffer unixText = new StringBuffer(256);
        int prev = 0;
        if (Boolean.getBoolean("ifdef.debug.unixre") && pattern.startsWith("[[[")) {
            this.re = new RE(pattern.substring(3));
            return;
        }
        this.starPattern = pattern.charAt(0) == '*';
        unixText.append('^');
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*' && prev != 92) {
                unixText.append(".*");
            } else if (c == '?' && prev != 92) {
                unixText.append(".{1}");
            } else if (c == '.' && prev != 92) {
                unixText.append("\\.");
            } else {
                unixText.append(c);
            }
            prev = c;
        }
        unixText.append('$');
        this.re = new RE(unixText.toString());
    }

    public boolean match(String s) {
        if (this.starPattern && s.charAt(0) == '.') {
            return false;
        }
        return this.re.match(s);
    }

    public static boolean isUnixRE(String s) {
        int prev = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c == '*' || c == '?' || c == '[' || c == ']') && prev != 92) {
                return true;
            }
            prev = c;
        }
        return false;
    }
}

