/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.utils;

import java.awt.Component;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cpp.utils.UnixEnv;

public class IpeUtils {
    private static WeakReference wrEnv;
    public static final boolean IfdefDiagnostics;

    public static final String getDirName(String path) {
        int sep = path.lastIndexOf(File.separatorChar);
        if (sep != -1) {
            return path.substring(0, sep);
        }
        return null;
    }

    public static final String getBaseName(String path) {
        int sep = path.lastIndexOf(File.separatorChar);
        if (sep != -1) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public static final String getRelativePath(String base, String path) {
        String pstring;
        String bstring;
        File baseFile = new File(base);
        if (baseFile.exists()) {
            try {
                base = baseFile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (path.equals(base)) {
            return new String(path);
        }
        if (path.startsWith(base + File.separator)) {
            return new String(path.substring(base.length() + 1));
        }
        if (!path.startsWith(File.separator)) {
            return new String(path);
        }
        Object[] bnames = IpeUtils.getPathNameArray(base);
        Object[] pnames = IpeUtils.getPathNameArray(path);
        int match = 0;
        for (int i = 0; i < bnames.length && i < pnames.length && (bstring = new String(bnames[i].toString())).equals(pstring = new String(pnames[i].toString())); ++i) {
            ++match;
        }
        if (match > 1 && match == pnames.length && bnames.length > pnames.length) {
            StringBuffer s = new StringBuffer();
            for (int cnt = 0; cnt < bnames.length - match - 1; ++cnt) {
                s.append(".." + File.separator);
            }
            s.append("..");
            return s.toString();
        }
        if (match > 1) {
            StringBuffer s = new StringBuffer();
            for (int cnt = bnames.length - match; cnt > 0; --cnt) {
                s.append(".." + File.separator);
            }
            for (int i = match; i < pnames.length; ++i) {
                if (s.charAt(s.length() - 1) != File.separatorChar) {
                    s.append(File.separator);
                }
                s.append(pnames[i].toString());
            }
            return s.toString();
        }
        return new String(path);
    }

    private static final Object[] getPathNameArray(String path) {
        int pos = 1;
        ArrayList<String> l = new ArrayList<String>();
        if (path.startsWith(File.separator)) {
            while (pos > 0) {
                int next = path.indexOf(File.separatorChar, pos);
                if (next > 0) {
                    l.add(path.substring(pos, next));
                    pos = next + 1;
                    continue;
                }
                l.add(path.substring(pos));
                pos = -1;
            }
        }
        return l.toArray();
    }

    public static String expandPath(String filename) {
        int si;
        int max = filename.length();
        StringBuffer dp = new StringBuffer(256);
        for (si = 0; si < max && Character.isSpaceChar(filename.charAt(si)); ++si) {
        }
        if (si < max && filename.charAt(si) == '~' && si++ < max && (si == max || filename.charAt(si) == '/')) {
            dp.append(System.getProperty("user.home"));
        }
        while (si < max) {
            int endIndex;
            char c;
            if ((c = filename.charAt(si++)) == '\\' && si < max) {
                if (filename.charAt(si) == '$') {
                    dp.append('\\');
                    dp.append('$');
                    ++si;
                    continue;
                }
                dp.append(c);
                continue;
            }
            if (c == '$' && si < max && filename.charAt(si) == '(') {
                endIndex = filename.indexOf(41, si);
                dp.append('$');
                if (endIndex > -1) {
                    dp.append(filename.substring(si, endIndex));
                    si = endIndex;
                    continue;
                }
                dp.append(filename.substring(si));
                si = max;
                continue;
            }
            if (c == '$' && si < max) {
                boolean braces;
                boolean bl = braces = filename.charAt(si) == '{';
                if (braces) {
                    // empty if block
                }
                int beginIndex = ++si;
                while (si < max) {
                    char c2 = filename.charAt(si);
                    if (braces && c2 == '}' || !Character.isLetterOrDigit(c2) && c2 != '_') break;
                    ++si;
                }
                endIndex = si;
                if (si < max && braces) {
                    ++si;
                }
                if (endIndex > beginIndex) {
                    String value = IpeUtils.getenv(filename.substring(beginIndex, endIndex));
                    if (value != null) {
                        dp.append(value);
                        continue;
                    }
                    dp.append('$');
                    if (braces) {
                        dp.append('{');
                    }
                    dp.append(filename.substring(beginIndex, endIndex));
                    if (!braces) continue;
                    dp.append('}');
                    continue;
                }
                dp.append('$');
                if (!braces) continue;
                dp.append("{}");
                continue;
            }
            dp.append(c);
        }
        return dp.toString();
    }

    public static String getenv(String name) {
        return IpeUtils.getUnixEnv().getenv(name);
    }

    public static String valueOf(String name) {
        return IpeUtils.getenv(name);
    }

    public static String entryFor(String name) {
        return IpeUtils.getUnixEnv().entryFor(name);
    }

    public static void putenv(String entry) {
        IpeUtils.getUnixEnv().putenv(entry);
    }

    public static void setValueOf(String name, String value) {
        IpeUtils.getUnixEnv().setValueOf(name, value);
    }

    public static String[] environ() {
        return IpeUtils.getUnixEnv().environ();
    }

    public static void envDump() {
        IpeUtils.getUnixEnv().dump();
    }

    private static UnixEnv getUnixEnv() {
        UnixEnv env = wrEnv == null ? null : (UnixEnv)wrEnv.get();
        if (env == null) {
            env = new UnixEnv();
            wrEnv = new WeakReference<UnixEnv>(env);
        }
        return env;
    }

    public static String trimSlashes(String dir) {
        int trim = 0;
        for (int i = dir.length(); i > 0 && dir.charAt(i - 1) == File.separatorChar; --i) {
            ++trim;
        }
        if (trim > 0) {
            return dir.substring(0, dir.length() - trim);
        }
        return dir;
    }

    public static String trimpath(String dir) {
        return IpeUtils.trimSlashes(dir.trim());
    }

    public static void requestFocus(final Component c) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (c != null && c.getParent() != null) {
                    try {
                        c.requestFocus();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void setDefaultButton(final JRootPane rootPane, final JButton button) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (button != null && button.getParent() != null && button.isVisible()) {
                    try {
                        rootPane.setDefaultButton(button);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    static {
        IfdefDiagnostics = Boolean.getBoolean("ifdef.debug.diagnostics");
    }
}

