/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.StringTokenizer;
import org.netbeans.modules.cpp.utils.UnexpectedEOFException;

public class FortranReader {
    private PushbackInputStream in;
    private StringBuffer statement = new StringBuffer(256);
    private boolean freeFormat;
    private boolean preprocess;
    private boolean longLines;
    private StringBuffer sbuf = new StringBuffer();
    private byte curc = 0;
    private byte lastc;
    private byte qchar;
    private byte prevlastc;
    private int col;
    int lastcol = 0;
    private static final byte EOF = -1;
    private int lineno;
    private int lnum;
    private State state;
    private final State StartOfLine = new State("StartOfLine");
    private final State EndOfLine = new State("EndOfLine");
    private final State StartOfStatement = new State("StartOfStatement");
    private final State EndOfStatement = new State("EndOfStatement");
    private final State InStatement = new State("InStatement");
    private final State InComment = new State("InComment");
    private final State InQuote = new State("InQuote");
    private final State GotEOF = new State("GotEOF");
    private boolean verbose = false;

    public FortranReader(String file, String options, boolean verbose) throws FileNotFoundException {
        this.verbose = verbose;
        try {
            this.in = new PushbackInputStream(new FileInputStream(file), 1);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        this.lineno = 1;
        this.col = 0;
        this.state = this.StartOfLine;
        this.setModes(file, options);
    }

    public FortranReader(String file, String options) throws FileNotFoundException {
        this(file, options, false);
    }

    public String getStatement() throws UnexpectedEOFException {
        String stmnt;
        block10: {
            this.statement.delete(0, this.statement.length());
            while (true) {
                byte c;
                stmnt = null;
                if (this.state == this.StartOfLine) {
                    this.state = this.readStartOfLine();
                    this.lnum = this.lineno;
                    if (this.state != this.StartOfStatement || this.statement.length() <= 0 || (stmnt = this.statement.toString().trim()).length() <= 0) continue;
                    break block10;
                }
                if (this.state == this.EndOfLine) {
                    c = this.getc();
                    if (c != 10) continue;
                    this.state = this.StartOfLine;
                    continue;
                }
                if (this.state == this.StartOfStatement || this.state == this.InStatement) {
                    this.state = this.readStatement();
                    continue;
                }
                if (this.state == this.EndOfStatement) {
                    c = this.getc();
                    if (c != 59) continue;
                    this.state = this.StartOfStatement;
                    stmnt = this.statement.toString().trim();
                    continue;
                }
                if (this.state == this.InComment) {
                    this.state = this.readUntilEOL();
                    continue;
                }
                if (this.state == this.InQuote) {
                    this.state = this.continueQuote();
                    continue;
                }
                if (this.state == this.GotEOF) break;
            }
            if (this.curc == -1 && this.lastc == 10) {
                stmnt = this.statement.toString().trim();
                if (stmnt.length() <= 0) {
                    return null;
                }
            } else {
                throw new UnexpectedEOFException();
            }
        }
        return stmnt;
    }

    private State readStartOfLine() {
        byte c = this.getc();
        if (c == 33 || !this.freeFormat && this.isComment((char)c)) {
            String buf = this.getbytes(4);
            if (buf.equalsIgnoreCase("dir$")) {
                this.trimInput();
                buf = this.getbytes(5);
                if (buf.equalsIgnoreCase("fixed")) {
                    this.freeFormat = false;
                } else if (buf.length() >= 4 && buf.substring(0, 4).equalsIgnoreCase("free")) {
                    this.freeFormat = true;
                }
            }
            return this.InComment;
        }
        if (c == 10) {
            return this.state;
        }
        if (this.freeFormat) {
            this.ungetc(c);
            return this.nextState();
        }
        String buf = this.getbytes(5);
        if (buf.length() == 5 && this.isContinuation(buf.charAt(4))) {
            return this.InStatement;
        }
        return this.nextState();
    }

    private State nextState() {
        if (this.state == this.StartOfLine) {
            byte c;
            while ((c = this.getc()) != -1) {
                if (this.col > 132 || !this.freeFormat && !this.longLines && this.col > 72) {
                    return this.readUntilEOL();
                }
                if (this.isSpace((char)c)) continue;
                if (c == 33) {
                    return this.readUntilEOL();
                }
                if (c == 59) {
                    this.ungetc(c);
                    return this.EndOfStatement;
                }
                if (c == 10) {
                    this.ungetc(c);
                    return this.EndOfLine;
                }
                if (c == 39 || c == 34) {
                    return this.readQuote(c, true);
                }
                this.ungetc(c);
                return this.StartOfStatement;
            }
            return this.GotEOF;
        }
        return this.state;
    }

    private State readStatement() {
        byte c;
        while ((c = this.getc()) != -1) {
            if (this.freeFormat && this.col > 132 || !this.freeFormat && (this.col > 72 || this.longLines && this.col > 132)) {
                return this.readUntilEOL();
            }
            if (c == 10) {
                this.ungetc(c);
                return this.EndOfLine;
            }
            if (c == 39 || c == 34) {
                return this.readQuote(c, true);
            }
            if (this.freeFormat && c == 38) {
                this.ungetc(c);
                return this.EndOfLine;
            }
            if (c == 59) {
                this.ungetc(c);
                return this.EndOfStatement;
            }
            if (c == 32) continue;
            this.statement.append((char)c);
        }
        return this.GotEOF;
    }

    private State readQuote(byte qchar, boolean printQchar) {
        byte c;
        this.qchar = qchar;
        if (printQchar) {
            this.statement.append((char)qchar);
        }
        while ((c = this.getc()) != -1) {
            if (c == qchar && this.peekc() != qchar && this.lastc != qchar) {
                this.statement.append((char)c);
                return this.InStatement;
            }
            if (this.freeFormat && c == 38 && this.peekc() == 10) {
                return this.InQuote;
            }
            if (c == 10) {
                this.ungetc(c);
                return this.InQuote;
            }
            this.statement.append((char)c);
        }
        return this.GotEOF;
    }

    private State continueQuote() {
        byte c;
        if (this.freeFormat) {
            if (this.curc == 38 && this.peekc() == 10) {
                byte c2;
                this.getc();
                this.sbuf.delete(0, this.sbuf.length());
                while ((c2 = this.getc()) != -1) {
                    if (c2 == 32 || c2 == 9) {
                        this.sbuf.append(c2);
                        continue;
                    }
                    if (c2 == 38) {
                        return this.readQuote(this.qchar, false);
                    }
                    if (c2 == 33) {
                        this.readUntilEOL();
                        continue;
                    }
                    if (c2 == 10) {
                        this.statement.append(this.sbuf);
                        this.sbuf.delete(0, this.sbuf.length());
                        continue;
                    }
                    this.statement.append(this.sbuf);
                    this.ungetc(c2);
                    return this.readQuote(this.qchar, false);
                }
                return this.GotEOF;
            }
            if (this.curc == 10) {
                return this.readQuote(this.qchar, false);
            }
            this.readUntilEOL();
            return this.EndOfLine;
        }
        this.getc();
        while (true) {
            this.sbuf.delete(0, this.sbuf.length());
            while ((c = this.getc()) == 32 || c == 9) {
                this.sbuf.append(c);
            }
            if (this.col == 1 && (c == 67 || c == 42) || this.col < 6 && c == 33) {
                this.readUntilEOL();
                continue;
            }
            if (c == -1) {
                return this.GotEOF;
            }
            if (c == 10) continue;
            if (this.col == 6 && this.isContinuation((char)c)) {
                return this.readQuote(this.qchar, false);
            }
            if (this.col > 6) break;
        }
        this.statement.append(this.sbuf);
        this.statement.append((char)c);
        return this.readQuote(this.qchar, false);
    }

    private State readUntilEOL() {
        byte c;
        while ((c = this.getc()) != -1) {
            if (c != 10) continue;
            this.ungetc(c);
            return this.EndOfLine;
        }
        return this.GotEOF;
    }

    private void trimInput() {
        byte c;
        while ((c = this.getc()) == 32 || c == 9) {
        }
        this.ungetc(c);
    }

    private boolean isComment(char c) {
        return "cC!dD*".indexOf(c) != -1;
    }

    private boolean isSpace(char c) {
        return " \t".indexOf(c) != -1;
    }

    private boolean isContinuation(char c) {
        return "0 ".indexOf(c) == -1;
    }

    private String getbytes(int num) {
        if (num < 0) {
            return null;
        }
        this.sbuf.delete(0, this.sbuf.length());
        for (int i = 0; i < num; ++i) {
            byte c = this.getc();
            if (c == 10) {
                this.ungetc(c);
                break;
            }
            this.sbuf.append((char)c);
        }
        return this.sbuf.toString();
    }

    private byte getc() {
        if (this.curc == -1) {
            return -1;
        }
        try {
            this.prevlastc = this.lastc;
            this.lastc = this.curc;
            this.curc = (byte)(this.in.read() & 0xFF);
            if (this.curc == 10) {
                this.lastcol = this.col;
                ++this.lineno;
                this.col = 0;
            } else {
                if (this.curc == -1) {
                    return -1;
                }
                ++this.col;
            }
            return this.curc;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    private byte peekc() {
        byte nextc = this.getc();
        this.ungetc(nextc);
        return nextc;
    }

    private void ungetc(byte b) {
        if (b != -1) {
            if (b == 10) {
                --this.lineno;
                this.col = this.lastcol;
            } else {
                --this.col;
            }
            try {
                this.in.unread(b);
                this.curc = this.lastc;
                this.lastc = this.prevlastc;
                this.prevlastc = 0;
            }
            catch (IOException ex) {
                this.println("*** Unread too many bytes ***");
            }
        }
    }

    private void setModes(String file, String options) {
        int pos = file.lastIndexOf(46);
        if (pos >= 0) {
            String ext = file.substring(pos + 1);
            if (ext.equals("f90") || ext.equals("f95")) {
                this.freeFormat = true;
            } else if (ext.equals("F90") || ext.equals("F95")) {
                this.freeFormat = true;
                this.preprocess = true;
            } else if (ext.equals(".f") || ext.equals("for")) {
                this.freeFormat = false;
            } else if (ext.equals("F")) {
                this.freeFormat = false;
                this.preprocess = true;
            }
        }
        if (options != null && options.length() > 0) {
            StringTokenizer st = new StringTokenizer(options);
            while (st.hasMoreTokens()) {
                String opt = st.nextToken();
                if (opt.equals("-free")) {
                    this.freeFormat = true;
                    continue;
                }
                if (opt.equals("-fixed")) {
                    this.freeFormat = false;
                    continue;
                }
                if (opt.equals("-e")) {
                    this.longLines = true;
                    continue;
                }
                if (!opt.equals("-fpp")) continue;
                this.preprocess = true;
            }
        }
    }

    private void println(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        FortranReader fr = null;
        boolean verbose = false;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            file = args[i];
        }
        if (file == null) {
            file = "fwutil.f";
        }
        try {
            String line;
            fr = new FortranReader(file, null);
            fr.verbose = verbose;
            boolean i = false;
            while ((line = fr.getStatement()) != null) {
                int lineno = fr.lnum - 1;
                System.out.println(lineno + ": " + line);
            }
        }
        catch (UnexpectedEOFException unex) {
            System.err.println("Unexpected EOF exception");
        }
        catch (FileNotFoundException fnfex) {
            System.err.println("File not found exception");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class State {
        private final String name;

        public State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

