/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.cpp.settings.CppSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class CppUtils {
    public static final int MOUNT_ASK = 0;
    public static final int MOUNT_NEVER = 1;
    public static final int MOUNT_ALWAYS = 2;
    private static String prevfilename = null;
    private static FileObject prevfo = null;
    private static FileChangeAdapter fcl = null;
    private static HashMap fstab = new HashMap();
    private static HashMap canonicalfstab = new HashMap();
    static CppSettings settings = null;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$utils$CppUtils;

    public static final FileObject findFileObject(String fileName) {
        return CppUtils.findFileObject(fileName, false);
    }

    public static final FileObject findFileObject(String fileName, boolean mount) {
        FileObject fo;
        block33: {
            fo = null;
            if (fileName == null) {
                return null;
            }
            File fileNameFile = new File(fileName);
            if (!fileNameFile.exists()) {
                return null;
            }
            int sep = fileName.lastIndexOf(File.separatorChar);
            if (sep == -1) {
                ErrorManager.getDefault().log("CppUtils.findFileObject(\"" + fileName + "\"): you have to supply a full pathname!");
                return null;
            }
            String dir = fileName.substring(0, sep);
            String base = fileName.substring(sep + 1);
            Enumeration enumeration = Repository.getDefault().fileSystems();
            boolean dirFound = false;
            while (enumeration.hasMoreElements()) {
                String fsdir;
                FileSystem fs = (FileSystem)enumeration.nextElement();
                if (fs.isHidden() || (fsdir = CppUtils.getRootDirectory(fs)) == null) continue;
                int fsdirLength = fsdir.length();
                if (fsdir.equals(dir)) {
                    dirFound = true;
                    fo = fs.findResource(base);
                    break;
                }
                if (!dir.startsWith(fsdir) || fileName.charAt(fsdirLength) != File.separatorChar) continue;
                dirFound = true;
                String name = fileName.substring(fsdirLength + 1);
                fo = fs.findResource(name);
                break;
            }
            String canonicalDir = null;
            if (!dirFound) {
                try {
                    canonicalDir = new File(dir).getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!dirFound && canonicalDir != null) {
                enumeration = Repository.getDefault().fileSystems();
                while (enumeration.hasMoreElements()) {
                    String fsdir;
                    FileSystem fs = (FileSystem)enumeration.nextElement();
                    if (fs.isHidden() || (fsdir = CppUtils.getCanonicalRootDirectory(fs)) == null) continue;
                    int fsdirLength = fsdir.length();
                    if (fsdir.equals(dir)) {
                        dirFound = true;
                        fo = fs.findResource(base);
                        break;
                    }
                    if (!dir.startsWith(fsdir) || fileName.charAt(fsdirLength) != File.separatorChar) continue;
                    dirFound = true;
                    String name = fileName.substring(fsdirLength + 1);
                    fo = fs.findResource(name);
                    break;
                }
            }
            boolean doMount = mount;
            String mountDir = dir;
            if (doMount && !dirFound && fo == null) {
                int mountMode = 0;
                if (settings == null) {
                    settings = CppSettings.getDefault();
                }
                if ((mountMode = settings.getAutoMount()) == 1) {
                    doMount = false;
                } else if (mountMode == 2) {
                    doMount = true;
                } else {
                    ResourceBundle b = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$utils$CppUtils == null ? (class$org$netbeans$modules$cpp$utils$CppUtils = CppUtils.class$("org.netbeans.modules.cpp.utils.CppUtils")) : class$org$netbeans$modules$cpp$utils$CppUtils));
                    Object[] options = new Object[]{b.getString("MountNow"), b.getString("AlwaysMount"), b.getString("DontMount"), b.getString("NeverMount")};
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    JLabel label = new JLabel(b.getString("MountQuestion"));
                    label.setBorder(new EmptyBorder(new Insets(0, 0, 5, 0)));
                    panel.add((Component)label, "North");
                    JTextField dirfield = new JTextField();
                    dirfield.setColumns(20);
                    dirfield.setText(dir);
                    panel.add((Component)dirfield, "Center");
                    label.setLabelFor(dirfield);
                    label.setDisplayedMnemonic(b.getString("MountQuestionMnemonic").charAt(0));
                    JButton mountNowBtn = new JButton();
                    JButton alwaysMountBtn = new JButton();
                    JButton dontMountBtn = new JButton();
                    JButton neverMountBtn = new JButton();
                    Actions.setMenuText((AbstractButton)mountNowBtn, (String)b.getString("MountNow"), (boolean)true);
                    Actions.setMenuText((AbstractButton)alwaysMountBtn, (String)b.getString("AlwaysMount"), (boolean)true);
                    Actions.setMenuText((AbstractButton)dontMountBtn, (String)b.getString("DontMount"), (boolean)true);
                    Actions.setMenuText((AbstractButton)neverMountBtn, (String)b.getString("NeverMount"), (boolean)true);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, MessageFormat.format(b.getString("MountHeader"), dir), true, (Object[])new JButton[]{mountNowBtn, alwaysMountBtn, dontMountBtn, neverMountBtn}, (Object)mountNowBtn, 0, null, null);
                    dd.setMessageType(3);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                    dialog.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_MountQuestionDialog"));
                    dialog.show();
                    Object pressedButton = dd.getValue();
                    if (pressedButton == alwaysMountBtn) {
                        settings.setAutoMount(2);
                    } else if (pressedButton == neverMountBtn) {
                        settings.setAutoMount(1);
                    }
                    if (pressedButton == mountNowBtn || pressedButton == alwaysMountBtn) {
                        doMount = true;
                        mountDir = dirfield.getText().trim();
                        if (mountDir != null && mountDir.length() > 0 && mountDir.charAt(mountDir.length() - 1) == File.separatorChar) {
                            mountDir = mountDir.substring(0, mountDir.length() - 1);
                        }
                        if (mountDir == null || mountDir.length() == 0 || !dir.startsWith(mountDir)) {
                            int ret = JOptionPane.showConfirmDialog(null, b.getString("InvalidMountDir"), b.getString("InvalidMountDirHeader"), 0, 2);
                            if (ret == 0) {
                                return CppUtils.findFileObject(fileName, mount);
                            }
                            return null;
                        }
                    } else {
                        doMount = false;
                    }
                }
            }
            if (doMount && !dirFound && fo == null && mountDir != null) {
                LocalFileSystem fs = null;
                try {
                    LocalFileSystem lfs = new LocalFileSystem();
                    lfs.setRootDirectory(new File(mountDir));
                    fs = lfs;
                    fs.setHidden(false);
                    Repository.getDefault().addFileSystem((FileSystem)fs);
                    if (mountDir.equals(dir)) {
                        dirFound = true;
                        fo = fs.findResource(base);
                        break block33;
                    }
                    if (dir.startsWith(mountDir)) {
                        int n = mountDir.length();
                        String name = fileName.substring(n + 1);
                        fo = fs.findResource(name);
                        break block33;
                    }
                    return null;
                }
                catch (Exception e) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$utils$CppUtils == null ? (class$org$netbeans$modules$cpp$utils$CppUtils = CppUtils.class$("org.netbeans.modules.cpp.utils.CppUtils")) : class$org$netbeans$modules$cpp$utils$CppUtils)).getString("EXC_FSNotCreated"), dir), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        }
        if (fo != null) {
            prevfilename = fileName;
            if (fcl != null) {
                prevfo.removeFileChangeListener((FileChangeListener)fcl);
            } else {
                fcl = new FileChangeAdapter(){

                    public void fileDeleted(FileEvent ev) {
                        prevfilename = null;
                        prevfo = null;
                        fcl = null;
                    }
                };
            }
            prevfo = fo;
            fo.addFileChangeListener((FileChangeListener)fcl);
        }
        return fo;
    }

    public static final FileObject findFileObject(FileObject fo, String rpath) {
        if (!fo.isFolder()) {
            fo = fo.getParent();
        }
        try {
            return CppUtils.findFileObject(CppUtils.getPath(fo) + File.separator + rpath);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static final String getPath(FileObject fo) {
        String rootDir;
        FileSystem fs;
        try {
            fs = fo.getFileSystem();
        }
        catch (Exception e) {
            return null;
        }
        Object o = fstab.get(fs.getSystemName());
        if (o == null) {
            FileObject rootFo = fs.getRoot();
            if (rootFo == null) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)rootFo);
            if (file == null) {
                return null;
            }
            rootDir = file.getAbsolutePath();
            fstab.put(fs.getSystemName(), rootDir);
        } else {
            rootDir = o.toString();
        }
        String ret = rootDir + File.separatorChar + fo.getPath();
        if (ret.charAt(ret.length() - 1) == File.separatorChar) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static final String getRootDirectory(FileSystem fs) {
        String rootDir;
        Object o = fstab.get(fs.getSystemName());
        if (o == null) {
            FileObject rootFo = fs.getRoot();
            if (rootFo == null) {
                return null;
            }
            File rootFile = FileUtil.toFile((FileObject)rootFo);
            if (rootFile == null) {
                return null;
            }
            rootDir = rootFile.getAbsolutePath();
            if (rootDir == null) {
                return null;
            }
            fstab.put(fs.getSystemName(), rootDir);
        } else {
            rootDir = o.toString();
        }
        return rootDir;
    }

    public static final String getCanonicalRootDirectory(FileSystem fs) {
        String rootDir = null;
        Object o = canonicalfstab.get(fs.getSystemName());
        if (o == null) {
            FileObject rootFo = fs.getRoot();
            if (rootFo == null) {
                return null;
            }
            File rootFile = FileUtil.toFile((FileObject)rootFo);
            if (rootFile == null) {
                return null;
            }
            try {
                rootDir = rootFile.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (rootDir == null) {
                return null;
            }
            canonicalfstab.put(fs.getSystemName(), rootDir);
        } else {
            rootDir = o.toString();
        }
        return rootDir;
    }

    public static final String getBaseName(FileObject fo) {
        String ext = fo.getExt();
        if (ext == null || ext.equals("")) {
            return fo.getName();
        }
        return fo.getName() + "." + ext;
    }

    public static final String getBaseName(DataObject obj) {
        if (obj instanceof MultiDataObject) {
            return CppUtils.getBaseName(((MultiDataObject)obj).getPrimaryEntry().getFile());
        }
        return "";
    }

    public static final String getDirectory(FileObject fo) {
        return CppUtils.getPath(fo.getParent());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

