/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.picklist;

import java.io.File;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.modules.cpp.builds.MakeExecSupport;
import org.netbeans.modules.cpp.loaders.CSrcObject;
import org.netbeans.modules.cpp.loaders.CoreElfObject;
import org.netbeans.modules.cpp.loaders.MakefileDataNode;
import org.netbeans.modules.cpp.loaders.MakefileDataObject;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.ExecutionSupport;
import org.openide.nodes.Node;

public class PicklistUtils {
    private static final int maxPixels = 240;
    private static int minStringLength = 0;
    private static Module javaModule = null;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$builds$MakeExecSupport;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$ExecutionSupport;

    public static Node findNode(String filePath) {
        FileObject fo = CppUtils.findFileObject(filePath, true);
        if (fo == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dataObject == null) {
            return null;
        }
        Node node = dataObject.getNodeDelegate();
        if (node == null) {
            return null;
        }
        return node;
    }

    public static MakefileDataNode findMakefileDataNode(String filePath) {
        if (filePath == null) {
            return null;
        }
        Node makefileNode = PicklistUtils.findNode(filePath);
        if (makefileNode == null) {
            return null;
        }
        if (!(makefileNode instanceof MakefileDataNode)) {
            return null;
        }
        return (MakefileDataNode)makefileNode;
    }

    public static MakeExecSupport findMakeExecSupport(String filePath) {
        return PicklistUtils.findMakeExecSupport(PicklistUtils.findMakefileDataNode(filePath));
    }

    public static MakeExecSupport findMakeExecSupport(MakefileDataNode makefileNode) {
        if (makefileNode == null) {
            return null;
        }
        MakeExecSupport mes = (MakeExecSupport)makefileNode.getCookie(class$org$netbeans$modules$cpp$builds$MakeExecSupport == null ? (class$org$netbeans$modules$cpp$builds$MakeExecSupport = PicklistUtils.class$("org.netbeans.modules.cpp.builds.MakeExecSupport")) : class$org$netbeans$modules$cpp$builds$MakeExecSupport);
        return mes;
    }

    public static DataNode findExecutableNode(String filePath) {
        if (filePath == null) {
            return null;
        }
        Node node = PicklistUtils.findNode(filePath);
        if (node == null) {
            return null;
        }
        if (!(node instanceof DataNode)) {
            return null;
        }
        if (node.getCookie(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = PicklistUtils.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie) == null) {
            return null;
        }
        DataNode dnode = (DataNode)node;
        if (dnode.getDataObject() instanceof CSrcObject) {
            return null;
        }
        if (dnode.getDataObject() instanceof MakefileDataObject) {
            return null;
        }
        return dnode;
    }

    public static DataNode findDebuggableNode(String filePath) {
        if (filePath == null) {
            return null;
        }
        Node node = PicklistUtils.findNode(filePath);
        if (node == null) {
            return null;
        }
        if (!(node instanceof DataNode)) {
            return null;
        }
        if (node.getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = PicklistUtils.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie) == null) {
            return null;
        }
        return (DataNode)node;
    }

    public static DataNode findCorefileNode(String filePath) {
        if (filePath == null) {
            return null;
        }
        Node node = PicklistUtils.findNode(filePath);
        if (node == null) {
            return null;
        }
        if (!(node instanceof DataNode)) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PicklistUtils.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (!(dataObject instanceof CoreElfObject)) {
            return null;
        }
        return (DataNode)node;
    }

    public static ExecutionSupport findExecutionSupport(String filePath) {
        return PicklistUtils.findExecutionSupport(PicklistUtils.findExecutableNode(filePath));
    }

    public static ExecutionSupport findExecutionSupport(DataNode executionNode) {
        if (executionNode == null) {
            return null;
        }
        if (executionNode.getDataObject() instanceof CSrcObject) {
            return null;
        }
        if (executionNode.getDataObject() instanceof CoreElfObject) {
            return null;
        }
        if (executionNode.getDataObject() instanceof MakefileDataObject) {
            return null;
        }
        ExecutionSupport bes = (ExecutionSupport)executionNode.getCookie(class$org$openide$loaders$ExecutionSupport == null ? (class$org$openide$loaders$ExecutionSupport = PicklistUtils.class$("org.openide.loaders.ExecutionSupport")) : class$org$openide$loaders$ExecutionSupport);
        return bes;
    }

    public static String toAbsolutePath(String base, String path) {
        File newPathFile;
        String newPath = path;
        if (newPath == null || newPath.length() == 0) {
            newPath = ".";
        }
        if (newPath.charAt(0) != File.separatorChar && (newPathFile = new File(newPath = base + File.separatorChar + newPath)).exists()) {
            try {
                newPath = newPathFile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return newPath;
    }

    public static String toRelativePath(String base, String path) {
        String relPath = path;
        if (relPath == null || relPath.length() == 0) {
            relPath = ".";
        }
        if (relPath.charAt(0) == File.separatorChar) {
            relPath = relPath.equals(base) ? "." : (base.charAt(0) == File.separatorChar ? IpeUtils.getRelativePath(base, relPath) : path);
        }
        return relPath;
    }

    public static String subPath(String path, int levels) {
        if (path == null || path.length() == 0) {
            return path;
        }
        String newPath = null;
        Vector<Integer> separators = new Vector<Integer>();
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != File.separatorChar) continue;
            separators.add(0, new Integer(i));
        }
        newPath = separators.size() > levels ? "..." + path.substring((Integer)separators.get(levels), path.length()) : path;
        return newPath;
    }

    public static String quoteArgument(String arg) {
        if (arg == null || arg.length() == 0) {
            return "";
        }
        boolean quote = false;
        for (int i = 0; i < arg.length(); ++i) {
            if (!Character.isWhitespace(arg.charAt(i))) continue;
            quote = true;
            break;
        }
        if (quote) {
            return "\"" + arg + "\"";
        }
        return arg;
    }

    public static String formatDisplayString(String path, String args, boolean quoteArguments) {
        int i = path.lastIndexOf(File.separatorChar);
        String shortArgs = args == null ? "" : (args.length() > 20 ? args.substring(0, 20) + "..." : args);
        if (shortArgs.length() > 0) {
            shortArgs = quoteArguments ? "  (" + shortArgs + ")" : "  " + shortArgs + "";
        }
        return PicklistUtils.formatDisplayPath(path) + shortArgs;
    }

    private static int getMaxPixels() {
        return 240;
    }

    private static int getMinStringLength() {
        if (minStringLength == 0) {
            int tenchar = (int)new JLabel("abcdefgh..").preferredSize().getWidth();
            minStringLength = PicklistUtils.getMaxPixels() * 10 / tenchar;
        }
        return minStringLength;
    }

    private static String formatDisplayPath(String path, int minStringLength) {
        JLabel nlabel;
        String newPath0 = path.substring(0, minStringLength / 2);
        int n0 = newPath0.length();
        int n00 = 0;
        String newPath1 = path.substring(path.length() - minStringLength / 2, path.length());
        int n1 = newPath1.length();
        int n11 = 0;
        String dots = "..";
        String newPath = null;
        int n = 0;
        while ((nlabel = new JLabel(newPath = newPath0 + dots + newPath1)).preferredSize().getWidth() > (double)PicklistUtils.getMaxPixels()) {
            if (n % 2 == 0) {
                newPath0 = newPath0.substring(0, n0 - ++n00);
            } else {
                newPath1 = newPath1.substring(1, n1 - ++n11 + 1);
            }
            ++n;
        }
        n = 0;
        while (true) {
            dots = dots + ".";
            newPath = newPath0 + dots + newPath1;
            if (new JLabel(newPath).preferredSize().getWidth() > (double)PicklistUtils.getMaxPixels()) break;
            ++n;
        }
        if (n00 + n11 == 0 && minStringLength < path.length()) {
            return PicklistUtils.formatDisplayPath(path, minStringLength + 10);
        }
        return newPath;
    }

    public static String formatDisplayPath(String path) {
        if (path == null) {
            return path;
        }
        int i = path.lastIndexOf(File.separatorChar);
        if (i <= 0) {
            return path;
        }
        String dirPath = path.substring(0, i + 1);
        String name = path.substring(i + 1);
        JLabel l = new JLabel(dirPath);
        JLabel jLabel = new JLabel(dirPath);
        if (jLabel.preferredSize().getWidth() < (double)PicklistUtils.getMaxPixels()) {
            return path;
        }
        int minStringLength = PicklistUtils.getMinStringLength();
        if (dirPath.length() < minStringLength) {
            minStringLength = dirPath.length();
        }
        dirPath = PicklistUtils.formatDisplayPath(dirPath, minStringLength);
        return dirPath + name;
    }

    public static Module getJavaModule() {
        if (javaModule == null) {
            ModuleManager moduleManager = NbTopManager.get().getModuleSystem().getManager();
            Set modulesSet = moduleManager.getModules();
            Object[] modulesArray = modulesSet.toArray();
            for (int i = 0; i < modulesArray.length; ++i) {
                Module m = (Module)modulesArray[i];
                if (!m.getCodeNameBase().equals("org.netbeans.modules.java")) continue;
                javaModule = m;
                break;
            }
        }
        return javaModule;
    }

    public static boolean isJavaModuleEnabled() {
        return PicklistUtils.getJavaModule() != null && PicklistUtils.getJavaModule().isEnabled();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

