/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.picklist;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.cpp.picklist.ElementChangeEvent;
import org.netbeans.modules.cpp.picklist.ElementChangeListener;
import org.netbeans.modules.cpp.picklist.ElementPanel;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.picklist.PicklistModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.EqualFlowLayout;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ListEditDialog
extends JDialog
implements ElementChangeListener {
    private JList targetList = null;
    private PicklistModel picklist = null;
    private ElementPanel elementPanel = null;
    private int lastSelectedIndex = 0;
    private TargetSelectionListener targetSelectionListener = null;
    public static int SHOW_MAX_ELEMENTS = 20;
    private JPanel buttonPanel;
    private JPanel buttonPanel1;
    private JPanel buttonPanel2;
    private JButton cancelButton;
    private JButton deleteAllButton;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JLabel errorLabel;
    private JTextArea guidanceText;
    private JButton helpButton;
    private JPanel itemControlsPanel;
    private JLabel listLabel;
    private JPanel mainPanel;
    private JButton okButton;
    private JButton resetButton;
    private JScrollPane scrollPane;
    private JButton updateButton;
    private ResourceBundle bundle = null;
    static /* synthetic */ Class class$org$netbeans$api$javahelp$Help;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$picklist$ListEditDialog;

    public ListEditDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.buttonPanel.setLayout((LayoutManager)new EqualFlowLayout(2, 5, 0));
        this.resetButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.setTitle(this.getTitleText());
        this.guidanceText.setText(this.getGuidanceText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.elementPanel = this.getElementPanel();
        this.itemControlsPanel.add((Component)this.elementPanel, gridBagConstraints);
        this.pack();
        String escape = "ListEditDialog-escape";
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getActionMap().put(escape, new EscapeKeyAction());
        this.getRootPane().getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), escape);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), escape);
        String help = "ListEditDialog-F1";
        this.getRootPane().getActionMap().put(help, new HelpKeyAction());
        this.getRootPane().getInputMap(0).put(KeyStroke.getKeyStroke(112, 0), help);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), help);
        this.getRootPane().setFocusable(false);
        this.picklist = this.getPicklist();
        this.targetList = new JList();
        this.targetList.setCellRenderer(new MyCellRenderer());
        this.targetList.setVisibleRowCount(8);
        this.targetList.setSelectionMode(0);
        this.targetList.setListData(this.picklist.getElementsDisplayName());
        this.scrollPane.setViewportView(this.targetList);
        this.listLabel.setLabelFor(this.targetList);
        this.targetList.setSelectedIndex(0);
        this.checkSelection();
        this.helpButton.setEnabled(this.getHelpCtx() != null);
        this.pack();
        this.initAccessibility();
        this.elementPanel.addChangeListener(this);
        this.targetSelectionListener = new TargetSelectionListener();
        this.targetList.addListSelectionListener(this.targetSelectionListener);
        this.targetList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.isConsumed()) {
                    return;
                }
                if (evt.getKeyChar() == '\u007f') {
                    evt.consume();
                    ListEditDialog.this.deleteAction();
                }
            }
        });
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(this.getTitle());
        context.setAccessibleDescription(this.guidanceText.getText());
        context = this.targetList.getAccessibleContext();
        context.setAccessibleName(this.getString("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(this.getString("LISTEDITDIALOG_ACSD"));
        context = this.scrollPane.getAccessibleContext();
        context.setAccessibleName(this.getString("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(this.getString("LISTEDITDIALOG_ACSD"));
        context = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        context.setAccessibleName(this.getString("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(this.getString("LISTEDITDIALOG_ACSD"));
        context = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        context.setAccessibleName(this.getString("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(this.getString("LISTEDITDIALOG_ACSD"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(this.duplicateButton.getText());
        this.deleteButton.getAccessibleContext().setAccessibleDescription(this.deleteButton.getText());
        this.deleteAllButton.getAccessibleContext().setAccessibleDescription(this.deleteAllButton.getText());
        this.updateButton.getAccessibleContext().setAccessibleDescription(this.updateButton.getText());
        this.resetButton.getAccessibleContext().setAccessibleDescription(this.resetButton.getText());
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getText());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.cancelButton.getText());
        this.helpButton.getAccessibleContext().setAccessibleDescription(this.helpButton.getText());
    }

    protected PicklistModel getPicklist() {
        return null;
    }

    protected ElementPanel getElementPanel() {
        return new ElementPanel();
    }

    protected String getTitleText() {
        return "Frame Title";
    }

    protected String getGuidanceText() {
        return "Guidance text...:";
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.guidanceText = new JTextArea();
        this.listLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.buttonPanel1 = new JPanel();
        this.duplicateButton = new JButton();
        this.deleteButton = new JButton();
        this.deleteAllButton = new JButton();
        this.itemControlsPanel = new JPanel();
        this.buttonPanel2 = new JPanel();
        this.updateButton = new JButton();
        this.resetButton = new JButton();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.errorLabel = new JLabel();
        this.setTitle("Dialog Title");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ListEditDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.guidanceText.setBackground(new Color(204, 204, 204));
        this.guidanceText.setEditable(false);
        this.guidanceText.setLineWrap(true);
        this.guidanceText.setText("G.T.:");
        this.guidanceText.setWrapStyleWord(true);
        this.guidanceText.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.mainPanel.add((Component)this.guidanceText, gridBagConstraints);
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_COMMANDS_MN").charAt(0));
        this.listLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_COMMANDS_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.mainPanel.add((Component)this.listLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.mainPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.buttonPanel1.setLayout(new GridBagLayout());
        this.duplicateButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_DUPLICATE_BUTTON_MN").charAt(0));
        this.duplicateButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_DUPLICATE_BUTTON_TXT"));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.duplicateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel1.add((Component)this.duplicateButton, gridBagConstraints);
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_DELETE_BUTTON_MN").charAt(0));
        this.deleteButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_DELETE_BUTTON_TXT"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.buttonPanel1.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteAllButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_DELETE_ALL_BUTTON_MN").charAt(0));
        this.deleteAllButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_DELETE_ALL_BUTTON_TXT"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.deleteAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel1.add((Component)this.deleteAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 7, 0, 11);
        this.mainPanel.add((Component)this.buttonPanel1, gridBagConstraints);
        this.itemControlsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.mainPanel.add((Component)this.itemControlsPanel, gridBagConstraints);
        this.buttonPanel2.setLayout(new GridBagLayout());
        this.updateButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_UPDATE_BUTTON_MN").charAt(0));
        this.updateButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_UPDATE_BUTTON_TXT"));
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.updateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel2.add((Component)this.updateButton, gridBagConstraints);
        this.resetButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_RESET_BUTTON_MN").charAt(0));
        this.resetButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_RESET_BUTTON_TXT"));
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.resetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel2.add((Component)this.resetButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 8, 0, 11);
        this.mainPanel.add((Component)this.buttonPanel2, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 0));
        this.okButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_OK_BUTTON_TXT"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_CANCEL_BUTTON_TXT"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.helpButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_HELP_BUTTON_MN").charAt(0));
        this.helpButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("LISTEDITDIALOG_HELP_BUTTON_TXT"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListEditDialog.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.helpButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 12, 10);
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.errorLabel.setForeground(new Color(89, 79, 191));
        this.errorLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.mainPanel.add((Component)this.errorLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    public void handleHelp() {
        HelpCtx helpCtx = this.getHelpCtx();
        if (helpCtx != null) {
            Help h = (Help)Lookup.getDefault().lookup(class$org$netbeans$api$javahelp$Help == null ? (class$org$netbeans$api$javahelp$Help = ListEditDialog.class$("org.netbeans.api.javahelp.Help")) : class$org$netbeans$api$javahelp$Help);
            if (h == null) {
                return;
            }
            h.showHelp(helpCtx);
        }
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.handleHelp();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.targetList.removeListSelectionListener(this.targetSelectionListener);
        this.handleReset(this.targetList.getSelectedIndex());
        this.elementPanel.reset();
        this.checkSelection();
        this.targetList.addListSelectionListener(this.targetSelectionListener);
    }

    private void updateAction(int selectedIndex) {
        if (selectedIndex < 0) {
            return;
        }
        this.targetList.removeListSelectionListener(this.targetSelectionListener);
        this.handleUpdate(selectedIndex);
        this.targetList.setListData(this.picklist.getElementsDisplayName());
        this.targetList.setSelectedIndex(selectedIndex);
        this.targetList.ensureIndexIsVisible(selectedIndex);
        this.elementPanel.reset();
        this.checkSelection();
        this.targetList.addListSelectionListener(this.targetSelectionListener);
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.updateAction(this.targetList.getSelectedIndex());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.handleCancel();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.elementPanel.isModified() && !this.updateModifiedDialog(this.targetList.getSelectedIndex())) {
            return;
        }
        this.handleOK();
    }

    private void duplicateAction() {
        if (this.elementPanel.isModified() && !this.updateModifiedDialog(this.targetList.getSelectedIndex())) {
            return;
        }
        int selectedIndex = this.targetList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.targetList.removeListSelectionListener(this.targetSelectionListener);
        PicklistElement elem = this.picklist.getElementAt(selectedIndex);
        PicklistElement elemDup = elem.cloneElement();
        this.picklist.addElement(elemDup, false);
        this.targetList.setListData(this.picklist.getElementsDisplayName());
        this.targetList.setSelectedIndex(0);
        this.targetList.ensureIndexIsVisible(0);
        this.handleDuplicate(selectedIndex);
        this.checkSelection();
        this.targetList.addListSelectionListener(this.targetSelectionListener);
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        this.duplicateAction();
    }

    private void deleteAllAction() {
        this.elementPanel.reset();
        this.picklist.removeAllElements();
        this.targetList.setListData(this.picklist.getElementsDisplayName());
        this.checkSelection();
        this.handleDeleteAll();
    }

    private void deleteAllButtonActionPerformed(ActionEvent evt) {
        this.deleteAllAction();
    }

    private void deleteAction() {
        int newselectedIndex;
        int selectedIndex = this.targetList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.targetList.removeListSelectionListener(this.targetSelectionListener);
        this.picklist.removeElementAt(selectedIndex);
        this.targetList.setListData(this.picklist.getElementsDisplayName());
        int n = newselectedIndex = selectedIndex >= this.picklist.getSize() ? selectedIndex - 1 : selectedIndex;
        if (newselectedIndex >= 0) {
            this.targetList.setSelectedIndex(newselectedIndex);
            this.targetList.ensureIndexIsVisible(newselectedIndex);
            this.handleSelection(newselectedIndex);
        }
        this.handleDelete(selectedIndex);
        this.elementPanel.reset();
        this.checkSelection();
        this.targetList.addListSelectionListener(this.targetSelectionListener);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteAction();
    }

    private void closeDialog(WindowEvent evt) {
        this.closeAction();
        this.setVisible(false);
        this.dispose();
    }

    protected void closeAction() {
    }

    public static void main(String[] args) {
        new ListEditDialog(new JFrame()).show();
    }

    private void checkSelection() {
        int selectedIndex = this.targetList.getSelectedIndex();
        if (this.elementPanel.isModified() && !this.updateModifiedDialog(this.lastSelectedIndex)) {
            this.targetList.removeListSelectionListener(this.targetSelectionListener);
            this.targetList.setSelectedIndex(this.lastSelectedIndex);
            this.targetList.ensureIndexIsVisible(this.lastSelectedIndex);
            this.targetList.addListSelectionListener(this.targetSelectionListener);
            return;
        }
        this.lastSelectedIndex = selectedIndex;
        if (selectedIndex != this.targetList.getSelectedIndex()) {
            this.targetList.removeListSelectionListener(this.targetSelectionListener);
            this.targetList.setSelectedIndex(this.lastSelectedIndex);
            this.targetList.ensureIndexIsVisible(this.lastSelectedIndex);
            this.targetList.addListSelectionListener(this.targetSelectionListener);
        }
        if (this.picklist.getSize() > 0) {
            if (this.lastSelectedIndex >= 0) {
                this.deleteButton.setEnabled(true);
                this.duplicateButton.setEnabled(true);
            } else {
                this.deleteButton.setEnabled(false);
                this.duplicateButton.setEnabled(false);
            }
            this.deleteAllButton.setEnabled(true);
        } else {
            this.duplicateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.deleteAllButton.setEnabled(false);
        }
        this.handleSelection(this.lastSelectedIndex);
        this.elementPanel.reset();
        this.resetFocusToAvailableComponent();
    }

    private void resetFocusToAvailableComponent() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null && !focusOwner.isEnabled()) {
            kfm.focusNextComponent(focusOwner);
        }
    }

    protected HelpCtx getHelpCtx() {
        return null;
    }

    protected void handleSelection(int i) {
    }

    protected void handleDelete(int i) {
    }

    protected void handleDeleteAll() {
    }

    protected void handleUpdate(int i) {
    }

    protected void handleReset(int i) {
    }

    protected void handleDuplicate(int i) {
    }

    protected void handleOK() {
        this.closeDialog(null);
    }

    protected void handleCancel() {
        this.closeDialog(null);
    }

    public void contentsChanged(ElementChangeEvent e) {
        switch (e.getType()) {
            case 1: {
                this.updateButton.setEnabled(false);
                this.resetButton.setEnabled(false);
                break;
            }
            case 0: {
                this.updateButton.setEnabled(true);
                this.resetButton.setEnabled(true);
            }
            case 2: {
                this.okButton.setEnabled(true);
                break;
            }
            case 3: {
                this.okButton.setEnabled(false);
                break;
            }
            case 4: {
                this.errorLabel.setText(e.getText());
                break;
            }
            case 5: {
                this.errorLabel.setText(" ");
            }
        }
    }

    private boolean updateModifiedDialog(int selectedIndex) {
        JButton updateButton = new JButton(this.getString("MODIFIEDDIALOG_UPDATE_BUTTON_TXT"));
        JButton cancelButton = new JButton(this.getString("MODIFIEDDIALOG_CANCEL_BUTTON_TXT"));
        updateButton.getAccessibleContext().setAccessibleDescription(this.getString("MODIFIEDDIALOG_UPDATE_BUTTON_ACSD"));
        cancelButton.getAccessibleContext().setAccessibleDescription(this.getString("MODIFIEDDIALOG_CANCEL_BUTTON_ACSD"));
        NotifyDescriptor d = new NotifyDescriptor((Object)this.getString("MODIFIEDDIALOG_COMMANDS_MODIFIED"), this.getString("MODIFIEDDIALOG_UNSAVED_MODIFICATIONS"), 2, 2, (Object[])new JButton[]{updateButton, cancelButton}, (Object)updateButton);
        if (DialogDisplayer.getDefault().notify(d) == updateButton) {
            this.elementPanel.reset();
            this.updateAction(selectedIndex);
            return true;
        }
        return false;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$picklist$ListEditDialog == null ? (class$org$netbeans$modules$cpp$picklist$ListEditDialog = ListEditDialog.class$("org.netbeans.modules.cpp.picklist.ListEditDialog")) : class$org$netbeans$modules$cpp$picklist$ListEditDialog));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HelpKeyAction
    extends AbstractAction {
        private HelpKeyAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ListEditDialog.this.handleHelp();
        }
    }

    private class EscapeKeyAction
    extends AbstractAction {
        private EscapeKeyAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ListEditDialog.this.closeDialog(null);
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                if (index == SHOW_MAX_ELEMENTS) {
                    this.setBorder(new MatteBorder(new Insets(2, 0, 0, 0), Color.gray));
                } else {
                    this.setBorder(null);
                }
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListEditDialog.this.checkSelection();
        }
    }
}

