/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cpp.builds.MakeExecSupport;
import org.netbeans.modules.cpp.makewizard.BaseDirectoryPanel;
import org.netbeans.modules.cpp.makewizard.BasicFlagsPanel;
import org.netbeans.modules.cpp.makewizard.BuildOutputPanel;
import org.netbeans.modules.cpp.makewizard.CompilerOptionsPanel;
import org.netbeans.modules.cpp.makewizard.CompilerPathPanel;
import org.netbeans.modules.cpp.makewizard.CreateTargetsPanel;
import org.netbeans.modules.cpp.makewizard.CustomTargetPanel;
import org.netbeans.modules.cpp.makewizard.MakeTargetPanel;
import org.netbeans.modules.cpp.makewizard.MakefileData;
import org.netbeans.modules.cpp.makewizard.MakefileGenerator;
import org.netbeans.modules.cpp.makewizard.MakefileIncludesPanel;
import org.netbeans.modules.cpp.makewizard.MakefileReviewPanel;
import org.netbeans.modules.cpp.makewizard.MakefileSourcesPanel;
import org.netbeans.modules.cpp.makewizard.MakefileWizardDescriptorFinishPanel;
import org.netbeans.modules.cpp.makewizard.MakefileWizardDescriptorPanel;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cpp.makewizard.PlatformTypePanel;
import org.netbeans.modules.cpp.makewizard.SelectPreferencesPanel;
import org.netbeans.modules.cpp.makewizard.StandardLibsPanel;
import org.netbeans.modules.cpp.makewizard.TargetData;
import org.netbeans.modules.cpp.makewizard.TargetNamePanel;
import org.netbeans.modules.cpp.makewizard.UserLibsPanel;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.settings.MakeSettings;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class MakefileWizard
implements WizardDescriptor.Iterator,
TemplateWizard.Iterator {
    private static Vector listenerList = null;
    protected TemplateWizard wd;
    protected Object[] panels;
    private WizardDescriptor.Panel currentPanel;
    protected Object[] normalPanels;
    protected LinkedList complexPanels;
    private MakefileData makefileData;
    private static MakefileWizard makefileWizard;
    private String title;
    private int index;
    private int virtIndex;
    private int addIdx;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private String finishLabel;
    private int finishMnemonic;
    private boolean finishEnabled;
    private boolean haveCompilerFlags;
    private PropertyChangeListener listener = null;
    private WizardDescriptor.Panel targetChooserDescriptorPanel;
    private WizardDescriptor.Panel baseDirectoryDescriptorPanel;
    private WizardDescriptor.Panel targetNameDescriptorPanel;
    private WizardDescriptor.Panel makefileSourcesDescriptorPanel;
    private WizardDescriptor.Panel selectPreferencesDescriptorPanel;
    private WizardDescriptor.Panel platformTypeDescriptorPanel;
    private WizardDescriptor.Panel createTargetsDescriptorPanel;
    private WizardDescriptor.Panel buildOutputDescriptorPanel;
    private WizardDescriptor.Panel makefileIncludesDescriptorPanel;
    private WizardDescriptor.Panel standardLibsDescriptorPanel;
    private WizardDescriptor.Panel userLibsDescriptorPanel;
    private WizardDescriptor.Panel compilerOptionsDescriptorPanel;
    private WizardDescriptor.Panel basicFlagsDescriptorPanel;
    private WizardDescriptor.Panel compilerPathDescriptorPanel;
    private WizardDescriptor.Panel makefileReviewDescriptorPanel;
    private transient Set listeners = new HashSet(1);
    static /* synthetic */ Class class$org$netbeans$modules$cpp$makewizard$MakefileWizard;
    static /* synthetic */ Class class$org$openide$WizardDescriptor;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$builds$MakeExecSupport;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public MakefileWizard() {
        makefileWizard = this;
        String title = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makewizard$MakefileWizard == null ? (class$org$netbeans$modules$cpp$makewizard$MakefileWizard = MakefileWizard.class$("org.netbeans.modules.cpp.makewizard.MakefileWizard")) : class$org$netbeans$modules$cpp$makewizard$MakefileWizard)).getString("LBL_MakefileWizardTitle");
        this.setTitle(title);
        this.makefileData = new MakefileData();
    }

    private void initPanels() {
        this.targetChooserDescriptorPanel = this.wd.targetChooser();
        this.baseDirectoryDescriptorPanel = new MakefileWizardDescriptorPanel(new BaseDirectoryPanel(this), "base_directory");
        this.targetNameDescriptorPanel = new MakefileWizardDescriptorPanel(new TargetNamePanel(this), "target_name");
        this.makefileSourcesDescriptorPanel = new MakefileWizardDescriptorFinishPanel(new MakefileSourcesPanel(this), "source_files");
        this.selectPreferencesDescriptorPanel = new MakefileWizardDescriptorPanel(new SelectPreferencesPanel(this), "compiling_preference");
        this.createTargetsDescriptorPanel = new MakefileWizardDescriptorPanel(new CreateTargetsPanel(this), "list_of_targets");
        this.platformTypeDescriptorPanel = new MakefileWizardDescriptorPanel(new PlatformTypePanel(this), "type_and_platform");
        this.buildOutputDescriptorPanel = new MakefileWizardDescriptorPanel(new BuildOutputPanel(this), "build_output");
        this.makefileIncludesDescriptorPanel = new MakefileWizardDescriptorPanel(new MakefileIncludesPanel(this), "include_directories");
        this.standardLibsDescriptorPanel = new MakefileWizardDescriptorPanel(new StandardLibsPanel(this), "standard_libraries");
        this.userLibsDescriptorPanel = new MakefileWizardDescriptorPanel(new UserLibsPanel(this), "libraries");
        this.basicFlagsDescriptorPanel = new MakefileWizardDescriptorFinishPanel(new BasicFlagsPanel(this), "basic_options");
        this.compilerPathDescriptorPanel = new MakefileWizardDescriptorFinishPanel(new CompilerPathPanel(this), "compiler_paths");
        this.compilerOptionsDescriptorPanel = new MakefileWizardDescriptorPanel(new CompilerOptionsPanel(this), "advanced_options");
        this.makefileReviewDescriptorPanel = new MakefileWizardDescriptorPanel(new MakefileReviewPanel(this), "review_makefile");
        this.normalPanels = new WizardDescriptor.Panel[]{this.targetChooserDescriptorPanel, this.platformTypeDescriptorPanel, this.targetNameDescriptorPanel, this.makefileSourcesDescriptorPanel, this.selectPreferencesDescriptorPanel, this.makefileReviewDescriptorPanel};
        this.complexPanels = new LinkedList();
        this.complexPanels.addLast(this.targetChooserDescriptorPanel);
        this.complexPanels.addLast(this.platformTypeDescriptorPanel);
        this.complexPanels.addLast(this.baseDirectoryDescriptorPanel);
        this.complexPanels.addLast(this.createTargetsDescriptorPanel);
        this.complexPanels.addLast(this.makefileReviewDescriptorPanel);
        this.panels = this.complexToArray();
        this.currentPanel = this.targetChooserDescriptorPanel;
        this.addIdx = 4;
        this.haveCompilerFlags = false;
        this.nextButton = null;
        this.finishButton = null;
        this.cancelButton = null;
        this.finishEnabled = false;
    }

    public TemplateWizard getTemplateWizard() {
        return this.wd;
    }

    public final MakefileData getMakefileData() {
        return this.makefileData;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public String getFinishLabel() {
        return this.finishLabel;
    }

    public int getFinishMnemonic() {
        return this.finishMnemonic;
    }

    public int getCurrentTargetKey() {
        int key = -1;
        if (this.makefileData.getMakefileType() < 4) {
            key = 0;
        } else {
            for (int i = 0; i < this.panels.length; ++i) {
                if (this.panels[i] instanceof StepHeader) {
                    key = ((StepHeader)this.panels[i]).getKey();
                }
                if (i == this.index) break;
            }
        }
        return key;
    }

    public WizardDescriptor.Panel current() {
        return this.currentPanel;
    }

    public String name() {
        Object[] args = new Object[]{new Integer(this.index + 1), new Integer(this.panels.length)};
        MessageFormat mf = new MessageFormat(NbBundle.getBundle((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = MakefileWizard.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor)).getString("CTL_ArrayIteratorName"));
        return mf.format(args);
    }

    public void updateStateHack() {
        if (this.wd != null) {
            this.wd.setTitleFormat(new MessageFormat("{0}"));
        }
    }

    public void updateState() {
        this.fireChangeEvent();
    }

    private String[] getSteps() {
        String[] steps = new String[this.panels.length];
        StepHeader hdr = null;
        int j = 0;
        int doingTarget = 0;
        int expand = 0;
        int virtIndex = 0;
        for (int i = 0; i < this.panels.length; ++i) {
            if (this.panels[i] instanceof StepHeader) {
                if (i < this.index) {
                    ++virtIndex;
                }
                hdr = (StepHeader)this.panels[i];
                steps[j++] = hdr.getTitle();
                doingTarget = hdr.getNum();
                if (this.index < i || this.index > i + hdr.getNum()) continue;
                expand = hdr.getNum();
                continue;
            }
            if (doingTarget-- > 0) {
                if (expand-- <= 0) continue;
                if (i < this.index) {
                    ++virtIndex;
                }
                steps[j++] = NbBundle.getMessage(this.getClass(), (String)"FMT_TARGET_PANEL", (Object)"    ", (Object)((WizardDescriptor.Panel)this.panels[i]).getComponent().getName());
                continue;
            }
            steps[j++] = ((WizardDescriptor.Panel)this.panels[i]).getComponent().getName();
            if (i >= this.index) continue;
            ++virtIndex;
        }
        String[] nue = new String[j];
        System.arraycopy(steps, 0, nue, 0, j);
        this.virtIndex = virtIndex;
        return nue;
    }

    public void updatePanels(int type) {
        this.panels = type >= 4 ? this.complexToArray() : this.normalPanels;
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.getSteps());
        this.updateState();
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public synchronized void nextPanel() {
        if (this.panels[++this.index] instanceof StepHeader) {
            ++this.index;
        }
        this.currentPanel = (WizardDescriptor.Panel)this.panels[this.index];
        this.updatePanels(this.makefileData.getMakefileType());
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.virtIndex));
    }

    public synchronized void previousPanel() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        if (this.panels[--this.index] instanceof StepHeader) {
            --this.index;
        }
        this.currentPanel = (WizardDescriptor.Panel)this.panels[this.index];
        this.updatePanels(this.makefileData.getMakefileType());
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.virtIndex));
    }

    private Object[] complexToArray() {
        Object[] p = new Object[this.complexPanels.size()];
        ListIterator iter = this.complexPanels.listIterator();
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            p[i] = iter.next();
        }
        return p;
    }

    public boolean targetExists(int key) {
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            Object o = this.complexPanels.get(i);
            if (!(o instanceof StepHeader) || ((StepHeader)o).getKey() != key) continue;
            return true;
        }
        return false;
    }

    public int addTarget(int type, String name, int key) {
        boolean needCompilerFlags = false;
        int count = 0;
        switch (type) {
            case 5: {
                needCompilerFlags = true;
                count = 6;
                this.complexPanels.add(this.addIdx++, new TargetHeader(name, type, count - 1, key));
                this.complexPanels.add(this.addIdx++, this.buildOutputDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileSourcesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileIncludesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.standardLibsDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.userLibsDescriptorPanel);
                break;
            }
            case 6: {
                needCompilerFlags = true;
                count = 4;
                this.complexPanels.add(this.addIdx++, new TargetHeader(name, type, count - 1, key));
                this.complexPanels.add(this.addIdx++, this.buildOutputDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileSourcesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileIncludesDescriptorPanel);
                break;
            }
            case 7: {
                needCompilerFlags = true;
                count = 5;
                this.complexPanels.add(this.addIdx++, new TargetHeader(name, type, count - 1, key));
                this.complexPanels.add(this.addIdx++, this.buildOutputDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileSourcesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.makefileIncludesDescriptorPanel);
                this.complexPanels.add(this.addIdx++, this.userLibsDescriptorPanel);
                break;
            }
            case 8: {
                this.complexPanels.add(this.addIdx++, new TargetHeader(name, type, 1, key));
                this.complexPanels.add(this.addIdx++, new MakefileWizardDescriptorPanel(new MakeTargetPanel(this), "recursive_make"));
                break;
            }
            case 9: {
                this.complexPanels.add(this.addIdx++, new TargetHeader(name, type, 1, key));
                this.complexPanels.add(this.addIdx++, new MakefileWizardDescriptorPanel(new CustomTargetPanel(this), "custom_make"));
            }
        }
        if (needCompilerFlags && !this.haveCompilerFlags) {
            this.complexPanels.add(this.addIdx, new StepHeader(NbBundle.getBundle(this.getClass()).getString("FMT_COMP_PREFS"), 3, -1));
            this.complexPanels.add(this.addIdx + 1, this.basicFlagsDescriptorPanel);
            this.complexPanels.add(this.addIdx + 2, this.compilerOptionsDescriptorPanel);
            this.complexPanels.add(this.addIdx + 3, this.compilerPathDescriptorPanel);
            this.haveCompilerFlags = true;
            count += 4;
        }
        this.updatePanels(type);
        return count;
    }

    public void deleteTarget(int key) {
        this.deleteTarget(key, true);
    }

    public void deleteTarget(int key, boolean doUpdate) {
        boolean changed = false;
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            TargetHeader hdr;
            if (!(this.complexPanels.get(i) instanceof TargetHeader) || key != (hdr = (TargetHeader)this.complexPanels.get(i)).getKey()) continue;
            for (int j = 0; j <= hdr.getNum(); ++j) {
                this.complexPanels.remove(i);
                changed = true;
            }
            this.addIdx -= hdr.getNum() + 1;
            break;
        }
        if (changed && doUpdate) {
            this.updatePanels(this.getMakefileData().getMakefileType());
        }
    }

    public void changeTarget(int key, String name, int type) {
        boolean changed = false;
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            TargetHeader hdr;
            if (!(this.complexPanels.get(i) instanceof TargetHeader) || key != (hdr = (TargetHeader)this.complexPanels.get(i)).getKey()) continue;
            if (type != hdr.getType()) {
                this.deleteTarget(key, false);
                int saveIdx = this.addIdx;
                this.addIdx = i;
                int count = this.addTarget(type, name, key);
                this.addIdx = saveIdx + count;
            } else {
                hdr.setName(name);
                hdr.setTitle(NbBundle.getMessage(this.getClass(), (String)"FMT_TARGET_CREATE", (Object)name));
            }
            changed = true;
            break;
        }
        if (changed) {
            this.updatePanels(this.getMakefileData().getMakefileType());
        }
    }

    public ArrayList validateAllData() {
        ArrayList msgs = new ArrayList();
        int key = -1;
        for (int i = 0; i < this.panels.length; ++i) {
            if (this.panels[i] instanceof WizardDescriptor.Panel && ((WizardDescriptor.Panel)this.panels[i]).getComponent() instanceof MakefileWizardPanel) {
                ((MakefileWizardPanel)((WizardDescriptor.Panel)this.panels[i]).getComponent()).validateData(msgs, key);
                continue;
            }
            if (!(this.panels[i] instanceof StepHeader)) continue;
            key = ((StepHeader)this.panels[i]).getKey();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public boolean onFinish() {
        TargetData target;
        MakefileGenerator gen = new MakefileGenerator(this.makefileData);
        ArrayList tlist = this.getMakefileData().getTargetList();
        if (tlist.size() > 1 && !(target = (TargetData)tlist.get(1)).isComplex()) {
            for (int i = tlist.size() - 1; i > 0; --i) {
                tlist.remove(i);
            }
        }
        boolean status = gen.generate();
        return status;
    }

    public void executeWizard() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object option;
                if (MakefileWizard.this.index == 0) {
                    MakefileWizard.this.finishButton.setEnabled(false);
                }
                if (event.getPropertyName().equals("value") && ((option = event.getNewValue()) == WizardDescriptor.FINISH_OPTION || option == WizardDescriptor.CANCEL_OPTION)) {
                    boolean done = false;
                    if (option == WizardDescriptor.FINISH_OPTION) {
                        if (MakefileWizard.this.hasNext()) {
                            MakefileWizard.this.index = MakefileWizard.this.panels.length - 2;
                            MakefileWizard.this.nextPanel();
                            MakefileWizard.this.nextButton.setEnabled(false);
                        }
                        MakefileWizard.this.updateStateHack();
                    }
                }
            }
        };
        this.index = 0;
        this.currentPanel = (WizardDescriptor.Panel)this.panels[this.index];
        this.setupWizardButtons((WizardDescriptor)this.wd);
        this.updatePanels(this.getMakefileData().getMakefileType());
        ((JPanel)this.currentPanel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        this.wd.addPropertyChangeListener(this.listener);
    }

    public void unexecuteWizard() {
        if (this.listener != null) {
            this.wd.removePropertyChangeListener(this.listener);
            this.listener = null;
        }
    }

    private void setupWizardButtons(WizardDescriptor wd) {
        Object[] options = wd.getOptions();
        wd.setOptions(new Object[]{WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, WizardDescriptor.CANCEL_OPTION});
        Object[] objs = wd.getOptions();
        if (objs != null && objs.length == 3) {
            this.nextButton = (JButton)objs[0];
            this.finishButton = (JButton)objs[1];
            this.finishLabel = this.finishButton.getText();
            this.finishMnemonic = this.finishButton.getMnemonic();
            this.finishButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makewizard$MakefileWizard == null ? (class$org$netbeans$modules$cpp$makewizard$MakefileWizard = MakefileWizard.class$("org.netbeans.modules.cpp.makewizard.MakefileWizard")) : class$org$netbeans$modules$cpp$makewizard$MakefileWizard)).getString("BTN_Last"));
            this.finishButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makewizard$MakefileWizard == null ? (class$org$netbeans$modules$cpp$makewizard$MakefileWizard = MakefileWizard.class$("org.netbeans.modules.cpp.makewizard.MakefileWizard")) : class$org$netbeans$modules$cpp$makewizard$MakefileWizard)).getString("MNEM_Last").charAt(0));
            this.cancelButton = (JButton)objs[2];
        }
        wd.setOptions(options);
        this.setFinishClosingEnabled(false);
    }

    private void unsetupWizardButtons(WizardDescriptor wd) {
        this.setFinishClosingEnabled(true);
        this.finishButton.setText(this.finishLabel);
        this.finishButton.setMnemonic(this.finishMnemonic);
    }

    public void setFinishClosingEnabled(boolean b) {
        if (b) {
            this.wd.setClosingOptions(new Object[]{this.finishButton, this.cancelButton});
        } else {
            this.wd.setClosingOptions(new Object[]{this.cancelButton});
        }
    }

    public void setFinishEnabled(boolean tf) {
        this.finishButton.setEnabled(tf);
    }

    public static final MakefileWizard getMakefileWizard() {
        return makefileWizard;
    }

    public static void showWizard() {
        makefileWizard = new MakefileWizard();
        makefileWizard.executeWizard();
    }

    public void initialize(TemplateWizard wiz) {
        this.wd = wiz;
        this.initPanels();
        this.executeWizard();
    }

    public void uninitialize(TemplateWizard wiz) {
        this.unexecuteWizard();
        this.unsetupWizardButtons((WizardDescriptor)wiz);
        this.wd = null;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        boolean done;
        MakeExecSupport mes;
        int pos;
        String makefileName;
        DataFolder targetFolder = wiz.getTargetFolder();
        DataObject template = wiz.getTemplate();
        DataObject result = template.createFromTemplate(targetFolder, makefileName = (pos = this.getMakefileData().getMakefileName().lastIndexOf(File.separatorChar)) >= 0 ? this.getMakefileData().getMakefileName().substring(pos + 1) : this.getMakefileData().getMakefileName());
        if (result != null && (mes = (MakeExecSupport)result.getCookie(class$org$netbeans$modules$cpp$builds$MakeExecSupport == null ? (class$org$netbeans$modules$cpp$builds$MakeExecSupport = MakefileWizard.class$("org.netbeans.modules.cpp.builds.MakeExecSupport")) : class$org$netbeans$modules$cpp$builds$MakeExecSupport)) != null) {
            mes.addMakeTargets("all");
            ArrayList tlist = this.getMakefileData().getTargetList();
            block9: for (int i = 0; i < tlist.size(); ++i) {
                TargetData t = (TargetData)tlist.get(i);
                switch (t.getTargetType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (t.getOutputDirectory() != null && t.getOutputDirectory().length() > 0) {
                            mes.addMakeTargets(t.getOutputDirectory() + "/" + t.getName());
                            continue block9;
                        }
                        mes.addMakeTargets(t.getName());
                        continue block9;
                    }
                    case 8: 
                    case 9: {
                        mes.addMakeTargets(t.getName());
                    }
                }
            }
            mes.addMakeTargets("clean");
            String makefileDir = this.getMakefileData().getMakefileDirName();
            String baseDir = this.getMakefileData().getBaseDirectory();
            String buildDirectory = makefileDir.equals(baseDir) ? "." : IpeUtils.getRelativePath(makefileDir, baseDir);
            mes.setBuildDirectory(buildDirectory);
            String fullMakefilePath = result.getPrimaryFile().getFileSystem().getDisplayName() + File.separator + result.getPrimaryFile().getPath();
            String fullBuildDirectoryPath = buildDirectory;
            int index = fullMakefilePath.lastIndexOf(File.separatorChar);
            if (index >= 0) {
                fullBuildDirectoryPath = PicklistUtils.toAbsolutePath(fullMakefilePath.substring(0, index), fullBuildDirectoryPath);
            }
            ArrayList<String> targets = new ArrayList<String>();
            ArrayList<String> executables = new ArrayList<String>();
            block10: for (int i = 0; i < tlist.size(); ++i) {
                TargetData t = (TargetData)tlist.get(i);
                String outputDirectory = t.getOutputDirectory();
                if (outputDirectory == null || outputDirectory.length() == 0) {
                    outputDirectory = ".";
                }
                switch (t.getTargetType()) {
                    case 1: 
                    case 5: {
                        String fullTargetPath = null;
                        fullTargetPath = t.getName().charAt(0) == File.separatorChar ? t.getName() : (outputDirectory.charAt(0) == File.separatorChar ? outputDirectory + File.separator + t.getName() : fullBuildDirectoryPath + File.separator + outputDirectory + File.separator + t.getName());
                        executables.add(fullTargetPath);
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: {
                        targets.add(t.getName());
                        continue block10;
                    }
                    case 8: 
                    case 9: {
                        mes.addMakeTargets(t.getName());
                    }
                }
            }
            MakefileWizardEvent wizardEvent = new MakefileWizardEvent(this, MakefileWizardEvent.MAKEFILE_NEW, fullMakefilePath, this.getMakefileData().getBaseDirectory(), MakeSettings.getDefault().getDefaultMakeCommand(), targets.toArray(new String[targets.size()]), executables.toArray(new String[executables.size()]));
            MakefileWizard.fireMakefileWizardEvent(wizardEvent);
        }
        if (done = this.onFinish()) {
            OpenCookie open = (OpenCookie)result.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = MakefileWizard.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
            if (open != null) {
                open.open();
            }
        } else {
            System.err.println("errors generating makefile...");
        }
        return Collections.singleton(result);
    }

    private String dirPath(FileObject fo, String path) {
        if (fo.getParent() != null && fo.getParent().getName() != null && fo.getParent().getName().length() > 0) {
            path = fo.getParent().getName() + File.separatorChar + path;
            return this.dirPath(fo.getParent(), path);
        }
        return path;
    }

    public void initDirPaths() {
        String fullFolderName = null;
        try {
            DataFolder targetFolder = this.getTemplateWizard().getTargetFolder();
            FileObject fo = targetFolder.getPrimaryFile();
            fullFolderName = CppUtils.getPath(fo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getMakefileData().setBaseDirectory(fullFolderName);
        this.getMakefileData().setMakefileDirName(fullFolderName);
    }

    private String uniqDefaultName(String dir, String makefileName) {
        String name = makefileName;
        File f = new File(dir + File.separator + name);
        int n = 1;
        while (f.exists()) {
            name = makefileName + "_" + n++;
            f = new File(dir + File.separator + name);
        }
        return name;
    }

    public void initMakefileName() {
        MakefileData md = this.getMakefileData();
        String makefileName = this.getTemplateWizard().getTargetName();
        String dir = IpeUtils.trimSlashes(md.getMakefileDirName());
        if (makefileName == null) {
            makefileName = this.uniqDefaultName(dir, "Makefile");
        }
        String fullMakefileName = dir + File.separator + makefileName;
        String useMakefileName = null;
        useMakefileName = dir.equals(md.getBaseDirectory()) || ".".equals(dir) || dir.length() == 0 ? makefileName : fullMakefileName;
        md.setMakefileName(useMakefileName);
    }

    protected static void fireMakefileWizardEvent(MakefileWizardEvent e) {
        Vector listeners = MakefileWizard.getListenerList();
        for (int i = listeners.size() - 1; i >= 0; --i) {
            ((MakefileWizardListener)listeners.elementAt(i)).makefileCreated(e);
        }
    }

    private static Vector getListenerList() {
        if (listenerList == null) {
            listenerList = new Vector(0);
        }
        return listenerList;
    }

    public static void addMakefileWizardListener(MakefileWizardListener l) {
        MakefileWizard.getListenerList().add(l);
    }

    public static void removeMakefileWizardListener(MakefileWizardListener l) {
        MakefileWizard.getListenerList().remove(l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TargetHeader
    extends StepHeader {
        private String name;
        private int type;

        public TargetHeader(String name, int type, int num, int key) {
            super(null, num, key);
            this.name = name;
            this.type = type;
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"FMT_TARGET_CREATE", (Object)name));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    private class StepHeader {
        private String title;
        private int num;
        private int key;

        public StepHeader(String title, int num, int key) {
            this.title = title;
            this.num = num;
            this.key = key;
        }

        public String getTitle() {
            return this.title;
        }

        protected void setTitle(String title) {
            this.title = title;
        }

        public int getNum() {
            return this.num;
        }

        protected void setNum(int num) {
            this.num = num;
        }

        public int getKey() {
            return this.key;
        }

        protected void setKey(int key) {
            this.key = key;
        }
    }
}

