/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cpp.makewizard.EnterItemsPanel;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.TargetData;

public class MakefileIncludesPanel
extends EnterItemsPanel {
    static final long serialVersionUID = -3932940292545539665L;
    private int key;
    private boolean initialized;

    MakefileIncludesPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = new String(this.getString("LBL_MakefileIncludesPanel"));
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_IncDir"), this.getString("MNEM_IncDir").charAt(0), 10);
    }

    protected String getListLabel() {
        return this.getString("LBL_IncludesList");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_IncludesList").charAt(0);
    }

    public void validateData(ArrayList msgs, int key) {
        TargetData target = this.getMakefileData().getTarget(key);
        String[] ilist = target.getIncludesList();
        if (ilist == null) {
            this.warn(msgs, WARN_NO_INC_DIRS, target.getName());
        } else {
            int i;
            String cwd = this.getMakefileData().getBaseDirectory(true);
            ArrayList<StringBuffer> dne = new ArrayList<StringBuffer>();
            ArrayList<StringBuffer> notDir = new ArrayList<StringBuffer>();
            for (i = 0; i < ilist.length; ++i) {
                String incDir = ilist[i].toString();
                File dir = incDir.startsWith(File.separator) ? new File(incDir) : new File(cwd, incDir);
                if (dir == null) continue;
                if (!dir.exists()) {
                    dne.add(new StringBuffer("\t").append(dir.getPath()).append("\n"));
                    continue;
                }
                if (dir.isDirectory()) continue;
                notDir.add(new StringBuffer("\t").append(dir.getPath()).append("\n"));
            }
            if (dne.size() > 0) {
                if (dne.size() < 5) {
                    this.warn(msgs, WARN_DNE_INCDIR, target.getName());
                    for (i = 0; i < dne.size(); ++i) {
                        msgs.add(dne.get(i));
                    }
                    msgs.add(new String("\n"));
                } else {
                    this.warn(msgs, WARN_DNE_COUNT, target.getName(), new Integer(dne.size()).toString());
                }
            }
            if (notDir.size() > 0) {
                if (notDir.size() < 5) {
                    this.warn(msgs, WARN_INC_NOT_DIR, target.getName());
                    for (i = 0; i < notDir.size(); ++i) {
                        msgs.add(notDir.get(i));
                    }
                    msgs.add(new String("\n"));
                } else {
                    this.warn(msgs, WARN_INC_NOT_DIR_COUNT, target.getName(), new Integer(notDir.size()).toString());
                }
            }
        }
    }

    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_MIP_EmptyRE"), this.getString("MSG_NoFilesMatched"));
    }

    protected String validateInput(String text) {
        if (text.startsWith("-I")) {
            return text.substring(2);
        }
        if (text.charAt(0) == '-') {
            return null;
        }
        return text;
    }

    public void addNotify() {
        TargetData target = this.getMakefileData().getCurrentTarget();
        this.key = target.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeAllElements();
        String[] ilist = target.getIncludesList();
        if (ilist != null) {
            for (int i = 0; i < ilist.length; ++i) {
                model.addElement(ilist[i]);
            }
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData target = this.getMakefileData().getTarget(this.key);
        target.setIncludesList(this.getListItems());
    }
}

