/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makepicklist;

import org.netbeans.modules.cpp.makepicklist.MakePicklistElement;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.picklist.DefaultPicklistModel;

public class MakePicklist
extends DefaultPicklistModel
implements MakefileWizardListener {
    private static MakePicklist instance = null;
    private static int picklistMaxSize = 100;
    private static String savehome = null;
    private static String savedir = "/system/picklists";
    private static String savename = "make";

    public MakePicklist() {
        instance = this;
        MakefileWizard.addMakefileWizardListener(this);
    }

    public MakePicklist(int max) {
        super(max);
        instance = this;
        MakefileWizard.addMakefileWizardListener(this);
    }

    private static String getSavehome() {
        if (savehome == null) {
            savehome = System.getProperty("netbeans.user");
        }
        if (savehome == null) {
            savehome = "/tmp";
        }
        return savehome;
    }

    public static MakePicklist getInstance() {
        if (instance == null) {
            try {
                instance = MakePicklist.restorePicklist();
            }
            catch (Exception e) {
                System.out.println("MakePicklist - getInstance - e " + e);
                System.out.println("Cannot restore picklist ...");
            }
            if (instance == null) {
                instance = new MakePicklist(picklistMaxSize);
            }
        }
        return instance;
    }

    public void savePicklist() {
        this.savePicklist(MakePicklist.getSavehome() + savedir, savename);
    }

    public static MakePicklist restorePicklist() {
        instance = (MakePicklist)MakePicklist.restorePicklist(MakePicklist.getSavehome() + savedir, savename);
        if (instance != null) {
            MakefileWizard.addMakefileWizardListener(instance);
        }
        return instance;
    }

    public void makefileCreated(MakefileWizardEvent e) {
        this.addElement(new MakePicklistElement(e.getMakefilePath(), "clean", e.getBuildDirectory(), e.getMakeCommand(), ""));
        this.addElement(new MakePicklistElement(e.getMakefilePath(), "all", e.getBuildDirectory(), e.getMakeCommand(), ""));
        this.savePicklist();
    }
}

