/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loadpicklist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.picklist.PicklistUtils;

public class LoadExecutablePicklistElement
implements PicklistElement,
Serializable {
    private static final long serialVersionUID = -8895252536364700093L;
    private String executable = null;
    private String arguments = null;
    private String runDirectory = null;

    public LoadExecutablePicklistElement(String executable, String arguments, String runDirectory) {
        this.executable = executable;
        this.arguments = arguments.trim();
        this.runDirectory = runDirectory;
    }

    public boolean equals(PicklistElement elem) {
        boolean equal = true;
        if (!(elem instanceof LoadExecutablePicklistElement)) {
            return false;
        }
        equal = this.executable.equals(((LoadExecutablePicklistElement)elem).executable);
        if (equal && this.arguments != null) {
            equal = this.arguments.equals(((LoadExecutablePicklistElement)elem).arguments);
        }
        return equal;
    }

    public String displayName() {
        return PicklistUtils.formatDisplayString(this.executable, this.arguments, false);
    }

    public PicklistElement cloneElement() {
        return new LoadExecutablePicklistElement(this.executable, this.arguments, this.runDirectory);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.executable);
            out.writeObject(this.arguments);
            out.writeObject(this.runDirectory);
        }
        catch (IOException ioe) {
            System.err.println("LoadExecutablePicklistElement - writeObject - ioe " + ioe);
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.executable = (String)in.readObject();
            this.arguments = (String)in.readObject();
            this.runDirectory = (String)in.readObject();
        }
        catch (IOException e) {
            System.err.println("LoadExecutablePicklistElement - readObject - e " + e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("LoadExecutablePicklistElement - readObject - e " + e);
            throw e;
        }
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getRunDirectory() {
        return this.runDirectory;
    }

    public void setRunDirectory(String runDirectory) {
        this.runDirectory = runDirectory;
    }
}

