/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loadpicklist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.picklist.PicklistUtils;

public class LoadCorePicklistElement
implements PicklistElement,
Serializable {
    private static final long serialVersionUID = -8898292837373738693L;
    private String corefile = null;
    private String executable = null;

    public LoadCorePicklistElement(String corefile, String executable) {
        this.corefile = corefile;
        this.executable = executable;
    }

    public boolean equals(PicklistElement elem) {
        boolean equal = true;
        if (!(elem instanceof LoadCorePicklistElement)) {
            return false;
        }
        equal = this.corefile.equals(((LoadCorePicklistElement)elem).corefile);
        return equal;
    }

    public String displayName() {
        return PicklistUtils.formatDisplayString(this.corefile, "", false);
    }

    public PicklistElement cloneElement() {
        return new LoadCorePicklistElement(this.corefile, this.executable);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.corefile);
            out.writeObject(this.executable);
        }
        catch (IOException ioe) {
            System.err.println("LoadCorePicklistElement - writeObject - ioe " + ioe);
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.corefile = (String)in.readObject();
            this.executable = (String)in.readObject();
        }
        catch (IOException e) {
            System.err.println("LoadCorePicklistElement - readObject - e " + e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("LoadCorePicklistElement - readObject - e " + e);
            throw e;
        }
    }

    public String getCorefile() {
        return this.corefile;
    }

    public void setCorefile(String corefile) {
        this.corefile = corefile;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }
}

