/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loaders;

import java.io.IOException;
import org.netbeans.modules.cpp.execution.BinaryExecSupport;
import org.netbeans.modules.cpp.loaders.ElfLoader;
import org.netbeans.modules.cpp.loaders.ElfObject;
import org.netbeans.modules.cpp.loaders.ExeElfNode;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;

public class ExeElfObject
extends ElfObject {
    static final long serialVersionUID = 77972208704093735L;

    public ExeElfObject(FileObject pf, ElfLoader loader) throws DataObjectExistsException {
        super(pf, loader);
    }

    protected void init() {
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)new BinaryExecSupport(this.getPrimaryEntry()));
    }

    protected Node createNodeDelegate() {
        return new ExeElfNode(this);
    }

    public String getName() {
        String ename = this.getPrimaryFile().getNameExt();
        return ename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String name) throws IOException {
        FileLock lock = this.getPrimaryFile().lock();
        int pos = name.lastIndexOf(46);
        try {
            if (pos <= 0) {
                this.getPrimaryFile().rename(lock, name, null);
            } else {
                this.getPrimaryFile().rename(lock, name.substring(0, pos), name.substring(pos + 1, name.length()));
            }
        }
        finally {
            lock.releaseLock();
        }
        return this.getPrimaryFile();
    }

    protected DataObject handleCopy(DataFolder df) throws IOException {
        DataObject dao = super.handleCopy(df);
        this.setExecutionFlags(dao.getPrimaryFile());
        return dao;
    }

    protected FileObject handleMove(DataFolder df) throws IOException {
        FileObject fob = super.handleMove(df);
        this.setExecutionFlags(fob);
        return fob;
    }

    private void setExecutionFlags(FileObject fob) throws IOException {
        if (fob != null) {
            Runtime.getRuntime().exec("/bin/chmod +x " + CppUtils.getPath(fob));
        }
    }
}

