/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loaders;

import java.io.IOException;
import org.netbeans.modules.cpp.loaders.CoreElfObject;
import org.netbeans.modules.cpp.loaders.ExeElfObject;
import org.netbeans.modules.cpp.loaders.OrphanedElfObject;
import org.netbeans.modules.cpp.loaders.ShobjElfObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ElfLoader
extends UniFileLoader {
    static final long serialVersionUID = -602486606840357846L;
    protected static SystemAction[] standardActions;
    private static String lastMime;
    private static FileObject lastFo;
    private static final String KNOWN_ELFFILE_TYPE = "org.netbeans.modules.cpp.ElfLoader.KNOWN_ELFFILE_TYPE";
    private static ElfLoader DEFAULT;
    private static int additionalActions;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$loaders$MakefileDataLoader;

    public ElfLoader() {
        super("org.netbeans.modules.cpp.loaders.ElfObject");
        DEFAULT = this;
    }

    public ElfLoader(Class recognizedClass) {
        super(recognizedClass);
        DEFAULT = this;
    }

    public ElfLoader(String representationClassName) {
        super(representationClassName);
        DEFAULT = this;
    }

    public static synchronized void addAction(SystemAction a) {
        if (a != null) {
            SystemAction execAction = SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = ElfLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction));
            SystemAction[] currentActions = DEFAULT.getActions();
            int numActions = currentActions.length + 1;
            if (additionalActions == 0) {
                ++numActions;
            }
            SystemAction[] newActions = new SystemAction[numActions];
            Boolean insertNewAction = Boolean.TRUE;
            int j = 0;
            for (int i = 0; i < currentActions.length; ++i) {
                newActions[j] = currentActions[i];
                if (currentActions[i] != null && currentActions[i].equals((Object)execAction) && insertNewAction == Boolean.TRUE) {
                    newActions[++j] = currentActions[++i];
                    newActions[++j] = a;
                    if (additionalActions == 0) {
                        newActions[++j] = null;
                    }
                    ++additionalActions;
                    insertNewAction = Boolean.FALSE;
                }
                ++j;
            }
            DEFAULT.setActions(newActions);
        }
    }

    public static synchronized void removeAction(SystemAction a) {
        if (a != null) {
            SystemAction[] currentActions = DEFAULT.getActions();
            int numActions = currentActions.length - 1;
            if (--additionalActions == 0) {
                --numActions;
            }
            SystemAction[] newActions = new SystemAction[numActions];
            int j = 0;
            for (int i = 0; i < numActions; ++i) {
                if (currentActions[j] != null && currentActions[j].equals((Object)a)) {
                    ++j;
                    if (additionalActions == 0) {
                        ++j;
                    }
                }
                newActions[i] = currentActions[j];
                ++j;
            }
            DEFAULT.setActions(newActions);
        }
    }

    public static ElfLoader getDefaultElfLoader() {
        return DEFAULT;
    }

    protected SystemAction[] createDefaultActions() {
        int numActionEntries = 13;
        SystemAction[] act = new SystemAction[numActionEntries];
        int j = 0;
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = ElfLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction));
        act[j++] = null;
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = ElfLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction));
        act[j++] = null;
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ElfLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction));
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ElfLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction));
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ElfLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction));
        act[j++] = null;
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ElfLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction));
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = ElfLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction));
        act[j++] = null;
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ElfLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction));
        act[j++] = SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ElfLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        if (numActionEntries != j && Boolean.getBoolean("netbeans.debug.exceptions")) {
            Thread.dumpStack();
        }
        return act;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SystemAction[] defaultActions() {
        if (standardActions != null) {
            return standardActions;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (standardActions == null) {
                standardActions = this.createDefaultActions();
            }
        }
        return standardActions;
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$loaders$MakefileDataLoader == null ? (class$org$netbeans$modules$cpp$loaders$MakefileDataLoader = ElfLoader.class$("org.netbeans.modules.cpp.loaders.MakefileDataLoader")) : class$org$netbeans$modules$cpp$loaders$MakefileDataLoader), (String)"PROP_ElfLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        String mime;
        if (fo.isFolder()) {
            return null;
        }
        Object o = fo.getAttribute(KNOWN_ELFFILE_TYPE);
        if (o != null) {
            mime = o.toString();
        } else {
            mime = fo.getMIMEType();
            if (mime.equals("application/x-executable+elf")) {
                mime = "application/x-executable+elf";
            } else if (mime.equals("application/x-core+elf")) {
                mime = "application/x-core+elf";
            } else if (mime.equals("application/x-shobj+elf")) {
                mime = "application/x-shobj+elf";
            } else if (mime.equals("application/x-object+elf")) {
                mime = "application/x-object+elf";
            } else if ("application/x-elf".equals(mime)) {
                String name = fo.getNameExt();
                mime = name.startsWith("core") || name.endsWith(".core") ? "application/x-core+elf" : (name.endsWith(".o") ? "application/x-object+elf" : (name.endsWith(".so") || name.indexOf(".so.") >= 0 ? "application/x-shobj+elf" : "application/x-executable+elf"));
            }
        }
        if ("application/x-executable+elf".equals(mime) || "application/x-core+elf".equals(mime) || "application/x-shobj+elf".equals(mime) || "application/x-object+elf".equals(mime)) {
            if (!"application/x-object+elf".equals(mime)) {
                fo.setImportant(false);
            }
            lastMime = mime;
            lastFo = fo;
            try {
                fo.setAttribute(KNOWN_ELFFILE_TYPE, (Object)mime);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return fo;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        String mime = lastFo.equals(primaryFile) ? lastMime : primaryFile.getMIMEType();
        if (mime.equals("application/x-executable+elf")) {
            return new ExeElfObject(primaryFile, this);
        }
        if (mime.equals("application/x-core+elf")) {
            return new CoreElfObject(primaryFile, this);
        }
        if (mime.equals("application/x-shobj+elf")) {
            return new ShobjElfObject(primaryFile, this);
        }
        return new OrphanedElfObject(primaryFile, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT = null;
        additionalActions = 0;
    }
}

