/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.execution;

import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.execution.BinaryExecSupport;
import org.netbeans.modules.cpp.loaders.CCFSrcObject;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.Executor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public final class BinaryExecutor
extends ProcessExecutor {
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor("{binary}", "{arguments}", BinaryExecutor.getString("ArgumentsKey"));
    public static ResourceBundle bundle = null;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$execution$BinaryExecSupport;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$execution$BinaryExecutor;

    public BinaryExecutor() {
        this.setExternalExecutor(DEFAULT);
    }

    protected Process createProcess(DataObject dao) throws IOException {
        String runDirectory;
        File parentFile;
        FileObject fo = null;
        if (dao instanceof CCFSrcObject) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)BinaryExecutor.getString("CantDebugSrcs")));
            return null;
        }
        fo = dao.getPrimaryFile();
        if (fo == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"INTERNAL ERROR"));
            return null;
        }
        String binary = CppUtils.getPath(fo);
        if (binary == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)BinaryExecutor.getString("MSG_CANT_FIND_PATH")));
            return null;
        }
        String[] argv = ExecSupport.getArguments((MultiDataObject.Entry)new FileEntry((MultiDataObject)dao, dao.getPrimaryFile()));
        ExecFormat format = new ExecFormat(binary, argv);
        File useParentFile = parentFile = FileUtil.toFile((FileObject)fo).getParentFile();
        BinaryExecSupport bes = (BinaryExecSupport)dao.getCookie(class$org$netbeans$modules$cpp$execution$BinaryExecSupport == null ? (class$org$netbeans$modules$cpp$execution$BinaryExecSupport = BinaryExecutor.class$("org.netbeans.modules.cpp.execution.BinaryExecSupport")) : class$org$netbeans$modules$cpp$execution$BinaryExecSupport);
        if (!(bes == null || (runDirectory = bes.getRunDirectory()) == null || runDirectory.length() <= 0 || (useParentFile = runDirectory.equals(".") ? parentFile : (runDirectory.charAt(0) == File.separatorChar ? new File(runDirectory) : new File(parentFile.getCanonicalPath() + File.separator + runDirectory))).exists() && useParentFile.isDirectory())) {
            String msg = MessageFormat.format(BinaryExecutor.getString("NOT_A_VALID_RUN_DIRECTORY"), useParentFile.getPath());
            NotifyDescriptor.Message notifyDescriptor = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            return null;
        }
        Process process = this.getExternalExecutor().exec((Format)((Object)format), null, useParentFile);
        new Thread(new ProcessMonitor(process)).start();
        return process;
    }

    private void refreshAllFilesystems() {
        Enumeration e = Repository.getDefault().getFileSystems();
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            fs.refresh(true);
        }
    }

    public static Executor getDefault() {
        Enumeration enumeration = BinaryExecutor.executors();
        while (enumeration.hasMoreElements()) {
            Executor ret = (Executor)enumeration.nextElement();
            if (!(ret instanceof BinaryExecutor)) continue;
            return ret;
        }
        enumeration = BinaryExecutor.executors();
        return (Executor)enumeration.nextElement();
    }

    public String displayName() {
        return BinaryExecutor.getString("ExecutorName");
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$execution$BinaryExecutor == null ? (class$org$netbeans$modules$cpp$execution$BinaryExecutor = BinaryExecutor.class$("org.netbeans.modules.cpp.execution.BinaryExecutor")) : class$org$netbeans$modules$cpp$execution$BinaryExecutor));
        }
        return bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExecFormat
    extends MapFormat {
        static final String TAG_ARGS = "arguments";
        static final String TAG_BINARY = "binary";

        ExecFormat(String binary, String[] argv) {
            super(new HashMap(2));
            Map map = this.getMap();
            map.put(TAG_BINARY, binary);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < argv.length; ++i) {
                sb.append('\"');
                sb.append(argv[i]);
                sb.append('\"');
                sb.append(' ');
            }
            map.put(TAG_ARGS, sb.toString());
        }
    }

    private class ProcessMonitor
    implements Runnable {
        private Process process = null;

        public ProcessMonitor(Process process) {
            this.process = process;
        }

        public void run() {
            try {
                this.process.waitFor();
                BinaryExecutor.this.refreshAllFilesystems();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

