/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.executepicklist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.picklist.PicklistUtils;

public class ExecutePicklistElement
implements PicklistElement,
Serializable {
    private static final long serialVersionUID = -8893321932141938693L;
    private String executable = null;
    private String arguments = null;
    private String runDirectory = null;

    public ExecutePicklistElement(String executable, String arguments, String runDirectory) {
        this.executable = executable;
        this.arguments = arguments.trim();
        this.runDirectory = runDirectory;
    }

    public boolean equals(PicklistElement elem) {
        boolean equal = true;
        equal = this.executable.equals(((ExecutePicklistElement)elem).executable);
        if (equal && this.arguments != null) {
            equal = this.arguments.equals(((ExecutePicklistElement)elem).arguments);
        }
        return equal;
    }

    public String displayName() {
        return PicklistUtils.formatDisplayString(this.executable, this.arguments, false);
    }

    public PicklistElement cloneElement() {
        return new ExecutePicklistElement(this.executable, this.arguments, this.runDirectory);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.executable);
            out.writeObject(this.arguments);
            out.writeObject(this.runDirectory);
        }
        catch (IOException ioe) {
            System.err.println("ExecutePicklistElement - writeObject - ioe " + ioe);
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.executable = (String)in.readObject();
            this.arguments = (String)in.readObject();
            this.runDirectory = (String)in.readObject();
        }
        catch (IOException e) {
            System.err.println("ExecutePicklistElement - readObject - e " + e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("ExecutePicklistElement - readObject - e " + e);
            throw e;
        }
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getRunDirectory() {
        return this.runDirectory;
    }

    public void setRunDirectory(String runDirectory) {
        this.runDirectory = runDirectory;
    }
}

